-- -----------------------------------------------------
-- CRM-Addon for OpenEstate-ImmoTool
-- update 2 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add field 'activity_direction' to 'immotool_crm_activities'
-- Add field 'activity_fixed' to 'immotool_crm_activities'
-- Rebuild 'view_immotool_crm_activities'
-- Rebuild 'save_immotool_crm_activities'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Add field 'activity_direction' to 'immotool_crm_activities'
-- -----------------------------------------------------
ALTER TABLE immotool_crm_activities
  ADD COLUMN activity_direction VARCHAR(3) DEFAULT NULL NULL
  BEFORE activity_status;

-- -----------------------------------------------------
-- Add field 'activity_fixed' to 'immotool_crm_activities'
-- -----------------------------------------------------
ALTER TABLE immotool_crm_activities
  ADD COLUMN activity_fixed BOOLEAN DEFAULT FALSE NULL
  BEFORE activity_notes;

-- -----------------------------------------------------
-- Rebuild 'view_immotool_crm_activities'
-- -----------------------------------------------------
ALTER VIEW view_immotool_crm_activities AS
  SELECT * FROM immotool_crm_activities
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

-- -----------------------------------------------------
-- Rebuild 'save_immotool_crm_activities'
-- -----------------------------------------------------
DROP PROCEDURE IF EXISTS save_immotool_crm_activities;
\.
CREATE PROCEDURE save_immotool_crm_activities(
    INOUT val_activity_id BIGINT,
    val_activity_subject VARCHAR(255),
    val_activity_type VARCHAR(100),
    val_activity_direction VARCHAR(3),
    val_activity_status VARCHAR(100),
    val_activity_begin TIMESTAMP WITH TIME ZONE,
    val_activity_end TIMESTAMP WITH TIME ZONE,
    val_activity_fixed BOOLEAN,
    val_activity_notes LONGVARCHAR,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_crm_activities
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neue Aktivität erzeugen
    IF val_activity_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Aktivität speichern
      INSERT INTO immotool_crm_activities (
        activity_subject,
        activity_type,
        activity_direction,
        activity_status,
        activity_begin,
        activity_end,
        activity_fixed,
        activity_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_activity_subject,
        val_activity_type,
        val_activity_direction,
        val_activity_status,
        val_activity_begin,
        val_activity_end,
        val_activity_fixed,
        val_activity_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_activity_id = IDENTITY();

    -- Bestehende Aktivität bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_crm_activities
        WHERE activity_id = val_activity_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>1 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>1 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>1 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Aktivität bearbeiten
      UPDATE immotool_crm_activities
        SET
          activity_subject = val_activity_subject,
          activity_type = val_activity_type,
          activity_direction = val_activity_direction,
          activity_status = val_activity_status,
          activity_begin = val_activity_begin,
          activity_end = val_activity_end,
          activity_fixed = val_activity_fixed,
          activity_notes = val_activity_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          activity_id = val_activity_id;

    END IF;

  END;
.;
GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities
  TO "IMMOTOOL";
