-- -----------------------------------------------------
-- CRM-Addon for OpenEstate-ImmoTool
-- routines for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_crm_activities
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_crm_activities( val_activity_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_crm_activities
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_activities
      WHERE activity_id = val_activity_id;

    RETURN can_delete( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_crm_marketing
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_crm_marketing( val_marketing_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_crm_marketing
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_marketing
      WHERE marketing_id = val_marketing_id;

    RETURN can_delete( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_crm_activities
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_crm_activities( val_activity_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_crm_activities
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_activities
      WHERE activity_id = val_activity_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_crm_marketing
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_crm_marketing( val_marketing_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_crm_marketing
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_marketing
      WHERE marketing_id = val_marketing_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_crm_activities
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_crm_activities( val_activity_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_crm_activities
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_activities
      WHERE activity_id = val_activity_id;

    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_crm_marketing
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_crm_marketing( val_marketing_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_crm_marketing
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_crm_marketing
      WHERE marketing_id = val_marketing_id;

    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_activities
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_activities( val_activity_id BIGINT )
  SPECIFIC remove_immotool_crm_activities
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_activity_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_delete_immotool_crm_activities( val_activity_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag entfernen
    DELETE
      FROM immotool_crm_activities
      WHERE activity_id = val_activity_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_activities
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_activities_contacts_entries
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_activities_contacts_entries(
    val_activity_id BIGINT,
    val_contacts_entry_id BIGINT
  )
  SPECIFIC remove_immotool_crm_activities_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_activity_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_crm_activities(val_activity_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_contacts_entry_id < 1 THEN

      -- alle Relationen entfernen
      DELETE
        FROM immotool_crm_activities_contacts_entries
        WHERE activity_id = val_activity_id;

    ELSE

      -- Relation entfernen
      DELETE
        FROM immotool_crm_activities_contacts_entries
        WHERE activity_id = val_activity_id
        AND contacts_entry_id = val_contacts_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_activities_contacts_entries
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_marketing
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_marketing( val_marketing_id BIGINT )
  SPECIFIC remove_immotool_crm_marketing
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_marketing_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Schreib-Rechte besitzt
    SET allowed = can_delete_immotool_crm_marketing( val_marketing_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag entfernen
    DELETE
      FROM immotool_crm_marketing
      WHERE marketing_id = val_marketing_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_marketing
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure remove_immotool_crm_marketing_feedback
-- -----------------------------------------------------
CREATE PROCEDURE remove_immotool_crm_marketing_feedback(
    val_marketing_id BIGINT,
    val_contacts_entry_id BIGINT
  )
  SPECIFIC remove_immotool_crm_marketing_feedback
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_marketing_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_crm_marketing(val_marketing_id);
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF val_contacts_entry_id < 1 THEN

      -- Alle Relationen entfernen
      DELETE
        FROM immotool_crm_marketing_feedback
        WHERE marketing_id = val_marketing_id;

    ELSE

      -- Relation entfernen
      DELETE
        FROM immotool_crm_marketing_feedback
        WHERE marketing_id = val_marketing_id
        AND contacts_entry_id = val_contacts_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_crm_marketing_feedback
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_activities
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_activities(
    INOUT val_activity_id BIGINT,
    val_activity_subject VARCHAR(255),
    val_activity_type VARCHAR(100),
    val_activity_direction VARCHAR(3),
    val_activity_status VARCHAR(100),
    val_activity_begin TIMESTAMP WITH TIME ZONE,
    val_activity_end TIMESTAMP WITH TIME ZONE,
    val_activity_fixed BOOLEAN,
    val_activity_notes LONGVARCHAR,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_crm_activities
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neue Aktivität erzeugen
    IF val_activity_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Aktivität speichern
      INSERT INTO immotool_crm_activities (
        activity_subject,
        activity_type,
        activity_direction,
        activity_status,
        activity_begin,
        activity_end,
        activity_fixed,
        activity_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_activity_subject,
        val_activity_type,
        val_activity_direction,
        val_activity_status,
        val_activity_begin,
        val_activity_end,
        val_activity_fixed,
        val_activity_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_activity_id = IDENTITY();

    -- Bestehende Aktivität bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_crm_activities
        WHERE activity_id = val_activity_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Aktivität bearbeiten
      UPDATE immotool_crm_activities
        SET
          activity_subject = val_activity_subject,
          activity_type = val_activity_type,
          activity_direction = val_activity_direction,
          activity_status = val_activity_status,
          activity_begin = val_activity_begin,
          activity_end = val_activity_end,
          activity_fixed = val_activity_fixed,
          activity_notes = val_activity_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          activity_id = val_activity_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_activities_contacts_entries
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_activities_contacts_entries(
    val_activity_id BIGINT,
    val_contacts_entry_id BIGINT
  )
  SPECIFIC save_immotool_crm_activities_contacts_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_activity_id < 1 OR val_contacts_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Relation ggf. entfernen
    CALL remove_immotool_crm_activities_contacts_entries( val_activity_id, val_contacts_entry_id );

    -- Kontakt speichern
    INSERT INTO immotool_crm_activities_contacts_entries (
      activity_id,
      contacts_entry_id )
    VALUES (
      val_activity_id,
      val_contacts_entry_id );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_activities_contacts_entries
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_marketing
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_marketing(
    INOUT val_marketing_id BIGINT,
    val_marketing_title VARCHAR(255),
    val_marketing_status VARCHAR(100),
    val_marketing_interval VARCHAR(100),
    val_marketing_costs DECIMAL,
    val_marketing_begin TIMESTAMP WITH TIME ZONE,
    val_marketing_end TIMESTAMP WITH TIME ZONE,
    val_marketing_notes LONGVARCHAR,
    val_access_owner_id BIGINT,
    val_access_group_id BIGINT,
    val_access_permissions INT
  )
  SPECIFIC save_immotool_crm_marketing
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neues Marketing erzeugen
    IF val_marketing_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Marketing speichern
      INSERT INTO immotool_crm_marketing (
        marketing_title,
        marketing_status,
        marketing_interval,
        marketing_costs,
        marketing_begin,
        marketing_end,
        marketing_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_marketing_title,
        val_marketing_status,
        val_marketing_interval,
        val_marketing_costs,
        val_marketing_begin,
        val_marketing_end,
        val_marketing_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_marketing_id = IDENTITY();

    -- Bestehendes Marketing bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_crm_marketing
        WHERE marketing_id = val_marketing_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Marketing bearbeiten
      UPDATE immotool_crm_marketing
        SET
          marketing_id = val_marketing_id,
          marketing_title = val_marketing_title,
          marketing_status = val_marketing_status,
          marketing_interval = val_marketing_interval,
          marketing_costs = val_marketing_costs,
          marketing_begin = val_marketing_begin,
          marketing_end = val_marketing_end,
          marketing_notes = val_marketing_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          marketing_id = val_marketing_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_marketing
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_crm_marketing_feedback
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_crm_marketing_feedback(
    val_marketing_id BIGINT,
    val_contacts_entry_id BIGINT,
    val_feedback_positive BOOLEAN,
    val_feedback_time TIMESTAMP WITH TIME ZONE
  )
  SPECIFIC save_immotool_crm_marketing_feedback
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_marketing_id < 1 OR val_contacts_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Relation ggf. entfernen
    CALL remove_immotool_crm_marketing_feedback( val_marketing_id, val_contacts_entry_id );

    -- Kontakt speichern
    INSERT INTO immotool_crm_marketing_feedback (
      marketing_id,
      contacts_entry_id,
      feedback_positive,
      feedback_time )
    VALUES (
      val_marketing_id,
      val_contacts_entry_id,
      val_feedback_positive,
      val_feedback_time );

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_crm_marketing_feedback
  TO "IMMOTOOL";
