-- -----------------------------------------------------
-- CRM-Addon for OpenEstate-ImmoTool
-- schema for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------

CREATE SEQUENCE seq_immotool_crm_activities
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;
CREATE SEQUENCE seq_immotool_crm_marketing
  AS BIGINT START WITH 1 INCREMENT BY 1 NO CYCLE;


-- -----------------------------------------------------
-- Table immotool_crm_activities
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_activities (
  activity_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_crm_activities NOT NULL,
  activity_subject VARCHAR(255) NOT NULL,
  activity_type VARCHAR(100) NOT NULL,
  activity_direction VARCHAR(3) DEFAULT NULL NULL,
  activity_status VARCHAR(100) NOT NULL,
  activity_begin TIMESTAMP WITH TIME ZONE NOT NULL,
  activity_end TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  activity_fixed BOOLEAN DEFAULT FALSE NULL,
  activity_notes LONGVARCHAR DEFAULT NULL NULL,
  access_owner_id BIGINT DEFAULT 1 NOT NULL,
  access_group_id BIGINT DEFAULT 1 NOT NULL,
  access_permissions INT DEFAULT 0 NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (activity_id),
  FOREIGN KEY (access_owner_id)
    REFERENCES immotool_users(user_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT,
  FOREIGN KEY (access_group_id)
    REFERENCES immotool_groups(group_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT
);

CREATE VIEW view_immotool_crm_activities AS
  SELECT * FROM immotool_crm_activities
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

GRANT SELECT
  ON view_immotool_crm_activities
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_crm_activities_contacts_entries
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_activities_contacts_entries (
  activity_id BIGINT NOT NULL,
  contacts_entry_id BIGINT NOT NULL,
  PRIMARY KEY (activity_id, contacts_entry_id),
  FOREIGN KEY (activity_id)
    REFERENCES immotool_crm_activities(activity_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_crm_activities_contacts_entries AS
  SELECT * FROM immotool_crm_activities_contacts_entries
  WHERE activity_id IN (SELECT activity_id FROM view_immotool_crm_activities);

GRANT SELECT
  ON view_immotool_crm_activities_contacts_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_crm_marketing
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_marketing (
  marketing_id BIGINT GENERATED BY DEFAULT AS SEQUENCE seq_immotool_crm_marketing NOT NULL,
  marketing_title VARCHAR(255) NOT NULL,
  marketing_status VARCHAR(100) NOT NULL,
  marketing_interval VARCHAR(100) NOT NULL,
  marketing_costs DECIMAL NOT NULL,
  marketing_begin TIMESTAMP WITH TIME ZONE NOT NULL,
  marketing_end TIMESTAMP WITH TIME ZONE DEFAULT NULL NULL,
  marketing_notes LONGVARCHAR DEFAULT NULL NULL,
  access_owner_id BIGINT DEFAULT 1 NOT NULL,
  access_group_id BIGINT DEFAULT 1 NOT NULL,
  access_permissions INT DEFAULT 0 NOT NULL,
  created_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  modified_at TIMESTAMP WITH TIME ZONE DEFAULT NOW() NOT NULL,
  PRIMARY KEY (marketing_id),
  FOREIGN KEY (access_owner_id)
    REFERENCES immotool_users(user_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT,
  FOREIGN KEY (access_group_id)
    REFERENCES immotool_groups(group_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE SET DEFAULT
);

CREATE VIEW view_immotool_crm_marketing AS
  SELECT * FROM immotool_crm_marketing
  WHERE
  (
    ('DBA' IN (SELECT authorization_name FROM information_schema.authorizations WHERE authorization_type = 'ROLE'))
    OR
    (BITAND(access_permissions, 64) = 64)
    OR
    (BITAND(access_permissions, 8) = 8 AND access_group_id IN (SELECT group_id FROM view_immotool_users_groups WHERE user_login=USER()))
    OR
    (BITAND(access_permissions, 1) = 1 AND access_owner_id IN (SELECT user_id FROM view_immotool_users WHERE user_login=USER()))
  );

GRANT SELECT
  ON view_immotool_crm_marketing
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Table immotool_crm_marketing_feedback
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_crm_marketing_feedback (
  marketing_id BIGINT NOT NULL,
  contacts_entry_id BIGINT NOT NULL,
  feedback_positive BOOLEAN DEFAULT true NOT NULL,
  feedback_time TIMESTAMP WITH TIME ZONE NOT NULL,
  PRIMARY KEY (marketing_id, contacts_entry_id),
  FOREIGN KEY (marketing_id)
    REFERENCES immotool_crm_marketing(marketing_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (contacts_entry_id)
    REFERENCES immotool_contacts_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

CREATE VIEW view_immotool_crm_marketing_feedback AS
  SELECT * FROM immotool_crm_marketing_feedback
  WHERE marketing_id IN (SELECT marketing_id FROM view_immotool_crm_marketing);

GRANT SELECT
  ON view_immotool_crm_marketing_feedback
  TO "IMMOTOOL";
