-- -----------------------------------------------------
-- CRM-Addon for OpenEstate-ImmoTool
-- update 3 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_crm_activities'
-- Fix update of owners in 'save_immotool_crm_marketing'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_crm_activities'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_crm_activities
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neue Aktivität erzeugen
    IF val_activity_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Aktivität speichern
      INSERT INTO immotool_crm_activities (
        activity_subject,
        activity_type,
        activity_direction,
        activity_status,
        activity_begin,
        activity_end,
        activity_fixed,
        activity_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_activity_subject,
        val_activity_type,
        val_activity_direction,
        val_activity_status,
        val_activity_begin,
        val_activity_end,
        val_activity_fixed,
        val_activity_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_activity_id = IDENTITY();

    -- Bestehende Aktivität bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_crm_activities
        WHERE activity_id = val_activity_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Aktivität bearbeiten
      UPDATE immotool_crm_activities
        SET
          activity_subject = val_activity_subject,
          activity_type = val_activity_type,
          activity_direction = val_activity_direction,
          activity_status = val_activity_status,
          activity_begin = val_activity_begin,
          activity_end = val_activity_end,
          activity_fixed = val_activity_fixed,
          activity_notes = val_activity_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          activity_id = val_activity_id;

    END IF;

  END;
.;

-- -----------------------------------------------------
-- Fix update of owners in 'save_immotool_crm_marketing'
-- -----------------------------------------------------
\.
ALTER SPECIFIC ROUTINE save_immotool_crm_marketing
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;
    DECLARE current_uid BIGINT;
    DECLARE dba BOOLEAN;
    SET dba = is_admin();

    SELECT user_id
      INTO current_uid
      FROM view_immotool_users
      WHERE user_login=USER();

    -- Neues Marketing erzeugen
    IF val_marketing_id < 1 THEN
      -- Inhaber-Benutzer ggf. automatisch setzen
      IF (val_access_owner_id IS NULL OR val_access_owner_id<1 OR dba = FALSE) THEN
        SET owner_uid = current_uid;
      ELSE
        SET owner_uid = val_access_owner_id;
      END IF;

      -- Inhaber-Gruppe ggf. automatisch setzen
      IF (val_access_group_id IS NULL OR val_access_group_id<1) THEN
        SELECT group_id
          INTO owner_gid
          FROM view_immotool_groups
          WHERE group_name='IMMOTOOL';
      ELSE
        SET owner_gid = val_access_group_id;
      END IF;

      -- Berechtigungen ggf. automatisch setzen
      IF (val_access_permissions IS NULL OR val_access_permissions<0) THEN
        SET permissions = 63;
      ELSE
        SET permissions = val_access_permissions;
      END IF;

      -- Marketing speichern
      INSERT INTO immotool_crm_marketing (
        marketing_title,
        marketing_status,
        marketing_interval,
        marketing_costs,
        marketing_begin,
        marketing_end,
        marketing_notes,
        access_owner_id,
        access_group_id,
        access_permissions )
      VALUES (
        val_marketing_title,
        val_marketing_status,
        val_marketing_interval,
        val_marketing_costs,
        val_marketing_begin,
        val_marketing_end,
        val_marketing_notes,
        owner_uid,
        owner_gid,
        permissions);

      -- ID zurückliefern
      SET val_marketing_id = IDENTITY();

    -- Bestehendes Marketing bearbeiten
    ELSE
      -- Prüfen ob Schreib-Rechte vorliegen
      SELECT access_permissions, access_owner_id, access_group_id
        INTO permissions, owner_uid, owner_gid
        FROM immotool_crm_marketing
        WHERE marketing_id = val_marketing_id;

      IF dba = FALSE THEN
        SET allowed = can_write(permissions, owner_uid, owner_gid);
        IF NOT allowed = TRUE THEN
          SIGNAL SQLSTATE '45000';
        END IF;
      END IF;

      -- Wechsel des Inhaber-Benutzers darf nur der Administrator durchführen
      IF dba = TRUE AND val_access_owner_id IS NOT NULL AND val_access_owner_id>0 THEN
        SET owner_uid = val_access_owner_id;
      END IF;

      IF dba = TRUE OR owner_uid = current_uid THEN

        -- Wechsel der Inhaber-Gruppe darf nur der Administrator oder Inhaber durchführen
        IF val_access_group_id IS NOT NULL AND val_access_group_id>0 THEN
          SET owner_gid = val_access_group_id;
        END IF;

        -- Wechsel der Berechtigungen darf nur der Administrator oder Inhaber durchführen
        IF val_access_permissions IS NOT NULL AND val_access_permissions>=0 THEN
          SET permissions = val_access_permissions;
        END IF;
      END IF;

      -- Marketing bearbeiten
      UPDATE immotool_crm_marketing
        SET
          marketing_id = val_marketing_id,
          marketing_title = val_marketing_title,
          marketing_status = val_marketing_status,
          marketing_interval = val_marketing_interval,
          marketing_costs = val_marketing_costs,
          marketing_begin = val_marketing_begin,
          marketing_end = val_marketing_end,
          marketing_notes = val_marketing_notes,
          access_owner_id = owner_uid,
          access_group_id = owner_gid,
          access_permissions = permissions,
          modified_at = NOW()
        WHERE
          marketing_id = val_marketing_id;

    END IF;

  END;
.;
