-- -----------------------------------------------------
-- News-Addon for OpenEstate-ImmoTool
-- update 9 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add function 'can_read_immotool_news_feeds'
-- Add function 'can_delete_immotool_news_entries'
-- Add function 'can_read_immotool_news_entries'
-- Add function 'can_write_immotool_news_entries'
-- Update procedure 'remove_immotool_news_entries'
-- -----------------------------------------------------

\.
-- -----------------------------------------------------
-- Function can_read_immotool_news_feeds
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_news_feeds( val_feed_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_news_feeds
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- auf Benutzer-Rechte prüfen
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_news_feeds
      WHERE feed_id = val_feed_id;

    RETURN can_read( permissions, owner_uid, owner_gid );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_delete_immotool_news_entries
-- -----------------------------------------------------
CREATE FUNCTION can_delete_immotool_news_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_news_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_feed_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Nachrichten-Quelle ermitteln
    SELECT feed_id
      INTO val_feed_id
      FROM immotool_news_entries
      WHERE entry_id = val_entry_id;

    -- Zum Löschen einer Nachricht müssen Schreibrechte auf der Nachrichten-Quelle vorliegen
    RETURN can_write_immotool_news_feeds( val_feed_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_read_immotool_news_entries
-- -----------------------------------------------------
CREATE FUNCTION can_read_immotool_news_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_read_immotool_news_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_feed_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Nachrichten-Quelle ermitteln
    SELECT feed_id
      INTO val_feed_id
      FROM immotool_news_entries
      WHERE entry_id = val_entry_id;

    -- Zum Lesen einer Nachricht müssen Leserechte auf der Nachrichten-Quelle vorliegen
    RETURN can_read_immotool_news_feeds( val_feed_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Function can_write_immotool_news_entries
-- -----------------------------------------------------
CREATE FUNCTION can_write_immotool_news_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_news_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE val_feed_id BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Nachrichten-Quelle ermitteln
    SELECT feed_id
      INTO val_feed_id
      FROM immotool_news_entries
      WHERE entry_id = val_entry_id;

    -- Zum Schreiben einer Nachricht müssen Schreibrechte auf der Nachrichten-Quelle vorliegen
    RETURN can_write_immotool_news_feeds( val_feed_id );
  END;
.;
\.
-- -----------------------------------------------------
-- Procedure remove_immotool_news_entries
-- -----------------------------------------------------
ALTER SPECIFIC ROUTINE remove_immotool_news_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    IF NOT can_delete_immotool_news_entries( val_entry_id ) = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag entfernen
    DELETE
      FROM immotool_news_entries
      WHERE entry_id = val_entry_id;

  END;
.;
