-- -----------------------------------------------------
-- Calendar-Addon for OpenEstate-ImmoTool
-- update 2 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Add table 'immotool_calendar_entries_logs'
-- Add view 'view_immotool_calendar_entries_logs'
-- Add procedure 'save_immotool_calendar_entries_logs'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table immotool_calendar_entries_logs
-- -----------------------------------------------------
CREATE CACHED TABLE immotool_calendar_entries_logs (
  log_id BIGINT NOT NULL,
  entry_id BIGINT NOT NULL,
  PRIMARY KEY (log_id, entry_id),
  FOREIGN KEY (log_id)
    REFERENCES immotool_logs(log_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE,
  FOREIGN KEY (entry_id)
    REFERENCES immotool_calendar_entries(entry_id)
    MATCH FULL
    ON UPDATE CASCADE
    ON DELETE CASCADE
);

-- -----------------------------------------------------
-- View view_immotool_calendar_entries_logs
-- -----------------------------------------------------
CREATE VIEW view_immotool_calendar_entries_logs AS
  SELECT a.entry_id, b.* FROM immotool_calendar_entries_logs a
  INNER JOIN immotool_logs b ON ( a.log_id = b.log_id )
  WHERE a.entry_id IN (SELECT entry_id FROM view_immotool_calendar_entries);

GRANT SELECT
  ON view_immotool_calendar_entries_logs
  TO "IMMOTOOL";

\.
-- -----------------------------------------------------
-- Procedure save_immotool_calendar_entries_logs
-- -----------------------------------------------------
CREATE PROCEDURE save_immotool_calendar_entries_logs(
  val_log_id BIGINT,
  val_entry_id BIGINT )
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_calendar_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Protokolleintrag aktualisieren
    DELETE
      FROM immotool_calendar_entries_logs
      WHERE log_id = val_log_id;

    INSERT
      INTO immotool_calendar_entries_logs (log_id, entry_id)
      VALUES (val_log_id, val_entry_id);

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_calendar_entries_logs
  TO "IMMOTOOL";
