-- -----------------------------------------------------
-- Calendar-Addon for OpenEstate-ImmoTool
-- update 4 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Remove access fields in 'immotool_calendar_entries'
-- Rebuild 'view_immotool_calendar_entries'
-- Rebuild 'view_immotool_calendar_entries_logs'
-- Rebuild 'can_delete_immotool_calendar_entries'
-- Rebuild 'can_write_immotool_calendar_entries'
-- Rebuild 'remove_immotool_calendar_entries'
-- Rebuild 'save_immotool_calendar_entries'
-- Rebuild 'save_immotool_calendar_entries_logs'
-- -----------------------------------------------------


DROP VIEW IF EXISTS view_immotool_calendar_entries CASCADE;
DROP VIEW IF EXISTS view_immotool_calendar_entries_logs CASCADE;
DROP FUNCTION IF EXISTS can_delete_immotool_calendar_entries CASCADE;
DROP FUNCTION IF EXISTS can_write_immotool_calendar_entries CASCADE;
DROP PROCEDURE IF EXISTS remove_immotool_calendar_entries CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_calendar_entries CASCADE;
DROP PROCEDURE IF EXISTS save_immotool_calendar_entries_logs CASCADE;


-- -----------------------------------------------------
-- Remove access fields in 'immotool_calendar_entries'
-- -----------------------------------------------------
ALTER TABLE immotool_calendar_entries
  DROP COLUMN access_owner_id CASCADE;
ALTER TABLE immotool_calendar_entries
  DROP COLUMN access_group_id CASCADE;
ALTER TABLE immotool_calendar_entries
  DROP COLUMN access_permissions CASCADE;


-- -----------------------------------------------------
-- Rebuild 'view_immotool_calendar_entries'
-- -----------------------------------------------------
CREATE VIEW view_immotool_calendar_entries AS
  SELECT * FROM immotool_calendar_entries
  WHERE group_id IN (SELECT group_id FROM view_immotool_calendar_groups);

GRANT SELECT
  ON view_immotool_calendar_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'view_immotool_calendar_entries_logs'
-- -----------------------------------------------------
CREATE VIEW view_immotool_calendar_entries_logs AS
  SELECT a.entry_id, b.* FROM immotool_calendar_entries_logs a
  INNER JOIN immotool_logs b ON ( a.log_id = b.log_id )
  WHERE a.entry_id IN (SELECT entry_id FROM view_immotool_calendar_entries)
  AND b.plugin_id IN (SELECT plugin_id FROM view_immotool_plugins WHERE plugin_name='OpenEstate-Tool-Calendar');

GRANT SELECT
  ON view_immotool_calendar_entries_logs
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'can_delete_immotool_calendar_entries'
-- -----------------------------------------------------
\.
CREATE FUNCTION can_delete_immotool_calendar_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_delete_immotool_calendar_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Benutzer-Rechte der Kalender-Gruppe ermitteln
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_calendar_groups
      WHERE group_id IN (SELECT group_id FROM immotool_calendar_entries WHERE entry_id = val_entry_id);

    -- Zum Löschen eines Kalender-Eintrages müssen Schreibrechte auf der Kalender-Gruppe vorliegen
    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild 'can_write_immotool_calendar_entries'
-- -----------------------------------------------------
\.
CREATE FUNCTION can_write_immotool_calendar_entries( val_entry_id BIGINT )
  RETURNS BOOLEAN
  SPECIFIC can_write_immotool_calendar_entries
  READS SQL DATA
  BEGIN ATOMIC
    DECLARE permissions INT;
    DECLARE owner_uid BIGINT;
    DECLARE owner_gid BIGINT;

    -- auf Administrator-Rechte prüfen
    IF is_admin() = TRUE THEN
      RETURN TRUE;
    END IF;

    -- Benutzer-Rechte der Kalender-Gruppe ermitteln
    SELECT access_permissions, access_owner_id, access_group_id
      INTO permissions, owner_uid, owner_gid
      FROM immotool_calendar_groups
      WHERE group_id IN (SELECT group_id FROM immotool_calendar_entries WHERE entry_id = val_entry_id);

    -- Zum Bearbeiten eines Kalender-Eintrages müssen Schreibrechte auf der Kalender-Gruppe vorliegen
    RETURN can_write( permissions, owner_uid, owner_gid );
  END;
.;


-- -----------------------------------------------------
-- Rebuild 'remove_immotool_calendar_entries'
-- -----------------------------------------------------
\.
CREATE PROCEDURE remove_immotool_calendar_entries( val_entry_id BIGINT )
  SPECIFIC remove_immotool_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    IF val_entry_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- sicherstellen, dass der Benutzer Lösch-Rechte besitzt
    SET allowed = can_delete_immotool_calendar_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Eintrag entfernen
    DELETE
      FROM immotool_calendar_entries
      WHERE entry_id = val_entry_id;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE remove_immotool_calendar_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_calendar_entries'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_calendar_entries(
    INOUT val_entry_id BIGINT,
    val_group_id BIGINT,
    val_entry_uid VARCHAR(255),
    val_entry_type VARCHAR(45),
    val_entry_status VARCHAR(45),
    val_entry_title VARCHAR(255),
    val_entry_begin TIMESTAMP WITH TIME ZONE,
    val_entry_end TIMESTAMP WITH TIME ZONE,
    val_entry_notes LONGVARCHAR,
    val_entry_ical LONGVARCHAR
  )
  SPECIFIC save_immotool_calendar_entries
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte auf der Kalender-Gruppe vorliegen
    IF val_group_id < 1 THEN
      SIGNAL SQLSTATE '45000';
    END IF;
    SET allowed = can_write_immotool_calendar_groups( val_group_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Neuen Eintrag erzeugen
    IF val_entry_id < 1 THEN

      -- Eintrag speichern
      INSERT INTO immotool_calendar_entries (
        group_id,
        entry_uid,
        entry_type,
        entry_status,
        entry_title,
        entry_begin,
        entry_end,
        entry_notes,
        entry_ical )
      VALUES (
        val_group_id,
        val_entry_uid,
        val_entry_type,
        val_entry_status,
        val_entry_title,
        val_entry_begin,
        val_entry_end,
        val_entry_notes,
        val_entry_ical );

      -- ID zurückliefern
      SET val_entry_id = IDENTITY();

    -- Bestehenden Eintrag bearbeiten
    ELSE

      -- Eintrag bearbeiten
      UPDATE immotool_calendar_entries
        SET
          group_id = val_group_id,
          entry_uid = val_entry_uid,
          entry_type = val_entry_type,
          entry_status = val_entry_status,
          entry_title = val_entry_title,
          entry_begin = val_entry_begin,
          entry_end = val_entry_end,
          entry_notes = val_entry_notes,
          entry_ical = val_entry_ical,
          modified_at = NOW()
        WHERE
          entry_id = val_entry_id;

    END IF;

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_calendar_entries
  TO "IMMOTOOL";


-- -----------------------------------------------------
-- Rebuild 'save_immotool_calendar_entries_logs'
-- -----------------------------------------------------
\.
CREATE PROCEDURE save_immotool_calendar_entries_logs(
    val_log_id BIGINT,
    val_entry_id BIGINT
  )
  SPECIFIC save_immotool_calendar_entries_logs
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE allowed BOOLEAN;

    -- Prüfen ob Schreib-Rechte vorliegen
    SET allowed = can_write_immotool_calendar_entries( val_entry_id );
    IF NOT allowed = TRUE THEN
      SIGNAL SQLSTATE '45000';
    END IF;

    -- Protokolleintrag aktualisieren
    DELETE
      FROM immotool_calendar_entries_logs
      WHERE log_id = val_log_id;

    INSERT
      INTO immotool_calendar_entries_logs (log_id, entry_id)
      VALUES (val_log_id, val_entry_id);

  END;
.;

GRANT EXECUTE
  ON PROCEDURE save_immotool_calendar_entries_logs
  TO "IMMOTOOL";
