-- -----------------------------------------------------
-- Calendar-Addon for OpenEstate-ImmoTool
-- update 6 for HSQLDB
-- Copyright (C) 2009-2019 OpenEstate.org
-- -----------------------------------------------------
-- Call temporary procedure 'immotool_calendar_update_permissions'
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Call temporary procedure 'immotool_calendar_update_permissions'
-- -----------------------------------------------------
DROP PROCEDURE
  IF EXISTS immotool_calendar_update_permissions;

\.
CREATE PROCEDURE immotool_calendar_update_permissions()
  SPECIFIC immotool_calendar_update_permissions
  MODIFIES SQL DATA
  BEGIN ATOMIC
    DECLARE pluginId BIGINT;
    DECLARE permissionId BIGINT;
    DECLARE groupId BIGINT;

    -- ID des Plugins ermitteln
    SELECT plugin_id
      INTO pluginId
      FROM immotool_plugins
      WHERE plugin_name = 'OpenEstate-Tool-Calendar';

    -- USE_PLUGIN-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'USE_PLUGIN' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ID der IMMOTOOL-Gruppe ermitteln
    SELECT group_id
      INTO groupId
      FROM immotool_groups
      WHERE group_name = 'IMMOTOOL';

    -- USE_PLUGIN-Berechtigung zur IMMOTOOL-Gruppe zuweisen
    INSERT INTO immotool_groups_permissions (
      group_id,
      permission_id )
    VALUES (
      groupId,
      permissionId );

    -- Umbenennung der bestehenden Berechtigungen
    UPDATE immotool_permissions
      SET permission_key = 'GROUPS_EDIT', modified_at = NOW()
      WHERE permission_key = 'calendar.edit'
      AND plugin_id = pluginId;

    UPDATE immotool_permissions
      SET permission_key = 'GROUPS_REMOVE', modified_at = NOW()
      WHERE permission_key = 'calendar.remove'
      AND plugin_id = pluginId;


    -- ENTRIES_EDIT-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ENTRIES_EDIT' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ENTRIES_EDIT-Berechtigung allen Benutzern mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );

    -- ENTRIES_EDIT-Berechtigung allen Gruppen mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );


    -- ENTRIES_EDIT_GROUP-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ENTRIES_EDIT_GROUP' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ENTRIES_EDIT_GROUP-Berechtigung allen Benutzern mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );

    -- ENTRIES_EDIT_GROUP-Berechtigung allen Gruppen mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );


    -- ENTRIES_IMPORT-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ENTRIES_IMPORT' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ENTRIES_IMPORT-Berechtigung allen Benutzern mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );

    -- ENTRIES_IMPORT-Berechtigung allen Gruppen mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );


    -- ENTRIES_REMOVE-Berechtigung erzeugen
    INSERT INTO immotool_permissions (
      plugin_id,
      permission_key )
    VALUES (
      pluginId,
      'ENTRIES_REMOVE' );

    -- ID der erzeugten Berechtigung zurückliefern
    SET permissionId = IDENTITY();

    -- ENTRIES_REMOVE-Berechtigung allen Benutzern mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_users_permissions (user_id, permission_id)
      (SELECT up.user_id, permissionId FROM immotool_users_permissions up WHERE up.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );

    -- ENTRIES_REMOVE-Berechtigung allen Gruppen mit GROUPS_EDIT-Berechtigung zuweisen
    INSERT INTO immotool_groups_permissions (group_id, permission_id)
      (SELECT gp.group_id, permissionId FROM immotool_groups_permissions gp WHERE gp.permission_id IN
        (SELECT p.permission_id FROM immotool_permissions p WHERE p.plugin_id=pluginId AND p.permission_key='GROUPS_EDIT')
      );

  END;
.;

CALL immotool_calendar_update_permissions();

DROP PROCEDURE
  IF EXISTS immotool_calendar_update_permissions;
