/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.io.read.boundary;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jepub.core.io.read.boundary.EpubInput;
import org.jepub.core.io.read.control.EpubContentBinary;
import org.jepub.core.spec.metainf.container.boundary.ContainerXml;
import org.jepub.core.spec.rendition.boundary.PackageRendition;
import org.jepub.core.spec.rendition.boundary.Rendition;

public final class EpubFile
implements EpubInput {
    private final File ePub;

    public EpubFile(File ePub) {
        this.ePub = ePub;
    }

    @Override
    public List<Rendition> renditions() {
        try {
            ArrayList<Rendition> renditions = new ArrayList<Rendition>();
            for (String path : this.opfLocations()) {
                byte[] opf = new EpubContentBinary(this.ePub, path).load();
                String localPath = path.substring(0, path.lastIndexOf("/"));
                renditions.add(new PackageRendition(this.ePub, localPath, opf));
            }
            return renditions;
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't process the ePub file!", ex);
        }
    }

    private List<String> opfLocations() throws IOException {
        byte[] container = new EpubContentBinary(this.ePub, "META-INF/container.xml").load();
        return new ContainerXml(container).opfLocations();
    }
}

