/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.io.write.boundary;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jepub.core.io.write.boundary.Directory;
import org.jepub.core.io.write.boundary.Extraction;
import org.jepub.core.io.write.boundary.FolderDirectory;
import org.jepub.core.io.write.control.PrefixWord;
import org.jepub.core.io.write.control.RandomWord;

public final class EpubExtraction
implements Extraction {
    private final String path;
    private final String name;
    private final Directory directory;

    public EpubExtraction() {
        this(System.getProperty("java.io.tmpdir"), new PrefixWord("jepub", new RandomWord()).asString());
    }

    public EpubExtraction(String path, String name) {
        this.path = path;
        this.name = name;
        this.directory = new FolderDirectory();
    }

    @Override
    public String extract(File file) throws IOException {
        String location = this.directory.create(this.path, this.name);
        try (ZipFile zip = new ZipFile(file);){
            Enumeration<? extends ZipEntry> entries = zip.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                File content = new File(location + "/" + entry.getName());
                if (entry.getName().endsWith("/")) {
                    content.mkdirs();
                    continue;
                }
                File parent = content.getParentFile();
                if (parent != null) {
                    parent.mkdirs();
                }
                InputStream stream = zip.getInputStream(entry);
                Throwable throwable = null;
                try {
                    FileOutputStream out = new FileOutputStream(content);
                    Throwable throwable2 = null;
                    try {
                        int data = stream.read();
                        while (data != -1) {
                            out.write(data);
                            data = stream.read();
                        }
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        if (out == null) continue;
                        if (throwable2 != null) {
                            try {
                                out.close();
                            }
                            catch (Throwable throwable4) {
                                throwable2.addSuppressed(throwable4);
                            }
                            continue;
                        }
                        out.close();
                    }
                }
                catch (Throwable throwable5) {
                    throwable = throwable5;
                    throw throwable5;
                }
                finally {
                    if (stream == null) continue;
                    if (throwable != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable6) {
                            throwable.addSuppressed(throwable6);
                        }
                        continue;
                    }
                    stream.close();
                }
            }
            String string = location;
            return string;
        }
    }
}

