/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.access.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.access.boundary.Access;
import org.jepub.core.spec.access.control.Components;
import org.jepub.core.spec.access.entity.Component;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.spec.resource.control.Path;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class Landmarks
implements Access {
    private final Path location;

    public Landmarks(String path) {
        this.location = new AbsolutePath(path);
    }

    @Override
    public Components compose(byte[] file) {
        Components result = null;
        try (ByteArrayInputStream stream = new ByteArrayInputStream(file);){
            XMLEventReader reader = ParseStaxXml.read(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (!event.isStartElement() || !this.isLandmarks(event)) continue;
                result = this.processComponent(reader);
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't read the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the package document file!", ex);
        }
        return result;
    }

    private Components processComponent(XMLEventReader reader) throws XMLStreamException {
        String title = null;
        ArrayList<Component> temps = new ArrayList<Component>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement()) {
                if (this.isHeading(event.asStartElement().getName().getLocalPart())) {
                    title = this.title(reader);
                }
                if (this.isOrder(event.asStartElement().getName().getLocalPart())) {
                    temps.addAll(this.components(reader));
                }
            }
            if (event.isEndElement() && this.isNav(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        Components components = title != null ? new Components(title) : new Components();
        components.append(temps);
        return components;
    }

    private String title(XMLEventReader reader) throws XMLStreamException {
        String result = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && this.isHeading(event.asStartElement().getName().getLocalPart())) {
                event = reader.nextEvent();
                result = ParseStaxXml.elementValue(event).orElse(null);
            }
            if (!event.isEndElement() || !this.isHeading(event.asEndElement().getName().getLocalPart())) continue;
            break;
        }
        return result;
    }

    private List<Component> components(XMLEventReader reader) throws XMLStreamException {
        ArrayList<Component> results = new ArrayList<Component>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isList(event.asStartElement().getName().getLocalPart())) {
                results.add(this.component(reader));
            }
            if (event.isEndElement() && this.isOrder(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return results;
    }

    private Component component(XMLEventReader reader) throws XMLStreamException {
        String href = null;
        String type = null;
        String title = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isHref(event.asStartElement().getName().getLocalPart())) {
                event = reader.nextEvent();
                href = this.path(event);
                type = this.type(event);
                title = ParseStaxXml.elementValue(reader.nextEvent()).orElse(null);
            }
            if (event.isEndElement() && this.isList(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        Component component = new Component(title, type, href);
        return component;
    }

    private String path(XMLEvent event) throws XMLStreamException {
        String result = null;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!"href".equals(attribute.getName().getLocalPart())) continue;
            result = this.location.compose(attribute.getValue());
        }
        return result;
    }

    private String type(XMLEvent event) throws XMLStreamException {
        String result = null;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!"type".equals(attribute.getName().getLocalPart())) continue;
            result = attribute.getValue();
        }
        return result;
    }

    private boolean isLandmarks(XMLEvent event) throws XMLStreamException {
        boolean result = false;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!"type".equals(attribute.getName().getLocalPart()) || !"landmarks".equals(attribute.getValue())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isNav(String element) {
        return "nav".equals(element);
    }

    private boolean isHeading(String element) {
        return "h1".equals(element);
    }

    private boolean isOrder(String element) {
        return "ol".equals(element);
    }

    private boolean isList(String element) {
        return "li".equals(element);
    }

    private boolean isHref(String element) {
        return "a".equals(element);
    }
}

