/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.cover.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.cover.boundary.Cover;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.xml.boundary.StaxXmlAttribute;

public final class ImageCover
implements Cover {
    private final String path;
    private final byte[] opf;

    public ImageCover(String path, byte[] opf) {
        this.path = path;
        this.opf = opf;
    }

    @Override
    public Optional<String> path() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(this.opf);){
            String href = null;
            try {
                XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
                while (reader.hasNext()) {
                    Map<String, String> attributes;
                    XMLEvent event = reader.nextEvent();
                    if (event.isStartElement() && this.isItem(event.asStartElement().getName().getLocalPart()) && (attributes = new StaxXmlAttribute(event).attributes()).containsKey("properties") && this.isCoverImage(attributes.get("properties"))) {
                        href = attributes.get("href");
                    } else if (!event.isEndElement() || !this.isManifest(event.asEndElement().getName().getLocalPart())) continue;
                    break;
                }
            }
            catch (XMLStreamException ex) {
                throw new IOException("Can not process Open Packaging Format file!", ex);
            }
            Optional<String> result = href == null ? Optional.empty() : Optional.of(new AbsolutePath(this.path).compose(href));
            Optional<String> optional = result;
            return optional;
        }
    }

    private boolean isManifest(String element) {
        return "manifest".equals(element);
    }

    private boolean isItem(String element) {
        return "item".equals(element);
    }

    private boolean isCoverImage(String value) {
        return "cover-image".equals(value);
    }
}

