/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.resource.boundary;

import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.resource.boundary.Resource;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.spec.resource.control.Path;
import org.jepub.core.xml.boundary.EventValidate;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class ItemResource
implements Resource {
    private final Map<String, String> attributes;
    private final Path location;

    public ItemResource(String path, XMLEvent event) throws XMLStreamException {
        this.attributes = ParseStaxXml.elementAttributes(EventValidate.startElement(event, "item"));
        this.location = new AbsolutePath(path);
    }

    @Override
    public String name() {
        return this.attributes.get("id");
    }

    @Override
    public String path() {
        return this.location.compose(this.attributes.get("href"));
    }

    @Override
    public String mediaType() {
        return this.attributes.get("media-type");
    }

    @Override
    public Optional<String> property() {
        return Optional.ofNullable(this.attributes.get("properties"));
    }
}

