/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.metainf.container.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.metainf.container.boundary.Container;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class ContainerXml
implements Container {
    private final byte[] container;

    public ContainerXml(byte[] container) {
        this.container = container;
    }

    @Override
    public List<String> opfLocations() {
        XMLEventReader reader;
        ArrayList<String> result = new ArrayList<String>();
        try (ByteArrayInputStream content = new ByteArrayInputStream(this.container);){
            reader = ParseStaxXml.read(content);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't open the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the container.xml file!", ex);
        }
        try {
            Object event;
            while (reader.hasNext()) {
                Map<String, String> attributes;
                event = reader.peek();
                if (event.isStartElement() && this.isRootFile(event.asStartElement().getName().getLocalPart()) && this.isOpfFile((attributes = ParseStaxXml.elementAttributes((XMLEvent)(event = reader.nextEvent()))).get("media-type"))) {
                    result.add(attributes.get("full-path"));
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
            event = result;
            return event;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't parse the container.xml file!", ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    private boolean isRootFile(String element) {
        return "rootfile".equals(element);
    }

    private boolean isOpfFile(String mime) {
        return "application/oebps-package+xml".equals(mime);
    }
}

