/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.navigation.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.navigation.boundary.TableOfContents;
import org.jepub.core.spec.navigation.control.Contents;
import org.jepub.core.spec.navigation.entity.Content;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.spec.resource.control.Path;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class NavContents
implements TableOfContents {
    private final Path location;

    public NavContents(String root) {
        this.location = new AbsolutePath(root);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Contents compose(byte[] file) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(file);){
            Contents contents = null;
            XMLEventReader reader = ParseStaxXml.read(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.nextEvent();
                if (event.isStartElement() && this.isToc(event)) {
                    contents = this.processContents(reader);
                }
                if (!event.isEndElement() || !this.isNav(event.asEndElement().getName().getLocalPart())) continue;
            }
            Contents contents2 = contents;
            return contents2;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private Contents processContents(XMLEventReader reader) throws XMLStreamException {
        ArrayList<Content> temps = new ArrayList<Content>();
        String title = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement()) {
                if (this.isHeading(event.asStartElement().getName().getLocalPart())) {
                    title = this.title(reader);
                }
                if (this.isOrder(event.asStartElement().getName().getLocalPart())) {
                    temps.addAll(this.contents(reader));
                }
            }
            if (event.isEndElement() && this.isNav(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        Contents contents = title != null ? new Contents(title) : new Contents();
        contents.append(temps);
        return contents;
    }

    private String title(XMLEventReader reader) throws XMLStreamException {
        String result = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.nextEvent();
            if (event.isStartElement() && this.isHeading(event.asStartElement().getName().getLocalPart())) {
                event = reader.nextEvent();
                result = ParseStaxXml.elementValue(event).orElse(null);
            }
            if (!event.isEndElement() || !this.isHeading(event.asEndElement().getName().getLocalPart())) continue;
            break;
        }
        return result;
    }

    private List<Content> contents(XMLEventReader reader) throws XMLStreamException {
        ArrayList<Content> results = new ArrayList<Content>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isList(event.asStartElement().getName().getLocalPart())) {
                results.add(this.content(reader));
            }
            if (event.isEndElement() && this.isOrder(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return results;
    }

    private Content content(XMLEventReader reader) throws XMLStreamException {
        String path = null;
        String title = null;
        ArrayList<Content> subContents = new ArrayList<Content>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement()) {
                if (this.isOrder(event.asStartElement().getName().getLocalPart())) {
                    subContents.addAll(this.contents(reader));
                }
                if (this.isHref(event.asStartElement().getName().getLocalPart())) {
                    event = reader.nextEvent();
                    path = this.path(event);
                    title = ParseStaxXml.elementValue(reader.nextEvent()).orElse(null);
                }
            }
            if (event.isEndElement() && this.isList(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        Content content = new Content(title, path);
        for (Content ctn : subContents) {
            content.addSubContent(ctn);
        }
        return content;
    }

    private String path(XMLEvent event) throws XMLStreamException {
        String result = null;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!this.isHref(attribute.getName().getLocalPart())) continue;
            result = this.location.compose(attribute.getValue());
        }
        return result;
    }

    private boolean isToc(XMLEvent event) throws XMLStreamException {
        boolean result = false;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!this.isType(attribute.getName().getLocalPart()) || !"toc".equals(attribute.getValue())) continue;
            result = true;
            break;
        }
        return result;
    }

    private boolean isNav(String element) {
        return "nav".equals(element);
    }

    private boolean isHeading(String element) {
        return "h1".equals(element);
    }

    private boolean isOrder(String element) {
        return "ol".equals(element);
    }

    private boolean isList(String element) {
        return "li".equals(element);
    }

    private boolean isHref(String element) {
        return "a".equals(element);
    }

    private boolean isType(String element) {
        return "type".equals(element);
    }
}

