/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.io.write.boundary;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Comparator;
import org.jepub.core.io.write.boundary.Directory;

public final class FolderDirectory
implements Directory {
    @Override
    public String create(String path, String name) throws IOException {
        String location = this.location(path, name);
        Path destination = Paths.get(location, new String[0]);
        if (Files.exists(destination, new LinkOption[0])) {
            throw new IOException("The destination directory already existed!");
        }
        Files.createDirectory(destination, new FileAttribute[0]);
        return location;
    }

    @Override
    public void delete(String location) throws IOException {
        Path destination = Paths.get(location, new String[0]);
        Files.walk(destination, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    private String location(String base, String name) {
        return base + System.getProperty("file.separator") + name;
    }
}

