/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.access.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.access.boundary.Access;
import org.jepub.core.spec.access.control.Components;
import org.jepub.core.spec.access.entity.Component;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.spec.resource.control.Path;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class GuideAccess
implements Access {
    private final Path location;

    public GuideAccess(String path) {
        this.location = new AbsolutePath(path);
    }

    @Override
    public Components compose(byte[] file) {
        Components result = new Components();
        try (ByteArrayInputStream stream = new ByteArrayInputStream(file);){
            XMLEventReader reader = ParseStaxXml.read(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if (event.isStartElement() && this.isGuide(event.asStartElement().getName().getLocalPart())) {
                    result.append(this.reference(reader));
                }
                if (event.isEndElement() && this.isGuide(event.asEndElement().getName().getLocalPart())) {
                    break;
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't read the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the package document file!", ex);
        }
        return result;
    }

    private List<Component> reference(XMLEventReader reader) throws XMLStreamException {
        ArrayList<Component> result = new ArrayList<Component>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isReference(event.asStartElement().getName().getLocalPart())) {
                event = reader.nextEvent();
                Map<String, String> attributes = ParseStaxXml.elementAttributes(event);
                result.add(new Component(attributes.get("title"), attributes.get("type"), this.location.compose(attributes.get("href"))));
            }
            if (event.isEndElement() && this.isGuide(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return result;
    }

    private boolean isGuide(String element) {
        return "guide".equals(element);
    }

    private boolean isReference(String element) {
        return "reference".equals(element);
    }
}

