/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.cover.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Optional;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.cover.boundary.Cover;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.xml.boundary.StaxXmlAttribute;

public final class KindleCover
implements Cover {
    private final String path;
    private final byte[] opf;

    public KindleCover(String path, byte[] opf) {
        this.path = path;
        this.opf = opf;
    }

    @Override
    public Optional<String> path() throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(this.opf);){
            Optional<Object> href = Optional.empty();
            Optional<Object> id = Optional.empty();
            try {
                XMLEventReader reader = XMLInputFactory.newInstance().createXMLEventReader(stream);
                while (reader.hasNext()) {
                    XMLEvent event = reader.nextEvent();
                    if (!event.isStartElement()) continue;
                    if (this.isMeta(event.asStartElement().getName().getLocalPart()) && !id.isPresent()) {
                        id = this.metaCover(new StaxXmlAttribute(event).attributes());
                    }
                    if (!this.isItem(event.asStartElement().getName().getLocalPart()) || !id.isPresent() || href.isPresent()) continue;
                    href = this.itemLocation((String)id.get(), new StaxXmlAttribute(event).attributes());
                }
            }
            catch (XMLStreamException ex) {
                throw new IOException("Can not process Open Packaging Format file!", ex);
            }
            Optional<String> result = href.isPresent() ? Optional.of(new AbsolutePath(this.path).compose((String)href.get())) : Optional.empty();
            Optional<String> optional = result;
            return optional;
        }
    }

    private Optional<String> metaCover(Map<String, String> attributes) {
        String result = null;
        if (attributes.containsKey("name") && this.isCoverImage(attributes.get("name"))) {
            result = attributes.get("content");
        }
        return Optional.ofNullable(result);
    }

    private Optional<String> itemLocation(String id, Map<String, String> attributes) {
        String result = null;
        if (attributes.get("id").equals(id)) {
            result = attributes.get("href");
        }
        return Optional.ofNullable(result);
    }

    private boolean isMeta(String element) {
        return "meta".equals(element);
    }

    private boolean isItem(String element) {
        return "item".equals(element);
    }

    private boolean isCoverImage(String element) {
        return "cover".equals(element);
    }
}

