/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.navigation.boundary;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.Optional;
import javax.xml.stream.XMLStreamException;
import org.jepub.core.io.read.control.EpubContentBinary;
import org.jepub.core.spec.navigation.boundary.NavContents;
import org.jepub.core.spec.navigation.boundary.Navigation;
import org.jepub.core.spec.navigation.boundary.NcxContents;
import org.jepub.core.spec.navigation.boundary.Order;
import org.jepub.core.spec.navigation.boundary.SpineOrder;
import org.jepub.core.spec.navigation.control.Contents;
import org.jepub.core.spec.resource.boundary.Resource;
import org.jepub.core.spec.resource.control.Resources;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class DocumentNavigation
implements Navigation {
    private final File ePub;
    private final Resources resources;
    private final byte[] opf;

    public DocumentNavigation(File ePub, Resources resources, byte[] opf) {
        this.resources = resources;
        this.ePub = ePub;
        this.opf = opf;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Order order() {
        try (ByteArrayInputStream content = new ByteArrayInputStream(this.opf);){
            SpineOrder spineOrder = new SpineOrder(this.resources, ParseStaxXml.read(content));
            return spineOrder;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't read the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the package document file!", ex);
        }
    }

    @Override
    public Optional<Contents> toc() {
        Iterator<Resource> rscIterator = this.resources.iterator();
        Optional<Contents> result = Optional.empty();
        while (rscIterator.hasNext()) {
            Resource resource = rscIterator.next();
            if (resource.property().isPresent() && resource.property().get().equals("nav")) {
                try {
                    byte[] navToC = new EpubContentBinary(this.ePub, resource.path()).load();
                    result = Optional.ofNullable(new NavContents(this.resources.root()).compose(navToC));
                    break;
                }
                catch (IOException ex) {
                    throw new RuntimeException(ex);
                }
            }
            if (!this.isNcxMime(resource.mediaType())) continue;
            try {
                byte[] ncxToC = new EpubContentBinary(this.ePub, resource.path()).load();
                result = Optional.ofNullable(new NcxContents(this.resources.root()).compose(ncxToC));
                break;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        return result;
    }

    private boolean isNcxMime(String mime) {
        return "application/x-dtbncx+xml".equals(mime);
    }
}

