/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.navigation.boundary;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.navigation.boundary.TableOfContents;
import org.jepub.core.spec.navigation.control.Contents;
import org.jepub.core.spec.navigation.entity.Content;
import org.jepub.core.spec.resource.control.AbsolutePath;
import org.jepub.core.spec.resource.control.Path;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class NcxContents
implements TableOfContents {
    private final Path location;

    public NcxContents(String root) {
        this.location = new AbsolutePath(root);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Contents compose(byte[] file) throws IOException {
        try (ByteArrayInputStream stream = new ByteArrayInputStream(file);){
            ArrayList<Content> temps = new ArrayList<Content>();
            String title = null;
            XMLEventReader reader = ParseStaxXml.read(stream);
            while (reader.hasNext()) {
                XMLEvent event = reader.peek();
                if (event.isStartElement()) {
                    if (this.isDocTitle(event.asStartElement().getName().getLocalPart())) {
                        title = this.docTitle(reader);
                    }
                    if (this.isNavMap(event.asStartElement().getName().getLocalPart())) {
                        temps.addAll(this.navPoints(reader));
                    }
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
            Contents contents = title != null ? new Contents(title) : new Contents();
            contents.append(temps);
            Contents contents2 = contents;
            return contents2;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String docTitle(XMLEventReader reader) throws XMLStreamException {
        String result = null;
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isText(event.asStartElement().getName().getLocalPart())) {
                event = reader.nextEvent();
                result = ParseStaxXml.elementValue(reader.nextEvent()).orElse(null);
            }
            if (event.isEndElement() && this.isDocTitle(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return result;
    }

    private List<Content> navPoints(XMLEventReader reader) throws XMLStreamException {
        ArrayList<Content> results = new ArrayList<Content>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement() && this.isNavPoint(event.asStartElement().getName().getLocalPart())) {
                results.add(this.navPoint(reader));
            }
            if (event.isEndElement() && this.isNavPoint(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return results;
    }

    private Content navPoint(XMLEventReader reader) throws XMLStreamException {
        String title = null;
        String path = null;
        int counter = 0;
        ArrayList<Content> subContents = new ArrayList<Content>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement()) {
                if (this.isNavPoint(event.asStartElement().getName().getLocalPart())) {
                    if (counter != 0) {
                        subContents.addAll(this.navPoints(reader));
                        break;
                    }
                    ++counter;
                }
                if (this.isText(event.asStartElement().getName().getLocalPart())) {
                    event = reader.nextEvent();
                    title = ParseStaxXml.elementValue(reader.nextEvent()).orElseThrow(XMLStreamException::new);
                }
                if (this.isContent(event.asStartElement().getName().getLocalPart())) {
                    path = this.path(reader.nextEvent());
                }
            }
            if (event.isEndElement() && this.isNavPoint(event.asEndElement().getName().getLocalPart())) break;
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return this.composeContent(title, path, subContents);
    }

    private String path(XMLEvent event) throws XMLStreamException {
        String path = null;
        Iterator<Attribute> attributes = event.asStartElement().getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (!this.isSrc(attribute.getName().getLocalPart())) continue;
            path = this.location.compose(attribute.getValue());
        }
        return path;
    }

    private Content composeContent(String title, String path, List<Content> subContents) {
        Content result = new Content(title, path);
        for (Content ctn : subContents) {
            result.addSubContent(ctn);
        }
        return result;
    }

    private boolean isDocTitle(String element) {
        return "docTitle".equals(element);
    }

    private boolean isNavMap(String element) {
        return "navMap".equals(element);
    }

    private boolean isNavPoint(String element) {
        return "navPoint".equals(element);
    }

    private boolean isNavLabel(String element) {
        return "navLabel".equals(element);
    }

    private boolean isText(String element) {
        return "text".equals(element);
    }

    private boolean isContent(String element) {
        return "content".equals(element);
    }

    private boolean isSrc(String element) {
        return "src".equals(element);
    }
}

