/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.navigation.boundary;

import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.navigation.boundary.Order;
import org.jepub.core.spec.navigation.control.References;
import org.jepub.core.spec.navigation.entity.ResourceReference;
import org.jepub.core.spec.resource.boundary.Resource;
import org.jepub.core.spec.resource.control.Resources;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class SpineOrder
implements Order {
    private final Resources resources;
    private final XMLEventReader reader;

    public SpineOrder(Resources resources, XMLEventReader reader) {
        this.resources = resources;
        this.reader = reader;
    }

    @Override
    public References resources() {
        References references = new References();
        try {
            while (this.reader.hasNext()) {
                XMLEvent event = this.reader.peek();
                if (event.isStartElement() && this.isItemRef(event.asStartElement().getName().getLocalPart())) {
                    ResourceReference reference;
                    event = this.reader.nextEvent();
                    Map<String, String> attributes = ParseStaxXml.elementAttributes(event);
                    Resource resource = this.findResource(attributes.get("idref"));
                    if (attributes.containsKey("linear")) {
                        boolean visible = attributes.get("linear").equals("yes");
                        reference = new ResourceReference(visible, resource);
                    } else {
                        reference = new ResourceReference(resource);
                    }
                    references.add(reference);
                }
                if (!this.reader.hasNext()) continue;
                this.reader.next();
            }
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException(ex);
        }
        return references;
    }

    private boolean isItemRef(String element) {
        return "itemref".equals(element);
    }

    private Resource findResource(String name) throws XMLStreamException {
        for (Resource rsc : this.resources) {
            if (!name.equals(rsc.name())) continue;
            return rsc;
        }
        throw new XMLStreamException(String.format("Can't find resource with reference %s!", name));
    }
}

