/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.rendition.boundary;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.io.read.control.EpubContentBinary;
import org.jepub.core.spec.access.boundary.GuideAccess;
import org.jepub.core.spec.access.boundary.Landmarks;
import org.jepub.core.spec.access.control.Components;
import org.jepub.core.spec.cover.boundary.Cover;
import org.jepub.core.spec.cover.boundary.ImageCover;
import org.jepub.core.spec.metadata.boundary.EpubInfo;
import org.jepub.core.spec.metadata.boundary.MetaInfo;
import org.jepub.core.spec.navigation.boundary.DocumentNavigation;
import org.jepub.core.spec.navigation.boundary.Navigation;
import org.jepub.core.spec.rendition.boundary.Rendition;
import org.jepub.core.spec.resource.boundary.ItemResource;
import org.jepub.core.spec.resource.boundary.Resource;
import org.jepub.core.spec.resource.control.Resources;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class PackageRendition
implements Rendition {
    private final File ePub;
    private final String path;
    private final byte[] opf;

    public PackageRendition(File ePub, String path, byte[] opf) {
        this.ePub = ePub;
        this.path = path;
        this.opf = opf;
    }

    @Override
    public Cover cover() {
        return new ImageCover(this.path, this.opf);
    }

    @Override
    public EpubInfo metadata() {
        XMLEventReader reader;
        try (ByteArrayInputStream content = new ByteArrayInputStream(this.opf);){
            reader = ParseStaxXml.read(content);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't read the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the package document file!", ex);
        }
        try {
            MetaInfo ex = new MetaInfo(reader);
            return ex;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't parse the Metadata information!", ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public Resources manifest() {
        XMLEventReader reader;
        try (ByteArrayInputStream content = new ByteArrayInputStream(this.opf);){
            reader = ParseStaxXml.read(content);
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't read the XML file!", ex);
        }
        catch (IOException ex) {
            throw new RuntimeException("Can't open the package document file!", ex);
        }
        Resources resources = new Resources(this.path);
        try {
            Object event;
            while (reader.hasNext()) {
                event = reader.peek();
                if (event.isStartElement() && this.isItem(event.asStartElement().getName().getLocalPart())) {
                    event = reader.nextEvent();
                    resources.add(new ItemResource(this.path, (XMLEvent)event));
                }
                if (!reader.hasNext()) continue;
                reader.next();
            }
            event = resources;
            return event;
        }
        catch (XMLStreamException ex) {
            throw new RuntimeException("Can't parse the Manifest information!", ex);
        }
        finally {
            try {
                reader.close();
            }
            catch (XMLStreamException ex) {
                throw new RuntimeException(ex);
            }
        }
    }

    @Override
    public Navigation spine() {
        return new DocumentNavigation(this.ePub, this.manifest(), this.opf);
    }

    @Override
    public Components guide() {
        Components result = null;
        for (Resource resource : this.manifest()) {
            if (!resource.property().isPresent() || !resource.property().get().equals("nav")) continue;
            try {
                byte[] navResource = new EpubContentBinary(this.ePub, resource.path()).load();
                result = new Landmarks(this.path).compose(navResource);
                break;
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }
        if (result == null) {
            result = new GuideAccess(this.path).compose(this.opf);
        }
        return result;
    }

    private boolean isItem(String element) {
        return "item".equals(element);
    }
}

