/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.archive.boundary;

import java.io.File;
import java.io.IOException;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.jepub.core.archive.boundary.Content;
import org.jepub.core.archive.entity.ContentStream;

public final class ArchiveContent
implements Content {
    private final File archive;
    private final String path;

    public ArchiveContent(File archive, String path) {
        this.archive = archive;
        this.path = path;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public ContentStream load() throws IOException {
        ZipFile zip = new ZipFile(this.archive);
        ZipEntry entry = zip.getEntry(this.path);
        if (entry == null) {
            zip.close();
            throw new IOException(String.format("Can't find item within location %s inside of %s", this.path, zip.getName()));
        }
        return new ContentStream(zip.getInputStream(entry), zip);
    }
}

