/*
 * Decompiled with CFR 0.152.
 */
package org.jepub.core.spec.metadata.boundary;

import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.jepub.core.spec.metadata.boundary.EpubInfo;
import org.jepub.core.xml.boundary.ParseStaxXml;

public final class MetaInfo
implements EpubInfo {
    private final Map<String, String> data;

    public MetaInfo(XMLEventReader reader) throws XMLStreamException {
        this.data = this.parseMetadata(reader);
    }

    @Override
    public Double version() {
        return Double.valueOf(this.data.get("version"));
    }

    @Override
    public String releaseIdentifier() {
        StringBuilder result = new StringBuilder();
        result.append(this.uniqueIdentifier());
        result.append("@");
        result.append(this.lastModified());
        return result.toString();
    }

    @Override
    public String uniqueIdentifier() {
        return this.data.get("identifier");
    }

    @Override
    public String title() {
        return this.data.get("title");
    }

    @Override
    public String language() {
        return this.data.get("language");
    }

    @Override
    public Instant lastModified() {
        return ZonedDateTime.parse(this.data.get("modified")).toInstant();
    }

    private Map<String, String> parseMetadata(XMLEventReader reader) throws XMLStreamException {
        HashMap<String, String> result = new HashMap<String, String>();
        while (reader.hasNext()) {
            XMLEvent event = reader.peek();
            if (event.isStartElement()) {
                event = reader.nextEvent();
                switch (event.asStartElement().getName().getLocalPart()) {
                    case "package": {
                        result.put("version", ParseStaxXml.elementAttributes(event).get("version"));
                        break;
                    }
                    case "identifier": {
                        event = reader.nextEvent();
                        result.put("identifier", ParseStaxXml.elementValue(event).orElse(""));
                        break;
                    }
                    case "title": {
                        event = reader.nextEvent();
                        result.put("title", ParseStaxXml.elementValue(event).orElse(""));
                        break;
                    }
                    case "language": {
                        event = reader.nextEvent();
                        result.put("language", ParseStaxXml.elementValue(event).orElse(""));
                        break;
                    }
                    case "meta": {
                        Map<String, String> attrributes = ParseStaxXml.elementAttributes(event);
                        if (!attrributes.containsValue("dcterms:modified")) break;
                        event = reader.nextEvent();
                        result.put("modified", ParseStaxXml.elementValue(event).orElse(Instant.now().toString()));
                        break;
                    }
                }
            }
            if (!reader.hasNext()) continue;
            reader.next();
        }
        return result;
    }
}

