/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmo_1_2_3
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_3.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_3;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_2);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removeEmailFeedbackElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <email_feedback> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removePreiseChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <preise> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeFlaechenChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <flaechen> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeAusstattungChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <ausstattung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeZustandAngabenChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <zustand_angaben> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeUserDefinedExtendElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <user_defined_extend> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeParkenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <parken> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBadElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <bad> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeKuecheElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <kueche> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBodenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <boden> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBefeuerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <befeuerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeAusrichtBalkonTerrasseElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <ausricht_balkon_terrasse> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeDachformElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <dachform> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeWohnungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <wohnung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHausElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <haus> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeSonstigeElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <sonstige> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeZinshausRenditeobjektElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <zinshaus_renditeobjekt> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_3);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeSonstigeElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <sonstige> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.upgradeZinshausRenditeobjektElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <zinshaus_renditeobjekt> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeAusrichtBalkonTerrasseElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:ausricht_balkon_terrasse[@NORDOST or @NORDWEST or @SUEDOST or @SUEDWEST]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            String string;
            Element element = (Element)e;
            if (element.hasAttribute("NORDOST")) {
                string = StringUtils.trimToEmpty((String)element.getAttribute("NORDOST")).toLowerCase();
                if (string.equals("1") || string.equals("true")) {
                    element.setAttribute("NORD", "true");
                    element.setAttribute("OST", "true");
                }
                element.removeAttribute("NORDOST");
            }
            if (element.hasAttribute("NORDWEST")) {
                string = StringUtils.trimToEmpty((String)element.getAttribute("NORDWEST")).toLowerCase();
                if (string.equals("1") || string.equals("true")) {
                    element.setAttribute("NORD", "true");
                    element.setAttribute("WEST", "true");
                }
                element.removeAttribute("NORDWEST");
            }
            if (element.hasAttribute("SUEDOST")) {
                string = StringUtils.trimToEmpty((String)element.getAttribute("SUEDOST")).toLowerCase();
                if (string.equals("1") || string.equals("true")) {
                    element.setAttribute("SUED", "true");
                    element.setAttribute("OST", "true");
                }
                element.removeAttribute("SUEDOST");
            }
            if (!element.hasAttribute("SUEDWEST")) continue;
            string = StringUtils.trimToEmpty((String)element.getAttribute("SUEDWEST")).toLowerCase();
            if (string.equals("1") || string.equals("true")) {
                element.setAttribute("SUED", "true");
                element.setAttribute("WEST", "true");
            }
            element.removeAttribute("SUEDWEST");
        }
    }

    protected void downgradeBadElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:bad[@BIDET or @PISSOIR]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("BIDET");
            element.removeAttribute("PISSOIR");
        }
    }

    protected void downgradeBefeuerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:befeuerung[@PELLET]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("PELLET");
        }
    }

    protected void downgradeBodenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:boden[@MARMOR or @TERRAKOTTA]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("MARMOR");
            element.removeAttribute("TERRAKOTTA");
        }
    }

    protected void downgradeDachformElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:dachform[@FLACHDACH or @PYRAMIDENDACH]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("FLACHDACH");
            element.removeAttribute("PYRAMIDENDACH");
        }
    }

    protected void downgradeFlaechenChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:flaechen", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            String string;
            Node node;
            Element element = (Element)e;
            boolean bl = false;
            boolean bl2 = false;
            double d = 0.0;
            List list2 = XmlUtils.newXPath((String)"io:anzahl_balkone", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl) {
                    bl = true;
                    string = StringUtils.trimToNull((String)node.getTextContent());
                    try {
                        d += string != null ? Double.parseDouble(string) : 0.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't parse <anzahl_balkone>" + string + "</anzahl_balkone> into a numeric value!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:anzahl_terrassen", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl2) {
                    bl2 = true;
                    string = StringUtils.trimToNull((String)node.getTextContent());
                    try {
                        d += string != null ? Double.parseDouble(string) : 0.0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        LOGGER.warn("Can't parse <anzahl_terrassen>" + string + "</anzahl_terrassen> into a numeric value!");
                        LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
                    }
                }
                element.removeChild(node);
            }
            if (!(d > 0.0)) continue;
            Object object = (Element)XmlUtils.newXPath((String)"io:anzahl_balkon_terrassen", (Document)document).selectSingleNode((Object)element);
            if (object == null) {
                object = document.createElementNS("", "anzahl_balkon_terrassen");
                object.setTextContent(String.valueOf(d));
                element.appendChild((Node)object);
                continue;
            }
            if (!StringUtils.isBlank((CharSequence)object.getTextContent())) continue;
            object.setTextContent(String.valueOf(d));
        }
    }

    protected void downgradeHausElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if ("APARTMENTHAUS".equalsIgnoreCase(string)) {
                element.setAttribute("haustyp", "KEINE_ANGABE");
                continue;
            }
            if ("BURG".equalsIgnoreCase(string)) {
                element.setAttribute("haustyp", "KEINE_ANGABE");
                continue;
            }
            if ("HERRENHAUS".equalsIgnoreCase(string)) {
                element.setAttribute("haustyp", "KEINE_ANGABE");
                continue;
            }
            if ("FINCA".equalsIgnoreCase(string)) {
                element.setAttribute("haustyp", "KEINE_ANGABE");
                continue;
            }
            if (!"RUSTICO".equalsIgnoreCase(string)) continue;
            element.setAttribute("haustyp", "KEINE_ANGABE");
        }
    }

    protected void downgradeKuecheElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:kueche[@PANTRY]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("PANTRY");
        }
    }

    protected void downgradeParkenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:parken", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
            Element element3 = document.createElementNS("", "sonstige");
            element3.setAttribute("sonstige_typ", "PARKFLACHE");
            element2.appendChild(element3);
        }
    }

    protected void downgradeSonstigeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:sonstige[@sonstige_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            String string = StringUtils.trimToNull((String)element.getAttribute("sonstige_typ"));
            if (!"KRANKENHAUS".equalsIgnoreCase(string)) continue;
            element2.removeChild(element);
            Element element3 = document.createElementNS("", "haus");
            element3.setAttribute("haustyp", "KRANKENHAUS");
            element2.appendChild(element3);
        }
    }

    protected void downgradeWohnungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:wohnung[@wohnungtyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("wohnungtyp"));
            if ("APARTMENT".equalsIgnoreCase(string)) {
                element.setAttribute("wohnungtyp", "KEINE_ANGABE");
                continue;
            }
            if ("FERIENWOHNUNG".equalsIgnoreCase(string)) {
                element.setAttribute("wohnungtyp", "KEINE_ANGABE");
                continue;
            }
            if (!"GALERIE".equalsIgnoreCase(string)) continue;
            element.setAttribute("wohnungtyp", "KEINE_ANGABE");
        }
    }

    protected void downgradeZinshausRenditeobjektElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:zinshaus_renditeobjekt[@zins_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element;
            Element element2 = (Element)e;
            Element element3 = (Element)element2.getParentNode();
            String string = StringUtils.trimToNull((String)element2.getAttribute("zins_typ"));
            if ("PFLEGEHEIM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "haus");
                element.setAttribute("haustyp", "PFLEGEHEIM");
                element3.appendChild(element);
                continue;
            }
            if ("SANATORIUM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "haus");
                element.setAttribute("haustyp", "SANATORIUM");
                element3.appendChild(element);
                continue;
            }
            if ("SENIORENHEIM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "haus");
                element.setAttribute("haustyp", "SENIORENHEIM");
                element3.appendChild(element);
                continue;
            }
            if (!"BETREUTES-WOHNEN".equalsIgnoreCase(string)) continue;
            element3.removeChild(element2);
            element = document.createElementNS("", "haus");
            element.setAttribute("haustyp", "BETREUTES-WOHNEN");
            element3.appendChild(element);
        }
    }

    protected void removeAusstattungChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:energietyp | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:bibliothek | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:dachboden | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:gaestewc | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:kabelkanaele | /io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:seniorengerecht", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeEmailFeedbackElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:kontaktperson/io:email_feedback", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removePreiseChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:courtage_hinweis | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:nettorendite_soll | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:nettorendite_ist", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeUserDefinedExtendElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:freitexte/io:user_defined_extend | /io:openimmo/io:anbieter/io:immobilie/io:anhaenge/io:user_defined_extend", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeZustandAngabenChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:letztemodernisierung | /io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:verkaufstatus", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeSonstigeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if (!"KRANKENHAUS".equalsIgnoreCase(string)) continue;
            element2.removeChild(element);
            Element element3 = document.createElementNS("", "sonstige");
            element3.setAttribute("sonstige_typ", "KRANKENHAUS");
            element2.appendChild(element3);
        }
    }

    protected void upgradeZinshausRenditeobjektElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element;
            Element element2 = (Element)e;
            Element element3 = (Element)element2.getParentNode();
            String string = StringUtils.trimToNull((String)element2.getAttribute("haustyp"));
            if ("PFLEGEHEIM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "zinshaus_renditeobjekt");
                element.setAttribute("zins_typ", "PFLEGEHEIM");
                element3.appendChild(element);
                continue;
            }
            if ("SANATORIUM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "zinshaus_renditeobjekt");
                element.setAttribute("zins_typ", "SANATORIUM");
                element3.appendChild(element);
                continue;
            }
            if ("SENIORENHEIM".equalsIgnoreCase(string)) {
                element3.removeChild(element2);
                element = document.createElementNS("", "zinshaus_renditeobjekt");
                element.setAttribute("zins_typ", "SENIORENHEIM");
                element3.appendChild(element);
                continue;
            }
            if (!"BETREUTES-WOHNEN".equalsIgnoreCase(string)) continue;
            element3.removeChild(element2);
            element = document.createElementNS("", "zinshaus_renditeobjekt");
            element.setAttribute("zins_typ", "BETREUTES-WOHNEN");
            element3.appendChild(element);
        }
    }
}

