/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoFeedbackDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmo_1_2_4
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_4.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_4;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_3);
        if (openImmoDocument instanceof OpenImmoFeedbackDocument) {
            try {
                this.removeFeedbackVersionElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <version> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeFeedbackInteressentChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <interessent> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        } else if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removePreiseChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <preise> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeWintergartenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <wintergarten> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergietypElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energietyp> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBebaubarNachElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <bebaubar_nach> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeAnhangElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <anhang> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeWohnungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <wohnung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeGrundstueckElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <grundstueck> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeLandUndForstwirtschaftElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <land_und_forstwirtschaft> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeParkenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <parken> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_4);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeAnzahlBalkonTerrassenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <anzahl_balkon_terrassen> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.upgradeAnhangElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <anhang> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.upgradeSonstigeElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <sonstige> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeAnhangElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:anhang | /io:openimmo/io:anbieter/io:immobilie/io:anhaenge/io:anhang", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("gruppe"));
            if ("QRCODE".equalsIgnoreCase(string)) {
                element.removeAttribute("gruppe");
            } else if ("FILM".equalsIgnoreCase(string)) {
                element.removeAttribute("gruppe");
            } else if ("FILMLINK".equalsIgnoreCase(string)) {
                element.removeAttribute("gruppe");
            }
            string = StringUtils.trimToNull((String)element.getAttribute("location"));
            if ("REMOTE".equalsIgnoreCase(string)) {
                element.setAttribute("location", "EXTERN");
            }
            List list2 = XmlUtils.newXPath((String)"io:check", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                element.removeChild((Node)e2);
            }
        }
    }

    protected void downgradeBebaubarNachElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:bebaubar_nach[@bebaubar_attr]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("bebaubar_attr"));
            if (!"LAENDERSPEZIFISCH".equalsIgnoreCase(string)) continue;
            element.removeAttribute("bebaubar_attr");
        }
    }

    protected void downgradeEnergietypElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:energietyp[@KFW55 or @KFW70]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("KFW55");
            element.removeAttribute("KFW70");
        }
    }

    protected void downgradeGrundstueckElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:grundstueck[@grundst_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("grundst_typ"));
            if (!"SEELIEGENSCHAFT".equalsIgnoreCase(string)) continue;
            element.removeAttribute("grundst_typ");
        }
    }

    protected void downgradeLandUndForstwirtschaftElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:land_und_forstwirtschaft[@land_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("land_typ"));
            if (!"JAGDREVIER".equalsIgnoreCase(string)) continue;
            element.setAttribute("land_typ", "SONSTIGE_LANDWIRTSCHAFTSIMMOBILIEN");
        }
    }

    protected void downgradeParkenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:parken[@parken_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("parken_typ"));
            if ("EINZELGARAGE".equalsIgnoreCase(string)) {
                element.setAttribute("parken_typ", "STELLPLATZ");
                continue;
            }
            if ("PARKHAUS".equalsIgnoreCase(string)) {
                element.setAttribute("parken_typ", "STELLPLATZ");
                continue;
            }
            if ("TIEFGARAGENSTELLPLATZ".equalsIgnoreCase(string)) {
                element.setAttribute("parken_typ", "STELLPLATZ");
                continue;
            }
            if (!"PARKPLATZ_STROM".equalsIgnoreCase(string)) continue;
            element.setAttribute("parken_typ", "STELLPLATZ");
        }
    }

    protected void downgradeWohnungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:wohnung[@wohnungtyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("wohnungtyp"));
            if (!"ROHDACHBODEN".equalsIgnoreCase(string)) continue;
            element.setAttribute("wohnungtyp", "KEINE_ANGABE");
        }
    }

    protected void removeFeedbackInteressentChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo_feedback/io:objekt/io:interessent", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element;
            Element element2 = (Element)e;
            boolean bl = false;
            boolean bl2 = false;
            List list2 = XmlUtils.newXPath((String)"io:bevorzugt", (Document)document).selectNodes((Object)element2);
            for (Object e2 : list2) {
                element = (Element)e2;
                if (!bl) {
                    bl = true;
                    continue;
                }
                element2.removeChild(element);
            }
            list2 = XmlUtils.newXPath((String)"io:wunsch", (Document)document).selectNodes((Object)element2);
            for (Object e2 : list2) {
                element = (Element)e2;
                if (!bl2) {
                    bl2 = true;
                    continue;
                }
                element2.removeChild(element);
            }
        }
    }

    protected void removeFeedbackVersionElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo_feedback/io:version", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removePreiseChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:provision_teilen | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:kaution_text | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:richtpreis", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeWintergartenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:wintergarten", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeAnhangElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:anhang/io:daten/io:pfad | /io:openimmo/io:anbieter/io:immobilie/io:anhaenge/io:anhang/io:daten/io:pfad", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode().getParentNode();
            String string = StringUtils.trimToEmpty((String)element.getTextContent()).toLowerCase();
            if (string.startsWith("http://")) {
                element2.setAttribute("location", "REMOTE");
                continue;
            }
            if (string.startsWith("https://")) {
                element2.setAttribute("location", "REMOTE");
                continue;
            }
            if (string.startsWith("ftp://")) {
                element2.setAttribute("location", "REMOTE");
                continue;
            }
            if (!string.startsWith("ftps://")) continue;
            element2.setAttribute("location", "REMOTE");
        }
    }

    protected void upgradeAnzahlBalkonTerrassenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:anzahl_balkon_terrassen", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            String string = StringUtils.trimToNull((String)element.getTextContent());
            if (string != null) {
                Element element3 = (Element)XmlUtils.newXPath((String)"io:anzahl_balkone", (Document)document).selectSingleNode((Object)element2);
                if (element3 == null) {
                    element3 = document.createElementNS("", "anzahl_balkone");
                    element3.setTextContent(string);
                    element2.appendChild(element3);
                } else if (StringUtils.isBlank((CharSequence)element3.getTextContent())) {
                    element3.setTextContent(string);
                }
            }
            element2.removeChild(element);
        }
    }

    protected void upgradeSonstigeElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:sonstige[@sonstige_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("sonstige_typ"));
            if (!"GARAGEN".equalsIgnoreCase(string) && !"PARKFLACHE".equalsIgnoreCase(string)) continue;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
            Element element3 = document.createElementNS("", "parken");
            element3.setAttribute("parken_typ", "STELLPLATZ");
            element2.appendChild(element3);
        }
    }
}

