/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.openestate.is24.restapi.utils.XmlUtils;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExportPool {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExportPool.class);
    private static final String UPDATE = "UPDATE";
    private static final String REMOVE = "REMOVE";
    private final File baseDir;
    private final File contactsDir;
    private final File objectsDir;
    private final Properties settings;

    public ExportPool() {
        this(new File(SystemUtils.getJavaIoTmpDir(), "pool-" + System.currentTimeMillis()));
    }

    public ExportPool(File file) {
        this.baseDir = file;
        this.contactsDir = new File(this.baseDir, "contacts");
        this.objectsDir = new File(this.baseDir, "objects");
        this.settings = new Properties();
    }

    public void cleanup() {
        this.settings.clear();
        FileUtils.deleteQuietly((File)this.baseDir);
    }

    public final File getBaseDir() {
        return this.baseDir;
    }

    public RealtorContactDetails getContact(String string) throws IOException {
        Unmarshaller unmarshaller;
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        File file = new File(new File(this.contactsDir, string), "contact.xml");
        if (!file.isFile()) {
            return null;
        }
        try {
            unmarshaller = XmlUtils.createUnmarshaller();
            if (unmarshaller == null) {
                throw new IOException("Can't init XML parser for IS24-REST!");
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't init XML parser for IS24-REST!", jAXBException);
        }
        try {
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(file);
            RealtorContactDetails realtorContactDetails = (RealtorContactDetails)jAXBElement.getValue();
            if (realtorContactDetails == null) {
                throw new IOException("Can't read XML file for contact '" + string + "'!");
            }
            return realtorContactDetails;
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't read XML file for contact '" + string + "'!", jAXBException);
        }
    }

    public String[] getContactIds() {
        if (!this.contactsDir.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.contactsDir.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                if (!((File)object).isDirectory()) continue;
                arrayList.add(((File)object).getName());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public long getContactSize(String string, boolean bl) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return 0L;
        }
        File file = new File(this.contactsDir, string);
        if (!bl) {
            file = new File(file, "contact.xml");
        }
        return file.isFile() ? FileUtils.sizeOf((File)file) : 0L;
    }

    public final File getContactsDir() {
        return this.contactsDir;
    }

    public RealEstate getObject(String string) throws IOException {
        Unmarshaller unmarshaller;
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        File file = new File(new File(this.objectsDir, string), "object.xml");
        if (!file.isFile()) {
            return null;
        }
        try {
            unmarshaller = XmlUtils.createUnmarshaller();
            if (unmarshaller == null) {
                throw new IOException("Can't init XML parser for IS24-REST!");
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't init XML parser for IS24-REST!", jAXBException);
        }
        try {
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(file);
            RealEstate realEstate = (RealEstate)jAXBElement.getValue();
            if (realEstate == null) {
                throw new IOException("Can't read XML file for object '" + string + "'!");
            }
            return realEstate;
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't read XML file for object '" + string + "'!", jAXBException);
        }
    }

    public Attachment getObjectAttachment(String string, String string2) throws IOException {
        Unmarshaller unmarshaller;
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            return null;
        }
        File file = new File(new File(this.objectsDir, string), "attachment." + string2 + ".xml");
        if (!file.isFile()) {
            return null;
        }
        try {
            unmarshaller = XmlUtils.createUnmarshaller();
            if (unmarshaller == null) {
                throw new IOException("Can't init XML parser for IS24-REST!");
            }
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't init XML parser for IS24-REST!", jAXBException);
        }
        try {
            JAXBElement jAXBElement = (JAXBElement)unmarshaller.unmarshal(file);
            Attachment attachment = (Attachment)jAXBElement.getValue();
            if (attachment == null) {
                throw new IOException("Can't read XML file for object '" + string + "'!");
            }
            return attachment;
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't read XML file for object '" + string + "'!", jAXBException);
        }
    }

    public File getObjectAttachmentFile(String string, Attachment attachment) {
        return attachment != null ? this.getObjectAttachmentFile(string, attachment.getHref()) : null;
    }

    public File getObjectAttachmentFile(String string, URI uRI) {
        return uRI != null && uRI.getScheme().equalsIgnoreCase("file") ? this.getObjectAttachmentFile(string, StringUtils.trimToNull((String)uRI.getHost())) : null;
    }

    public File getObjectAttachmentFile(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string2)) {
            return null;
        }
        File file = new File(new File(this.objectsDir, string), string2);
        return file.isFile() ? file : null;
    }

    public long getObjectAttachmentSize(String string, String string2) {
        if (StringUtils.isBlank((CharSequence)string) || StringUtils.isBlank((CharSequence)string2)) {
            return 0L;
        }
        File file = new File(new File(this.objectsDir, string), "attachment." + string2 + ".xml");
        return file.isFile() ? FileUtils.sizeOf((File)file) : 0L;
    }

    public URI getObjectAttachmentURI(Attachment attachment) {
        return attachment != null ? attachment.getHref() : null;
    }

    public URI getObjectAttachmentURI(String string, String string2) throws IOException {
        return this.getObjectAttachmentURI(this.getObjectAttachment(string, string2));
    }

    public String[] getObjectAttachmentIds(String string) {
        File file = new File(this.objectsDir, string);
        if (!file.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = file.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                String string2 = ((File)object).getName();
                if (!string2.startsWith("attachment.") || !string2.endsWith(".xml")) continue;
                String[] stringArray = StringUtils.split((String)string2, (String)".");
                if (stringArray.length == 3) {
                    arrayList.add(stringArray[1]);
                    continue;
                }
                LOGGER.warn("Invalid attachment.xml at '" + ((File)object).getAbsolutePath() + "'!");
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getObjectIds() {
        if (!this.objectsDir.isDirectory()) {
            return new String[0];
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        Object[] objectArray = this.objectsDir.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                if (!((File)object).isDirectory()) continue;
                arrayList.add(((File)object).getName());
            }
        }
        return arrayList.toArray(new String[0]);
    }

    public String[] getObjectIdsForRemoval() {
        ArrayList<String> arrayList = new ArrayList<String>();
        Enumeration<?> enumeration = this.settings.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string;
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith("object.") || !REMOVE.equals(string = this.settings.getProperty(string2))) continue;
            String[] stringArray = StringUtils.split((String)string2, (String)".", (int)2);
            arrayList.add(stringArray[1]);
        }
        return arrayList.toArray(new String[0]);
    }

    public long getObjectSize(String string, boolean bl) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return 0L;
        }
        File file = new File(this.objectsDir, string);
        if (!bl) {
            file = new File(file, "object.xml");
        }
        return file.isFile() ? FileUtils.sizeOf((File)file) : 0L;
    }

    public final File getObjectsDir() {
        return this.objectsDir;
    }

    public String getSetting(String string) {
        return this.getSetting(string, null);
    }

    public String getSetting(String string, String string2) {
        return this.settings.getProperty(string, string2);
    }

    public long getTotalSize() {
        return this.baseDir.exists() ? FileUtils.sizeOf((File)this.baseDir) : 0L;
    }

    public boolean hasContactForExport(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        File file = new File(new File(this.contactsDir, string), "contact.xml");
        return file.isFile();
    }

    public boolean hasObjectForExport(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return UPDATE.equalsIgnoreCase(this.getSetting("object." + string));
    }

    public boolean hasObjectForRemoval(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        return REMOVE.equalsIgnoreCase(this.getSetting("object." + string));
    }

    public synchronized void putContact(RealtorContactDetails realtorContactDetails) throws IOException {
        if (realtorContactDetails != null) {
            this.putContact(realtorContactDetails, realtorContactDetails.getExternalId());
        }
    }

    public synchronized void putContact(RealtorContactDetails realtorContactDetails, String string) throws IOException {
        File file;
        if (realtorContactDetails == null) {
            return;
        }
        if (string == null) {
            string = realtorContactDetails.getExternalId();
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IOException("No pool ID was provided for the object!");
        }
        if (StringUtils.isBlank((CharSequence)realtorContactDetails.getExternalId())) {
            realtorContactDetails.setExternalId(string);
        }
        if ((file = new File(this.contactsDir, string)).exists()) {
            FileUtils.deleteDirectory((File)file);
        }
        if (!file.mkdirs()) {
            throw new IOException("Can't create folder at '" + file.getAbsolutePath() + "'!");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "contact.xml"));){
            XmlUtils.writeXml(realtorContactDetails, (OutputStream)fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML for contact '" + string + "'!", jAXBException);
        }
    }

    public synchronized void putObject(RealEstate realEstate) throws IOException {
        if (realEstate != null) {
            this.putObject(realEstate, realEstate.getExternalId());
        }
    }

    public synchronized void putObject(RealEstate realEstate, String string) throws IOException {
        File file;
        if (realEstate == null) {
            return;
        }
        if (string == null) {
            string = realEstate.getExternalId();
        }
        if (StringUtils.isBlank((CharSequence)string)) {
            throw new IOException("No pool ID was provided for the object!");
        }
        if (StringUtils.isBlank((CharSequence)realEstate.getExternalId())) {
            realEstate.setExternalId(string);
        }
        if ((file = new File(this.objectsDir, string)).exists()) {
            FileUtils.deleteDirectory((File)file);
        }
        if (!file.mkdirs()) {
            throw new IOException("Can't create folder at '" + file.getAbsolutePath() + "'!");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "object.xml"));){
            XmlUtils.writeXml(realEstate, (OutputStream)fileOutputStream);
            this.putSetting("object." + realEstate.getExternalId(), UPDATE);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML for object '" + string + "'!", jAXBException);
        }
    }

    public synchronized void putObjectAttachedFile(String string, Attachment attachment, File file) throws IOException {
        if (StringUtils.isBlank((CharSequence)string) || attachment == null || file == null || !file.isFile()) {
            return;
        }
        File file2 = new File(this.objectsDir, string);
        if (!file2.exists() && !file2.mkdirs()) {
            throw new IOException("Can't create folder at '" + file2.getAbsolutePath() + "'!");
        }
        int n = 0;
        Object[] objectArray = file2.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                String string2 = ((File)object).getName();
                if (!string2.startsWith("attachment.") || !string2.endsWith(".xml")) continue;
                ++n;
            }
        }
        File file3 = new File(file2, file.getName());
        FileUtils.copyFile((File)file, (File)file3);
        try {
            attachment.setHref(new URI("file://" + file3.getName()));
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IOException("Can't create URI for an attachment of object '" + string + "'!", uRISyntaxException);
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file2, "attachment." + (n + 1) + ".xml"));){
            XmlUtils.writeXml(attachment, (OutputStream)fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML for an attachment of object '" + string + "'!", jAXBException);
        }
    }

    public synchronized void putObjectAttachedFile(String string, Attachment attachment, URI uRI) throws IOException {
        if (StringUtils.isBlank((CharSequence)string) || attachment == null || uRI == null) {
            return;
        }
        File file = new File(this.objectsDir, string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create folder at '" + file.getAbsolutePath() + "'!");
        }
        int n = 0;
        Object[] objectArray = file.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                String string2 = ((File)object).getName();
                if (!string2.startsWith("attachment.") || !string2.endsWith(".xml")) continue;
                ++n;
            }
        }
        attachment.setHref(uRI);
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "attachment." + (n + 1) + ".xml"));){
            XmlUtils.writeXml(attachment, (OutputStream)fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML for an attachment of object '" + string + "'!", jAXBException);
        }
    }

    public synchronized void putObjectAttachedLink(String string, Attachment attachment) throws IOException {
        if (StringUtils.isBlank((CharSequence)string) || attachment == null) {
            return;
        }
        File file = new File(this.objectsDir, string);
        if (!file.exists() && !file.mkdirs()) {
            throw new IOException("Can't create folder at '" + file.getAbsolutePath() + "'!");
        }
        int n = 0;
        Object[] objectArray = file.listFiles();
        if (objectArray != null && ArrayUtils.isNotEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                String string2 = ((File)object).getName();
                if (!string2.startsWith("attachment.") || !string2.endsWith(".xml")) continue;
                ++n;
            }
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(file, "attachment." + (n + 1) + ".xml"));){
            XmlUtils.writeXml(attachment, (OutputStream)fileOutputStream);
        }
        catch (JAXBException jAXBException) {
            throw new IOException("Can't write XML for an attachment of object '" + string + "'!", jAXBException);
        }
    }

    public synchronized void putObjectForRemoval(String string) {
        if ((string = StringUtils.trimToNull((String)string)) != null) {
            this.putSetting("object." + string, REMOVE);
        }
    }

    public synchronized void putSetting(String string, String string2) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return;
        }
        if ((string2 = StringUtils.trimToNull((String)string2)) == null && this.settings.containsKey(string)) {
            this.settings.remove(string);
        } else if (string2 != null) {
            this.settings.setProperty(string, string2);
        }
    }

    public void readSettings() throws IOException {
        this.settings.clear();
        File file = new File(this.baseDir, "settings.xml");
        if (!file.isFile()) {
            return;
        }
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            this.settings.loadFromXML(fileInputStream);
        }
    }

    public void writeSettings() throws IOException {
        if (!this.baseDir.exists() && !this.baseDir.mkdirs()) {
            throw new IOException("Can't create folder at '" + this.baseDir.getAbsolutePath() + "'!");
        }
        File file = new File(this.baseDir, "settings.xml");
        if (file.exists() && !file.delete()) {
            throw new IOException("Can't remove file at '" + file.getAbsolutePath() + "'!");
        }
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            this.settings.storeToXML((OutputStream)fileOutputStream, "ExportPool settings", "UTF-8");
        }
    }
}

