/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.is24.restapi.utils;

import java.awt.Color;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.bind.DatatypeConverter;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.ValidationEvent;
import javax.xml.bind.ValidationEventHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.City;
import org.openestate.is24.restapi.xml.common.Continent;
import org.openestate.is24.restapi.xml.common.Country;
import org.openestate.is24.restapi.xml.common.PublishObject;
import org.openestate.is24.restapi.xml.common.Quarter;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.common.Region;
import org.openestate.is24.restapi.xml.realestates.ApartmentBuy;
import org.openestate.is24.restapi.xml.realestates.ApartmentRent;
import org.openestate.is24.restapi.xml.realestates.AssistedLiving;
import org.openestate.is24.restapi.xml.realestates.CompulsoryAuction;
import org.openestate.is24.restapi.xml.realestates.FlatShareRoom;
import org.openestate.is24.restapi.xml.realestates.GarageBuy;
import org.openestate.is24.restapi.xml.realestates.GarageRent;
import org.openestate.is24.restapi.xml.realestates.Gastronomy;
import org.openestate.is24.restapi.xml.realestates.HouseBuy;
import org.openestate.is24.restapi.xml.realestates.HouseRent;
import org.openestate.is24.restapi.xml.realestates.HouseType;
import org.openestate.is24.restapi.xml.realestates.Industry;
import org.openestate.is24.restapi.xml.realestates.Investment;
import org.openestate.is24.restapi.xml.realestates.LivingBuySite;
import org.openestate.is24.restapi.xml.realestates.LivingRentSite;
import org.openestate.is24.restapi.xml.realestates.ObjectFactory;
import org.openestate.is24.restapi.xml.realestates.Office;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.openestate.is24.restapi.xml.realestates.SeniorCare;
import org.openestate.is24.restapi.xml.realestates.ShortTermAccommodation;
import org.openestate.is24.restapi.xml.realestates.SpecialPurpose;
import org.openestate.is24.restapi.xml.realestates.Store;
import org.openestate.is24.restapi.xml.realestates.TradeSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlUtils.class);
    public static final String DEFAULT_ENCODING = "UTF-8";
    private static JAXBContext JAXB = null;
    private static final String JAXB_PACKAGES = "org.openestate.is24.restapi.xml.attachmentsorder:org.openestate.is24.restapi.xml.common:org.openestate.is24.restapi.xml.gis:org.openestate.is24.restapi.xml.offerlistelement:org.openestate.is24.restapi.xml.offeruser:org.openestate.is24.restapi.xml.premiumplacement:org.openestate.is24.restapi.xml.realestatecounts:org.openestate.is24.restapi.xml.realestateproject:org.openestate.is24.restapi.xml.realestates:org.openestate.is24.restapi.xml.realtor:org.openestate.is24.restapi.xml.realtorbadges:org.openestate.is24.restapi.xml.showcaseplacement:org.openestate.is24.restapi.xml.topplacement:org.openestate.is24.restapi.xml.videoupload";
    private static final Pattern ANY_TAG_PATTERN = Pattern.compile("<[^<>\\n]*>", 66);
    private static final Pattern BR_TAG_PATTERN = Pattern.compile("<\\s*br[^<>\\n]*>", 66);
    private static final Pattern EMAIL_PATTERN = Pattern.compile(".+@.+\\..+", 66);

    private XmlUtils() {
    }

    public static Marshaller createMarshaller() throws JAXBException {
        return XmlUtils.createMarshaller(Charset.defaultCharset().name(), true);
    }

    public static Marshaller createMarshaller(String string, boolean bl) throws JAXBException {
        Marshaller marshaller = XmlUtils.getContext().createMarshaller();
        marshaller.setProperty("jaxb.encoding", (Object)string);
        marshaller.setProperty("jaxb.formatted.output", (Object)bl);
        return marshaller;
    }

    public static Unmarshaller createUnmarshaller() throws JAXBException {
        return XmlUtils.getContext().createUnmarshaller();
    }

    public static synchronized JAXBContext getContext() throws JAXBException {
        if (JAXB == null) {
            XmlUtils.initContext(Thread.currentThread().getContextClassLoader());
        }
        return JAXB;
    }

    public static synchronized void initContext(ClassLoader classLoader) throws JAXBException {
        JAXB = JAXBContext.newInstance((String)JAXB_PACKAGES, (ClassLoader)classLoader);
    }

    public static String marshal(Object object) throws JAXBException, IOException {
        return XmlUtils.marshal(object, DEFAULT_ENCODING, true);
    }

    public static String marshal(Object object, String string) throws JAXBException, IOException {
        return XmlUtils.marshal(object, string, true);
    }

    public static String marshal(Object object, String string, boolean bl) throws JAXBException, IOException {
        if (object == null) {
            return null;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();){
            if (object instanceof Attachment) {
                XmlUtils.writeXml((Attachment)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof City) {
                XmlUtils.writeXml((City)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof Continent) {
                XmlUtils.writeXml((Continent)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof Country) {
                XmlUtils.writeXml((Country)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof PublishObject) {
                XmlUtils.writeXml((PublishObject)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof Quarter) {
                XmlUtils.writeXml((Quarter)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof RealtorContactDetails) {
                XmlUtils.writeXml((RealtorContactDetails)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof RealEstate) {
                XmlUtils.writeXml((RealEstate)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else if (object instanceof Region) {
                XmlUtils.writeXml((Region)object, string, bl, (OutputStream)byteArrayOutputStream);
            } else {
                XmlUtils.createMarshaller(string, bl).marshal(object, (OutputStream)byteArrayOutputStream);
            }
            byteArrayOutputStream.flush();
            String string2 = Charset.forName(string).decode(ByteBuffer.wrap(byteArrayOutputStream.toByteArray())).toString();
            return string2;
        }
    }

    public static Color parseColor(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 == null) {
            return null;
        }
        if (string2.startsWith("#")) {
            string2 = string2.substring(1);
        }
        if (!string2.startsWith("0x")) {
            string2 = "0x" + string2;
        }
        return Color.decode(string2);
    }

    public static Calendar parseDate(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        try {
            return DatatypeConverter.parseDate((String)string);
        }
        catch (Exception exception) {
            try {
                Date date = DateUtils.parseDateStrictly((String)string, (String[])new String[]{"dd.MM.yyyy", "dd.MM.yy", "dd/MM/yyyy", "dd/MM/yy", "dd-MM-yyyy", "dd-MMM-yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy-D", "MM/yyyy", "MMM yyyy", "MMMMM yyyy", "yyyy"});
                Calendar calendar = Calendar.getInstance();
                calendar.setTime(date);
                return calendar;
            }
            catch (Exception exception2) {
                throw new IllegalArgumentException("Can't parse xsd:date value '" + string + "'!", exception2);
            }
        }
    }

    public static BigDecimal parseDecimal8_2(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseDecimal13_2(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseDecimalPositive(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static String parseEmail(String string) {
        String string2 = XmlUtils.parseText(string, 5, 300);
        if (string2 == null) {
            return null;
        }
        return EMAIL_PATTERN.matcher(string2).matches() ? string2 : null;
    }

    public static Integer parseFlatShareSearchSize(String string) {
        return XmlUtils.parseInteger(string, 2, 11);
    }

    public static Integer parseFloorNr(String string) {
        return XmlUtils.parseInteger(string, -1, null);
    }

    public static Integer parseGroupNr(String string) {
        return XmlUtils.parseInteger(string, 0, Integer.MAX_VALUE);
    }

    private static Integer parseInteger(String string, Integer n, Integer n2) {
        String string2 = StringUtils.trimToNull((String)string);
        return StringUtils.isNumeric((CharSequence)string2) ? Integer.valueOf(string2) : null;
    }

    public static Integer parseInteger9Positive(String string) {
        return XmlUtils.parseInteger(string, 1, 9);
    }

    public static Integer parseInteger99(String string) {
        return XmlUtils.parseInteger(string, 0, 99);
    }

    public static Integer parseInteger999(String string) {
        return XmlUtils.parseInteger(string, 0, 999);
    }

    public static Integer parseInteger9999(String string) {
        return XmlUtils.parseInteger(string, 0, 9999);
    }

    public static Integer parseInteger9999Positive(String string) {
        return XmlUtils.parseInteger(string, 1, 9999);
    }

    public static Integer parseInteger99999(String string) {
        return XmlUtils.parseInteger(string, 0, 99999);
    }

    public static BigDecimal parseLatitude(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseLongitude(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static String parseNonEmptyText(String string) {
        return XmlUtils.parseText(string, 1, null);
    }

    public static String parsePassword(String string) {
        return XmlUtils.parseText(string, 5, 40);
    }

    public static Integer parsePercent(String string) {
        return XmlUtils.parseInteger(string, 0, 99);
    }

    public static String parsePhoneNumber(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parsePhoneNumberAreaCode(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parsePhoneNumberCountryCode(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parsePhoneNumberSubscriber(String string) {
        return StringUtils.trimToNull((String)string);
    }

    public static BigDecimal parsePriceMultiplier(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseRoomNr(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static BigDecimal parseRoomNrForBaseHouse(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    private static String parseText(String string, Integer n, Integer n2) {
        return StringUtils.trimToNull((String)string);
    }

    public static String parseText15(String string) {
        return XmlUtils.parseText(string, null, 15);
    }

    public static String parseText16(String string) {
        return XmlUtils.parseText(string, null, 16);
    }

    public static String parseText18(String string) {
        return XmlUtils.parseText(string, null, 18);
    }

    public static String parseText20(String string) {
        return XmlUtils.parseText(string, null, 20);
    }

    public static String parseText30(String string) {
        return XmlUtils.parseText(string, null, 30);
    }

    public static String parseText40(String string) {
        return XmlUtils.parseText(string, null, 40);
    }

    public static String parseText50(String string) {
        return XmlUtils.parseText(string, null, 50);
    }

    public static String parseText80(String string) {
        return XmlUtils.parseText(string, null, 80);
    }

    public static String parseText100(String string) {
        return XmlUtils.parseText(string, null, 100);
    }

    public static String parseText1000(String string) {
        return XmlUtils.parseText(string, null, 1000);
    }

    public static String parseText1800(String string) {
        return XmlUtils.parseText(string, null, 1800);
    }

    public static String parseText3999(String string) {
        return XmlUtils.parseText(string, null, 3999);
    }

    public static BigDecimal parseThermalCharacteristic(String string) {
        return (string = StringUtils.trimToNull((String)string)) != null ? DatatypeConverter.parseDecimal((String)string) : null;
    }

    public static URI parseUri(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        try {
            return string2 != null ? new URI(string2) : null;
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalArgumentException("Can't parse URI '" + string + "'!", uRISyntaxException);
        }
    }

    public static Integer parseYear(String string) {
        return XmlUtils.parseInteger(string, 1000, 9999);
    }

    public static String printColor(Color color) {
        String string;
        String string2;
        if (color == null) {
            throw new IllegalArgumentException("The provided color is invalid!");
        }
        String string3 = Integer.toHexString(color.getRed()).trim();
        if (string3.length() == 1) {
            string3 = "0" + string3;
        }
        if ((string2 = Integer.toHexString(color.getGreen()).trim()).length() == 1) {
            string2 = "0" + string2;
        }
        if ((string = Integer.toHexString(color.getBlue()).trim()).length() == 1) {
            string = "0" + string;
        }
        return "#" + string3 + string2 + string;
    }

    public static String printDate(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        return simpleDateFormat.format(calendar.getTime());
    }

    private static String printDecimal(BigDecimal bigDecimal, BigDecimal bigDecimal2, BigDecimal bigDecimal3, int n, boolean bl) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("The provided double value NULL is invalid!");
        }
        bigDecimal = bigDecimal.setScale(n, 4);
        if (!(bigDecimal2 == null || bigDecimal.compareTo(bigDecimal2) > 0 || bl && BigDecimal.ZERO.equals(bigDecimal))) {
            throw new IllegalArgumentException("The provided double value " + bigDecimal + " is too small (minimum is " + bigDecimal2 + ")!");
        }
        if (bigDecimal3 != null && bigDecimal.compareTo(bigDecimal3) >= 0) {
            throw new IllegalArgumentException("The provided double value " + bigDecimal + " is too high (maximum is " + bigDecimal3 + ")!");
        }
        return DatatypeConverter.printDecimal((BigDecimal)bigDecimal);
    }

    public static String printDecimal8_2(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, BigDecimal.TEN.pow(8), 2, false);
    }

    public static String printDecimal13_2(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, BigDecimal.TEN.pow(13), 2, false);
    }

    public static String printDecimalPositive(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, null, 3, false);
    }

    public static String printEmail(String string) {
        String string2 = XmlUtils.printText(string, 5, 300);
        if (string2 == null || !EMAIL_PATTERN.matcher(string2).matches()) {
            throw new IllegalArgumentException("The provided email '" + string + "' is invalid!");
        }
        return string2;
    }

    public static String printFlatShareSearchSize(Integer n) {
        return XmlUtils.printInteger(n, 2, 11);
    }

    public static String printFloorNr(Integer n) {
        return XmlUtils.printInteger(n, -1, null);
    }

    public static String printGroupNr(Integer n) {
        return XmlUtils.printInteger(n, 0, Integer.MAX_VALUE);
    }

    private static String printInteger(Integer n, Integer n2, Integer n3) {
        if (n == null) {
            throw new IllegalArgumentException("The provided integer value NULL is invalid!");
        }
        if (n2 != null && n < n2) {
            throw new IllegalArgumentException("The provided integer value " + n + " is too small (minimum is " + n2 + ")!");
        }
        if (n3 != null && n > n3) {
            throw new IllegalArgumentException("The provided integer value " + n + " is too high (maximum is " + n3 + ")!");
        }
        return n.toString();
    }

    public static String printInteger9Positive(Integer n) {
        return XmlUtils.printInteger(n, 1, 9);
    }

    public static String printInteger99(Integer n) {
        return XmlUtils.printInteger(n, 0, 99);
    }

    public static String printInteger999(Integer n) {
        return XmlUtils.printInteger(n, 0, 999);
    }

    public static String printInteger9999(Integer n) {
        return XmlUtils.printInteger(n, 0, 9999);
    }

    public static String printInteger9999Positive(Integer n) {
        return XmlUtils.printInteger(n, 1, 9999);
    }

    public static String printInteger99999(Integer n) {
        return XmlUtils.printInteger(n, 0, 99999);
    }

    public static String printLatitude(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, new BigDecimal("-90"), new BigDecimal("90"), 10, false);
    }

    public static String printLongitude(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, new BigDecimal("-180"), new BigDecimal("180"), 10, false);
    }

    public static String printNonEmptyText(String string) {
        return XmlUtils.printText(string, 1, null);
    }

    public static String printPassword(String string) {
        return XmlUtils.printText(string, 5, 40);
    }

    public static String printPercent(Integer n) {
        return XmlUtils.printInteger(n, 0, 99);
    }

    public static String printPhoneNumber(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 == null || !string2.matches("(\\+[1-9]\\d{0,3}) +\\d{1,10} +([\\d][\\d \\-]{0,24}[\\d])")) {
            throw new IllegalArgumentException("The provided phone number '" + string + "' is invalid!");
        }
        return string2;
    }

    public static String printPhoneNumberAreaCode(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (!StringUtils.isNumericSpace((CharSequence)string2)) {
            throw new IllegalArgumentException("The provided area phone code '" + string + "' is invalid!");
        }
        if ((string2 = StringUtils.trimToNull((String)string2.replaceAll("\\D", ""))) == null || string2.length() > 10) {
            throw new IllegalArgumentException("The provided area phone code '" + string + "' is invalid!");
        }
        return string2;
    }

    public static String printPhoneNumberCountryCode(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 != null && !string2.startsWith("+")) {
            if (string2.startsWith("00")) {
                string2 = StringUtils.substring((String)string2, (int)2);
            }
            string2 = "+" + string2;
        }
        if (string2 == null || !string2.matches("\\+[1-9]\\d{0,3}")) {
            throw new IllegalArgumentException("The provided country phone code '" + string + "' is invalid!");
        }
        return string2;
    }

    public static String printPhoneNumberSubscriber(String string) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 != null) {
            String string3 = StringUtils.substring((String)string2, (int)0, (int)1);
            String string4 = StringUtils.substring((String)string2, (int)(string2.length() - 1));
            if (!StringUtils.isNumeric((CharSequence)string3) || !StringUtils.isNumeric((CharSequence)string4)) {
                throw new IllegalArgumentException("The provided phone subscriber  '" + string + "' is invalid!");
            }
            string2 = string2.replaceAll("\\D", "-");
            while (string2.contains("--")) {
                string2 = StringUtils.replace((String)string2, (String)"--", (String)"-");
            }
        }
        if (string2 == null || !string2.matches("[\\d][\\d \\-]{0,24}[\\d]")) {
            throw new IllegalArgumentException("The provided phone subscriber  '" + string + "' is invalid!");
        }
        return string2;
    }

    public static String printPriceMultiplier(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, BigDecimal.TEN.pow(2), 1, true);
    }

    public static String printRoomNr(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, new BigDecimal("0.49"), BigDecimal.TEN.pow(4), 2, false);
    }

    public static String printRoomNrForBaseHouse(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, BigDecimal.TEN.pow(3), 1, true);
    }

    private static String printText(String string, Integer n, Integer n2) {
        String string2 = StringUtils.trimToNull((String)string);
        if (string2 == null) {
            throw new IllegalArgumentException("The provided text '" + string + "' is invalid!");
        }
        if (n != null && string2.length() < n) {
            throw new IllegalArgumentException("The provided text " + string + " is too short (minimum is " + n + ")!");
        }
        string2 = StringEscapeUtils.unescapeHtml4((String)string);
        Matcher matcher = BR_TAG_PATTERN.matcher(string2);
        string2 = StringUtils.trimToEmpty((String)matcher.replaceAll(System.lineSeparator()));
        matcher = ANY_TAG_PATTERN.matcher(string2);
        string2 = StringUtils.trimToEmpty((String)matcher.replaceAll(""));
        string2 = StringUtils.replace((String)string2, (String)"<", (String)"\u00ab");
        string2 = StringUtils.replace((String)string2, (String)">", (String)"\u00bb");
        return n2 != null ? StringUtils.abbreviate((String)string2, (int)n2) : string2;
    }

    public static String printText15(String string) {
        return XmlUtils.printText(string, null, 15);
    }

    public static String printText16(String string) {
        return XmlUtils.printText(string, null, 16);
    }

    public static String printText18(String string) {
        return XmlUtils.printText(string, null, 18);
    }

    public static String printText20(String string) {
        return XmlUtils.printText(string, null, 20);
    }

    public static String printText30(String string) {
        return XmlUtils.printText(string, null, 30);
    }

    public static String printText40(String string) {
        return XmlUtils.printText(string, null, 40);
    }

    public static String printText50(String string) {
        return XmlUtils.printText(string, null, 50);
    }

    public static String printText80(String string) {
        return XmlUtils.printText(string, null, 80);
    }

    public static String printText100(String string) {
        return XmlUtils.printText(string, null, 100);
    }

    public static String printText1000(String string) {
        return XmlUtils.printText(string, null, 1000);
    }

    public static String printText1800(String string) {
        return XmlUtils.printText(string, null, 1800);
    }

    public static String printText3999(String string) {
        return XmlUtils.printText(string, null, 3999);
    }

    public static String printThermalCharacteristic(BigDecimal bigDecimal) {
        return XmlUtils.printDecimal(bigDecimal, BigDecimal.ZERO, new BigDecimal("2000"), 2, false);
    }

    public static String printUri(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("The provided URI is NULL!");
        }
        return uRI.toString();
    }

    public static String printYear(Integer n) {
        return XmlUtils.printInteger(n, 1000, 9999);
    }

    public static Object unmarshal(String string) throws JAXBException, IOException {
        if (StringUtils.isBlank((CharSequence)string)) {
            return null;
        }
        try (StringReader stringReader = new StringReader(string);){
            Object object = XmlUtils.createUnmarshaller().unmarshal((Reader)stringReader);
            return object;
        }
    }

    public static void writeXml(Attachment attachment, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(attachment, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(Attachment attachment, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(attachment, string, true, outputStream);
    }

    public static void writeXml(Attachment attachment, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(attachment, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(Attachment attachment, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createAttachment(attachment), outputStream);
    }

    public static void writeXml(City city, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(city, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(City city, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(city, string, true, outputStream);
    }

    public static void writeXml(City city, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(city, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(City city, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.gis.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.gis.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createCity(city), outputStream);
    }

    public static void writeXml(Continent continent, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(continent, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(Continent continent, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(continent, string, true, outputStream);
    }

    public static void writeXml(Continent continent, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(continent, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(Continent continent, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.gis.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.gis.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createContinent(continent), outputStream);
    }

    public static void writeXml(Country country, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(country, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(Country country, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(country, string, true, outputStream);
    }

    public static void writeXml(Country country, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(country, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(Country country, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.gis.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.gis.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createCountry(country), outputStream);
    }

    public static void writeXml(PublishObject publishObject, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(publishObject, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(PublishObject publishObject, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(publishObject, string, true, outputStream);
    }

    public static void writeXml(PublishObject publishObject, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(publishObject, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(PublishObject publishObject, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createPublishObject(publishObject), outputStream);
    }

    public static void writeXml(Quarter quarter, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(quarter, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(Quarter quarter, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(quarter, string, true, outputStream);
    }

    public static void writeXml(Quarter quarter, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(quarter, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(Quarter quarter, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.gis.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.gis.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createQuarter(quarter), outputStream);
    }

    public static void writeXml(RealtorContactDetails realtorContactDetails, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realtorContactDetails, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(RealtorContactDetails realtorContactDetails, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realtorContactDetails, string, true, outputStream);
    }

    public static void writeXml(RealtorContactDetails realtorContactDetails, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realtorContactDetails, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(RealtorContactDetails realtorContactDetails, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createRealtorContactDetail(realtorContactDetails), outputStream);
    }

    public static void writeXml(RealEstate realEstate, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realEstate, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(RealEstate realEstate, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realEstate, string, true, outputStream);
    }

    public static void writeXml(RealEstate realEstate, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(realEstate, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(RealEstate realEstate, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        ObjectFactory objectFactory = new ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        if (realEstate instanceof ApartmentBuy) {
            marshaller.marshal(objectFactory.createApartmentBuy((ApartmentBuy)realEstate), outputStream);
        } else if (realEstate instanceof ApartmentRent) {
            marshaller.marshal(objectFactory.createApartmentRent((ApartmentRent)realEstate), outputStream);
        } else if (realEstate instanceof AssistedLiving) {
            marshaller.marshal(objectFactory.createAssistedLiving((AssistedLiving)realEstate), outputStream);
        } else if (realEstate instanceof CompulsoryAuction) {
            marshaller.marshal(objectFactory.createCompulsoryAuction((CompulsoryAuction)realEstate), outputStream);
        } else if (realEstate instanceof FlatShareRoom) {
            marshaller.marshal(objectFactory.createFlatShareRoom((FlatShareRoom)realEstate), outputStream);
        } else if (realEstate instanceof GarageBuy) {
            marshaller.marshal(objectFactory.createGarageBuy((GarageBuy)realEstate), outputStream);
        } else if (realEstate instanceof GarageRent) {
            marshaller.marshal(objectFactory.createGarageRent((GarageRent)realEstate), outputStream);
        } else if (realEstate instanceof Gastronomy) {
            marshaller.marshal(objectFactory.createGastronomy((Gastronomy)realEstate), outputStream);
        } else if (realEstate instanceof HouseBuy) {
            marshaller.marshal(objectFactory.createHouseBuy((HouseBuy)realEstate), outputStream);
        } else if (realEstate instanceof HouseRent) {
            marshaller.marshal(objectFactory.createHouseRent((HouseRent)realEstate), outputStream);
        } else if (realEstate instanceof HouseType) {
            marshaller.marshal(objectFactory.createHouseType((HouseType)realEstate), outputStream);
        } else if (realEstate instanceof Industry) {
            marshaller.marshal(objectFactory.createIndustry((Industry)realEstate), outputStream);
        } else if (realEstate instanceof Investment) {
            marshaller.marshal(objectFactory.createInvestment((Investment)realEstate), outputStream);
        } else if (realEstate instanceof LivingBuySite) {
            marshaller.marshal(objectFactory.createLivingBuySite((LivingBuySite)realEstate), outputStream);
        } else if (realEstate instanceof LivingRentSite) {
            marshaller.marshal(objectFactory.createLivingRentSite((LivingRentSite)realEstate), outputStream);
        } else if (realEstate instanceof Office) {
            marshaller.marshal(objectFactory.createOffice((Office)realEstate), outputStream);
        } else if (realEstate instanceof SeniorCare) {
            marshaller.marshal(objectFactory.createSeniorCare((SeniorCare)realEstate), outputStream);
        } else if (realEstate instanceof ShortTermAccommodation) {
            marshaller.marshal(objectFactory.createShortTermAccommodation((ShortTermAccommodation)realEstate), outputStream);
        } else if (realEstate instanceof SpecialPurpose) {
            marshaller.marshal(objectFactory.createSpecialPurpose((SpecialPurpose)realEstate), outputStream);
        } else if (realEstate instanceof Store) {
            marshaller.marshal(objectFactory.createStore((Store)realEstate), outputStream);
        } else if (realEstate instanceof TradeSite) {
            marshaller.marshal(objectFactory.createTradeSite((TradeSite)realEstate), outputStream);
        } else {
            marshaller.marshal(objectFactory.createRealEstate(realEstate), outputStream);
        }
    }

    public static void writeXml(Region region, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(region, DEFAULT_ENCODING, true, outputStream);
    }

    public static void writeXml(Region region, String string, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(region, string, true, outputStream);
    }

    public static void writeXml(Region region, String string, boolean bl, OutputStream outputStream) throws JAXBException {
        XmlUtils.writeXml(region, XmlUtils.createMarshaller(string, bl), outputStream);
    }

    public static void writeXml(Region region, Marshaller marshaller, OutputStream outputStream) throws JAXBException {
        org.openestate.is24.restapi.xml.gis.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.gis.ObjectFactory();
        marshaller.setEventHandler(new ValidationEventHandler(){

            public boolean handleEvent(ValidationEvent validationEvent) {
                return true;
            }
        });
        marshaller.marshal(objectFactory.createRegion(region), outputStream);
    }
}

