/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.immobiliare_it;

import com.openindex.openestate.impl.GeoAreaImpl;
import com.openindex.openestate.impl.GeoCountryImpl;
import com.openindex.openestate.impl.GeoImpl;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.SerializableXmlElement;
import java.io.File;
import java.io.Writer;
import java.util.Date;
import java.util.Locale;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.output.FileWriterWithEncoding;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImmobiliareItGeoBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImmobiliareItGeoBuilder.class);

    public GeoImpl build(File file) throws DocumentException {
        GeoImpl geoImpl = new GeoImpl();
        geoImpl.setBuildTime(new Date());
        geoImpl.setName("immobiliare");
        geoImpl.setProvider("Immobiliare.it");
        SAXReader sAXReader = new SAXReader();
        Document document = sAXReader.read(file);
        Element element = document.getRootElement();
        if (!"geolocation".equals(element.getName())) {
            return geoImpl;
        }
        GeoCountryImpl geoCountryImpl = new GeoCountryImpl();
        geoCountryImpl.setId(Locale.ITALY.getISO3Country());
        geoCountryImpl.setIsoCode(Locale.ITALY.getCountry());
        geoCountryImpl.setName(Locale.ITALY.getDisplayCountry(Locale.ITALY));
        geoImpl.getCountries().add(geoCountryImpl);
        for (Object e : element.selectNodes("administrative-area")) {
            this.build_area1((Element)e, geoCountryImpl);
        }
        return geoImpl;
    }

    private void build_area1(Element element, GeoCountryImpl geoCountryImpl) {
        GeoAreaImpl geoAreaImpl = new GeoAreaImpl();
        geoAreaImpl.setName(element.valueOf("@name"));
        geoAreaImpl.setId(DigestUtils.sha1Hex((String)(geoCountryImpl.getId() + "-" + geoAreaImpl.getName())));
        geoAreaImpl.setLevel(GeoAreaImpl.LEVEL_REGION);
        geoCountryImpl.getAreas().add(geoAreaImpl);
        for (Object e : element.selectNodes("sub-administrative-area")) {
            this.build_area2((Element)e, geoAreaImpl);
        }
    }

    private void build_area2(Element element, GeoAreaImpl geoAreaImpl) {
        GeoAreaImpl geoAreaImpl2 = new GeoAreaImpl();
        geoAreaImpl2.setName(element.valueOf("@name"));
        geoAreaImpl2.setId(DigestUtils.sha1Hex((String)(geoAreaImpl.getId() + "-" + geoAreaImpl2.getName())));
        geoAreaImpl.getAreas().add(geoAreaImpl2);
        for (Object e : element.selectNodes("city")) {
            this.build_area3((Element)e, geoAreaImpl2);
        }
    }

    private void build_area3(Element element, GeoAreaImpl geoAreaImpl) {
        GeoAreaImpl geoAreaImpl2 = new GeoAreaImpl();
        geoAreaImpl2.setName(element.valueOf("@name"));
        geoAreaImpl2.setId(DigestUtils.sha1Hex((String)(geoAreaImpl.getId() + "-" + geoAreaImpl2.getName())));
        geoAreaImpl2.setLevel(GeoAreaImpl.LEVEL_CITY);
        geoAreaImpl2.setProviderId(element.valueOf("@code"));
        geoAreaImpl.getAreas().add(geoAreaImpl2);
        for (Object e : element.selectNodes("locality")) {
            this.build_area4((Element)e, geoAreaImpl2);
        }
    }

    private void build_area4(Element element, GeoAreaImpl geoAreaImpl) {
        GeoAreaImpl geoAreaImpl2 = new GeoAreaImpl();
        geoAreaImpl2.setName(element.valueOf("@name"));
        geoAreaImpl2.setId(DigestUtils.sha1Hex((String)(geoAreaImpl.getId() + "-" + geoAreaImpl2.getName())));
        geoAreaImpl2.setLevel(GeoAreaImpl.LEVEL_CITY_PART);
        geoAreaImpl2.setProviderId(element.valueOf("@id"));
        geoAreaImpl.getAreas().add(geoAreaImpl2);
    }

    public static void main(String[] stringArray) {
        File file;
        if (stringArray.length <= 1) {
            System.out.println("no input- and output-file was provided!");
            System.exit(1);
        }
        if (!(file = new File(stringArray[0])).isFile()) {
            System.out.println("input-file is invalid!");
            System.exit(1);
        }
        ImmobiliareItGeoBuilder immobiliareItGeoBuilder = new ImmobiliareItGeoBuilder();
        GeoImpl geoImpl = null;
        try {
            geoImpl = immobiliareItGeoBuilder.build(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        if (geoImpl == null) {
            System.exit(1);
        }
        File file2 = new File(stringArray[1]);
        try (FileWriterWithEncoding fileWriterWithEncoding = new FileWriterWithEncoding(file2, "UTF-8");){
            OpenEstateUtils.serializeToXML((SerializableXmlElement)geoImpl, (Writer)fileWriterWithEncoding, (boolean)true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

