/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv.records;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.types.Auswahl;
import org.openestate.io.is24_csv.types.Befeuerungsart;
import org.openestate.io.is24_csv.types.EnergieausweisTyp;
import org.openestate.io.is24_csv.types.Geschlecht;
import org.openestate.io.is24_csv.types.HeizungsartWohnenAufZeit;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieWohnenAufZeit;
import org.openestate.io.is24_csv.types.Objektzustand;
import org.openestate.io.is24_csv.types.PauschalmietePro;
import org.openestate.io.is24_csv.types.Rauchen;
import org.openestate.io.is24_csv.types.Stellplatz;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WohnenAufZeit
extends Is24CsvRecord {
    private static final Logger LOGGER = LoggerFactory.getLogger(WohnenAufZeit.class);
    protected static final int FIELD_OBJEKTKATEGORIE = 60;
    protected static final int FIELD_WOHNFLAECHE = 61;
    protected static final int FIELD_ZIMMER = 62;
    protected static final int FIELD_FREI_BIS = 63;
    protected static final int FIELD_MIETDAUER_MINIMUM = 64;
    protected static final int FIELD_MIETDAUER_MAXIMUM = 65;
    protected static final int FIELD_ETAGE = 66;
    protected static final int FIELD_ETAGENZAHL = 67;
    protected static final int FIELD_OBJEKTZUSTAND = 68;
    protected static final int FIELD_HEIZUNGSART = 69;
    protected static final int FIELD_AUFZUG = 70;
    protected static final int FIELD_HAUSTIERE = 71;
    protected static final int FIELD_BALKON_TERRASSE = 72;
    protected static final int FIELD_GARTENNUTZUNG = 73;
    protected static final int FIELD_MOBILIAR = 74;
    protected static final int FIELD_RAUCHEN = 75;
    protected static final int FIELD_GESCHLECHT = 76;
    protected static final int FIELD_ANZAHL_PERSONEN = 77;
    protected static final int FIELD_FREI_AB = 78;
    protected static final int FIELD_STELLPLATZ = 79;
    protected static final int FIELD_ROLLSTUHLGERECHT = 80;
    protected static final int FIELD_ANZAHL_GARAGE_STELLPLATZ = 81;
    protected static final int FIELD_BARRIEREFREI = 82;
    protected static final int FIELD_BEFEUERUNG = 83;
    protected static final int FIELD_ENERGIEAUSWEIS_TYP = 84;
    protected static final int FIELD_ENERGIEAUSWEIS_KENNWERT = 85;
    protected static final int FIELD_ENERGIEAUSWEIS_INKL_WARMWASSER = 86;
    protected static final int FIELD_GAESTE_WC = 87;
    protected static final int FIELD_KELLER = 89;
    protected static final int FIELD_PAUSCHALMIETE = 90;
    protected static final int FIELD_PAUSCHALMIETE_PRO = 91;
    protected static final int FIELD_KALTMIETE = 92;
    protected static final int FIELD_NEBENKOSTEN = 93;
    protected static final int FIELD_KAUTION = 94;
    protected static final int FIELD_STELLPLATZMIETE = 95;

    public WohnenAufZeit() {
        this.setImmobilienart(Immobilienart.WOHNEN_AUF_ZEIT);
    }

    public Integer getAnzahlGarageStellplatz() {
        try {
            return Is24CsvFormat.parseInteger(this.get(81));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Garage / Stellplatz'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getAnzahlPersonen() {
        try {
            return Is24CsvFormat.parseInteger(this.get(77));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Anzahl Personen'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getAufzug() {
        return Is24CsvFormat.parseBoolean(this.get(70));
    }

    public Boolean getBalkonTerrasse() {
        return Is24CsvFormat.parseBoolean(this.get(72));
    }

    public Boolean getBarrierefrei() {
        return Is24CsvFormat.parseBoolean(this.get(82));
    }

    public Befeuerungsart[] getBefeuerungsart() {
        return Befeuerungsart.parseMultiple(this.get(83));
    }

    public Boolean getEnergieausweisInklWarmwasser() {
        return Is24CsvFormat.parseBoolean(this.get(86));
    }

    public BigDecimal getEnergieausweisKennwert() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(85));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Energieausweis-Kennwert'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public EnergieausweisTyp getEnergieausweisTyp() {
        return EnergieausweisTyp.parse(this.get(84));
    }

    public Integer getEtage() {
        try {
            return Is24CsvFormat.parseInteger(this.get(66));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Etage'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Integer getEtagenzahl() {
        try {
            return Is24CsvFormat.parseInteger(this.get(67));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Etagenzahl'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Calendar getFreiAb() {
        try {
            return Is24CsvFormat.parseDateAsCalendar(this.get(78));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read 'frei ab'!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public Calendar getFreiBis() {
        try {
            return Is24CsvFormat.parseDateAsCalendar(this.get(63));
        }
        catch (ParseException parseException) {
            LOGGER.warn("Can't read 'frei bis'!");
            LOGGER.warn("> " + parseException.getLocalizedMessage(), (Throwable)parseException);
            return null;
        }
    }

    public Boolean getGaesteWc() {
        return Is24CsvFormat.parseBoolean(this.get(87));
    }

    public Boolean getGartennutzung() {
        return Is24CsvFormat.parseBoolean(this.get(73));
    }

    public Geschlecht getGeschlecht() {
        return Geschlecht.parse(this.get(76));
    }

    public Auswahl getHaustiere() {
        return Auswahl.parse(this.get(71));
    }

    public HeizungsartWohnenAufZeit getHeizungsart() {
        return HeizungsartWohnenAufZeit.parse(this.get(69));
    }

    public BigDecimal getKaltmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(92));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Kaltmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public String getKaution() {
        return this.get(94);
    }

    public Boolean getKeller() {
        return Is24CsvFormat.parseBoolean(this.get(89));
    }

    public BigDecimal getMietdauerMaximum() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(65));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Maximalmietdauer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getMietdauerMinimum() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(64));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Mindestmietdauer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public Boolean getMobiliar() {
        return Is24CsvFormat.parseBoolean(this.get(74));
    }

    public BigDecimal getNebenkosten() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(93));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Nebenkosten'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public ObjektkategorieWohnenAufZeit getObjektkategorie() {
        return ObjektkategorieWohnenAufZeit.parse(this.get(60));
    }

    public Objektzustand getObjektzustand() {
        return Objektzustand.parse(this.get(68));
    }

    public BigDecimal getPauschalmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(90));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Pauschalmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public PauschalmietePro getPauschalmietePro() {
        return PauschalmietePro.parse(this.get(91));
    }

    public Rauchen getRauchen() {
        return Rauchen.parse(this.get(75));
    }

    @Deprecated
    public Boolean getRollstuhlgerecht() {
        return Is24CsvFormat.parseBoolean(this.get(80));
    }

    public Stellplatz getStellplatz() {
        return Stellplatz.parse(this.get(79));
    }

    public BigDecimal getStellplatzmiete() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(95));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Stellplatzmiete'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getWohnflaeche() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(61));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Wohnflaeche'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public BigDecimal getZimmer() {
        try {
            return Is24CsvFormat.parseDecimal(this.get(62));
        }
        catch (NumberFormatException numberFormatException) {
            LOGGER.warn("Can't read 'Zimmer'!");
            LOGGER.warn("> " + numberFormatException.getLocalizedMessage(), (Throwable)numberFormatException);
            return null;
        }
    }

    public static WohnenAufZeit newRecord(CSVRecord cSVRecord) {
        WohnenAufZeit wohnenAufZeit = new WohnenAufZeit();
        wohnenAufZeit.parse(cSVRecord);
        return wohnenAufZeit;
    }

    protected Iterable<String> print() {
        this.setImmobilienart(Immobilienart.WOHNEN_AUF_ZEIT);
        return super.print();
    }

    public void setAnzahlGarageStellplatz(Number number) {
        this.set(81, Is24CsvFormat.printNumber(number, 2));
    }

    public void setAnzahlPersonen(Number number) {
        this.set(77, Is24CsvFormat.printNumber(number, 2));
    }

    public void setAufzug(Boolean bl) {
        this.set(70, Is24CsvFormat.printBoolean(bl));
    }

    public void setBalkonTerrasse(Boolean bl) {
        this.set(72, Is24CsvFormat.printBoolean(bl));
    }

    public void setBarrierefrei(Boolean bl) {
        this.set(82, Is24CsvFormat.printBoolean(bl));
    }

    public void setBefeuerungsart(Befeuerungsart befeuerungsart) {
        this.set(83, befeuerungsart != null ? befeuerungsart.print() : null);
    }

    public void setBefeuerungsart(Iterable<Befeuerungsart> iterable) {
        this.set(83, Befeuerungsart.printMultiple(iterable));
    }

    public void setEnergieausweisInklWarmwasser(Boolean bl) {
        this.set(86, Is24CsvFormat.printBoolean(bl));
    }

    public void setEnergieausweisKennwert(Number number) {
        this.set(85, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setEnergieausweisTyp(EnergieausweisTyp energieausweisTyp) {
        this.set(84, energieausweisTyp != null ? energieausweisTyp.print() : null);
    }

    public void setEtage(Number number) {
        this.set(66, Is24CsvFormat.printNumber(number, 3));
    }

    public void setEtagenzahl(Number number) {
        this.set(67, Is24CsvFormat.printNumber(number, 2));
    }

    public void setFreiAb(Calendar calendar) {
        this.set(78, Is24CsvFormat.printDate(calendar));
    }

    public void setFreiAb(Date date) {
        this.set(78, Is24CsvFormat.printDate(date));
    }

    public void setFreiBis(Calendar calendar) {
        this.set(63, Is24CsvFormat.printDate(calendar));
    }

    public void setFreiBis(Date date) {
        this.set(63, Is24CsvFormat.printDate(date));
    }

    public void setGaesteWc(Boolean bl) {
        this.set(87, Is24CsvFormat.printBoolean(bl));
    }

    public void setGartennutzung(Boolean bl) {
        this.set(73, Is24CsvFormat.printBoolean(bl));
    }

    public void setGeschlecht(Geschlecht geschlecht) {
        this.set(76, geschlecht != null ? geschlecht.print() : null);
    }

    public void setHaustiere(Auswahl auswahl) {
        this.set(71, auswahl != null ? auswahl.print() : null);
    }

    public void setHeizungsart(HeizungsartWohnenAufZeit heizungsartWohnenAufZeit) {
        this.set(69, heizungsartWohnenAufZeit != null ? heizungsartWohnenAufZeit.print() : null);
    }

    public void setKaltmiete(Number number) {
        this.set(92, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setKaution(String string) {
        this.set(94, Is24CsvFormat.printString(string, 50));
    }

    public void setKeller(Boolean bl) {
        this.set(89, Is24CsvFormat.printBoolean(bl));
    }

    public void setMietdauerMaximum(Number number) {
        this.set(65, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setMietdauerMinimum(Number number) {
        this.set(64, Is24CsvFormat.printNumber(number, 5, 2));
    }

    public void setMobiliar(Boolean bl) {
        this.set(74, Is24CsvFormat.printBoolean(bl));
    }

    public void setNebenkosten(Number number) {
        this.set(93, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setObjektkategorie(ObjektkategorieWohnenAufZeit objektkategorieWohnenAufZeit) {
        this.set(60, objektkategorieWohnenAufZeit != null ? objektkategorieWohnenAufZeit.print() : null);
    }

    public void setObjektzustand(Objektzustand objektzustand) {
        this.set(68, objektzustand != null ? objektzustand.print() : null);
    }

    public void setPauschalmiete(Number number) {
        this.set(90, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setPauschalmietePro(PauschalmietePro pauschalmietePro) {
        this.set(91, pauschalmietePro != null ? pauschalmietePro.print() : null);
    }

    public void setRauchen(Rauchen rauchen) {
        this.set(75, rauchen != null ? rauchen.print() : null);
    }

    @Deprecated
    public void setRollstuhlgerecht(Boolean bl) {
        this.set(80, Is24CsvFormat.printBoolean(bl));
    }

    public void setStellplatz(Stellplatz stellplatz) {
        this.set(79, stellplatz != null ? stellplatz.print() : null);
    }

    public void setStellplatzmiete(Number number) {
        this.set(95, Is24CsvFormat.printNumber(number, 15, 2));
    }

    public void setWohnflaeche(Number number) {
        this.set(61, Is24CsvFormat.printNumber(number, 7, 2));
    }

    public void setZimmer(Number number) {
        this.set(62, Is24CsvFormat.printNumber(number, 2, 1));
    }
}

