/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.trovit.xml.types;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum TypeValue {
    FOR_RENT(new String[]{"For Rent", "Alquiler"}),
    FOR_SALE(new String[]{"For Sale", "Venta"}),
    RENTALS(new String[]{"Rentals"}),
    ROOMMATE(new String[]{"Roommate"}),
    PARKING_FOR_RENT(new String[]{"Parking For Rent"}),
    PARKING_FOR_SALE(new String[]{"Parking For Sale"}),
    OFFICE_FOR_RENT(new String[]{"Office For Rent"}),
    OFFICE_FOR_SALE(new String[]{"Office For Sale"}),
    LAND_FOR_SALE(new String[]{"Land For Sale"}),
    LOCAL_FOR_RENT(new String[]{"For Rent Local"}),
    LOCAL_FOR_SALE(new String[]{"For Sale Local"}),
    LOCAL_FOR_TRANSFER(new String[]{"Transfer Local"}),
    COUNTRY_HOUSE_RENTALS(new String[]{"Country House Rentals"}),
    WAREHOUSE_FOR_RENT(new String[]{"Warehouse For Rent"}),
    WAREHOUSE_FOR_SALE(new String[]{"Warehouse For Sale"}),
    OVERSEAS(new String[]{"Overseas"}),
    SHORT_TERM_RENTALS(new String[]{"Short Term Rentals"}),
    UNLISTED_FORECLOSURE(new String[]{"Unlisted Foreclosure"});

    private static final Logger LOGGER;
    private final String[] aliases;

    private TypeValue(String[] stringArray) {
        this.aliases = stringArray;
    }

    public static TypeValue fromXmlValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (TypeValue typeValue : TypeValue.values()) {
            if (typeValue.name().equalsIgnoreCase(string)) {
                return typeValue;
            }
            for (String string2 : typeValue.aliases) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return typeValue;
            }
        }
        return null;
    }

    public String write() {
        return this.aliases[0];
    }

    static {
        LOGGER = LoggerFactory.getLogger(TypeValue.class);
    }
}

