/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.idx.types;

import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Media
implements Serializable {
    private static final long serialVersionUID = 5668966682578880420L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Media.class);
    private String fileName;
    private String title;
    private String description;
    private String url;
    private static final String SUFFIX_AVI = ".avi";
    private static final String SUFFIX_DOC = ".doc";
    private static final String SUFFIX_FLV = ".flv";
    private static final String SUFFIX_GIF = ".gif";
    private static final String SUFFIX_JPG = ".jpg";
    private static final String SUFFIX_JPEG = ".jpeg";
    private static final String SUFFIX_MP4 = ".mp4";
    private static final String SUFFIX_MPG = ".mpg";
    private static final String SUFFIX_MPEG = ".mpeg";
    private static final String SUFFIX_MOV = ".mov";
    private static final String SUFFIX_PDF = ".pdf";
    private static final String SUFFIX_RPM = ".rpm";
    private static final String SUFFIX_RTF = ".rtf";
    private static final String SUFFIX_WMV = ".wmv";

    public Media() {
        this(null, null, null, null);
    }

    public Media(String string) {
        this(string, null, null, null);
    }

    public Media(String string, String string2) {
        this(string, string2, null, null);
    }

    public Media(String string, String string2, String string3) {
        this(string, string2, string3, null);
    }

    public Media(String string, String string2, String string3, String string4) {
        this.fileName = string;
        this.title = string2;
        this.description = string3;
        this.url = string4;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getTitle() {
        return this.title;
    }

    public String getUrl() {
        return this.url;
    }

    public String guessMimeType() {
        String string = StringUtils.lowerCase((String)(!StringUtils.isBlank((CharSequence)this.fileName) ? this.fileName : this.url));
        if (string.endsWith(SUFFIX_AVI)) {
            return "video/x-msvideo";
        }
        if (string.endsWith(SUFFIX_DOC)) {
            return "application/msword";
        }
        if (string.endsWith(SUFFIX_FLV)) {
            return "video/x-flv";
        }
        if (string.endsWith(SUFFIX_GIF)) {
            return "image/gif";
        }
        if (string.endsWith(SUFFIX_JPEG)) {
            return "image/jpeg";
        }
        if (string.endsWith(SUFFIX_JPG)) {
            return "image/jpeg";
        }
        if (string.endsWith(SUFFIX_MOV)) {
            return "video/quicktime";
        }
        if (string.endsWith(SUFFIX_MP4)) {
            return "video/mp4";
        }
        if (string.endsWith(SUFFIX_MPEG)) {
            return "video/mpeg";
        }
        if (string.endsWith(SUFFIX_MPG)) {
            return "video/mpeg";
        }
        if (string.endsWith(SUFFIX_PDF)) {
            return "application/pdf";
        }
        if (string.endsWith(SUFFIX_RPM)) {
            return "video/vnd.rn-realvideo";
        }
        if (string.endsWith(SUFFIX_RTF)) {
            return "application/rtf";
        }
        if (string.endsWith(SUFFIX_WMV)) {
            return "video/x-ms-wmv";
        }
        return "application/octet-stream";
    }

    public boolean isDocument() {
        return Media.isDocument(this.fileName);
    }

    public static boolean isDocument(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(SUFFIX_PDF) || string2.endsWith(SUFFIX_RTF) || string2.endsWith(SUFFIX_DOC);
    }

    public boolean isImage() {
        return Media.isImage(this.fileName);
    }

    public static boolean isImage(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(SUFFIX_JPEG) || string2.endsWith(SUFFIX_JPG) || string2.endsWith(SUFFIX_GIF);
    }

    public boolean isMovie() {
        return Media.isMovie(this.fileName);
    }

    public static boolean isMovie(String string) {
        if (StringUtils.isBlank((CharSequence)string)) {
            return false;
        }
        String string2 = string.toLowerCase().trim();
        return string2.endsWith(SUFFIX_MOV) || string2.endsWith(SUFFIX_AVI) || string2.endsWith(SUFFIX_RPM) || string2.endsWith(SUFFIX_MPG) || string2.endsWith(SUFFIX_MPEG) || string2.endsWith(SUFFIX_WMV) || string2.endsWith(SUFFIX_MP4) || string2.endsWith(SUFFIX_FLV);
    }

    public void setDescription(String string) {
        this.description = StringUtils.trimToNull((String)string);
    }

    public void setFileName(String string) {
        this.fileName = StringUtils.trimToNull((String)string);
    }

    public void setTitle(String string) {
        this.title = StringUtils.trimToNull((String)string);
    }

    public void setUrl(String string) {
        this.url = StringUtils.trimToNull((String)string);
    }
}

