/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoFeedbackDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmo_1_2_5
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_5.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_5;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_4);
        if (openImmoDocument instanceof OpenImmoFeedbackDocument) {
            try {
                this.removeFeedbackObjektChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <objekt> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        } else if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removeKontaktpersonChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <kontaktperson> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeMwstGesamtElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <mwst_gesamt> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeVerkehrswertElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <verkehrswert> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeAnzahlLogiaElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <anzahl_logia> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeErschliessungUmfangElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <erschliessung_umfang> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeVerwaltungTechnChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <verwaltung_techn> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeZustandElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <zustand> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBebaubarNachElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <bebaubar_nach> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeErschliessungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <erschliessung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeWohnungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <wohnung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeHausElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <haus> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_5);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.upgradeEnergiepassElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't upgrade <energiepass> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    protected void downgradeBebaubarNachElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:bebaubar_nach[@bebaubar_attr]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("bebaubar_attr"));
            if (!"BAULAND_OHNE_B_PLAN".equalsIgnoreCase(string)) continue;
            element.removeAttribute("bebaubar_attr");
        }
    }

    protected void downgradeEnergiepassElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:energiepass", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            String string;
            Node node;
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            List list2 = XmlUtils.newXPath((String)"io:hwbwert", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_hwbwert", string));
                    bl = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:hwbklasse", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl2 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_hwbklasse", string));
                    bl2 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:fgeewert", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl3 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_fgeewert", string));
                    bl3 = true;
                }
                element.removeChild(node);
            }
            list2 = XmlUtils.newXPath((String)"io:fgeeklasse", (Document)document).selectNodes((Object)element);
            for (Object e2 : list2) {
                node = (Node)e2;
                if (!bl4 && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                    element2.appendChild(OpenImmoUtils.createUserDefinedSimplefield(document, "epass_fgeeklasse", string));
                    bl4 = true;
                }
                element.removeChild(node);
            }
        }
    }

    protected void downgradeErschliessungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:erschliessung[@erschl_attr]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("erschl_attr"));
            if (!"ORTSUEBLICHERSCHLOSSEN".equalsIgnoreCase(string)) continue;
            element.removeAttribute("erschl_attr");
        }
    }

    protected void downgradeHausElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:haus[@haustyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("haustyp"));
            if (!"FERTIGHAUS".equalsIgnoreCase(string)) continue;
            element.setAttribute("haustyp", "KEINE_ANGABE");
        }
    }

    protected void downgradeWohnungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:wohnung[@wohnungtyp]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("wohnungtyp"));
            if (!"ATTIKAWOHNUNG".equalsIgnoreCase(string)) continue;
            element.setAttribute("wohnungtyp", "KEINE_ANGABE");
        }
    }

    protected void downgradeZustandElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:zustand[@zustand_art]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("zustand_art"));
            if ("TEIL_SANIERT".equalsIgnoreCase(string)) {
                element.setAttribute("zustand_art", "TEIL_VOLLSANIERT");
                continue;
            }
            if ("VOLL_SANIERT".equalsIgnoreCase(string)) {
                element.setAttribute("zustand_art", "TEIL_VOLLSANIERT");
                continue;
            }
            if (!"SANIERUNGSBEDUERFTIG".equalsIgnoreCase(string)) continue;
            element.removeAttribute("zustand_art");
        }
    }

    protected void removeAnzahlLogiaElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:anzahl_logia", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeErschliessungUmfangElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:erschliessung_umfang", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeFeedbackObjektChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo_feedback/io:objekt/io:land |/io:openimmo_feedback/io:objekt/io:stadtbezirk |/io:openimmo_feedback/io:objekt/io:anzahl_zimmer |/io:openimmo_feedback/io:objekt/io:flaeche", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeKontaktpersonChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:kontaktperson/io:position |/io:openimmo/io:anbieter/io:immobilie/io:kontaktperson/io:immobilientreuhaenderid |/io:openimmo/io:anbieter/io:immobilie/io:kontaktperson/io:foto", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeMwstGesamtElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:mwst_gesamt", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeVerkehrswertElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:versteigerung/io:verkehrswert", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeVerwaltungTechnChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:verwaltung_techn/io:gruppen_kennung |/io:openimmo/io:anbieter/io:immobilie/io:verwaltung_techn/io:master |/io:openimmo/io:anbieter/io:immobilie/io:verwaltung_techn/io:sprache", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void upgradeEnergiepassElements(Document document) throws JaxenException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("hwbwert", "user_defined_simplefield[@feldname='epass_hwbwert']");
        hashMap.put("hwbklasse", "user_defined_simplefield[@feldname='epass_hwbklasse']");
        hashMap.put("fgeewert", "user_defined_simplefield[@feldname='epass_fgeewert']");
        hashMap.put("fgeeklasse", "user_defined_simplefield[@feldname='epass_fgeeklasse']");
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)XmlUtils.newXPath((String)"io:energiepass", (Document)document).selectSingleNode((Object)element);
            if (element2 == null) {
                element2 = document.createElementNS("", "energiepass");
            }
            for (Map.Entry entry : hashMap.entrySet()) {
                boolean bl = false;
                List list2 = XmlUtils.newXPath((String)((String)entry.getValue()), (Document)document).selectNodes((Object)element);
                for (Object e2 : list2) {
                    String string;
                    Node node = (Node)e2;
                    if (!bl && (string = StringUtils.trimToNull((String)node.getTextContent())) != null) {
                        Element element3 = document.createElementNS("", (String)entry.getKey());
                        element3.setTextContent(string);
                        element2.appendChild(element3);
                        bl = true;
                    }
                    element.removeChild(node);
                }
            }
            if (element2.getParentNode() != null || !element2.hasChildNodes()) continue;
            element.appendChild(element2);
        }
    }
}

