/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.GeoAreaLevel;
import com.openindex.openestate.impl.db.DbGeo;
import com.openindex.openestate.impl.db.DbGeoArea;
import com.openindex.openestate.impl.db.DbGeoCountry;
import com.openindex.openestate.impl.db.DbGeoHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbGeoHandler
extends DbGeoHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbGeoHandler.class);
    public static final String VIEW_AREAS = "view_openestate_geodbs_areas";
    public static final String VIEW_COUNTRIES = "view_openestate_geodbs_countries";
    public static final String VIEW_GEODBS = "view_openestate_geodbs";
    public static final String PROC_REMOVE_AREAS = "remove_openestate_geodbs_areas";
    public static final String PROC_REMOVE_COUNTRIES = "remove_openestate_geodbs_countries";
    public static final String PROC_REMOVE_GEODBS = "remove_openestate_geodbs";
    public static final String PROC_SAVE_AREAS = "save_openestate_geodbs_areas";
    public static final String PROC_SAVE_COUNTRIES = "save_openestate_geodbs_countries";
    public static final String PROC_SAVE_GEODBS = "save_openestate_geodbs";
    public static final String FIELD_GEODB_ID = "geodb_id";
    public static final String FIELD_GEODB_NAME = "geodb_name";
    public static final String FIELD_GEODB_PROVIDER = "geodb_provider";
    public static final String FIELD_GEODB_BUILD_TIME = "geodb_build_time";
    public static final String FIELD_AREA_ID = "area_id";
    public static final String FIELD_AREA_PARENT_ID = "area_parent_id";
    public static final String FIELD_AREA_NAME = "area_name";
    public static final String FIELD_AREA_LEVEL = "area_level";
    public static final String FIELD_AREA_PROVIDER_ID = "area_provider_id";
    public static final String FIELD_COUNTRY_ID = "country_id";
    public static final String FIELD_COUNTRY_ISO = "country_iso";
    public static final String FIELD_COUNTRY_NAME = "country_name";
    public static final String FIELD_COUNTRY_PROVIDER_ID = "country_provider_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    public HSqlDbGeoHandler() {
    }

    public HSqlDbGeoHandler(String string) {
        super(string);
    }

    private static DbGeoArea createGeoArea(ResultSet resultSet) throws SQLException {
        DbGeoArea dbGeoArea = new DbGeoArea();
        dbGeoArea.id = resultSet.getLong(FIELD_AREA_ID);
        dbGeoArea.countryId = resultSet.getLong(FIELD_COUNTRY_ID);
        dbGeoArea.parentAreaId = resultSet.getLong(FIELD_AREA_PARENT_ID);
        dbGeoArea.providerId = resultSet.getString(FIELD_AREA_PROVIDER_ID);
        dbGeoArea.name = resultSet.getString(FIELD_AREA_NAME);
        try {
            String string = resultSet.getString(FIELD_AREA_LEVEL);
            if (string != null && string.trim().length() > 0) {
                dbGeoArea.level = GeoAreaLevel.valueOf((String)string);
            }
        }
        catch (Exception exception) {
            dbGeoArea.level = null;
            LOGGER.warn("Can't read level of geo-area #" + dbGeoArea.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return dbGeoArea;
    }

    private static DbGeoCountry createGeoCountry(ResultSet resultSet) throws SQLException {
        DbGeoCountry dbGeoCountry = new DbGeoCountry();
        dbGeoCountry.id = resultSet.getLong(FIELD_COUNTRY_ID);
        dbGeoCountry.providerId = resultSet.getString(FIELD_COUNTRY_PROVIDER_ID);
        dbGeoCountry.name = resultSet.getString(FIELD_COUNTRY_NAME);
        String string = resultSet.getString(FIELD_COUNTRY_ISO);
        if (string != null) {
            dbGeoCountry.locale = new Locale("", string);
        }
        return dbGeoCountry;
    }

    private static DbGeo createGeoDb(ResultSet resultSet) throws SQLException {
        DbGeo dbGeo = new DbGeo();
        dbGeo.id = resultSet.getLong(FIELD_GEODB_ID);
        dbGeo.name = resultSet.getString(FIELD_GEODB_NAME);
        dbGeo.provider = resultSet.getString(FIELD_GEODB_PROVIDER);
        dbGeo.buildTime = resultSet.getTimestamp(FIELD_GEODB_BUILD_TIME);
        dbGeo.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbGeo.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbGeo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoArea[] getGeoAreas(Connection connection, long[] lArray) throws SQLException {
        DbGeoArea[] dbGeoAreaArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbGeoArea[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_AREA_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoArea(resultSet));
            }
            dbGeoAreaArray = arrayList.toArray(new DbGeoArea[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoAreaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoArea[] getGeoAreas(Connection connection, long l) throws SQLException {
        DbGeoArea[] dbGeoAreaArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_AREA_PARENT_ID + " = ? ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoArea(resultSet));
            }
            dbGeoAreaArray = arrayList.toArray(new DbGeoArea[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoAreaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoArea[] getGeoAreas(Connection connection, long l, GeoAreaLevel geoAreaLevel) throws SQLException {
        DbGeoArea[] dbGeoAreaArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
            } else if (geoAreaLevel == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_COUNTRY_ID + " = ? ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
                preparedStatement.setLong(1, l);
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_COUNTRY_ID + " = ? AND " + FIELD_AREA_LEVEL + " = ? ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
                preparedStatement.setLong(1, l);
                preparedStatement.setString(2, geoAreaLevel.toString());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoArea(resultSet));
            }
            dbGeoAreaArray = arrayList.toArray(new DbGeoArea[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoAreaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoArea[] getGeoAreas(Connection connection, long l, boolean bl) throws SQLException {
        DbGeoArea[] dbGeoAreaArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
            } else if (bl) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_COUNTRY_ID + " = ? ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
                preparedStatement.setLong(1, l);
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_AREAS) + " WHERE " + FIELD_COUNTRY_ID + " = ? AND " + FIELD_AREA_PARENT_ID + " IS NULL ORDER BY " + FIELD_AREA_PARENT_ID + " ASC, " + FIELD_AREA_NAME + " ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoArea> arrayList = new ArrayList<DbGeoArea>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoArea(resultSet));
            }
            dbGeoAreaArray = arrayList.toArray(new DbGeoArea[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoAreaArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoCountry[] getGeoCountries(Connection connection, long[] lArray) throws SQLException {
        DbGeoCountry[] dbGeoCountryArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbGeoCountry[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_COUNTRIES) + " ORDER BY " + FIELD_COUNTRY_PROVIDER_ID + " ASC, " + FIELD_COUNTRY_ISO + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_COUNTRIES) + " WHERE " + FIELD_COUNTRY_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_COUNTRY_PROVIDER_ID + " ASC, " + FIELD_COUNTRY_ISO + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoCountry> arrayList = new ArrayList<DbGeoCountry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoCountry(resultSet));
            }
            dbGeoCountryArray = arrayList.toArray(new DbGeoCountry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoCountryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbGeoCountry[] getGeoCountries(Connection connection, long l) throws SQLException {
        DbGeoCountry[] dbGeoCountryArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (l < 1L) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_COUNTRIES) + " ORDER BY " + FIELD_COUNTRY_PROVIDER_ID + " ASC, " + FIELD_COUNTRY_ISO + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_COUNTRIES) + " WHERE " + FIELD_GEODB_ID + " = ? ORDER BY " + FIELD_COUNTRY_PROVIDER_ID + " ASC, " + FIELD_COUNTRY_ISO + " ASC;");
                preparedStatement.setLong(1, l);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeoCountry> arrayList = new ArrayList<DbGeoCountry>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoCountry(resultSet));
            }
            dbGeoCountryArray = arrayList.toArray(new DbGeoCountry[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoCountryArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbGeoCountry getGeoCountry(Connection connection, long l, String string) throws SQLException {
        DbGeoCountry dbGeoCountry;
        if (l < 1L || string == null || string.trim().length() == 0) {
            return null;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_COUNTRIES) + " WHERE " + FIELD_GEODB_ID + " = ? AND UPPER(" + FIELD_COUNTRY_ISO + ") = ? LIMIT 1;");
            preparedStatement.setLong(1, l);
            preparedStatement.setString(2, string.toUpperCase());
            resultSet = preparedStatement.executeQuery();
            dbGeoCountry = resultSet.next() ? HSqlDbGeoHandler.createGeoCountry(resultSet) : null;
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoCountry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbGeo[] getGeoDbs(Connection connection, long[] lArray) throws SQLException {
        DbGeo[] dbGeoArray;
        if (lArray != null && lArray.length < 1) {
            return new DbGeo[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_GEODBS) + " ORDER BY " + FIELD_GEODB_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_GEODBS) + " WHERE " + FIELD_GEODB_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_GEODB_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeo> arrayList = new ArrayList<DbGeo>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoDb(resultSet));
            }
            dbGeoArray = arrayList.toArray(new DbGeo[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbGeo[] getGeoDbs(Connection connection, String[] stringArray) throws SQLException {
        DbGeo[] dbGeoArray;
        if (stringArray != null && stringArray.length < 1) {
            return new DbGeo[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (stringArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_GEODBS) + " ORDER BY " + FIELD_GEODB_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_GEODBS) + " WHERE " + FIELD_GEODB_NAME + " IN (" + JdbcUtils.writeQuestionMarkList((int)stringArray.length) + ") ORDER BY " + FIELD_GEODB_ID + " ASC LIMIT " + stringArray.length + ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbGeo> arrayList = new ArrayList<DbGeo>();
            while (resultSet.next()) {
                arrayList.add(HSqlDbGeoHandler.createGeoDb(resultSet));
            }
            dbGeoArray = arrayList.toArray(new DbGeo[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbGeoArray;
    }

    public void removeGeoAreas(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_AREAS) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void removeGeoCountries(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_COUNTRIES) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void removeGeoDbs(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_GEODBS) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveGeoArea(Connection connection, DbGeoArea dbGeoArea, boolean bl) throws SQLException {
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_AREAS) + "(:" + FIELD_AREA_ID + ", :" + FIELD_COUNTRY_ID + ", :" + FIELD_AREA_PARENT_ID + ", :" + FIELD_AREA_NAME + ", :" + FIELD_AREA_LEVEL + ", :" + FIELD_AREA_PROVIDER_ID + ");");
            namedCallableStatement.setLong(FIELD_AREA_ID, dbGeoArea.id);
            namedCallableStatement.setLong(FIELD_COUNTRY_ID, dbGeoArea.countryId);
            namedCallableStatement.setString(FIELD_AREA_NAME, StringUtils.abbreviate((String)dbGeoArea.name, (int)255));
            namedCallableStatement.setString(FIELD_AREA_PROVIDER_ID, StringUtils.abbreviate((String)dbGeoArea.providerId, (int)255));
            namedCallableStatement.setString(FIELD_AREA_LEVEL, dbGeoArea.level != null ? StringUtils.abbreviate((String)dbGeoArea.level.name(), (int)15) : null);
            if (dbGeoArea.parentAreaId > 0L) {
                namedCallableStatement.setLong(FIELD_AREA_PARENT_ID, dbGeoArea.parentAreaId);
            } else {
                namedCallableStatement.setNull(FIELD_AREA_PARENT_ID, -5);
            }
            namedCallableStatement.execute();
            long l2 = l = dbGeoArea.id < 1L ? namedCallableStatement.getLong(FIELD_AREA_ID) : dbGeoArea.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbGeoArea.id < 1L) {
                dbGeoArea.id = l;
                if (dbGeoArea.childAreas != null) {
                    for (DbGeoArea dbGeoArea2 : dbGeoArea.childAreas) {
                        dbGeoArea2.geo = dbGeoArea.geo;
                        dbGeoArea2.country = dbGeoArea.country;
                        dbGeoArea2.countryId = dbGeoArea.countryId;
                        dbGeoArea2.parentArea = dbGeoArea;
                        dbGeoArea2.parentAreaId = dbGeoArea.id;
                    }
                }
            }
            if (bl && dbGeoArea.childAreas != null) {
                for (DbGeoArea dbGeoArea2 : dbGeoArea.childAreas) {
                    this.saveGeoArea(connection, dbGeoArea2, true);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    public void saveGeoCountry(Connection connection, DbGeoCountry dbGeoCountry, boolean bl) throws SQLException {
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_COUNTRIES) + "(:" + FIELD_COUNTRY_ID + ", :" + FIELD_GEODB_ID + ", :" + FIELD_COUNTRY_ISO + ", :" + FIELD_COUNTRY_NAME + ", :" + FIELD_COUNTRY_PROVIDER_ID + ");");
            namedCallableStatement.setLong(FIELD_COUNTRY_ID, dbGeoCountry.id);
            namedCallableStatement.setLong(FIELD_GEODB_ID, dbGeoCountry.geoId);
            namedCallableStatement.setString(FIELD_COUNTRY_ISO, dbGeoCountry.locale != null ? dbGeoCountry.locale.getCountry() : null);
            namedCallableStatement.setString(FIELD_COUNTRY_NAME, StringUtils.abbreviate((String)dbGeoCountry.name, (int)255));
            namedCallableStatement.setString(FIELD_COUNTRY_PROVIDER_ID, StringUtils.abbreviate((String)dbGeoCountry.providerId, (int)255));
            namedCallableStatement.execute();
            long l2 = l = dbGeoCountry.id < 1L ? namedCallableStatement.getLong(FIELD_COUNTRY_ID) : dbGeoCountry.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbGeoCountry.id < 1L) {
                dbGeoCountry.id = l;
                if (dbGeoCountry.areas != null) {
                    for (DbGeoArea dbGeoArea : dbGeoCountry.getChildAreas(true)) {
                        dbGeoArea.geo = dbGeoCountry.geo;
                        dbGeoArea.country = dbGeoCountry;
                        dbGeoArea.countryId = dbGeoCountry.id;
                    }
                }
            }
            if (bl && dbGeoCountry.areas != null) {
                for (DbGeoArea dbGeoArea : dbGeoCountry.areas) {
                    this.saveGeoArea(connection, dbGeoArea, true);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }

    public void saveGeoDb(Connection connection, DbGeo dbGeo, boolean bl) throws SQLException {
        boolean bl2 = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_GEODBS) + "(:" + FIELD_GEODB_ID + ", :" + FIELD_GEODB_NAME + ", :" + FIELD_GEODB_PROVIDER + ", :" + FIELD_GEODB_BUILD_TIME + ");");
            namedCallableStatement.setLong(FIELD_GEODB_ID, dbGeo.id);
            namedCallableStatement.setString(FIELD_GEODB_NAME, StringUtils.abbreviate((String)dbGeo.name, (int)255));
            namedCallableStatement.setString(FIELD_GEODB_PROVIDER, StringUtils.abbreviate((String)dbGeo.provider, (int)255));
            namedCallableStatement.setTimestamp(FIELD_GEODB_BUILD_TIME, dbGeo.buildTime != null ? new Timestamp(dbGeo.buildTime.getTime()) : null);
            namedCallableStatement.execute();
            long l2 = l = dbGeo.id < 1L ? namedCallableStatement.getLong(FIELD_GEODB_ID) : dbGeo.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbGeo.id < 1L) {
                dbGeo.id = l;
                if (dbGeo.countries != null) {
                    for (DbGeoCountry dbGeoCountry : dbGeo.countries) {
                        dbGeoCountry.geo = dbGeo;
                        dbGeoCountry.geoId = dbGeo.id;
                        if (dbGeoCountry.areas == null) continue;
                        for (DbGeoArea dbGeoArea : dbGeoCountry.getChildAreas(true)) {
                            dbGeoArea.geo = dbGeo;
                        }
                    }
                }
            }
            if (bl && dbGeo.countries != null) {
                for (DbGeoCountry dbGeoCountry : dbGeo.countries) {
                    this.saveGeoCountry(connection, dbGeoCountry, true);
                }
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl2);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl2);
    }
}

