/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.EstateLinkProvider;
import com.openindex.openestate.impl.db.DbLink;
import com.openindex.openestate.impl.db.DbLinksHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbLinksHandler
extends DbLinksHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbLinksHandler.class);
    public static final String PROC_REMOVE_LINKS = "remove_openestate_objects_links";
    public static final String PROC_REMOVE_LINKS_I18N = "remove_openestate_objects_links_i18n";
    public static final String PROC_SAVE_LINKS = "save_openestate_objects_links";
    public static final String PROC_SAVE_LINKS_I18N = "save_openestate_objects_links_i18n";
    public static final String VIEW_LINKS = "view_openestate_objects_links";
    public static final String VIEW_LINKS_I18N = "view_openestate_objects_links_i18n";
    public static final String FIELD_LINK_ID = "link_id";
    public static final String FIELD_LINK_WEB_URL = "link_web_url";
    public static final String FIELD_LINK_PROVIDER_ID = "link_provider_id";
    public static final String FIELD_LINK_PROVIDER_NAME = "link_provider_name";
    public static final String FIELD_LINK_PUBLISHED = "link_published";
    public static final String FIELD_LINK_POSITION = "link_position";
    public static final String FIELD_I18N_TITLE = "i18n_title";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_OBJECT_ID = "object_id";
    private static final String FIELD_LANGUAGE_ID = "language_id";

    public HSqlDbLinksHandler() {
    }

    public HSqlDbLinksHandler(String string) {
        super(string);
    }

    protected DbLink buildLink(ResultSet resultSet) throws SQLException {
        String string;
        DbLink dbLink = this.createLink();
        dbLink.id = resultSet.getLong(FIELD_LINK_ID);
        dbLink.objectId = resultSet.getLong(FIELD_OBJECT_ID);
        dbLink.position = resultSet.getInt(FIELD_LINK_POSITION);
        dbLink.published = resultSet.getBoolean(FIELD_LINK_PUBLISHED);
        dbLink.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbLink.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        try {
            string = StringUtils.trimToNull((String)resultSet.getString(FIELD_LINK_WEB_URL));
            if (string != null) {
                dbLink.webLinkUrl = new URI(string);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            LOGGER.warn("Can't read web link URL!");
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        string = resultSet.getString(FIELD_LINK_PROVIDER_NAME);
        if (!StringUtils.isBlank((CharSequence)string)) {
            dbLink.providerLinkId = resultSet.getString(FIELD_LINK_PROVIDER_ID);
            for (EstateLinkProvider estateLinkProvider : EstateLinkProvider.values()) {
                if (!estateLinkProvider.getXmlName().equalsIgnoreCase(string)) continue;
                dbLink.provider = estateLinkProvider;
                break;
            }
        }
        return dbLink;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbLink[] getLinks(Connection connection, long[] lArray) throws SQLException {
        DbLink[] dbLinkArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbLink[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LINKS) + " ORDER BY " + FIELD_LINK_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LINKS) + " WHERE " + FIELD_LINK_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_LINK_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbLink> arrayList = new ArrayList<DbLink>();
            while (resultSet.next()) {
                arrayList.add(this.buildLink(resultSet));
            }
            dbLinkArray = arrayList.toArray(new DbLink[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLinkArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbLink[] getLinks(Connection connection, long l, Boolean bl, EstateLinkProvider estateLinkProvider) throws SQLException {
        DbLink[] dbLinkArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l > 0L) {
                arrayList.add("object_id = ?");
            }
            if (bl != null) {
                arrayList.add("link_published = ?");
            }
            if (estateLinkProvider != null) {
                arrayList.add("link_provider_name LIKE ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LINKS) + " " + string + " ORDER BY " + FIELD_LINK_POSITION + " ASC, " + FIELD_LINK_ID + " ASC;");
            int n = 0;
            if (l > 0L) {
                preparedStatement.setLong(++n, l);
            }
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (estateLinkProvider != null) {
                preparedStatement.setString(++n, estateLinkProvider.getXmlName());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbLink> arrayList2 = new ArrayList<DbLink>();
            while (resultSet.next()) {
                arrayList2.add(this.buildLink(resultSet));
            }
            dbLinkArray = arrayList2.toArray(new DbLink[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbLinkArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getLinkIds(Connection connection, long l, Boolean bl, EstateLinkProvider estateLinkProvider) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l > 0L) {
                arrayList.add("object_id = ?");
            }
            if (bl != null) {
                arrayList.add("link_published = ?");
            }
            if (estateLinkProvider != null) {
                arrayList.add("link_provider_name LIKE ?");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT link_id FROM " + this.getSchemaPath(VIEW_LINKS) + " " + string + " ORDER BY " + FIELD_LINK_ID + " ASC;");
            int n = 0;
            if (l > 0L) {
                preparedStatement.setLong(++n, l);
            }
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (estateLinkProvider != null) {
                preparedStatement.setString(++n, estateLinkProvider.getXmlName());
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getLong(FIELD_LINK_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadLinkTranslations(Connection connection, DbLink[] dbLinkArray, Map<Long, String> map) throws SQLException {
        ResultSet resultSet;
        HashMap<Long, DbLink> hashMap = new HashMap<Long, DbLink>();
        for (DbLink object2 : dbLinkArray) {
            if (object2.id <= 0L || hashMap.containsKey(object2.id)) continue;
            hashMap.put(object2.id, object2);
            if (object2.translations == null) {
                object2.translations = new HashMap();
                continue;
            }
            object2.translations.clear();
        }
        int n = map.size();
        int n2 = hashMap.size();
        if (n2 < 1 || n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_LINKS_I18N) + " WHERE " + FIELD_LINK_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n2) + ") AND " + FIELD_LANGUAGE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_LINK_ID + " ASC;");
            int n3 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            for (Long l : map.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong(FIELD_LINK_ID);
                if (!hashMap.containsKey(l2) || !map.containsKey(l = Long.valueOf(resultSet.getLong(FIELD_LANGUAGE_ID)))) continue;
                DbLink dbLink = (DbLink)hashMap.get(l2);
                String string = map.get(l);
                DbLink.Translation translation = new DbLink.Translation();
                translation.title = resultSet.getString(FIELD_I18N_TITLE);
                dbLink.translations.put(string, translation);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet2);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    public void removeLinks(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_LINKS) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    public void saveLink(Connection connection, DbLink dbLink, Map<Long, String> map) throws SQLException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block15: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_LINKS) + "(:" + FIELD_LINK_ID + ", :" + FIELD_OBJECT_ID + ", :" + FIELD_LINK_WEB_URL + ", :" + FIELD_LINK_PROVIDER_ID + ", :" + FIELD_LINK_PROVIDER_NAME + ", :" + FIELD_LINK_PUBLISHED + ", :" + FIELD_LINK_POSITION + ");");
                namedCallableStatement.setLong(FIELD_LINK_ID, dbLink.id);
                namedCallableStatement.setLong(FIELD_OBJECT_ID, dbLink.objectId);
                namedCallableStatement.setInt(FIELD_LINK_POSITION, dbLink.position);
                namedCallableStatement.setBoolean(FIELD_LINK_PUBLISHED, dbLink.published);
                if (dbLink.webLinkUrl != null) {
                    namedCallableStatement.setString(FIELD_LINK_WEB_URL, StringUtils.abbreviate((String)dbLink.webLinkUrl.toString(), (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_LINK_WEB_URL, 12);
                }
                if (dbLink.provider != null && dbLink.providerLinkId != null) {
                    namedCallableStatement.setString(FIELD_LINK_PROVIDER_ID, StringUtils.abbreviate((String)dbLink.providerLinkId, (int)255));
                    namedCallableStatement.setString(FIELD_LINK_PROVIDER_NAME, StringUtils.abbreviate((String)dbLink.provider.getXmlName(), (int)255));
                } else {
                    namedCallableStatement.setNull(FIELD_LINK_PROVIDER_ID, 12);
                    namedCallableStatement.setNull(FIELD_LINK_PROVIDER_NAME, 12);
                }
                namedCallableStatement.execute();
                long l2 = l = dbLink.id < 1L ? namedCallableStatement.getLong(FIELD_LINK_ID) : dbLink.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveLinkAdditionally(connection, dbLink, l, arrayList);
                if (dbLink.translations != null && map != null && !map.isEmpty()) {
                    NamedCallableStatement namedCallableStatement2;
                    if (dbLink.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_LINKS_I18N) + "(:" + FIELD_LINK_ID + ", :" + FIELD_LANGUAGE_ID + ");");
                        for (Long object : map.keySet()) {
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_LINK_ID, dbLink.id);
                            namedCallableStatement2.setLong(FIELD_LANGUAGE_ID, object.longValue());
                            namedCallableStatement2.execute();
                            arrayList.add(namedCallableStatement2.getStatement());
                        }
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_LINKS_I18N) + "(:" + FIELD_LINK_ID + ", :" + FIELD_LANGUAGE_ID + ", :" + FIELD_I18N_TITLE + ");");
                    for (Map.Entry entry : map.entrySet()) {
                        DbLink.Translation translation;
                        Long l3 = (Long)entry.getKey();
                        String string = (String)entry.getValue();
                        DbLink.Translation translation2 = translation = dbLink.translations.containsKey(string) ? (DbLink.Translation)dbLink.translations.get(string) : null;
                        if (translation == null) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_LINK_ID, l);
                        namedCallableStatement2.setLong(FIELD_LANGUAGE_ID, l3.longValue());
                        namedCallableStatement2.setString(FIELD_I18N_TITLE, StringUtils.abbreviate((String)translation.title, (int)255));
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbLink.id >= 1L) break block15;
                dbLink.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    protected void saveLinkAdditionally(Connection connection, DbLink dbLink, long l, List<Statement> list) throws SQLException {
    }
}

