/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.db.hsql;

import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.db.DbFile;
import com.openindex.openestate.impl.db.DbFilesHandlerImpl;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSqlDbFilesHandler
extends DbFilesHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbFilesHandler.class);
    public static final String PROC_REMOVE_FILES = "remove_openestate_objects_files";
    public static final String PROC_REMOVE_FILES_I18N = "remove_openestate_objects_files_i18n";
    public static final String PROC_SAVE_FILES = "save_openestate_objects_files";
    public static final String PROC_SAVE_FILES_I18N = "save_openestate_objects_files_i18n";
    public static final String PROC_SET_FILES_CONTENT = "set_openestate_objects_files_content";
    public static final String VIEW_FILES = "view_openestate_objects_files";
    public static final String VIEW_FILES_CONTENT = "view_openestate_objects_files_content";
    public static final String VIEW_FILES_I18N = "view_openestate_objects_files_i18n";
    public static final String VIEW_FILES_PREVIEW = "view_openestate_objects_files_preview";
    public static final String FIELD_FILE_ID = "file_id";
    public static final String FIELD_FILE_NAME = "file_name";
    public static final String FIELD_FILE_URL = "file_url";
    public static final String FIELD_FILE_CONTENT = "file_content";
    public static final String FIELD_FILE_CONTENT_PREVIEW = "file_content_preview";
    public static final String FIELD_FILE_HASH = "file_hash";
    public static final String FIELD_FILE_MIMETYPE = "file_mimetype";
    public static final String FIELD_FILE_PUBLISHED = "file_published";
    public static final String FIELD_FILE_TYPE = "file_type";
    public static final String FIELD_FILE_SIZE = "file_size";
    public static final String FIELD_FILE_IMAGE_WIDTH = "file_image_width";
    public static final String FIELD_FILE_IMAGE_HEIGHT = "file_image_height";
    public static final String FIELD_FILE_POSITION = "file_position";
    public static final String FIELD_I18N_TITLE = "i18n_title";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";
    private static final String FIELD_OBJECT_ID = "object_id";
    private static final String FIELD_LANGUAGE_ID = "language_id";

    public HSqlDbFilesHandler() {
    }

    public HSqlDbFilesHandler(String string) {
        super(string);
    }

    protected DbFile buildFile(ResultSet resultSet) throws SQLException {
        DbFile dbFile = this.createFile();
        dbFile.id = resultSet.getLong(FIELD_FILE_ID);
        dbFile.objectId = resultSet.getLong(FIELD_OBJECT_ID);
        dbFile.size = resultSet.getLong(FIELD_FILE_SIZE);
        dbFile.imageWidth = resultSet.getInt(FIELD_FILE_IMAGE_WIDTH);
        dbFile.imageHeight = resultSet.getInt(FIELD_FILE_IMAGE_HEIGHT);
        dbFile.hash = resultSet.getString(FIELD_FILE_HASH);
        dbFile.mimeType = resultSet.getString(FIELD_FILE_MIMETYPE);
        dbFile.name = resultSet.getString(FIELD_FILE_NAME);
        dbFile.position = resultSet.getInt(FIELD_FILE_POSITION);
        dbFile.published = resultSet.getBoolean(FIELD_FILE_PUBLISHED);
        dbFile.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbFile.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        String string = resultSet.getString(FIELD_FILE_TYPE);
        try {
            dbFile.type = string != null ? EstateAttachmentType.valueOf((String)string) : null;
        }
        catch (Exception exception) {
            dbFile.type = null;
            LOGGER.warn("Can't read attachment type: " + string + " for file #" + dbFile.id + "!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        try {
            String string2 = StringUtils.trimToNull((String)resultSet.getString(FIELD_FILE_URL));
            if (string2 != null) {
                dbFile.url = new URI(string2);
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            dbFile.url = null;
            LOGGER.warn("The provided URL is invalid for file #" + dbFile.id);
            LOGGER.warn("> " + uRISyntaxException.getLocalizedMessage(), (Throwable)uRISyntaxException);
        }
        return dbFile;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadContent(Connection connection, long l, OutputStream outputStream) throws SQLException, IOException {
        boolean bl;
        Blob blob;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block17: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement("SELECT file_content FROM " + this.getSchemaPath(VIEW_FILES_CONTENT) + " WHERE " + FIELD_FILE_ID + " = ? LIMIT 1;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new IOException("Can't find requested file #" + l + "!");
            }
            blob = resultSet.getBlob(FIELD_FILE_CONTENT);
            if (blob != null) break block17;
            boolean bl2 = false;
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(resultSet);
                    JdbcUtils.closeQuietly(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return bl2;
        }
        InputStream inputStream = blob.getBinaryStream();
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
            bl = true;
            JdbcUtils.closeQuietly((ResultSet)resultSet);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return bl;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean downloadPreview(Connection connection, long l, OutputStream outputStream) throws SQLException, IOException {
        boolean bl;
        Blob blob;
        ResultSet resultSet;
        PreparedStatement preparedStatement;
        block17: {
            preparedStatement = null;
            resultSet = null;
            preparedStatement = connection.prepareStatement("SELECT file_content_preview FROM " + this.getSchemaPath(VIEW_FILES_PREVIEW) + " WHERE " + FIELD_FILE_ID + " = ? LIMIT 1;");
            preparedStatement.setLong(1, l);
            resultSet = preparedStatement.executeQuery();
            if (!resultSet.next()) {
                throw new IOException("Can't find requested file #" + l + "!");
            }
            blob = resultSet.getBlob(FIELD_FILE_CONTENT_PREVIEW);
            if (blob != null) break block17;
            boolean bl2 = false;
            {
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(resultSet);
                    JdbcUtils.closeQuietly(preparedStatement);
                    throw throwable;
                }
            }
            JdbcUtils.closeQuietly((ResultSet)resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            return bl2;
        }
        InputStream inputStream = blob.getBinaryStream();
        Throwable throwable = null;
        try {
            IOUtils.copy((InputStream)inputStream, (OutputStream)outputStream);
            outputStream.flush();
            bl = true;
            JdbcUtils.closeQuietly((ResultSet)resultSet);
        }
        catch (Throwable throwable2) {
            try {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream != null) {
                    if (throwable != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        inputStream.close();
                    }
                }
            }
        }
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbFile[] getFiles(Connection connection, long[] lArray) throws SQLException {
        DbFile[] dbFileArray;
        if (lArray != null && lArray.length <= 0) {
            return new DbFile[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES) + " ORDER BY " + FIELD_FILE_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES) + " WHERE " + FIELD_FILE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY " + FIELD_FILE_ID + " ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbFile> arrayList = new ArrayList<DbFile>();
            while (resultSet.next()) {
                arrayList.add(this.buildFile(resultSet));
            }
            dbFileArray = arrayList.toArray(new DbFile[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DbFile[] getFiles(Connection connection, String[] stringArray) throws SQLException {
        DbFile[] dbFileArray;
        if (stringArray != null && stringArray.length <= 0) {
            return new DbFile[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (stringArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES) + " ORDER BY " + FIELD_FILE_ID + " ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES) + " WHERE " + FIELD_FILE_HASH + " IN (" + JdbcUtils.writeQuestionMarkList((int)stringArray.length) + ") ORDER BY " + FIELD_FILE_ID + " ASC LIMIT " + stringArray.length + ";");
                for (int i = 0; i < stringArray.length; ++i) {
                    preparedStatement.setString(i + 1, stringArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbFile> arrayList = new ArrayList<DbFile>();
            while (resultSet.next()) {
                arrayList.add(this.buildFile(resultSet));
            }
            dbFileArray = arrayList.toArray(new DbFile[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressFBWarnings(value={"SQL_PREPARED_STATEMENT_GENERATED_FROM_NONCONSTANT_STRING"}, justification="The non-constant string is properly escaped.")
    public DbFile[] getFiles(Connection connection, long l, Boolean bl, String string) throws SQLException {
        DbFile[] dbFileArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l > 0L) {
                arrayList.add("object_id = ?");
            }
            if (bl != null) {
                arrayList.add("file_published = ?");
            }
            if (string != null) {
                arrayList.add("file_mimetype LIKE ?");
            }
            String string2 = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES) + " " + string2 + " ORDER BY " + FIELD_FILE_POSITION + " ASC, " + FIELD_FILE_ID + " ASC;");
            int n = 0;
            if (l > 0L) {
                preparedStatement.setLong(++n, l);
            }
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (string != null) {
                preparedStatement.setString(++n, string);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbFile> arrayList2 = new ArrayList<DbFile>();
            while (resultSet.next()) {
                arrayList2.add(this.buildFile(resultSet));
            }
            dbFileArray = arrayList2.toArray(new DbFile[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbFileArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getFileIds(Connection connection, long l, Boolean bl, String string) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            if (l > 0L) {
                arrayList.add("object_id = ?");
            }
            if (bl != null) {
                arrayList.add("file_published = ?");
            }
            if (string != null) {
                arrayList.add("file_mimetype LIKE ?");
            }
            String string2 = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)") AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT file_id FROM " + this.getSchemaPath(VIEW_FILES) + " " + string2 + " ORDER BY " + FIELD_FILE_ID + " ASC;");
            int n = 0;
            if (l > 0L) {
                preparedStatement.setLong(++n, l);
            }
            if (bl != null) {
                preparedStatement.setBoolean(++n, bl);
            }
            if (string != null) {
                preparedStatement.setString(++n, string);
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getLong(FIELD_FILE_ID));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadFileTranslations(Connection connection, DbFile[] dbFileArray, Map<Long, String> map) throws SQLException {
        ResultSet resultSet;
        HashMap<Long, DbFile> hashMap = new HashMap<Long, DbFile>();
        for (DbFile object2 : dbFileArray) {
            if (object2.id <= 0L || hashMap.containsKey(object2.id)) continue;
            hashMap.put(object2.id, object2);
            if (object2.translations == null) {
                object2.translations = new HashMap();
                continue;
            }
            object2.translations.clear();
        }
        int n = map.size();
        int n2 = hashMap.size();
        if (n2 < 1 || n < 1) {
            return;
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet2 = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT * FROM " + this.getSchemaPath(VIEW_FILES_I18N) + " WHERE " + FIELD_FILE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n2) + ") AND " + FIELD_LANGUAGE_ID + " IN (" + JdbcUtils.writeQuestionMarkList((int)n) + ") ORDER BY " + FIELD_FILE_ID + " ASC;");
            int n3 = 0;
            for (Long l : hashMap.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            for (Long l : map.keySet()) {
                preparedStatement.setLong(++n3, l);
            }
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                Long l;
                Long l2 = resultSet.getLong(FIELD_FILE_ID);
                if (!hashMap.containsKey(l2) || !map.containsKey(l = Long.valueOf(resultSet.getLong(FIELD_LANGUAGE_ID)))) continue;
                DbFile dbFile = (DbFile)hashMap.get(l2);
                String string = map.get(l);
                DbFile.Translation translation = new DbFile.Translation();
                translation.title = resultSet.getString(FIELD_I18N_TITLE);
                dbFile.translations.put(string, translation);
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet2);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
    }

    public void removeFiles(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL " + this.getSchemaPath(PROC_REMOVE_FILES) + "(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public void saveFile(Connection connection, DbFile dbFile, File file, File file2, Map<Long, String> map) throws SQLException, IOException {
        ArrayList<Statement> arrayList;
        NamedCallableStatement namedCallableStatement;
        boolean bl;
        block42: {
            bl = connection.getAutoCommit();
            namedCallableStatement = null;
            arrayList = new ArrayList<Statement>();
            try {
                long l;
                connection.setAutoCommit(false);
                namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_FILES) + "(:" + FIELD_FILE_ID + ", :" + FIELD_OBJECT_ID + ", :" + FIELD_FILE_NAME + ", :" + FIELD_FILE_URL + ", :" + FIELD_FILE_CONTENT + ", :" + FIELD_FILE_CONTENT_PREVIEW + ", :" + FIELD_FILE_MIMETYPE + ", :" + FIELD_FILE_PUBLISHED + ", :" + FIELD_FILE_TYPE + ", :" + FIELD_FILE_SIZE + ", :" + FIELD_FILE_HASH + ", :" + FIELD_FILE_IMAGE_WIDTH + ", :" + FIELD_FILE_IMAGE_HEIGHT + ", :" + FIELD_FILE_POSITION + ");");
                namedCallableStatement.setLong(FIELD_FILE_ID, dbFile.id);
                namedCallableStatement.setLong(FIELD_OBJECT_ID, dbFile.objectId);
                namedCallableStatement.setInt(FIELD_FILE_IMAGE_WIDTH, dbFile.imageWidth);
                namedCallableStatement.setInt(FIELD_FILE_IMAGE_HEIGHT, dbFile.imageHeight);
                namedCallableStatement.setInt(FIELD_FILE_POSITION, dbFile.position);
                namedCallableStatement.setBoolean(FIELD_FILE_PUBLISHED, dbFile.published);
                namedCallableStatement.setString(FIELD_FILE_NAME, StringUtils.abbreviate((String)dbFile.name, (int)255));
                namedCallableStatement.setString(FIELD_FILE_MIMETYPE, StringUtils.abbreviate((String)dbFile.mimeType, (int)255));
                namedCallableStatement.setString(FIELD_FILE_TYPE, dbFile.type != null ? StringUtils.abbreviate((String)dbFile.type.name(), (int)100) : null);
                namedCallableStatement.setString(FIELD_FILE_URL, dbFile.url != null ? StringUtils.abbreviate((String)dbFile.url.toString(), (int)255) : null);
                Object object = null;
                InputStream autoCloseable = null;
                try {
                    if (file != null && file.isFile()) {
                        object = new FileInputStream(file);
                        namedCallableStatement.setBinaryStream(FIELD_FILE_CONTENT, (InputStream)object, (int)file.length());
                        namedCallableStatement.setLong(FIELD_FILE_SIZE, file.length());
                        try (FileInputStream fileInputStream = new FileInputStream(file);){
                            namedCallableStatement.setString(FIELD_FILE_HASH, DigestUtils.sha1Hex((InputStream)fileInputStream));
                        }
                    } else {
                        namedCallableStatement.setNull(FIELD_FILE_CONTENT, 2004);
                        namedCallableStatement.setLong(FIELD_FILE_SIZE, dbFile.size);
                        namedCallableStatement.setString(FIELD_FILE_HASH, StringUtils.trimToNull((String)dbFile.hash));
                    }
                    if (file2 != null && file2.isFile()) {
                        FileInputStream fileInputStream = new FileInputStream(file2);
                        namedCallableStatement.setBinaryStream(FIELD_FILE_CONTENT_PREVIEW, (InputStream)fileInputStream, (int)file2.length());
                    } else {
                        namedCallableStatement.setNull(FIELD_FILE_CONTENT_PREVIEW, 2004);
                    }
                    namedCallableStatement.execute();
                }
                catch (Throwable throwable) {
                    try {
                        if (object != null) {
                            ((InputStream)object).close();
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    try {
                        if (autoCloseable != null) {
                            autoCloseable.close();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    throw throwable;
                }
                try {
                    if (object != null) {
                        ((InputStream)object).close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    void var10_13;
                    if (var10_13 != null) {
                        var10_13.close();
                    }
                }
                catch (Exception exception) {}
                long l2 = l = dbFile.id < 1L ? namedCallableStatement.getLong(FIELD_FILE_ID) : dbFile.id;
                if (l < 1L) {
                    throw new SQLException("Can't determine ID of the saved object!");
                }
                this.saveFileAdditionally(connection, dbFile, l, arrayList);
                if (dbFile.translations != null && map != null && !map.isEmpty()) {
                    NamedCallableStatement namedCallableStatement2;
                    if (dbFile.id > 0L) {
                        namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_REMOVE_FILES_I18N) + "(:" + FIELD_FILE_ID + ", :" + FIELD_LANGUAGE_ID + ");");
                        for (Long l3 : map.keySet()) {
                            namedCallableStatement2.clearParameters();
                            namedCallableStatement2.setLong(FIELD_FILE_ID, dbFile.id);
                            namedCallableStatement2.setLong(FIELD_LANGUAGE_ID, l3.longValue());
                            namedCallableStatement2.execute();
                            arrayList.add(namedCallableStatement2.getStatement());
                        }
                    }
                    namedCallableStatement2 = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SAVE_FILES_I18N) + "(:" + FIELD_FILE_ID + ", :" + FIELD_LANGUAGE_ID + ", :" + FIELD_I18N_TITLE + ");");
                    for (Map.Entry entry : map.entrySet()) {
                        DbFile.Translation translation;
                        Long l4 = (Long)entry.getKey();
                        String string = (String)entry.getValue();
                        DbFile.Translation translation2 = translation = dbFile.translations.containsKey(string) ? (DbFile.Translation)dbFile.translations.get(string) : null;
                        if (translation == null) continue;
                        namedCallableStatement2.clearParameters();
                        namedCallableStatement2.setLong(FIELD_FILE_ID, l);
                        namedCallableStatement2.setLong(FIELD_LANGUAGE_ID, l4.longValue());
                        namedCallableStatement2.setString(FIELD_I18N_TITLE, StringUtils.abbreviate((String)translation.title, (int)255));
                        namedCallableStatement2.execute();
                        arrayList.add(namedCallableStatement2.getStatement());
                    }
                }
                connection.commit();
                if (dbFile.id >= 1L) break block42;
                dbFile.id = l;
            }
            catch (SQLException sQLException) {
                try {
                    connection.rollback();
                    throw sQLException;
                }
                catch (Throwable throwable) {
                    JdbcUtils.closeQuietly(namedCallableStatement);
                    for (Statement statement : arrayList) {
                        JdbcUtils.closeQuietly((Statement)statement);
                    }
                    connection.setAutoCommit(bl);
                    throw throwable;
                }
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        for (Statement statement : arrayList) {
            JdbcUtils.closeQuietly((Statement)statement);
        }
        connection.setAutoCommit(bl);
    }

    protected void saveFileAdditionally(Connection connection, DbFile dbFile, long l, List<Statement> list) throws SQLException {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setFileContent(Connection connection, long l, File file, File file2) throws SQLException, IOException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        InputStream inputStream = null;
        InputStream inputStream2 = null;
        try {
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL " + this.getSchemaPath(PROC_SET_FILES_CONTENT) + "(:" + FIELD_FILE_ID + ", :" + FIELD_FILE_SIZE + ", :" + FIELD_FILE_HASH + ", :" + FIELD_FILE_CONTENT + ", :" + FIELD_FILE_CONTENT_PREVIEW + ");");
            namedCallableStatement.setLong(FIELD_FILE_ID, l);
            if (file != null && file.isFile()) {
                inputStream = new FileInputStream(file);
                namedCallableStatement.setBinaryStream(FIELD_FILE_CONTENT, inputStream, (int)file.length());
                namedCallableStatement.setLong(FIELD_FILE_SIZE, file.length());
                try (FileInputStream fileInputStream = new FileInputStream(file);){
                    namedCallableStatement.setString(FIELD_FILE_HASH, DigestUtils.sha1Hex((InputStream)fileInputStream));
                }
            } else {
                namedCallableStatement.setNull(FIELD_FILE_HASH, 12);
                namedCallableStatement.setNull(FIELD_FILE_CONTENT, 2004);
                namedCallableStatement.setNull(FIELD_FILE_SIZE, -5);
            }
            if (file2 != null && file2.isFile()) {
                inputStream2 = new FileInputStream(file2);
                namedCallableStatement.setBinaryStream(FIELD_FILE_CONTENT_PREVIEW, inputStream2, (int)file2.length());
            } else {
                namedCallableStatement.setNull(FIELD_FILE_CONTENT_PREVIEW, 2004);
            }
            namedCallableStatement.execute();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        try {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (inputStream2 != null) {
                inputStream2.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

