/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.factories.Paddings;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestOfferPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestTable;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestOffer;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.addons.contacts.gui.InterestOfferStatusRenderer;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractPanel;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DateRenderer;
import com.openindex.openestate.tool.gui.DefaultEditorPane;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import javax.swing.ListCellRenderer;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class AgencyEstateViewInterestsPanel
extends AgencyEstateViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewInterestsPanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewInterestsPanel.class);
    private static final String ASSIGNMENT_TABLE_ID = "AgencyEstateViewInterestsPanel.AssignmentTable";
    private static final String MATCHING_TABLE_ID = "AgencyEstateViewInterestsPanel.MatchingTable";
    private DbAgencyObject currentAgencyObject = null;
    private int matchingInterestsCount = 0;
    private final List<Long> matchingInterestIds = new ArrayList<Long>();
    private final Map<Long, DbAgencyInterestOffer> removedOffers = new HashMap<Long, DbAgencyInterestOffer>();
    private JSplitPane splitPane;
    private AssignmentPanel assignmentPanel;
    private MatchingPanel matchingPanel;

    public AgencyEstateViewInterestsPanel() {
        this.build();
    }

    private void build() {
        this.assignmentPanel = new AssignmentPanel();
        this.matchingPanel = new MatchingPanel();
        this.splitPane = new JSplitPane(0);
        this.splitPane.setTopComponent((Component)((Object)this.matchingPanel));
        this.splitPane.setBottomComponent((Component)((Object)this.assignmentPanel));
        this.splitPane.setBorder(Paddings.EMPTY);
        this.splitPane.setDividerLocation(200);
        this.setBorder(Paddings.EMPTY);
        this.setLayout(new BorderLayout(5, 5));
        this.add(this.splitPane, "Center");
    }

    private void doAssign(DbAgencyInterestOffer.Status status) {
        DbAgencyInterestOffer dbAgencyInterestOffer;
        if (this.matchingPanel.table.getSelectedRowCount() < 1) {
            return;
        }
        int n = this.matchingPanel.table.getSelectedRow();
        int n2 = this.matchingPanel.table.convertRowIndexToModel(n);
        Long l = this.matchingPanel.table.getInterestIdAt(n2);
        DbAgencyInterestOffer dbAgencyInterestOffer2 = dbAgencyInterestOffer = this.removedOffers.containsKey(l) ? this.removedOffers.get(l) : null;
        if (dbAgencyInterestOffer == null) {
            dbAgencyInterestOffer = new DbAgencyInterestOffer();
            dbAgencyInterestOffer.agencyObjectId = this.currentAgencyObject != null ? this.currentAgencyObject.id : 0L;
            dbAgencyInterestOffer.interestId = l;
            dbAgencyInterestOffer.notes = null;
            dbAgencyInterestOffer.time = new Date();
        }
        dbAgencyInterestOffer.status = status != null ? status : DbAgencyInterestOffer.Status.OPEN;
        AgencyEstateViewInterestsPanel.moveAgencyObjectTableSelection((AbstractTable)this.matchingPanel.table, (AbstractTable)this.assignmentPanel.table, dbAgencyInterestOffer);
        this.matchingPanel.updateLocalization();
        this.assignmentPanel.updateLocalization();
        if (this.matchingInterestIds.contains(l)) {
            this.setMatchingInterestsCount(this.matchingInterestsCount - 1);
        }
    }

    public void doLoadInBackground(Connection connection) throws Exception {
        this.doLoadInBackground(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doLoadInBackground(Connection connection, boolean bl) throws Exception {
        DbAgencyObject.Status status;
        if (this.currentAgencyObject == null || this.currentAgencyObject.id < 1L) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        if (!bl) {
            for (int i = 0; i < this.assignmentPanel.table.getRowCount(); ++i) {
                arrayList.add(this.assignmentPanel.table.getInterestIdAt(i));
            }
        }
        if (bl) {
            this.assignmentPanel.table.clearSelection();
            this.assignmentPanel.table.clearRows();
        }
        this.matchingPanel.table.clearSelection();
        this.matchingPanel.table.clearRows();
        this.matchingInterestIds.clear();
        this.updateButtons(false);
        DbAgencyObject dbAgencyObject = null;
        int n = 0;
        try {
            boolean bl2 = this.matchingPanel.allInterestsField.isSelected();
            DbAgencyInterest.Status status2 = (DbAgencyInterest.Status)((Object)this.matchingPanel.statusField.getSelectedItem());
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            dbAgencyObject = new DbAgencyObject();
            dbAgencyObject.id = this.currentAgencyObject != null ? this.currentAgencyObject.id : 0L;
            try {
                this.getViewPanel().initEstate(dbAgencyObject);
            }
            catch (Exception exception) {
                LOGGER.error("Can't load current estate parameters!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                if (bl) {
                    this.assignmentPanel.table.clearSelection();
                }
                this.matchingPanel.table.clearSelection();
                this.updateButtons(true);
                this.matchingPanel.updateLocalization();
                this.assignmentPanel.updateLocalization();
                return;
            }
            HashMap<Long, DbAgencyInterest> hashMap = new HashMap<Long, DbAgencyInterest>();
            HashMap<Long, String> hashMap2 = new HashMap<Long, String>();
            if (bl && dbAgencyObject.id > 0L) {
                for (DbAgencyInterest dbAgencyInterestArray2 : dbAgencyInterestsHandler.getInterestsForEstate(connection, dbAgencyObject.id)) {
                    hashMap.put(dbAgencyInterestArray2.id, dbAgencyInterestArray2);
                }
            }
            for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestsHandler.getInterests(connection, status2)) {
                if (hashMap.containsKey(dbAgencyInterest.id)) continue;
                hashMap.put(dbAgencyInterest.id, dbAgencyInterest);
            }
            for (DbAgencyInterest dbAgencyInterest : dbContactsHandler.getGroups(connection)) {
                hashMap2.put(((DbContactsGroup)dbAgencyInterest).id, ((DbContactsGroup)dbAgencyInterest).name);
            }
            DbAgencyInterest[] dbAgencyInterestArray3 = hashMap.values().toArray(new DbAgencyInterest[0]);
            dbAgencyInterestsHandler.loadInterestOffers(connection, dbAgencyInterestArray3);
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            ArrayList<Long> arrayList3 = new ArrayList<Long>();
            for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestArray3) {
                if (!bl && arrayList.contains(dbAgencyInterest.id)) continue;
                arrayList2.add(dbAgencyInterest.contactsEntryId);
                arrayList3.add(dbAgencyInterest.agencySearchId);
            }
            DbContactsEntry[] dbContactsEntryArray = dbContactsHandler.getEntries(connection, ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0])));
            dbContactsHandler.loadEntrySettings(connection, dbContactsEntryArray);
            HashMap<Long, DbContactsEntry> hashMap3 = new HashMap<Long, DbContactsEntry>();
            for (DbContactsEntry dbContactsEntry : dbContactsEntryArray) {
                hashMap3.put(dbContactsEntry.id, dbContactsEntry);
            }
            DbContactsEntry[] dbContactsEntryArray2 = dbAgencySearchesHandler.getSearches(connection, ArrayUtils.toPrimitive((Long[])arrayList3.toArray(new Long[0])));
            dbAgencySearchesHandler.loadAttribConditions(connection, (DbSearch[])dbContactsEntryArray2);
            dbAgencySearchesHandler.loadValueConditions(connection, (DbSearch[])dbContactsEntryArray2);
            HashMap<Long, DbAgencySearch> hashMap4 = new HashMap<Long, DbAgencySearch>();
            for (DbContactsEntry dbContactsEntry : dbContactsEntryArray2) {
                hashMap4.put(dbContactsEntry.id, (DbAgencySearch)dbContactsEntry);
            }
            for (DbContactsEntry dbContactsEntry : dbAgencyInterestArray3) {
                boolean bl3;
                String string;
                DbContactsEntry dbContactsEntry2;
                DbAgencySearch dbAgencySearch;
                if (!bl && arrayList.contains(dbContactsEntry.id)) continue;
                boolean bl4 = dbContactsEntry.offers.containsKey(dbAgencyObject.id);
                if (bl && bl4) {
                    dbAgencySearch = hashMap4.containsKey(dbContactsEntry.agencySearchId) ? (DbAgencySearch)hashMap4.get(dbContactsEntry.agencySearchId) : null;
                    dbContactsEntry2 = hashMap3.containsKey(dbContactsEntry.contactsEntryId) ? (DbContactsEntry)hashMap3.get(dbContactsEntry.contactsEntryId) : null;
                    string = dbContactsEntry2 != null && hashMap2.containsKey(dbContactsEntry2.groupId) ? (String)hashMap2.get(dbContactsEntry2.groupId) : null;
                    this.assignmentPanel.table.addRow((AbstractTable.Row)new AssignmentTableRow(dbContactsEntry2, string, (DbAgencyInterest)dbContactsEntry, dbAgencySearch, dbContactsEntry.offers.get(dbAgencyObject.id)));
                    this.matchingInterestIds.add(dbContactsEntry.id);
                    continue;
                }
                if (bl4) continue;
                dbAgencySearch = hashMap4.containsKey(dbContactsEntry.agencySearchId) ? (DbAgencySearch)hashMap4.get(dbContactsEntry.agencySearchId) : null;
                dbContactsEntry2 = hashMap3.containsKey(dbContactsEntry.contactsEntryId) ? (DbContactsEntry)hashMap3.get(dbContactsEntry.contactsEntryId) : null;
                string = dbContactsEntry2 != null && hashMap2.containsKey(dbContactsEntry2.groupId) ? (String)hashMap2.get(dbContactsEntry2.groupId) : null;
                boolean bl5 = bl3 = dbAgencySearch != null && dbAgencySearch.isMatching(dbAgencyObject);
                if (!bl2 && !bl3) continue;
                if (bl3) {
                    ++n;
                    this.matchingInterestIds.add(dbContactsEntry.id);
                }
                this.matchingPanel.table.addRow((AbstractTable.Row)new AgencyInterestTable.Row(dbContactsEntry2, string, (DbAgencyInterest)dbContactsEntry, dbAgencySearch));
            }
        }
        finally {
            if (bl) {
                this.assignmentPanel.table.clearSelection();
            }
            this.matchingPanel.table.clearSelection();
            this.updateButtons(true);
            this.matchingPanel.updateLocalization();
            this.assignmentPanel.updateLocalization();
        }
        DbAgencyObject.Status status2 = status = dbAgencyObject != null ? dbAgencyObject.status : null;
        if (n < 1 && (status == null || DbAgencyObject.Status.BROKERED.equals((Object)status) || DbAgencyObject.Status.NOT_BROKERED.equals((Object)status))) {
            this.setMatchingInterestsCount(0);
            this.matchingInterestIds.clear();
        } else {
            this.setMatchingInterestsCount(n);
        }
    }

    private void doRefresh(boolean bl) {
        ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask(bl));
    }

    private void doRemove() {
        AssignmentTable assignmentTable = this.assignmentPanel.table;
        if (assignmentTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = assignmentTable.convertRowIndexToModel(assignmentTable.getSelectedRow());
        DbAgencyInterestOffer dbAgencyInterestOffer = new DbAgencyInterestOffer();
        dbAgencyInterestOffer.agencyObjectId = this.currentAgencyObject != null ? this.currentAgencyObject.id : 0L;
        dbAgencyInterestOffer.interestId = assignmentTable.getInterestIdAt(n);
        dbAgencyInterestOffer.notes = assignmentTable.getNotesAt(n);
        dbAgencyInterestOffer.status = assignmentTable.getStatusAt(n);
        dbAgencyInterestOffer.time = assignmentTable.getTimeAt(n);
        this.removedOffers.put(dbAgencyInterestOffer.interestId, dbAgencyInterestOffer);
        AgencyEstateViewInterestsPanel.moveAgencyObjectTableSelection((AbstractTable)assignmentTable, (AbstractTable)this.matchingPanel.table, dbAgencyInterestOffer);
        this.matchingPanel.updateLocalization();
        this.assignmentPanel.updateLocalization();
        this.assignmentPanel.offerForm.unselectRelation();
        if (this.matchingInterestIds.contains(dbAgencyInterestOffer.interestId)) {
            this.setMatchingInterestsCount(this.matchingInterestsCount + 1);
        }
    }

    private void doShowAssignmentActions(Component component, int n, int n2) {
        AssignmentTable assignmentTable = this.assignmentPanel.table;
        if (assignmentTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new ViewAssignmentInterestAction()));
        jPopupMenu.addSeparator();
        jPopupMenu.add((Action)((Object)new RemoveAction()));
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.setIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
        jMenu.add((Action)((Object)new ViewAssignmentEntryAction()));
        Object[] objectArray = assignmentTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Long[] longArray = null;
            if (longArray == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = assignmentTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = assignmentTable.convertRowIndexToModel(n4);
                    arrayList.add(assignmentTable.getContactEntryIdAt(n5));
                }
                longArray = arrayList.toArray(new Long[0]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    objectArray2 = object.createActionMenuItems(immoToolProject, longArray, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.show(component, n, n2);
    }

    /*
     * WARNING - void declaration
     */
    private void doShowMatchingActions(Component component, int n, int n2) {
        MatchingTable matchingTable = this.matchingPanel.table;
        if (matchingTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new ViewMatchingInterestAction()));
        JMenu jMenu = new JMenu();
        jMenu.setText(StringUtils.capitalize((String)I18N.tr("assign search mandate")));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
        for (DbAgencyInterestOffer.Status longArray : DbAgencyInterestOffer.Status.values()) {
            jMenu.add((Action)((Object)new AssignAction(longArray)));
        }
        jPopupMenu.add(jMenu);
        jPopupMenu.addSeparator();
        JMenu jMenu2 = new JMenu();
        jMenu2.setText(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu2.setIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
        jMenu2.add((Action)((Object)new ViewAssignmentEntryAction()));
        Object[] objectArray = matchingTable.getAddons();
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            Object var10_13 = null;
            if (var10_13 == null) {
                ArrayList arrayList = new ArrayList();
                int[] nArray = matchingTable.getSelectedRows();
                int n3 = nArray.length;
                for (int i = 0; i < n3; ++i) {
                    int n4 = nArray[i];
                    int n5 = matchingTable.convertRowIndexToModel(n4);
                    arrayList.add(matchingTable.getContactEntryIdAt(n5));
                }
                Long[] longArray = arrayList.toArray(new Long[0]);
            }
            for (Object object : objectArray) {
                Object[] objectArray2;
                try {
                    void var10_15;
                    objectArray2 = object.createActionMenuItems(immoToolProject, (Long[])var10_15, (JComponent)((Object)this));
                }
                catch (Exception exception) {
                    LOGGER.error("Can't load popup extension!");
                    LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
                    continue;
                }
                if (ArrayUtils.isEmpty((Object[])objectArray2)) continue;
                for (Object object2 : objectArray2) {
                    jMenu2.add((JMenuItem)object2);
                }
            }
        }
        jPopupMenu.add(jMenu2);
        jPopupMenu.show(component, n, n2);
    }

    private void doViewAssignmentEntry() {
        AssignmentTable assignmentTable = this.assignmentPanel.table;
        if (assignmentTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = assignmentTable.convertRowIndexToModel(assignmentTable.getSelectedRow());
        Long l = assignmentTable.getContactEntryIdAt(n);
        new ContactsPlugin.EntryFormAction(l.longValue()).actionPerformed(null);
    }

    private void doViewAssignmentInterest() {
        AssignmentTable assignmentTable = this.assignmentPanel.table;
        if (assignmentTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = assignmentTable.convertRowIndexToModel(assignmentTable.getSelectedRow());
        Long l = assignmentTable.getInterestIdAt(n);
        new AgencyContactsUtils.InterestFormAction(l).actionPerformed(null);
    }

    private void doViewMatchingEntry() {
        MatchingTable matchingTable = this.matchingPanel.table;
        if (matchingTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = matchingTable.convertRowIndexToModel(matchingTable.getSelectedRow());
        Long l = matchingTable.getContactEntryIdAt(n);
        new ContactsPlugin.EntryFormAction(l.longValue()).actionPerformed(null);
    }

    private void doViewMatchingInterest() {
        MatchingTable matchingTable = this.matchingPanel.table;
        if (matchingTable.getSelectedRowCount() < 1) {
            return;
        }
        int n = matchingTable.convertRowIndexToModel(matchingTable.getSelectedRow());
        Long l = matchingTable.getInterestIdAt(n);
        new AgencyContactsUtils.InterestFormAction(l).actionPerformed(null);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("search mandates"));
    }

    public boolean isLoadedInBackground() {
        return true;
    }

    public void load(DbAgencyObject dbAgencyObject) {
        this.removedOffers.clear();
        this.matchingInterestIds.clear();
        this.setMatchingInterestsCount(0);
        this.currentAgencyObject = dbAgencyObject;
        this.matchingPanel.allInterestsField.setSelected(false);
        this.matchingPanel.statusField.setSelectedItem((Object)DbAgencyInterest.Status.PROCESSING);
        this.assignmentPanel.offerForm.unselectRelation();
    }

    private static void moveAgencyObjectTableSelection(AbstractTable abstractTable, AbstractTable abstractTable2, DbAgencyInterestOffer dbAgencyInterestOffer) {
        if (abstractTable.getSelectedRowCount() < 1) {
            return;
        }
        abstractTable.setEnabled(false);
        ArrayList<AgencyInterestTable.Row> arrayList = new ArrayList<AgencyInterestTable.Row>();
        for (int n : abstractTable.getSelectedRows()) {
            int n2 = abstractTable.convertRowIndexToModel(n);
            AgencyInterestTable.Row row = (AgencyInterestTable.Row)abstractTable.getRow(n2);
            if (abstractTable2 instanceof AssignmentTable) {
                abstractTable2.addRow((AbstractTable.Row)new AssignmentTableRow(row.getEntry(), row.getGroupName(), row.getInterest(), row.getSearch(), dbAgencyInterestOffer));
                arrayList.add(row);
                continue;
            }
            if (!(abstractTable2 instanceof MatchingTable)) continue;
            abstractTable2.addRow((AbstractTable.Row)new AgencyInterestTable.Row(row.getEntry(), row.getGroupName(), row.getInterest(), row.getSearch()));
            arrayList.add(row);
        }
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            AgencyInterestTable.Row row = (AgencyInterestTable.Row)((Object)object.next());
            abstractTable.removeRow((AbstractTable.Row)row);
        }
        abstractTable.setEnabled(true);
        abstractTable.clearSelection();
    }

    public void save(DbAgencyObject dbAgencyObject) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbAgencyObject dbAgencyObject) throws SQLException {
        DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbAgencyInterestsHandler.getInterestsForEstate(connection, dbAgencyObject.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            dbAgencyInterestsHandler.loadInterestOffers(connection, (DbAgencyInterest[])objectArray);
            for (Object object : objectArray) {
                hashMap.put(((DbAgencyInterest)object).id, object);
            }
        }
        Object[] objectArray2 = new ArrayList();
        for (int i = 0; i < this.assignmentPanel.table.getRowCount(); ++i) {
            Object object;
            Long l = this.assignmentPanel.table.getInterestIdAt(i);
            object = hashMap.containsKey(l) ? (DbAgencyInterest)hashMap.get(l) : null;
            DbAgencyInterestOffer serializable = object != null && ((DbAgencyInterest)object).offers.containsKey(dbAgencyObject.id) ? ((DbAgencyInterest)object).offers.get(dbAgencyObject.id) : new DbAgencyInterestOffer();
            serializable.interestId = l;
            serializable.agencyObjectId = dbAgencyObject.id;
            serializable.time = this.assignmentPanel.table.getTimeAt(i);
            serializable.status = this.assignmentPanel.table.getStatusAt(i);
            serializable.notes = this.assignmentPanel.table.getNotesAt(i);
            dbAgencyInterestsHandler.saveInterestOffer(connection, serializable);
            objectArray2.add(l);
        }
        for (Long l : hashMap.keySet().toArray(new Long[0])) {
            if (objectArray2.contains(l)) continue;
            dbAgencyInterestsHandler.removeInterestOffer(connection, l, dbAgencyObject.id);
        }
    }

    private void setMatchingInterestsCount(int n) {
        this.matchingInterestsCount = n;
        if (n < 1) {
            this.getViewPanel().setInfoMessage((String)null);
        } else {
            String string = I18N.trn("{0} matching search mandate was found, that is not assigned to the property.", "{0} matching search mandates were found, that are not assigned to the property.", (long)n, (Object)n);
            DefaultEditorPane defaultEditorPane = new DefaultEditorPane();
            defaultEditorPane.setOpaque(false);
            defaultEditorPane.setEditable(false);
            defaultEditorPane.setContentType("text/html");
            defaultEditorPane.setText("<html><a href=\"#\" style=\"font-family:sans-serif;\">" + string + "</a></html>");
            defaultEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        AgencyEstateViewInterestsPanel.this.getViewPanel().selectContactsTab(AgencyEstateViewInterestsPanel.class);
                    }
                }
            });
            this.getViewPanel().setInfoMessage((Component)defaultEditorPane);
        }
    }

    private void updateButtons(boolean bl) {
        this.matchingPanel.allInterestsField.setEnabled(bl);
        this.matchingPanel.statusField.setEnabled(bl);
        this.matchingPanel.searchAction.setEnabled(bl);
        this.matchingPanel.showActionsAction.setEnabled(bl && this.matchingPanel.table.getSelectedRowCount() > 0);
        this.assignmentPanel.showActionsAction.setEnabled(bl && this.assignmentPanel.table.getSelectedRowCount() > 0);
    }

    protected void updateLocalization() {
        super.updateLocalization();
    }

    private class ViewMatchingInterestAction
    extends AbstractI18nAction {
        private ViewMatchingInterestAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doViewMatchingInterest();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show search mandate")));
            this.setShortDescription(I18N.tr("Show details about the search mandate."));
        }
    }

    private class ViewMatchingEntryAction
    extends AbstractI18nAction {
        private ViewMatchingEntryAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doViewMatchingEntry();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the addressbook entry."));
        }
    }

    private class ViewAssignmentInterestAction
    extends AbstractI18nAction {
        private ViewAssignmentInterestAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doViewAssignmentInterest();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show search mandate")));
            this.setShortDescription(I18N.tr("Show details about the search mandate."));
        }
    }

    private class ViewAssignmentEntryAction
    extends AbstractI18nAction {
        private ViewAssignmentEntryAction() {
            this.setSmallIcon(ContactsPlugin.getResourceIcon((String)"edit_user.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doViewAssignmentEntry();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the addressbook entry."));
        }
    }

    private class ShowMatchingActionsAction
    extends AbstractI18nAction {
        private ShowMatchingActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyEstateViewInterestsPanel.this.doShowMatchingActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected search mandates."));
        }
    }

    private class ShowAssignmentActionsAction
    extends AbstractI18nAction {
        private ShowAssignmentActionsAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            AgencyEstateViewInterestsPanel.this.doShowAssignmentActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class SearchAction
    extends AbstractI18nAction {
        private SearchAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"search.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doRefresh(false);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.trc("search (verb)", "search")));
            this.setShortDescription(I18N.tr("Lookup for matching search mandates."));
        }
    }

    private class RemoveAction
    extends AbstractI18nAction {
        private RemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private final boolean reloadAssignments;

        private RefreshTask(boolean bl) {
            this.reloadAssignments = bl;
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                AgencyEstateViewInterestsPanel.this.doLoadInBackground(connection, this.reloadAssignments);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doRefresh(true);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class AssignAction
    extends AbstractI18nAction {
        private final DbAgencyInterestOffer.Status status;

        private AssignAction(DbAgencyInterestOffer.Status status) {
            this.status = status;
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyEstateViewInterestsPanel.this.doAssign(this.status);
        }

        protected void updateLocalization() {
            this.setName(this.status.getTranslation());
        }
    }

    private final class InterestOfferForm
    extends AgencyInterestOfferPanel {
        private InterestOfferForm() {
        }

        @Override
        public void close() {
            AssignmentTable assignmentTable = AgencyEstateViewInterestsPanel.this.assignmentPanel.table;
            if (assignmentTable.getSelectedRowCount() > 0) {
                assignmentTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean submit(DbAgencyInterestOffer dbAgencyInterestOffer) {
            AssignmentTable assignmentTable = AgencyEstateViewInterestsPanel.this.assignmentPanel.table;
            if (dbAgencyInterestOffer == null) {
                return false;
            }
            if (assignmentTable.getSelectedRowCount() < 1) {
                return false;
            }
            int n = assignmentTable.convertRowIndexToModel(assignmentTable.getSelectedRow());
            try {
                assignmentTable.setEnabled(false);
                assignmentTable.setTimeAt(n, dbAgencyInterestOffer.time);
                assignmentTable.setNotesAt(n, dbAgencyInterestOffer.notes);
                assignmentTable.setStatusAt(n, dbAgencyInterestOffer.status != null ? dbAgencyInterestOffer.status : DbAgencyInterestOffer.Status.OPEN);
            }
            finally {
                assignmentTable.setEnabled(true);
                assignmentTable.clearSelection();
            }
            return true;
        }
    }

    private class MatchingTable
    extends AgencyInterestTable<AgencyInterestTable.Row> {
        private MatchingTable() {
            super(AgencyEstateViewInterestsPanel.MATCHING_TABLE_ID);
        }

        protected void doSelect() {
            AgencyEstateViewInterestsPanel.this.matchingPanel.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            if (this.getSelectedRowCount() > 0) {
                AgencyEstateViewInterestsPanel.this.doShowMatchingActions((Component)((Object)this), n, n2);
            }
        }

        protected void doView() {
            AgencyEstateViewInterestsPanel.this.doViewMatchingInterest();
        }
    }

    private class MatchingPanel
    extends AbstractPanel {
        private JXTitledSeparator formTitle;
        private JCheckBox allInterestsField;
        private JComboBox<DbAgencyInterest.Status> statusField;
        private MatchingTable table;
        private SearchAction searchAction;
        private ShowMatchingActionsAction showActionsAction;

        private MatchingPanel() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.allInterestsField = new JCheckBox();
            this.statusField = new JComboBox();
            this.statusField.setRenderer((ListCellRenderer<DbAgencyInterest.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer<DbAgencyInterest.Status>(){

                public String getEmptyText() {
                    return "[ " + I18N.tr("select status") + " ]";
                }
            }));
            this.statusField.addItem(null);
            for (DbAgencyInterest.Status status : DbAgencyInterest.Status.values()) {
                this.statusField.addItem(status);
            }
            this.searchAction = new SearchAction();
            this.showActionsAction = new ShowMatchingActionsAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (JComponent[])new JComponent[]{this.allInterestsField, this.statusField, new JButton((Action)((Object)this.searchAction)), new JButton((Action)((Object)this.showActionsAction))});
            this.table = new MatchingTable();
            this.table.setSortOrder(0, SortOrder.DESCENDING);
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            Object object = StringUtils.capitalize((String)I18N.tr("available search mandates"));
            int n = this.table.getRowCount();
            if (n > 0) {
                object = (String)object + " / ";
                object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.formTitle.setTitle((String)object);
            this.allInterestsField.setText(I18N.tr("all search mandates"));
        }
    }

    public static class AssignmentTableRow
    extends AgencyInterestTable.Row {
        private final DbAgencyInterestOffer offer;

        private AssignmentTableRow(DbContactsEntry dbContactsEntry, String string, DbAgencyInterest dbAgencyInterest, DbAgencySearch dbAgencySearch, DbAgencyInterestOffer dbAgencyInterestOffer) {
            super(dbContactsEntry, string, dbAgencyInterest, dbAgencySearch);
            this.offer = dbAgencyInterestOffer;
        }

        public DbAgencyInterestOffer getOffer() {
            return this.offer;
        }

        @Override
        public Object getValue(AbstractTable.Column column) {
            if (column instanceof AssignmentTableColumn) {
                return this.getValueForOffer((AssignmentTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForOffer(AssignmentTableColumn assignmentTableColumn) {
            if (this.offer == null) {
                return null;
            }
            switch (assignmentTableColumn) {
                case OFFER_TIME: {
                    return this.offer.time;
                }
                case OFFER_STATUS: {
                    return this.offer.status;
                }
                case OFFER_NOTES: {
                    return StringUtils.trimToNull((String)this.offer.notes);
                }
            }
            return null;
        }

        public void setNotes(String string) {
            this.offer.notes = string;
        }

        public void setStatus(DbAgencyInterestOffer.Status status) {
            this.offer.status = status;
        }

        public void setTime(Date date) {
            this.offer.time = date;
        }
    }

    public static enum AssignmentTableColumn implements AbstractTable.Column
    {
        OFFER_TIME,
        OFFER_STATUS,
        OFFER_NOTES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case OFFER_NOTES: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
                case OFFER_STATUS: {
                    return new DefaultTableCellRenderer((Renderer)new InterestOfferStatusRenderer());
                }
                case OFFER_TIME: {
                    return new DefaultTableCellRenderer((Renderer)new DateRenderer(DateFormat.getDateTimeInstance(3, 2)));
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case OFFER_TIME: {
                    return Date.class;
                }
                case OFFER_STATUS: {
                    return DbAgencyInterestOffer.Status.class;
                }
                case OFFER_NOTES: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case OFFER_TIME: {
                    return StringUtils.capitalize((String)I18N.tr("time"));
                }
                case OFFER_STATUS: {
                    return StringUtils.capitalize((String)I18N.tr("offer")) + "-" + StringUtils.capitalize((String)I18N.tr("status"));
                }
                case OFFER_NOTES: {
                    return StringUtils.capitalize((String)I18N.tr("notes"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private class AssignmentTable
    extends AgencyInterestTable<AssignmentTableRow> {
        private AssignmentTable() {
            super(AgencyEstateViewInterestsPanel.ASSIGNMENT_TABLE_ID);
        }

        protected void doSelect() {
            AgencyEstateViewInterestsPanel.this.assignmentPanel.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                AgencyEstateViewInterestsPanel.this.assignmentPanel.offerForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                DbAgencyInterestOffer dbAgencyInterestOffer = new DbAgencyInterestOffer();
                dbAgencyInterestOffer.interestId = this.getInterestIdAt(n);
                dbAgencyInterestOffer.agencyObjectId = AgencyEstateViewInterestsPanel.this.currentAgencyObject != null ? AgencyEstateViewInterestsPanel.this.currentAgencyObject.id : 0L;
                dbAgencyInterestOffer.notes = this.getNotesAt(n);
                dbAgencyInterestOffer.status = this.getStatusAt(n);
                dbAgencyInterestOffer.time = this.getTimeAt(n);
                AgencyEstateViewInterestsPanel.this.assignmentPanel.offerForm.selectRelation(dbAgencyInterestOffer);
            }
        }

        protected void doShowActions(int n, int n2) {
            AgencyEstateViewInterestsPanel.this.doShowAssignmentActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyEstateViewInterestsPanel.this.doViewAssignmentInterest();
        }

        protected void init() {
            super.init();
            this.setSortOrder(AssignmentTableColumn.OFFER_TIME.getColumnId(), SortOrder.DESCENDING);
        }

        public String getNotesAt(int n) {
            DbAgencyInterestOffer dbAgencyInterestOffer = this.getOfferAt(n);
            return dbAgencyInterestOffer != null ? StringUtils.trimToNull((String)dbAgencyInterestOffer.notes) : null;
        }

        public DbAgencyInterestOffer getOfferAt(int n) {
            AssignmentTableRow assignmentTableRow = (AssignmentTableRow)this.getRow(n);
            return assignmentTableRow != null ? assignmentTableRow.getOffer() : null;
        }

        public DbAgencyInterestOffer.Status getStatusAt(int n) {
            DbAgencyInterestOffer dbAgencyInterestOffer = this.getOfferAt(n);
            return dbAgencyInterestOffer != null ? dbAgencyInterestOffer.status : null;
        }

        public Date getTimeAt(int n) {
            DbAgencyInterestOffer dbAgencyInterestOffer = this.getOfferAt(n);
            return dbAgencyInterestOffer != null ? dbAgencyInterestOffer.time : null;
        }

        @Override
        protected List<AbstractTable.Column> listColumns() {
            ArrayList<AbstractTable.Column> arrayList = new ArrayList<AbstractTable.Column>();
            arrayList.add(AssignmentTableColumn.OFFER_TIME);
            arrayList.addAll(super.listColumns());
            for (AssignmentTableColumn assignmentTableColumn : AssignmentTableColumn.values()) {
                if (arrayList.contains((Object)assignmentTableColumn)) continue;
                arrayList.add(assignmentTableColumn);
            }
            return arrayList;
        }

        public void setNotesAt(int n, String string) {
            AssignmentTableRow assignmentTableRow = (AssignmentTableRow)this.getRow(n);
            if (assignmentTableRow != null) {
                assignmentTableRow.setNotes(string);
            }
        }

        public void setStatusAt(int n, DbAgencyInterestOffer.Status status) {
            AssignmentTableRow assignmentTableRow = (AssignmentTableRow)this.getRow(n);
            if (assignmentTableRow != null) {
                assignmentTableRow.setStatus(status);
            }
        }

        public void setTimeAt(int n, Date date) {
            AssignmentTableRow assignmentTableRow = (AssignmentTableRow)this.getRow(n);
            if (assignmentTableRow != null) {
                assignmentTableRow.setTime(date);
            }
        }
    }

    private class AssignmentPanel
    extends AbstractPanel {
        private JXTitledSeparator formTitle;
        private AssignmentTable table;
        private InterestOfferForm offerForm;
        private ShowAssignmentActionsAction showActionsAction;

        private AssignmentPanel() {
            this.build();
        }

        private void build() {
            this.formTitle = ImmoToolUtils.createHead2Separator((String)"");
            this.showActionsAction = new ShowAssignmentActionsAction();
            JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.formTitle, (Action[])new Action[]{this.showActionsAction});
            this.table = new AssignmentTable();
            this.offerForm = new InterestOfferForm();
            this.setBorder((Border)Paddings.DIALOG);
            this.setLayout(new BorderLayout(5, 5));
            this.add(jPanel, "North");
            this.add(this.table.createScrollPane(), "Center");
            this.add((Component)((Object)this.offerForm), "South");
            this.updateLocalization();
        }

        protected void updateLocalization() {
            super.updateLocalization();
            Object object = StringUtils.capitalize((String)I18N.tr("assigned search mandates"));
            int n = this.table.getRowCount();
            if (n > 0) {
                object = (String)object + " / ";
                object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
            }
            this.formTitle.setTitle((String)object);
        }
    }
}

