/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.openindex.openestate.impl.CompanyAddressImpl;
import com.openindex.openestate.impl.db.DbSearch;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestTable;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyInterestViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterest;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyInterestsHandler;
import com.openindex.openestate.tool.agency.db.DbAgencySearch;
import com.openindex.openestate.tool.agency.db.DbAgencySearchesHandler;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import com.openindex.openestate.tool.contacts.db.DbContactsEntry;
import com.openindex.openestate.tool.contacts.db.DbContactsGroup;
import com.openindex.openestate.tool.contacts.db.DbContactsHandler;
import com.openindex.openestate.tool.contacts.extensions.EntryTableExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractMainTable;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultFormBuilder;
import com.openindex.openestate.tool.gui.DefaultListCellRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import com.openindex.openestate.tool.gui.TranslatableRenderer;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.Connection;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public final class AgencyInterestTablePanel
extends AbstractMainTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyInterestTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyInterestTablePanel.class);
    private static final String TABLE_ID = "AgencyInterestTablePanel.Table";
    private static final int FILTER_ID = 0;
    private static final int FILTER_PERSON = 1;
    private static final int FILTER_ADDRESS = 2;
    private static final int FILTER_STATUS = 3;
    private static final int COUNT_FILTERS = 4;
    private List<String> filterValues;
    private JLabel filterIdLabel;
    private JFormattedTextField filterIdField;
    private JLabel filterPersonLabel;
    private JTextField filterPersonField;
    private JLabel filterAddressLabel;
    private JTextField filterAddressField;
    private JLabel filterStatusLabel;
    private JComboBox<DbAgencyInterest.Status> filterStatusField;
    private Table table;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction createAction;
    private AbstractI18nAction helpAction;
    private AbstractI18nAction closeAction;
    private AbstractI18nAction showActionsAction;

    private AgencyInterestTablePanel() {
        this.updateLocalization();
    }

    protected void buildHeaderComponentButtons(ButtonBarBuilder buttonBarBuilder) {
        this.refreshAction = this.createDefaultRefreshAction();
        this.createAction = new InterestAddAction();
        this.helpAction = this.createDefaultHelpAction();
        this.closeAction = this.createDefaultCloseAction();
        this.showActionsAction = this.createDefaultShowActionsAction(ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.refreshAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.createAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.showActionsAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.helpAction));
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addFixed((JComponent)new JButton((Action)this.closeAction));
    }

    protected JComponent buildHeaderComponentForm() {
        this.filterValues = new ArrayList<String>();
        for (int i = 0; i < 4; ++i) {
            this.filterValues.add(null);
        }
        this.filterIdLabel = new JLabel();
        this.filterIdField = new JFormattedTextField(NumberFormat.getIntegerInstance());
        this.filterIdField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                String string;
                if (!AgencyInterestTablePanel.this.filterIdField.isEnabled()) {
                    return;
                }
                try {
                    AgencyInterestTablePanel.this.filterIdField.commitEdit();
                }
                catch (Exception exception) {
                    AgencyInterestTablePanel.this.filterIdField.setValue(null);
                }
                String string2 = string = AgencyInterestTablePanel.this.filterIdField.isEditValid() ? AgencyInterestTablePanel.this.filterIdField.getText().trim() : null;
                if (StringUtils.isEmpty(string) && AgencyInterestTablePanel.this.filterValues.get(0) == null) {
                    return;
                }
                if (string != null && string.equalsIgnoreCase(AgencyInterestTablePanel.this.filterValues.get(0))) {
                    return;
                }
                AgencyInterestTablePanel.this.filterValues.set(0, string);
                AgencyInterestTablePanel.this.updateFilters(true);
            }
        });
        this.filterPersonLabel = new JLabel();
        this.filterPersonField = new JTextField();
        this.filterPersonField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyInterestTablePanel.this.filterPersonField.isEnabled()) {
                    return;
                }
                String string = AgencyInterestTablePanel.this.filterPersonField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyInterestTablePanel.this.filterValues.get(1) == null) {
                    return;
                }
                if (string.equalsIgnoreCase(AgencyInterestTablePanel.this.filterValues.get(1))) {
                    return;
                }
                AgencyInterestTablePanel.this.filterValues.set(1, string);
                AgencyInterestTablePanel.this.updateFilters(true);
            }
        });
        this.filterAddressLabel = new JLabel();
        this.filterAddressField = new JTextField();
        this.filterAddressField.addKeyListener(new KeyAdapter(){

            @Override
            public void keyReleased(KeyEvent keyEvent) {
                if (!AgencyInterestTablePanel.this.filterAddressField.isEnabled()) {
                    return;
                }
                String string = AgencyInterestTablePanel.this.filterAddressField.getText().trim();
                if (StringUtils.isEmpty((CharSequence)string) && AgencyInterestTablePanel.this.filterValues.get(2) == null) {
                    return;
                }
                if (string.equalsIgnoreCase(AgencyInterestTablePanel.this.filterValues.get(2))) {
                    return;
                }
                AgencyInterestTablePanel.this.filterValues.set(2, string);
                AgencyInterestTablePanel.this.updateFilters(true);
            }
        });
        this.filterStatusLabel = new JLabel();
        this.filterStatusField = new JComboBox();
        this.filterStatusField.setRenderer((ListCellRenderer<DbAgencyInterest.Status>)new DefaultListCellRenderer((Renderer)new TranslatableRenderer("-")));
        this.filterStatusField.addItem(null);
        for (DbAgencyInterest.Status status : DbAgencyInterest.Status.values()) {
            this.filterStatusField.addItem(status);
        }
        this.filterStatusField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!AgencyInterestTablePanel.this.filterStatusField.isEnabled()) {
                    return;
                }
                DbAgencyInterest.Status status = (DbAgencyInterest.Status)((Object)AgencyInterestTablePanel.this.filterStatusField.getSelectedItem());
                if (status == null && AgencyInterestTablePanel.this.filterValues.get(3) == null) {
                    return;
                }
                if (status != null && status.name().equalsIgnoreCase(AgencyInterestTablePanel.this.filterValues.get(3))) {
                    return;
                }
                AgencyInterestTablePanel.this.filterValues.set(3, status != null ? status.name() : null);
                AgencyInterestTablePanel.this.updateFilters(true);
            }
        });
        DefaultFormBuilder defaultFormBuilder = DefaultFormBuilder.create((String)"right:pref, 3dlu, 30dlu, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, 30dlu:grow, 3dlu, right:pref, 3dlu, pref");
        defaultFormBuilder.add((Component)this.filterIdLabel).xy(1, defaultFormBuilder.nextRow());
        defaultFormBuilder.add((Component)this.filterIdField).xy(3, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterPersonLabel).xy(5, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterPersonField).xy(7, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterAddressLabel).xy(9, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterAddressField).xy(11, defaultFormBuilder.row());
        defaultFormBuilder.add((Component)this.filterStatusLabel).xy(13, defaultFormBuilder.row());
        defaultFormBuilder.add(this.filterStatusField).xy(15, defaultFormBuilder.row());
        return defaultFormBuilder.getPanel();
    }

    public static AgencyInterestTablePanel createTab() {
        return new AgencyInterestTablePanel();
    }

    protected JXTable createTable() {
        this.table = new Table();
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyInterestTable.Row>(){

            public boolean include(AgencyInterestTable.Row row) {
                Number number = AgencyInterestTablePanel.this.filterIdField.isEditValid() ? (Number)((Number)AgencyInterestTablePanel.this.filterIdField.getValue()) : (Number)null;
                return number == null || StringUtils.startsWithIgnoreCase((CharSequence)String.valueOf(row.getEntry().id), (CharSequence)String.valueOf(number));
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyInterestTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyInterestTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)AgencyInterestTablePanel.this.filterAddressField.getText());
                if (string == null) {
                    return true;
                }
                if (this.value == null || !string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 6.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPostalCode())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getCity())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getDistrict())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getRegion())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.writeStreet())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyInterestTable.Row>(){
            private String value = null;
            private Pattern pattern = null;

            public boolean include(AgencyInterestTable.Row row) {
                CompanyAddressImpl companyAddressImpl;
                String string = StringUtils.trimToNull((String)AgencyInterestTablePanel.this.filterPersonField.getText());
                if (string == null) {
                    return true;
                }
                if (!string.equalsIgnoreCase(this.value)) {
                    this.value = string;
                    this.pattern = 7.createPattern((String)this.value);
                }
                return this.pattern.matcher(StringUtils.trimToEmpty((String)(companyAddressImpl = row.getEntry().address).getPersonLastName())).find() || this.pattern.matcher(StringUtils.trimToEmpty((String)companyAddressImpl.getPersonFirstName())).find();
            }
        });
        this.table.addFilter((RowFilter)new AbstractTable.Filter<AgencyInterestTable.Row>(){

            public boolean include(AgencyInterestTable.Row row) {
                DbAgencyInterest.Status status = (DbAgencyInterest.Status)((Object)AgencyInterestTablePanel.this.filterStatusField.getSelectedItem());
                return status == null || status.equals((Object)row.getInterest().status);
            }
        });
        return this.table;
    }

    protected void doHelp() {
    }

    private void doInterestRemove() {
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_REMOVE)) {
            return;
        }
        int[] nArray = this.table.getSelectedRows();
        if (ArrayUtils.isEmpty((int[])nArray)) {
            return;
        }
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n : nArray) {
            int n2 = this.table.convertRowIndexToModel(n);
            arrayList.add(this.table.getInterestIdAt(n2));
        }
        boolean bl = ImmoToolUtils.showQuestionDialog((String)I18N.tr("Do you really want to remove the selected search mandates?"), (Component)((Object)this));
        if (!bl) {
            return;
        }
        long[] lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        ImmoToolUtils.executeTask((ImmoToolTask)new InterestRemoveTask(lArray));
    }

    private void doInterestView() {
        if (!AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
            return;
        }
        int n = this.table.getSelectedRowCount();
        if (n < 1) {
            return;
        }
        int n2 = n < 10 ? n : 10;
        int n3 = 0;
        ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
        for (int n4 : this.table.getSelectedRows()) {
            int n5 = this.table.convertRowIndexToModel(n4);
            long l = this.table.getInterestIdAt(n5);
            ImmoToolUtils.executeTask((ImmoToolTask)new AgencyInterestViewTask(immoToolProject.getDbDriver(), l, n2 == 1));
            if (++n3 >= 10) break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    protected void doLoadInBackground(Connection connection) throws Exception {
        this.table.setEnabled(false);
        this.table.clearSelection();
        this.table.clearRows();
        this.updateFilters(false);
        ArrayList<DbAgencyInterest> arrayList = new ArrayList<DbAgencyInterest>();
        HashMap<Long, String> hashMap = new HashMap<Long, String>();
        HashMap<Long, DbAgencyInterest> hashMap2 = new HashMap<Long, DbAgencyInterest>();
        HashMap<Long, DbAgencySearch> hashMap3 = new HashMap<Long, DbAgencySearch>();
        try {
            void var13_19;
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            DbContactsHandler dbContactsHandler = ContactsPlugin.getDbContactsExtension().getContactsHandler();
            DbAgencySearchesHandler dbAgencySearchesHandler = AgencyPlugin.getDbAgencyExtension().getSearchesHandler();
            DbAgencyInterest[] dbAgencyInterestArray = dbAgencyInterestsHandler.getInterests(connection);
            arrayList.addAll(Arrays.asList(dbAgencyInterestArray));
            for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestArray) {
                if (!hashMap2.containsKey(dbAgencyInterest.contactsEntryId)) {
                    hashMap2.put(dbAgencyInterest.contactsEntryId, null);
                }
                if (hashMap3.containsKey(dbAgencyInterest.agencySearchId)) continue;
                hashMap3.put(dbAgencyInterest.agencySearchId, null);
            }
            for (DbAgencyInterest dbAgencyInterest : dbContactsHandler.getGroups(connection)) {
                hashMap.put(((DbContactsGroup)dbAgencyInterest).id, ((DbContactsGroup)dbAgencyInterest).name);
            }
            DbAgencyInterest[] dbAgencyInterestArray2 = dbContactsHandler.getEntries(connection, ArrayUtils.toPrimitive((Long[])hashMap2.keySet().toArray(new Long[0])));
            dbContactsHandler.loadEntrySettings(connection, (DbContactsEntry[])dbAgencyInterestArray2);
            DbAgencyInterest[] dbAgencyInterestArray3 = dbAgencyInterestArray2;
            int n = dbAgencyInterestArray3.length;
            boolean bl = false;
            while (var13_19 < n) {
                DbAgencyInterest dbAgencyInterest = dbAgencyInterestArray3[var13_19];
                hashMap2.put(((DbContactsEntry)dbAgencyInterest).id, dbAgencyInterest);
                ++var13_19;
            }
            dbAgencyInterestArray3 = dbAgencySearchesHandler.getSearches(connection, ArrayUtils.toPrimitive((Long[])hashMap3.keySet().toArray(new Long[0])));
            dbAgencySearchesHandler.loadValueConditions(connection, (DbSearch[])dbAgencyInterestArray3);
            for (DbAgencyInterest dbAgencyInterest : dbAgencyInterestArray3) {
                hashMap3.put(((DbSearch)dbAgencyInterest).id, (DbAgencySearch)dbAgencyInterest);
            }
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap2, hashMap3, hashMap){
                final /* synthetic */ List val$interestsList;
                final /* synthetic */ Map val$contactsEntryMap;
                final /* synthetic */ Map val$agencySearchMap;
                final /* synthetic */ Map val$contactsGroupNameMap;
                {
                    this.val$interestsList = list;
                    this.val$contactsEntryMap = map;
                    this.val$agencySearchMap = map2;
                    this.val$contactsGroupNameMap = map3;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (DbAgencyInterest dbAgencyInterest : this.val$interestsList) {
                            DbContactsEntry dbContactsEntry = dbAgencyInterest.contactsEntryId > 0L && this.val$contactsEntryMap.containsKey(dbAgencyInterest.contactsEntryId) ? (DbContactsEntry)this.val$contactsEntryMap.get(dbAgencyInterest.contactsEntryId) : null;
                            DbAgencySearch dbAgencySearch = dbAgencyInterest.agencySearchId > 0L && this.val$agencySearchMap.containsKey(dbAgencyInterest.agencySearchId) ? (DbAgencySearch)this.val$agencySearchMap.get(dbAgencyInterest.agencySearchId) : null;
                            String string = dbContactsEntry != null && this.val$contactsGroupNameMap.containsKey(dbContactsEntry.groupId) ? (String)this.val$contactsGroupNameMap.get(dbContactsEntry.groupId) : null;
                            AgencyInterestTablePanel.this.table.addRow((AbstractTable.Row)new AgencyInterestTable.Row(dbContactsEntry, string, dbAgencyInterest, dbAgencySearch));
                        }
                    }
                    finally {
                        AgencyInterestTablePanel.this.table.setEnabled(true);
                        AgencyInterestTablePanel.this.updateFilters(true);
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    public void doRefresh() {
        this.loadInBackground(ImmoToolProject.getAppInstance().getDbDriver());
    }

    protected void doShowActions(Component component, int n, int n2) {
        if (this.table.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add((Action)((Object)new InterestViewAction()));
        jPopupMenu.add((Action)((Object)new InterestRemoveAction()));
        jPopupMenu.addSeparator();
        JMenu jMenu = new JMenu(StringUtils.capitalize((String)I18N.tr("actions for address")));
        jMenu.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
        jMenu.setIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_user.png", (int)16));
        jMenu.add((Action)((Object)new ContactsEntryViewAction()));
        jPopupMenu.add(jMenu);
        ArrayList<Long> arrayList = new ArrayList<Long>();
        for (int n3 : this.table.getSelectedRows()) {
            int entryTableExtension = this.table.convertRowIndexToModel(n3);
            arrayList.add(this.table.getContactEntryIdAt(entryTableExtension));
        }
        Long[] longArray = arrayList.toArray(new Long[0]);
        for (EntryTableExtension entryTableExtension : this.table.getAddons()) {
            Object[] objectArray = entryTableExtension.createActionMenuItems(ImmoToolProject.getAppInstance(), longArray, (JComponent)((Object)this));
            if (ArrayUtils.isEmpty((Object[])objectArray)) continue;
            for (Object object : objectArray) {
                jMenu.add((JMenuItem)object);
            }
        }
        jPopupMenu.show(component, n, n2);
    }

    protected Icon getHeaderIcon() {
        return ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)32);
    }

    protected String getHeaderTitle() {
        return StringUtils.capitalize((String)I18N.tr("table of search mandates"));
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("search mandates"));
    }

    public String getTabToolTipText() {
        return I18N.tr("This tab contains a table of search mandates.");
    }

    protected String getTableTitle() {
        int n;
        Object object = StringUtils.capitalize((String)I18N.tr("search result"));
        int n2 = n = this.table != null ? this.table.getRowCount() : 0;
        if (n > 0) {
            object = (String)object + " / ";
            object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        return object;
    }

    protected boolean isLoadedInBackground() {
        return true;
    }

    protected void setButtonsEnabled(boolean bl) {
        super.setButtonsEnabled(bl);
        this.refreshAction.setEnabled(bl);
        this.createAction.setEnabled(bl && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT));
        this.helpAction.setEnabled(bl);
        this.closeAction.setEnabled(bl);
        this.showActionsAction.setEnabled(bl && this.table.getSelectedRowCount() > 0);
    }

    private void updateFilters(boolean bl) {
        this.table.updateFilters(bl);
        this.updateLocalization();
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.filterIdLabel.setText(I18N.tr("ID") + ":");
        this.filterPersonLabel.setText(StringUtils.capitalize((String)I18N.tr("person")) + ":");
        this.filterAddressLabel.setText(StringUtils.capitalize((String)I18N.tr("address")) + ":");
        this.filterStatusLabel.setText(StringUtils.capitalize((String)I18N.tr("status")) + ":");
    }

    private class InterestViewAction
    extends AbstractI18nAction {
        private InterestViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestTablePanel.this.doInterestView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show mandate")));
            this.setShortDescription(I18N.tr("Show the selected search mandates."));
        }
    }

    private class InterestRemoveTask
    extends ImmoToolTask<Boolean, Void> {
        private final long[] interestIds;

        private InterestRemoveTask(long[] lArray) {
            this.interestIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyInterestsHandler dbAgencyInterestsHandler = AgencyContactsUtils.getInterestsHandler();
            Connection connection = null;
            try {
                connection = immoToolProject.getDbConnection();
                dbAgencyInterestsHandler.removeInterests(connection, this.interestIds);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't remove search requests!", (Throwable)throwable, (Window)ImmoToolEnvironment.getFrame());
        }

        protected void finished() {
            super.finished();
            AgencyInterestTablePanel.this.setButtonsEnabled(true);
        }

        protected void succeeded(Boolean bl) {
            super.succeeded((Object)bl);
            if (!Boolean.TRUE.equals(bl)) {
                return;
            }
            for (long l : this.interestIds) {
                int n = AgencyInterestTablePanel.this.table.getRowForInterestId(l);
                if (n <= -1) continue;
                AgencyInterestTablePanel.this.table.removeRow(n);
            }
        }
    }

    private class InterestRemoveAction
    extends AbstractI18nAction {
        private InterestRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_REMOVE));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            AgencyInterestTablePanel.this.doInterestRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove mandate")));
            this.setShortDescription(I18N.tr("Remove the selected search mandates."));
        }
    }

    private static class InterestAddAction
    extends AbstractI18nAction {
        private InterestAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            new AgencyContactsUtils.InterestFormAction().actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new")));
            this.setShortDescription(I18N.tr("Add a new search mandate."));
        }
    }

    private class ContactsEntryViewAction
    extends AbstractI18nAction {
        private ContactsEntryViewAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit.png", (int)16));
            this.setEnabled(ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (AgencyInterestTablePanel.this.table.getSelectedRowCount() < 1) {
                return;
            }
            int n = AgencyInterestTablePanel.this.table.convertRowIndexToModel(AgencyInterestTablePanel.this.table.getSelectedRow());
            long l = AgencyInterestTablePanel.this.table.getContactEntryIdAt(n);
            new ContactsPlugin.EntryFormAction(l).actionPerformed(actionEvent);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show address")));
            this.setShortDescription(I18N.tr("Show details about the address."));
        }
    }

    private class Table
    extends AgencyInterestTable<AgencyInterestTable.Row> {
        public Table() {
            super(AgencyInterestTablePanel.TABLE_ID);
        }

        protected void doRemove() {
            AgencyInterestTablePanel.this.doInterestRemove();
        }

        protected void doSelect() {
            AgencyInterestTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
        }

        protected void doShowActions(int n, int n2) {
            AgencyInterestTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            AgencyInterestTablePanel.this.doInterestView();
        }
    }
}

