/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.contacts.ContactsFrameSidebarExtension;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonAdapter;
import com.openindex.openestate.tool.extensions.FrameSidebarAddonExtension;
import java.awt.Component;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JMenuItem;
import javax.swing.tree.MutableTreeNode;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={FrameSidebarAddonExtension.class}, plugins={"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"})
public class ContactsAgencyFrameSidebarExtension
extends FrameSidebarAddonAdapter<ContactsFrameSidebarExtension.TreeNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ContactsAgencyFrameSidebarExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(ContactsAgencyFrameSidebarExtension.class);

    public ContactsAgencyFrameSidebarExtension() {
        super(ContactsFrameSidebarExtension.class);
    }

    public Component[] getMenuComponents(ContactsFrameSidebarExtension.TreeNode treeNode, int n) {
        ArrayList<JMenuItem> arrayList = new ArrayList<JMenuItem>();
        if (n == 4) {
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS_EDIT)) {
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.InterestFormAction())));
            }
            if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS_EDIT)) {
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.BrokeringFormAction())));
            }
        }
        if (n == 7 && treeNode instanceof AddonTreeNode) {
            AddonTreeNode addonTreeNode = (AddonTreeNode)treeNode;
            if (addonTreeNode.isBrokeringsNode() && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
                arrayList.add((JMenuItem)ImmoToolUtils.createMenuSeparator((String)addonTreeNode.getNodeText()));
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.BrokeringTableAction(true))));
            }
            if (addonTreeNode.isInterestsNode() && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
                arrayList.add((JMenuItem)ImmoToolUtils.createMenuSeparator((String)addonTreeNode.getNodeText()));
                arrayList.add(new JMenuItem((Action)((Object)new AgencyContactsUtils.InterestTableAction(true))));
            }
            if (addonTreeNode.isStaffsNode() && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.CONTACTS)) {
                arrayList.add((JMenuItem)ImmoToolUtils.createMenuSeparator((String)addonTreeNode.getNodeText()));
                arrayList.add(new JMenuItem((Action)new AgencyPlugin.ContactTableAction(true)));
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Component[0]);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"};
    }

    public void initTree(Connection connection, ContactsFrameSidebarExtension.TreeNode treeNode) {
        AddonTreeNode addonTreeNode = new AddonTreeNode(0);
        if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.CONTACTS)) {
            addonTreeNode.add((MutableTreeNode)((Object)new AddonTreeNode(1)));
        }
        if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
            addonTreeNode.add((MutableTreeNode)((Object)new AddonTreeNode(2)));
        }
        if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
            addonTreeNode.add((MutableTreeNode)((Object)new AddonTreeNode(3)));
        }
        if (addonTreeNode.getChildCount() > 0) {
            treeNode.add((MutableTreeNode)((Object)addonTreeNode));
        }
    }

    private static class AddonTreeNode
    extends ContactsFrameSidebarExtension.TreeNode {
        private static final int TYPE_CONTACTS = 0;
        private static final int TYPE_CONTACTS_STAFFS = 1;
        private static final int TYPE_CONTACTS_INTERESTS = 2;
        private static final int TYPE_CONTACTS_BROKERINGS = 3;
        private final int contactsType;

        public AddonTreeNode(int n) {
            super(0);
            this.contactsType = n;
        }

        public void doShow(boolean bl) {
            switch (this.contactsType) {
                case 0: {
                    break;
                }
                case 3: {
                    new AgencyContactsUtils.BrokeringTableAction(bl).actionPerformed(null);
                    break;
                }
                case 2: {
                    new AgencyContactsUtils.InterestTableAction(bl).actionPerformed(null);
                    break;
                }
                case 1: {
                    new AgencyPlugin.ContactTableAction(bl).actionPerformed(null);
                    break;
                }
                default: {
                    super.doShow(bl);
                }
            }
        }

        public Icon getNodeIcon() {
            switch (this.contactsType) {
                case 0: {
                    return null;
                }
                case 3: {
                    return ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16);
                }
                case 2: {
                    return ImmoToolEnvironment.getResourceIcon((String)"find.png", (int)16);
                }
                case 1: {
                    return AgencyPlugin.getResourceIcon((String)"agent_family.png", (int)16);
                }
            }
            return super.getNodeIcon();
        }

        public String getNodeText() {
            switch (this.contactsType) {
                case 0: {
                    return this.title(StringUtils.capitalize((String)I18N.tr("contacts")));
                }
                case 3: {
                    return StringUtils.capitalize((String)I18N.tr("brokering mandates"));
                }
                case 2: {
                    return StringUtils.capitalize((String)I18N.tr("search mandates"));
                }
                case 1: {
                    return StringUtils.capitalize((String)I18N.tr("contact persons"));
                }
            }
            return super.getNodeText();
        }

        public String getNodeTooltip() {
            switch (this.contactsType) {
                case 0: {
                    return null;
                }
                case 3: {
                    return null;
                }
                case 2: {
                    return null;
                }
                case 1: {
                    return null;
                }
            }
            return super.getNodeTooltip();
        }

        public boolean isBrokeringsNode() {
            return this.contactsType == 3;
        }

        public boolean isInterestsNode() {
            return this.contactsType == 2;
        }

        public boolean isStaffsNode() {
            return this.contactsType == 1;
        }
    }
}

