/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.is24_csv;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import org.apache.commons.csv.CSVParser;
import org.apache.commons.csv.CSVRecord;
import org.openestate.io.core.CsvParser;
import org.openestate.io.is24_csv.Is24CsvFormat;
import org.openestate.io.is24_csv.Is24CsvRecord;
import org.openestate.io.is24_csv.records.Anlageobjekt;
import org.openestate.io.is24_csv.records.GewerbeBueroPraxis;
import org.openestate.io.is24_csv.records.GewerbeEinzelhandel;
import org.openestate.io.is24_csv.records.GewerbeGastronomieHotel;
import org.openestate.io.is24_csv.records.GewerbeHalleProduktion;
import org.openestate.io.is24_csv.records.GewerbeSonstiges;
import org.openestate.io.is24_csv.records.Grundstueck;
import org.openestate.io.is24_csv.records.GrundstueckGewerbe;
import org.openestate.io.is24_csv.records.GrundstueckWohnen;
import org.openestate.io.is24_csv.records.HausKauf;
import org.openestate.io.is24_csv.records.HausMiete;
import org.openestate.io.is24_csv.records.StellplatzKauf;
import org.openestate.io.is24_csv.records.StellplatzMiete;
import org.openestate.io.is24_csv.records.WohnenAufZeit;
import org.openestate.io.is24_csv.records.WohnungKauf;
import org.openestate.io.is24_csv.records.WohnungMiete;
import org.openestate.io.is24_csv.types.Immobilienart;
import org.openestate.io.is24_csv.types.ObjektkategorieGrundstueck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24CsvParser
extends CsvParser<Is24CsvRecord> {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24CsvParser.class);

    protected Is24CsvParser(CSVParser cSVParser) {
        super(cSVParser);
    }

    public static Is24CsvParser create(String string) throws IOException {
        return (Is24CsvParser)new Is24CsvFormat().parse(string);
    }

    public static Is24CsvParser create(File file) throws IOException {
        return (Is24CsvParser)new Is24CsvFormat().parse(file);
    }

    public static Is24CsvParser create(InputStream inputStream) throws IOException {
        return (Is24CsvParser)new Is24CsvFormat().parse(inputStream);
    }

    public static Is24CsvParser create(Reader reader) throws IOException {
        return (Is24CsvParser)new Is24CsvFormat().parse(reader);
    }

    public static Is24CsvRecord createRecord(CSVRecord cSVRecord) {
        Immobilienart immobilienart = Is24CsvRecord.getImmobilienart(cSVRecord);
        if (Immobilienart.ANLAGE.equals((Object)immobilienart)) {
            return Anlageobjekt.newRecord(cSVRecord);
        }
        if (Immobilienart.GEWERBE_BUERO_PRAXEN.equals((Object)immobilienart)) {
            return GewerbeBueroPraxis.newRecord(cSVRecord);
        }
        if (Immobilienart.GEWERBE_EINZELHANDEL.equals((Object)immobilienart)) {
            return GewerbeEinzelhandel.newRecord(cSVRecord);
        }
        if (Immobilienart.GEWERBE_GASTRONOMIE_HOTEL.equals((Object)immobilienart)) {
            return GewerbeGastronomieHotel.newRecord(cSVRecord);
        }
        if (Immobilienart.GEWERBE_HALLE_PRODUKTION.equals((Object)immobilienart)) {
            return GewerbeHalleProduktion.newRecord(cSVRecord);
        }
        if (Immobilienart.GEWERBE_SONSTIGES.equals((Object)immobilienart)) {
            return GewerbeSonstiges.newRecord(cSVRecord);
        }
        if (Immobilienart.HAUS_KAUF.equals((Object)immobilienart)) {
            return HausKauf.newRecord(cSVRecord);
        }
        if (Immobilienart.HAUS_MIETE.equals((Object)immobilienart)) {
            return HausMiete.newRecord(cSVRecord);
        }
        if (Immobilienart.STELLPLATZ_KAUF.equals((Object)immobilienart)) {
            return StellplatzKauf.newRecord(cSVRecord);
        }
        if (Immobilienart.STELLPLATZ_MIETE.equals((Object)immobilienart)) {
            return StellplatzMiete.newRecord(cSVRecord);
        }
        if (Immobilienart.WOHNEN_AUF_ZEIT.equals((Object)immobilienart)) {
            return WohnenAufZeit.newRecord(cSVRecord);
        }
        if (Immobilienart.WOHNUNG_KAUF.equals((Object)immobilienart)) {
            return WohnungKauf.newRecord(cSVRecord);
        }
        if (Immobilienart.WOHNUNG_MIETE.equals((Object)immobilienart)) {
            return WohnungMiete.newRecord(cSVRecord);
        }
        if (Immobilienart.GRUNDSTUECKE.equals((Object)immobilienart)) {
            ObjektkategorieGrundstueck objektkategorieGrundstueck = Grundstueck.getObjektkategorie(cSVRecord);
            if (ObjektkategorieGrundstueck.WOHNEN.equals((Object)objektkategorieGrundstueck)) {
                return GrundstueckWohnen.newRecord(cSVRecord);
            }
            return GrundstueckGewerbe.newRecord(cSVRecord);
        }
        LOGGER.warn("Unsupported 'Immobilienart' value: " + cSVRecord.get(2));
        return null;
    }

    protected Is24CsvRecord newRecord(CSVRecord cSVRecord) {
        return Is24CsvParser.createRecord(cSVRecord);
    }
}

