/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.is24;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateAttachmentType;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.EstateLinkImpl;
import com.openindex.openestate.impl.Gender;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateAttribGroup;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexAreaAttrib;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMaximal;
import com.openindex.openestate.impl.attribs.administration.AgeOfRequestedFlatmatesMinimal;
import com.openindex.openestate.impl.attribs.administration.AuctionCancellationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionDate;
import com.openindex.openestate.impl.attribs.administration.AuctionModificationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRecordationDate;
import com.openindex.openestate.impl.attribs.administration.AuctionRepeated;
import com.openindex.openestate.impl.attribs.administration.AuctionSplitted;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBegin;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.administration.AvailabilityEndDate;
import com.openindex.openestate.impl.attribs.administration.BuildableAccordingTo;
import com.openindex.openestate.impl.attribs.administration.BuildableInShortTerm;
import com.openindex.openestate.impl.attribs.administration.BuildableWith;
import com.openindex.openestate.impl.attribs.administration.BuildingPermissionAvailable;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesFemale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesMale;
import com.openindex.openestate.impl.attribs.administration.CountFlatmatesTotal;
import com.openindex.openestate.impl.attribs.administration.CountRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.CountryCourtFileReference;
import com.openindex.openestate.impl.attribs.administration.CountryCourtName;
import com.openindex.openestate.impl.attribs.administration.CountryCourtNr;
import com.openindex.openestate.impl.attribs.administration.DemolitionRequired;
import com.openindex.openestate.impl.attribs.administration.EmphyteusisDuration;
import com.openindex.openestate.impl.attribs.administration.GenderOfRequestedFlatmates;
import com.openindex.openestate.impl.attribs.administration.GrannyFlat;
import com.openindex.openestate.impl.attribs.administration.HolidayProperty;
import com.openindex.openestate.impl.attribs.administration.LandRegisterNr;
import com.openindex.openestate.impl.attribs.administration.MonumentalProtection;
import com.openindex.openestate.impl.attribs.administration.NonSmoker;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMaximum;
import com.openindex.openestate.impl.attribs.administration.OccupationPeriodMinimum;
import com.openindex.openestate.impl.attribs.administration.Owner;
import com.openindex.openestate.impl.attribs.administration.PeopleMaximumCount;
import com.openindex.openestate.impl.attribs.administration.Pets;
import com.openindex.openestate.impl.attribs.administration.Rented;
import com.openindex.openestate.impl.attribs.administration.Usage;
import com.openindex.openestate.impl.attribs.administration.WbsRequired;
import com.openindex.openestate.impl.attribs.condition.BuildYear;
import com.openindex.openestate.impl.attribs.condition.ConditionType;
import com.openindex.openestate.impl.attribs.condition.ConstructionPhase;
import com.openindex.openestate.impl.attribs.condition.Development;
import com.openindex.openestate.impl.attribs.condition.RefurbishmentYear;
import com.openindex.openestate.impl.attribs.descriptions.AgentFeeInformation;
import com.openindex.openestate.impl.attribs.descriptions.DetailledDescription;
import com.openindex.openestate.impl.attribs.descriptions.FeatureDescription;
import com.openindex.openestate.impl.attribs.descriptions.LocationDescription;
import com.openindex.openestate.impl.attribs.energy_certificate.Available;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionIncludingHotWater;
import com.openindex.openestate.impl.attribs.energy_certificate.ConsumptionTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.CreationDate;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandElectricity;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandHeating;
import com.openindex.openestate.impl.attribs.energy_certificate.DemandTotal;
import com.openindex.openestate.impl.attribs.energy_certificate.EfficiencyCategory;
import com.openindex.openestate.impl.attribs.energy_certificate.Type;
import com.openindex.openestate.impl.attribs.features.AirConditioned;
import com.openindex.openestate.impl.attribs.features.BalconyTerrace;
import com.openindex.openestate.impl.attribs.features.BarrierFree;
import com.openindex.openestate.impl.attribs.features.Basement;
import com.openindex.openestate.impl.attribs.features.Bathroom;
import com.openindex.openestate.impl.attribs.features.CanteenCafeteria;
import com.openindex.openestate.impl.attribs.features.CeilingLoad;
import com.openindex.openestate.impl.attribs.features.CountFloors;
import com.openindex.openestate.impl.attribs.features.Crane;
import com.openindex.openestate.impl.attribs.features.CraneLiftingCapacity;
import com.openindex.openestate.impl.attribs.features.ElectricalConnectionValue;
import com.openindex.openestate.impl.attribs.features.Equipment;
import com.openindex.openestate.impl.attribs.features.Floor;
import com.openindex.openestate.impl.attribs.features.FloorLoading;
import com.openindex.openestate.impl.attribs.features.FlooringMaterial;
import com.openindex.openestate.impl.attribs.features.FreightElevator;
import com.openindex.openestate.impl.attribs.features.FreightElevatorCapacity;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.GardenUse;
import com.openindex.openestate.impl.attribs.features.Kitchen;
import com.openindex.openestate.impl.attribs.features.Lift;
import com.openindex.openestate.impl.attribs.features.LiftingPlatform;
import com.openindex.openestate.impl.attribs.features.Ramp;
import com.openindex.openestate.impl.attribs.features.ResidentialRooms;
import com.openindex.openestate.impl.attribs.features.ResidentialServices;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.features.TypeOfBeaconing;
import com.openindex.openestate.impl.attribs.features.TypeOfHeating;
import com.openindex.openestate.impl.attribs.features.WarehouseHeight;
import com.openindex.openestate.impl.attribs.measures.AdministrationArea;
import com.openindex.openestate.impl.attribs.measures.BaseAreaIndex;
import com.openindex.openestate.impl.attribs.measures.CarParkingType;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.CountGuestroomSeats;
import com.openindex.openestate.impl.attribs.measures.CountParkingSpaces;
import com.openindex.openestate.impl.attribs.measures.CountRooms;
import com.openindex.openestate.impl.attribs.measures.DivisibleFromArea;
import com.openindex.openestate.impl.attribs.measures.FloorAreaIndex;
import com.openindex.openestate.impl.attribs.measures.FrontWindowLength;
import com.openindex.openestate.impl.attribs.measures.Height;
import com.openindex.openestate.impl.attribs.measures.Length;
import com.openindex.openestate.impl.attribs.measures.OfficeArea;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.RemainingAreas;
import com.openindex.openestate.impl.attribs.measures.RentableArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.SeatingArea;
import com.openindex.openestate.impl.attribs.measures.StorageArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.measures.UsableArea;
import com.openindex.openestate.impl.attribs.measures.Width;
import com.openindex.openestate.impl.attribs.prices.AgentFee;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpacePrice;
import com.openindex.openestate.impl.attribs.prices.CarParkingSpaceRent;
import com.openindex.openestate.impl.attribs.prices.CommonCharge;
import com.openindex.openestate.impl.attribs.prices.Deposit;
import com.openindex.openestate.impl.attribs.prices.DepositAmount;
import com.openindex.openestate.impl.attribs.prices.HeatingCosts;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.LowestBid;
import com.openindex.openestate.impl.attribs.prices.MarketValue;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.PurchasePriceOnAnnualRentalIncome;
import com.openindex.openestate.impl.attribs.prices.PurchasePricePerArea;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceChargesPerArea;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeActualPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomeDebitPerAnnum;
import com.openindex.openestate.impl.attribs.prices.RentalIncomePerMonth;
import com.openindex.openestate.impl.attribs.prices.ServiceCharges;
import com.openindex.openestate.impl.attribs.prices.ServiceChargesIncludingHeatingCosts;
import com.openindex.openestate.impl.attribs.surroundings.CommercialZone;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToAirport;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToBusStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMainLineStation;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToMotorway;
import com.openindex.openestate.impl.attribs.surroundings.DistanceToNextTrainStation;
import com.openindex.openestate.impl.attribs.surroundings.SupplyAccess;
import com.openindex.openestate.impl.is24.Is24Utils;
import com.openindex.openestate.impl.utils.AbstractConverter;
import com.openindex.openestate.impl.values.AreaValue;
import com.openindex.openestate.impl.values.EnergyConsumptionValue;
import com.openindex.openestate.impl.values.LengthValue;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.openestate.is24.restapi.xml.common.Address;
import org.openestate.is24.restapi.xml.common.AirConditioningType;
import org.openestate.is24.restapi.xml.common.ApartmentType;
import org.openestate.is24.restapi.xml.common.Attachment;
import org.openestate.is24.restapi.xml.common.BuildingEnergyRatingType;
import org.openestate.is24.restapi.xml.common.BuildingType;
import org.openestate.is24.restapi.xml.common.CommercializationType;
import org.openestate.is24.restapi.xml.common.CompulsoryAuctionType;
import org.openestate.is24.restapi.xml.common.ConstructionPhaseType;
import org.openestate.is24.restapi.xml.common.CountryCode;
import org.openestate.is24.restapi.xml.common.CountryRegion;
import org.openestate.is24.restapi.xml.common.CourtageInfo;
import org.openestate.is24.restapi.xml.common.Currency;
import org.openestate.is24.restapi.xml.common.EnergyCertificateAvailability;
import org.openestate.is24.restapi.xml.common.EnergyCertificateCreationDate;
import org.openestate.is24.restapi.xml.common.EnergyEfficiencyClass;
import org.openestate.is24.restapi.xml.common.EnergySourceEnev2014;
import org.openestate.is24.restapi.xml.common.EnergySourcesEnev2014;
import org.openestate.is24.restapi.xml.common.FlatMateGenderType;
import org.openestate.is24.restapi.xml.common.FlooringType;
import org.openestate.is24.restapi.xml.common.GarageType;
import org.openestate.is24.restapi.xml.common.GastronomyType;
import org.openestate.is24.restapi.xml.common.GeoHierarchy;
import org.openestate.is24.restapi.xml.common.HeatingTypeEnev2014;
import org.openestate.is24.restapi.xml.common.HouseTypeBuildingType;
import org.openestate.is24.restapi.xml.common.IndustryType;
import org.openestate.is24.restapi.xml.common.InteriorQuality;
import org.openestate.is24.restapi.xml.common.InternetConnectionType;
import org.openestate.is24.restapi.xml.common.InvestmentType;
import org.openestate.is24.restapi.xml.common.ItInfrastructureType;
import org.openestate.is24.restapi.xml.common.Link;
import org.openestate.is24.restapi.xml.common.LocationClassificationType;
import org.openestate.is24.restapi.xml.common.MarketingType;
import org.openestate.is24.restapi.xml.common.OfficeType;
import org.openestate.is24.restapi.xml.common.PDFDocument;
import org.openestate.is24.restapi.xml.common.ParkingSituationType;
import org.openestate.is24.restapi.xml.common.ParkingSpaceType;
import org.openestate.is24.restapi.xml.common.PetsAllowedType;
import org.openestate.is24.restapi.xml.common.Picture;
import org.openestate.is24.restapi.xml.common.Price;
import org.openestate.is24.restapi.xml.common.PriceIntervalType;
import org.openestate.is24.restapi.xml.common.PublishChannel;
import org.openestate.is24.restapi.xml.common.PublishChannels;
import org.openestate.is24.restapi.xml.common.RealEstateCondition;
import org.openestate.is24.restapi.xml.common.RealEstateState;
import org.openestate.is24.restapi.xml.common.RealtorContactDetails;
import org.openestate.is24.restapi.xml.common.SalutationType;
import org.openestate.is24.restapi.xml.common.ShortTermAccommodationType;
import org.openestate.is24.restapi.xml.common.SiteConstructibleType;
import org.openestate.is24.restapi.xml.common.SiteDevelopmentType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseForTradeType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseForTradeTypes;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseType;
import org.openestate.is24.restapi.xml.common.SiteRecommendedUseTypes;
import org.openestate.is24.restapi.xml.common.SmokingAllowedType;
import org.openestate.is24.restapi.xml.common.SpecialPurposeType;
import org.openestate.is24.restapi.xml.common.StoreType;
import org.openestate.is24.restapi.xml.common.StreamingVideo;
import org.openestate.is24.restapi.xml.common.SupplyType;
import org.openestate.is24.restapi.xml.common.TelephoneConnectionType;
import org.openestate.is24.restapi.xml.common.TvConnectionType;
import org.openestate.is24.restapi.xml.common.UtilizationTradeSite;
import org.openestate.is24.restapi.xml.common.Wgs84Address;
import org.openestate.is24.restapi.xml.common.Wgs84Coordinate;
import org.openestate.is24.restapi.xml.common.YesNoNotApplicableType;
import org.openestate.is24.restapi.xml.common.YesNotApplicableType;
import org.openestate.is24.restapi.xml.realestates.ApartmentBuy;
import org.openestate.is24.restapi.xml.realestates.ApartmentRent;
import org.openestate.is24.restapi.xml.realestates.AssistedLiving;
import org.openestate.is24.restapi.xml.realestates.CompulsoryAuction;
import org.openestate.is24.restapi.xml.realestates.FlatShareRoom;
import org.openestate.is24.restapi.xml.realestates.GarageBuy;
import org.openestate.is24.restapi.xml.realestates.GarageRent;
import org.openestate.is24.restapi.xml.realestates.Gastronomy;
import org.openestate.is24.restapi.xml.realestates.HouseBuy;
import org.openestate.is24.restapi.xml.realestates.HouseRent;
import org.openestate.is24.restapi.xml.realestates.HouseType;
import org.openestate.is24.restapi.xml.realestates.Industry;
import org.openestate.is24.restapi.xml.realestates.Investment;
import org.openestate.is24.restapi.xml.realestates.LivingBuySite;
import org.openestate.is24.restapi.xml.realestates.LivingRentSite;
import org.openestate.is24.restapi.xml.realestates.ObjectFactory;
import org.openestate.is24.restapi.xml.realestates.Office;
import org.openestate.is24.restapi.xml.realestates.RealEstate;
import org.openestate.is24.restapi.xml.realestates.SeniorCare;
import org.openestate.is24.restapi.xml.realestates.ShortTermAccommodation;
import org.openestate.is24.restapi.xml.realestates.SpecialPurpose;
import org.openestate.is24.restapi.xml.realestates.Store;
import org.openestate.is24.restapi.xml.realestates.TradeSite;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Is24RestWriter
extends AbstractConverter {
    private static final Logger LOGGER = LoggerFactory.getLogger(Is24RestWriter.class);

    public Is24RestWriter() {
        this(OpenEstateUtils.DEFAULT_LOCALE);
    }

    public Is24RestWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : OpenEstateUtils.DEFAULT_LOCALE);
    }

    protected Price getEstateAdditionalCosts(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.MONTH);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected AirConditioningType getEstateAirConditioningType(EstateImpl estateImpl) {
        Boolean bl = AirConditioned.get((EstateImpl)estateImpl);
        if (Boolean.TRUE.equals(bl)) {
            return AirConditioningType.YES;
        }
        if (Boolean.FALSE.equals(bl)) {
            return AirConditioningType.NO;
        }
        return AirConditioningType.NO_INFORMATION;
    }

    protected ApartmentType getEstateApartmentType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.ATTIC_APARTMENT.equals((Object)openEstateType)) {
                return ApartmentType.ROOF_STOREY;
            }
            if (OpenEstateType.GROUND_FLOOR_APARTMENT.equals((Object)openEstateType)) {
                return ApartmentType.GROUND_FLOOR;
            }
            if (OpenEstateType.HIGHER_FLOOR_APARTMENT.equals((Object)openEstateType)) {
                return ApartmentType.APARTMENT;
            }
            if (OpenEstateType.MEZZANINE.equals((Object)openEstateType)) {
                return ApartmentType.RAISED_GROUND_FLOOR;
            }
            if (OpenEstateType.LOFT.equals((Object)openEstateType)) {
                return ApartmentType.LOFT;
            }
            if (OpenEstateType.MAISONETTE.equals((Object)openEstateType)) {
                return ApartmentType.MAISONETTE;
            }
            if (OpenEstateType.PENTHOUSE_APARTMENT.equals((Object)openEstateType)) {
                return ApartmentType.PENTHOUSE;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return ApartmentType.OTHER;
            }
            if (OpenEstateType.SOUTERRAIN_APARTMENT.equals((Object)openEstateType)) {
                return ApartmentType.HALF_BASEMENT;
            }
            if (!OpenEstateType.TERRACE_APARTMENT.equals((Object)openEstateType)) continue;
            return ApartmentType.TERRACED_FLAT;
        }
        return ApartmentType.OTHER;
    }

    protected BuildingType getEstateBuildingType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.FARMHOUSE.equals((Object)openEstateType)) {
                return BuildingType.FARMHOUSE;
            }
            if (OpenEstateType.SPECIAL_HOUSE.equals((Object)openEstateType)) {
                return BuildingType.SPECIAL_REAL_ESTATE;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return BuildingType.BUNGALOW;
            }
            if (OpenEstateType.CASTLE.equals((Object)openEstateType) || OpenEstateType.PALACE.equals((Object)openEstateType)) {
                return BuildingType.CASTLE_MANOR_HOUSE;
            }
            if (OpenEstateType.SEMIDETACHED_HOUSE.equals((Object)openEstateType)) {
                return BuildingType.SEMIDETACHED_HOUSE;
            }
            if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return BuildingType.SINGLE_FAMILY_HOUSE;
            }
            if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return BuildingType.MULTI_FAMILY_HOUSE;
            }
            if (OpenEstateType.TERRACED_HOUSE_CORNERSIDE.equals((Object)openEstateType)) {
                return BuildingType.END_TERRACE_HOUSE;
            }
            if (OpenEstateType.TERRACED_HOUSE.equals((Object)openEstateType)) {
                return BuildingType.TERRACE_HOUSE;
            }
            if (OpenEstateType.TERRACED_HOUSE_MIDDLE.equals((Object)openEstateType)) {
                return BuildingType.MID_TERRACE_HOUSE;
            }
            if (OpenEstateType.HOUSE.equals((Object)openEstateType)) {
                return BuildingType.OTHER;
            }
            if (OpenEstateType.VILLA.equals((Object)openEstateType)) {
                return BuildingType.VILLA;
            }
            if (!OpenEstateType.TWO_FAMILY_HOUSE.equals((Object)openEstateType) && !OpenEstateType.DUPLEX_HOUSE.equals((Object)openEstateType)) continue;
            return BuildingType.MULTI_FAMILY_HOUSE;
        }
        return BuildingType.OTHER;
    }

    protected CommercializationType getEstateCommercializationType(EstateImpl estateImpl, boolean bl) {
        OpenEstateAction openEstateAction = estateImpl.getAction();
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            return CommercializationType.BUY;
        }
        if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            return bl ? CommercializationType.RENT : CommercializationType.LEASE;
        }
        if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            return CommercializationType.LEASEHOLD;
        }
        if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            return CommercializationType.RENT;
        }
        if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            return CommercializationType.RENT;
        }
        return null;
    }

    protected CompulsoryAuctionType getEstateCompulsoryAuctionType(EstateImpl estateImpl, List<OpenEstateType> list) {
        if (list.contains(OpenEstateType.HOUSE)) {
            return CompulsoryAuctionType.FAMILY_HOUSE;
        }
        if (list.contains(OpenEstateType.RESIDENCE)) {
            return CompulsoryAuctionType.FREEHOLD_FLAT;
        }
        if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            return CompulsoryAuctionType.LOT;
        }
        if (list.contains(OpenEstateType.GENERAL_COMMERCIAL) || Usage.hasOption((EstateImpl)estateImpl, (Usage.Option)Usage.Option.COMMERCIAL)) {
            return CompulsoryAuctionType.BUSINESS_AND_YIELD;
        }
        return CompulsoryAuctionType.GARAGE_AND_OTHER;
    }

    protected RealEstateCondition getEstateCondition(EstateImpl estateImpl) {
        ConditionType.Option option = ConditionType.get((EstateImpl)estateImpl);
        if (ConditionType.Option.CONDEMNED.equals((Object)option)) {
            return RealEstateCondition.RIPE_FOR_DEMOLITION;
        }
        if (ConditionType.Option.EXCELLENT.equals((Object)option)) {
            return RealEstateCondition.WELL_KEPT;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY.equals((Object)option)) {
            return RealEstateCondition.FIRST_TIME_USE;
        }
        if (ConditionType.Option.FIRST_OCCUPANCY_AFTER_REFURBISHMENT.equals((Object)option)) {
            return RealEstateCondition.FIRST_TIME_USE_AFTER_REFURBISHMENT;
        }
        if (ConditionType.Option.WELL_TENDED.equals((Object)option)) {
            return RealEstateCondition.WELL_KEPT;
        }
        if (ConditionType.Option.GOOD.equals((Object)option)) {
            return RealEstateCondition.WELL_KEPT;
        }
        if (ConditionType.Option.MODERNIZED.equals((Object)option)) {
            return RealEstateCondition.MODERNIZED;
        }
        if (ConditionType.Option.AS_APPOINTED.equals((Object)option)) {
            return RealEstateCondition.NEGOTIABLE;
        }
        if (ConditionType.Option.AS_GOOD_AS_NEW.equals((Object)option)) {
            return RealEstateCondition.MINT_CONDITION;
        }
        if (ConditionType.Option.FULLY_RENOVATED.equals((Object)option)) {
            return RealEstateCondition.FULLY_RENOVATED;
        }
        if (ConditionType.Option.PARTIAL_RENOVATION_REQUIRED.equals((Object)option)) {
            return RealEstateCondition.NEED_OF_RENOVATION;
        }
        if (ConditionType.Option.COMPLETE_RENOVATION_REQUIRED.equals((Object)option)) {
            return RealEstateCondition.NEED_OF_RENOVATION;
        }
        if (ConditionType.Option.FULLY_REFURBISHED.equals((Object)option)) {
            return RealEstateCondition.REFURBISHED;
        }
        return RealEstateCondition.NO_INFORMATION;
    }

    protected ConstructionPhaseType getEstateConstructionPhaseType(EstateImpl estateImpl) {
        ConstructionPhase.Option option = ConstructionPhase.get((EstateImpl)estateImpl);
        if (ConstructionPhase.Option.COMPLETED.equals((Object)option)) {
            return ConstructionPhaseType.COMPLETED;
        }
        if (ConstructionPhase.Option.UNDER_CONSTRUCTION.equals((Object)option)) {
            return ConstructionPhaseType.UNDER_CONSTRUCTION;
        }
        if (ConstructionPhase.Option.PLANNED.equals((Object)option)) {
            return ConstructionPhaseType.PROJECTED;
        }
        return ConstructionPhaseType.NO_INFORMATION;
    }

    protected CourtageInfo getEstateCourtageInfo(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        CourtageInfo courtageInfo = objectFactory.createCourtageInfo();
        if (estateImpl.hasAttribute(OpenEstateAttrib.PRICES_AGENT_FEE)) {
            String string = AgentFee.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage());
            courtageInfo.setCourtage(StringUtils.trimToNull((String)string));
            if (StringUtils.isBlank((CharSequence)string)) {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
            } else if (string.equalsIgnoreCase("keine")) {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
            } else if (string.equalsIgnoreCase("nein")) {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
            } else if (string.equalsIgnoreCase("frei")) {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
            } else if (string.equalsIgnoreCase("provisionsfrei")) {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
            } else {
                courtageInfo.setHasCourtage(YesNoNotApplicableType.YES);
            }
        } else {
            courtageInfo.setHasCourtage(YesNoNotApplicableType.NO);
        }
        if (YesNoNotApplicableType.YES.equals((Object)courtageInfo.getHasCourtage())) {
            courtageInfo.setCourtageNote(StringUtils.trimToNull((String)AgentFeeInformation.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        return courtageInfo;
    }

    protected Boolean getEstateEnergyCertificateAvailable(EstateImpl estateImpl) {
        return Available.get((EstateImpl)estateImpl);
    }

    protected EnergyEfficiencyClass getEstateEnergyCertificateClass(EstateImpl estateImpl) {
        EfficiencyCategory.Option option = EfficiencyCategory.get((EstateImpl)estateImpl);
        if (EfficiencyCategory.Option.A_PLUS.equals((Object)option)) {
            return EnergyEfficiencyClass.A_PLUS;
        }
        if (EfficiencyCategory.Option.A.equals((Object)option)) {
            return EnergyEfficiencyClass.A;
        }
        if (EfficiencyCategory.Option.B.equals((Object)option)) {
            return EnergyEfficiencyClass.B;
        }
        if (EfficiencyCategory.Option.C.equals((Object)option)) {
            return EnergyEfficiencyClass.C;
        }
        if (EfficiencyCategory.Option.D.equals((Object)option)) {
            return EnergyEfficiencyClass.D;
        }
        if (EfficiencyCategory.Option.E.equals((Object)option)) {
            return EnergyEfficiencyClass.E;
        }
        if (EfficiencyCategory.Option.F.equals((Object)option)) {
            return EnergyEfficiencyClass.F;
        }
        if (EfficiencyCategory.Option.G.equals((Object)option)) {
            return EnergyEfficiencyClass.G;
        }
        if (EfficiencyCategory.Option.H.equals((Object)option)) {
            return EnergyEfficiencyClass.H;
        }
        return null;
    }

    protected EnergyCertificateCreationDate getEstateEnergyCertificateDate(EstateImpl estateImpl) {
        Date date = CreationDate.get((EstateImpl)estateImpl);
        if (date == null) {
            return EnergyCertificateCreationDate.NOT_APPLICABLE;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, 2014);
        calendar.set(2, 4);
        calendar.set(5, 1);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return date.before(calendar.getTime()) ? EnergyCertificateCreationDate.BEFORE_01_MAY_2014 : EnergyCertificateCreationDate.FROM_01_MAY_2014;
    }

    protected BuildingEnergyRatingType getEstateEnergyCertificateType(EstateImpl estateImpl) {
        Type.Option option = Type.get((EstateImpl)estateImpl);
        if (Type.Option.CONSUMPTION.equals((Object)option)) {
            return BuildingEnergyRatingType.ENERGY_CONSUMPTION;
        }
        if (Type.Option.DEMAND.equals((Object)option)) {
            return BuildingEnergyRatingType.ENERGY_REQUIRED;
        }
        return null;
    }

    protected BigDecimal getEstateEnergyValue(EstateImpl estateImpl, BuildingEnergyRatingType buildingEnergyRatingType) {
        BigDecimal bigDecimal = BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType) ? DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR) : ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
        return bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : null;
    }

    protected EnergySourcesEnev2014 getEstateFiringTypes(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        EnergySourcesEnev2014 energySourcesEnev2014 = objectFactory.createEnergySourcesEnev2014();
        List list = TypeOfBeaconing.getAsList((EstateImpl)estateImpl);
        if (list.contains(TypeOfBeaconing.Option.COAL)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.COAL);
        }
        if (list.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.DISTRICT_HEATING);
        }
        if (list.contains(TypeOfBeaconing.Option.ELECTRICS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.ELECTRICITY);
        }
        if (list.contains(TypeOfBeaconing.Option.GAS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.GAS);
        }
        if (list.contains(TypeOfBeaconing.Option.GEOTHERMICS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.GEOTHERMAL);
        }
        if (list.contains(TypeOfBeaconing.Option.LIQUID_GAS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.LIQUID_GAS);
        }
        if (list.contains(TypeOfBeaconing.Option.OIL)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.OIL);
        }
        if (list.contains(TypeOfBeaconing.Option.PELLETS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.PELLET_HEATING);
        }
        if (list.contains(TypeOfBeaconing.Option.SOLAR)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.SOLAR_HEATING);
        }
        if (list.contains(TypeOfBeaconing.Option.WOOD)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.WOOD);
        }
        if (list.contains(TypeOfBeaconing.Option.WOODCHIPS)) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.WOOD_CHIPS);
        }
        if (energySourcesEnev2014.getEnergySourceEnev2014().isEmpty()) {
            energySourcesEnev2014.getEnergySourceEnev2014().add(EnergySourceEnev2014.NO_INFORMATION);
        }
        return energySourcesEnev2014;
    }

    protected HouseTypeBuildingType getEstateHouseTypeBuildingType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.APARTMENT_BUILDING;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.BUNGALOW;
            }
            if (OpenEstateType.TOWN_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.CITY_VILLA;
            }
            if (OpenEstateType.COUNTRY_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.COUNTRY_HOUSE;
            }
            if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.ONE_FAMILY_HOUSE;
            }
            if (OpenEstateType.SEMIDETACHED_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.SEMI_DETACHED_HOUSE;
            }
            if (OpenEstateType.DUPLEX_HOUSE.equals((Object)openEstateType)) {
                return HouseTypeBuildingType.SEMI_DETACHED_HOUSE_PAIR;
            }
            if (!OpenEstateType.VILLA.equals((Object)openEstateType)) continue;
            return HouseTypeBuildingType.VILLA;
        }
        return HouseTypeBuildingType.NO_INFORMATION;
    }

    protected FlatMateGenderType getEstateFlatMateGenderType(EstateImpl estateImpl) {
        if (estateImpl == null) {
            return FlatMateGenderType.MALE_OR_FEMALE;
        }
        GenderOfRequestedFlatmates.Option option = GenderOfRequestedFlatmates.get((EstateImpl)estateImpl);
        if (GenderOfRequestedFlatmates.Option.FEMALE.equals((Object)option)) {
            return FlatMateGenderType.FEMALE;
        }
        if (GenderOfRequestedFlatmates.Option.MALE.equals((Object)option)) {
            return FlatMateGenderType.MALE;
        }
        return FlatMateGenderType.MALE_OR_FEMALE;
    }

    protected FlooringType getEstateFlooringType(EstateImpl estateImpl) {
        List list = FlooringMaterial.getAsList((EstateImpl)estateImpl);
        if (list.contains(FlooringMaterial.Option.CONCRETE)) {
            return FlooringType.CONCRETE;
        }
        if (list.contains(FlooringMaterial.Option.FLOOR_BOARDS) || list.contains(FlooringMaterial.Option.FLOOR_BOARDS_POLISHED)) {
            return FlooringType.PLANKS;
        }
        if (list.contains(FlooringMaterial.Option.EPOXY_RESIN)) {
            return FlooringType.EPOXY_RESIN;
        }
        if (list.contains(FlooringMaterial.Option.TILES) || list.contains(FlooringMaterial.Option.CERAMIC) || list.contains(FlooringMaterial.Option.TERRACOTTA)) {
            return FlooringType.TILES;
        }
        if (list.contains(FlooringMaterial.Option.LAMINATE)) {
            return FlooringType.LAMINATE;
        }
        if (list.contains(FlooringMaterial.Option.PARQUET)) {
            return FlooringType.PARQUET;
        }
        if (list.contains(FlooringMaterial.Option.PVC)) {
            return FlooringType.PVC;
        }
        if (list.contains(FlooringMaterial.Option.STONE) || list.contains(FlooringMaterial.Option.GRANITE) || list.contains(FlooringMaterial.Option.MARBLE) || list.contains(FlooringMaterial.Option.SLATE)) {
            return FlooringType.STONE;
        }
        if (list.contains(FlooringMaterial.Option.CARPET)) {
            return FlooringType.CARPET;
        }
        if (list.contains(FlooringMaterial.Option.CARPET_ANTISTATIC)) {
            return FlooringType.ANTISTATIC_FLOOR;
        }
        return FlooringType.NO_INFORMATION;
    }

    protected YesNoNotApplicableType getEstateFurnishing(EstateImpl estateImpl) {
        Furnished.Option option = Furnished.get((EstateImpl)estateImpl);
        if (Furnished.Option.YES.equals((Object)option)) {
            return YesNoNotApplicableType.YES;
        }
        if (Furnished.Option.NO.equals((Object)option)) {
            return YesNoNotApplicableType.NO;
        }
        return YesNoNotApplicableType.NOT_APPLICABLE;
    }

    protected GarageType getEstateGarageType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.OUTDOOR_CAR_PARKING_SPACE.equals((Object)openEstateType)) {
                return GarageType.STREET_PARKING;
            }
            if (OpenEstateType.CARPORT.equals((Object)openEstateType)) {
                return GarageType.CARPORT;
            }
            if (OpenEstateType.DUPLEX_GARAGE.equals((Object)openEstateType)) {
                return GarageType.DUPLEX;
            }
            if (OpenEstateType.GARAGE.equals((Object)openEstateType)) {
                return GarageType.GARAGE;
            }
            if (OpenEstateType.CAR_PARK.equals((Object)openEstateType)) {
                return GarageType.CAR_PARK;
            }
            if (!OpenEstateType.UNDERGROUND_CAR_PARK.equals((Object)openEstateType)) continue;
            return GarageType.UNDERGROUND_GARAGE;
        }
        return GarageType.NO_INFORMATION;
    }

    protected GastronomyType getEstateGastronomyType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.RESTAURANT_BAR.equals((Object)openEstateType)) {
                return GastronomyType.BAR_LOUNGE;
            }
            if (OpenEstateType.BISTRO_CAFE.equals((Object)openEstateType)) {
                return GastronomyType.CAFE;
            }
            if (OpenEstateType.DISCOTHEQUE.equals((Object)openEstateType)) {
                return GastronomyType.CLUB_DISCO;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return GastronomyType.BUNGALOW;
            }
            if (OpenEstateType.HOSPITALITY_INDUSTRY.equals((Object)openEstateType)) {
                return GastronomyType.GUESTS_HOUSE;
            }
            if (OpenEstateType.HOSTEL.equals((Object)openEstateType)) {
                return GastronomyType.HOTEL;
            }
            if (OpenEstateType.HOTEL.equals((Object)openEstateType)) {
                return GastronomyType.HOTEL;
            }
            if (OpenEstateType.GUESTHOUSE.equals((Object)openEstateType)) {
                return GastronomyType.PENSION;
            }
            if (!OpenEstateType.RESTAURANT.equals((Object)openEstateType)) continue;
            return GastronomyType.RESTAURANT;
        }
        return GastronomyType.TAVERN;
    }

    protected HeatingTypeEnev2014 getEstateHeatingType(EstateImpl estateImpl) {
        List list = TypeOfBeaconing.getAsList((EstateImpl)estateImpl);
        List list2 = TypeOfHeating.getAsList((EstateImpl)estateImpl);
        if (list.contains(TypeOfBeaconing.Option.DISTRICT_HEATING)) {
            return HeatingTypeEnev2014.DISTRICT_HEATING;
        }
        if (list.contains(TypeOfBeaconing.Option.ELECTRICS)) {
            return HeatingTypeEnev2014.ELECTRIC_HEATING;
        }
        if (list.contains(TypeOfBeaconing.Option.GAS)) {
            return HeatingTypeEnev2014.GAS_HEATING;
        }
        if (list.contains(TypeOfBeaconing.Option.AIR_TO_WATER_HEAT_PUMP)) {
            return HeatingTypeEnev2014.HEAT_PUMP;
        }
        if (list.contains(TypeOfBeaconing.Option.OIL)) {
            return HeatingTypeEnev2014.OIL_HEATING;
        }
        if (list.contains(TypeOfBeaconing.Option.SOLAR)) {
            return HeatingTypeEnev2014.SOLAR_HEATING;
        }
        if (list.contains(TypeOfBeaconing.Option.PELLETS) || list.contains(TypeOfBeaconing.Option.WOODCHIPS)) {
            return HeatingTypeEnev2014.WOOD_PELLET_HEATING;
        }
        if (list2.contains(TypeOfHeating.Option.CENTRAL)) {
            return HeatingTypeEnev2014.CENTRAL_HEATING;
        }
        if (list2.contains(TypeOfHeating.Option.SELF_CONTAINED_CENTRAL)) {
            return HeatingTypeEnev2014.SELF_CONTAINED_CENTRAL_HEATING;
        }
        if (list2.contains(TypeOfHeating.Option.OVEN)) {
            return HeatingTypeEnev2014.STOVE_HEATING;
        }
        if (list2.contains(TypeOfHeating.Option.UNDERFLOOR)) {
            return HeatingTypeEnev2014.FLOOR_HEATING;
        }
        return HeatingTypeEnev2014.NO_INFORMATION;
    }

    protected IndustryType getEstateIndustryType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
                return IndustryType.SHOWROOM_SPACE;
            }
            if (OpenEstateType.HALL_WAREHOUSE.equals((Object)openEstateType)) {
                return IndustryType.HALL;
            }
            if (OpenEstateType.HIGH_RACK_WAREHOUSE.equals((Object)openEstateType)) {
                return IndustryType.HIGH_LACK_STORAGE;
            }
            if (OpenEstateType.INDUSTRIAL_WAREHOUSE.equals((Object)openEstateType)) {
                return IndustryType.INDUSTRY_HALL;
            }
            if (OpenEstateType.INDUSTRIAL_WAREHOUSE_WITH_OPEN_SPACE.equals((Object)openEstateType)) {
                return IndustryType.INDUSTRY_HALL_WITH_OPEN_AREA;
            }
            if (OpenEstateType.COOLING_HOUSE.equals((Object)openEstateType)) {
                return IndustryType.COLD_STORAGE;
            }
            if (OpenEstateType.COLD_STORAGE_WAREHOUSE.equals((Object)openEstateType)) {
                return IndustryType.MULTIDECK_CABINET_STORAGE;
            }
            if (OpenEstateType.STORAGE_AREA.equals((Object)openEstateType)) {
                return IndustryType.STORAGE_AREA;
            }
            if (OpenEstateType.SERVICE_AREA.equals((Object)openEstateType)) {
                return IndustryType.SERVICE_AREA;
            }
            if (OpenEstateType.FORWARDING_WAREHOUSE.equals((Object)openEstateType)) {
                return IndustryType.SHIPPING_STORAGE;
            }
            if (!OpenEstateType.WORKSHOP.equals((Object)openEstateType)) continue;
            return IndustryType.REPAIR_SHOP;
        }
        return IndustryType.STORAGE_AREA;
    }

    protected InteriorQuality getEstateInteriorQuality(EstateImpl estateImpl) {
        Equipment.Option option = Equipment.get((EstateImpl)estateImpl);
        if (Equipment.Option.BASIC.equals((Object)option)) {
            return InteriorQuality.SIMPLE;
        }
        if (Equipment.Option.EXCLUSIVE.equals((Object)option)) {
            return InteriorQuality.SOPHISTICATED;
        }
        if (Equipment.Option.LUXURY.equals((Object)option)) {
            return InteriorQuality.LUXURY;
        }
        if (Equipment.Option.STANDARD.equals((Object)option)) {
            return InteriorQuality.NORMAL;
        }
        return null;
    }

    protected InvestmentType getEstateInvestmentType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.OFFICE_BUILDING.equals((Object)openEstateType)) {
                return InvestmentType.OFFICE_BUILDING;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return InvestmentType.FREEHOLD_FLAT;
            }
            if (OpenEstateType.SINGLE_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return InvestmentType.SINGLE_FAMILY_HOUSE;
            }
            if (OpenEstateType.SHOPPING_CENTER.equals((Object)openEstateType)) {
                return InvestmentType.SHOPPING_CENTRE;
            }
            if (OpenEstateType.LEISURE_SPORTS_FACILITY.equals((Object)openEstateType)) {
                return InvestmentType.LEISURE_FACILITY;
            }
            if (OpenEstateType.GASTRONOMY.equals((Object)openEstateType)) {
                return InvestmentType.RESTAURANT;
            }
            if (OpenEstateType.COMMERCIAL_BUILDING.equals((Object)openEstateType)) {
                return InvestmentType.COMMERCIAL_BUILDING;
            }
            if (OpenEstateType.COMMERCIAL_CENTER.equals((Object)openEstateType)) {
                return InvestmentType.COMMERCIAL_PROPERTY;
            }
            if (OpenEstateType.HALL_WAREHOUSE.equals((Object)openEstateType)) {
                return InvestmentType.HALL_STORAGE;
            }
            if (OpenEstateType.HOSTEL.equals((Object)openEstateType) || OpenEstateType.HOTEL.equals((Object)openEstateType)) {
                return InvestmentType.HOTEL;
            }
            if (OpenEstateType.PRODUCTION.equals((Object)openEstateType)) {
                return InvestmentType.INDUSTRIAL_PROPERTY;
            }
            if (OpenEstateType.RETAIL.equals((Object)openEstateType)) {
                return InvestmentType.SHOP_SALES_FLOOR;
            }
            if (OpenEstateType.MULTI_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return InvestmentType.MULTI_FAMILY_HOUSE;
            }
            if (OpenEstateType.SERVICE_CENTER.equals((Object)openEstateType)) {
                return InvestmentType.SERVICE_CENTRE;
            }
            if (OpenEstateType.GENERAL_COMMERCIAL.equals((Object)openEstateType)) {
                return InvestmentType.OTHER;
            }
            if (OpenEstateType.CONSUMER_STORE.equals((Object)openEstateType)) {
                return InvestmentType.SUPERMARKET;
            }
            if (OpenEstateType.HOUSING_COMPLEX.equals((Object)openEstateType)) {
                return InvestmentType.HOUSING_ESTATE;
            }
            if (!OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING.equals((Object)openEstateType)) continue;
            return InvestmentType.LIVING_BUSINESS_HOUSE;
        }
        return InvestmentType.OTHER;
    }

    protected ItInfrastructureType getEstateItInfrastructureType(EstateImpl estateImpl) {
        Boolean bl = Technics.hasOption((EstateImpl)estateImpl, (Technics.Option)Technics.Option.DV_CABLING);
        if (Boolean.TRUE.equals(bl)) {
            return ItInfrastructureType.YES;
        }
        return ItInfrastructureType.NO_INFORMATION;
    }

    protected LocationClassificationType getEstateLocationClassificationType(EstateImpl estateImpl) {
        CommercialZone.Option option = CommercialZone.get((EstateImpl)estateImpl);
        if (CommercialZone.Option.LOCATION_A.equals((Object)option) || CommercialZone.Option.LOCATION_1A.equals((Object)option) || CommercialZone.Option.LOCATION_2A.equals((Object)option)) {
            return LocationClassificationType.CLASSIFICATION_A;
        }
        if (CommercialZone.Option.LOCATION_B.equals((Object)option) || CommercialZone.Option.LOCATION_1B.equals((Object)option) || CommercialZone.Option.LOCATION_2B.equals((Object)option)) {
            return LocationClassificationType.CLASSIFICATION_B;
        }
        if (CommercialZone.Option.SHOPPING_CENTER.equals((Object)option)) {
            return LocationClassificationType.SHOPPING_CENTRE;
        }
        return LocationClassificationType.NO_INFORMATION;
    }

    protected Price getEstateLowestBid(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = LowestBid.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        price.setMarketingType(MarketingType.PURCHASE);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected Price getEstateMarketValue(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = MarketValue.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 0) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        price.setMarketingType(MarketingType.PURCHASE);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    @SuppressFBWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="NULL is an expected return value.")
    protected Boolean getEstateNonSmoker(EstateImpl estateImpl) {
        NonSmoker.Option option = NonSmoker.get((EstateImpl)estateImpl);
        if (NonSmoker.Option.YES.equals((Object)option)) {
            return true;
        }
        if (NonSmoker.Option.INDIFFERENT.equals((Object)option)) {
            return false;
        }
        if (NonSmoker.Option.NO.equals((Object)option)) {
            return false;
        }
        return null;
    }

    protected OfficeType getEstateOfficeType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.ATELIER.equals((Object)openEstateType)) {
                return OfficeType.STUDIO;
            }
            if (OpenEstateType.OFFICE.equals((Object)openEstateType)) {
                return OfficeType.OFFICE;
            }
            if (OpenEstateType.OFFICE_BUILDING.equals((Object)openEstateType)) {
                return OfficeType.OFFICE_BUILDING;
            }
            if (OpenEstateType.OFFICE_CENTER.equals((Object)openEstateType)) {
                return OfficeType.OFFICE_CENTRE;
            }
            if (OpenEstateType.OFFICE_FLOOR.equals((Object)openEstateType)) {
                return OfficeType.OFFICE_FLOOR;
            }
            if (OpenEstateType.OFFICE_COMMERCIAL_BUILDING.equals((Object)openEstateType)) {
                return OfficeType.OFFICE_AND_COMMERCIAL_BUILDING;
            }
            if (OpenEstateType.COMMERCIAL_CENTER.equals((Object)openEstateType)) {
                return OfficeType.COMMERCIAL_CENTRE;
            }
            if (OpenEstateType.LOFT.equals((Object)openEstateType)) {
                return OfficeType.LOFT;
            }
            if (OpenEstateType.SURGERY.equals((Object)openEstateType)) {
                return OfficeType.SURGERY;
            }
            if (OpenEstateType.SURGERY_FLOOR.equals((Object)openEstateType)) {
                return OfficeType.SURGERY_FLOOR;
            }
            if (OpenEstateType.DOCTORS_OFFICE_HOUSE.equals((Object)openEstateType)) {
                return OfficeType.SURGERY_BUILDING;
            }
            if (!OpenEstateType.RESIDENTIAL_COMMERCIAL_BUILDING.equals((Object)openEstateType)) continue;
            return OfficeType.LIVING_AND_COMMERCIAL_BUILDING;
        }
        return OfficeType.OFFICE;
    }

    protected ParkingSpaceType getEstateParkingSpaceType(EstateImpl estateImpl) {
        List list = CarParkingType.getAsList((EstateImpl)estateImpl);
        if (list.contains(CarParkingType.Option.OUTDOOR)) {
            return ParkingSpaceType.OUTSIDE;
        }
        if (list.contains(CarParkingType.Option.CARPORT)) {
            return ParkingSpaceType.CARPORT;
        }
        if (list.contains(CarParkingType.Option.DUPLEX_GARAGE)) {
            return ParkingSpaceType.DUPLEX;
        }
        if (list.contains(CarParkingType.Option.GARAGE)) {
            return ParkingSpaceType.GARAGE;
        }
        if (list.contains(CarParkingType.Option.AT_MULTI_STOREY_CAR_PARK)) {
            return ParkingSpaceType.CAR_PARK;
        }
        if (list.contains(CarParkingType.Option.AT_UNDERGROUND_CAR_PARK)) {
            return ParkingSpaceType.UNDERGROUND_GARAGE;
        }
        return ParkingSpaceType.NO_INFORMATION;
    }

    protected PetsAllowedType getEstatePetsAllowedType(EstateImpl estateImpl) {
        Pets.Option option = Pets.get((EstateImpl)estateImpl);
        if (Pets.Option.YES.equals((Object)option)) {
            return PetsAllowedType.YES;
        }
        if (Pets.Option.NO.equals((Object)option)) {
            return PetsAllowedType.NO;
        }
        if (Pets.Option.AS_APPOINTED.equals((Object)option)) {
            return PetsAllowedType.NEGOTIABLE;
        }
        return PetsAllowedType.NO_INFORMATION;
    }

    protected Price getEstatePrice(EstateImpl estateImpl, List<OpenEstateType> list, boolean bl, boolean bl2) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        OpenEstateAction openEstateAction = estateImpl.getAction();
        if (openEstateAction == null) {
            return null;
        }
        Price price = objectFactory.createPrice();
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency (" + estateImpl.getCurrency() + ")!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            price.setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
            if (bl && estateImpl.isHiddenPrices()) {
                price.setMarketingType(MarketingType.PURCHASE);
                price.setValue(BigDecimal.ZERO);
            } else {
                BigDecimal bigDecimal = PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl);
                if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    price.setMarketingType(MarketingType.PURCHASE);
                    price.setValue(bigDecimal);
                } else {
                    bigDecimal = PurchasePricePerArea.getAsBigDecimal((EstateImpl)estateImpl);
                    if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        price.setMarketingType(MarketingType.PURCHASE_PER_SQM);
                        price.setValue(bigDecimal);
                    }
                }
            }
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
            if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                price.setPriceIntervalType(PriceIntervalType.YEAR);
            } else {
                price.setPriceIntervalType(PriceIntervalType.MONTH);
            }
            if (bl && estateImpl.isHiddenPrices()) {
                price.setMarketingType(MarketingType.RENT);
                price.setValue(BigDecimal.ZERO);
            } else {
                BigDecimal bigDecimal = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
                if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    price.setMarketingType(MarketingType.RENT);
                    price.setValue(bigDecimal);
                } else {
                    bigDecimal = RentExcludingServiceChargesPerArea.getAsBigDecimal((EstateImpl)estateImpl);
                    if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        price.setMarketingType(MarketingType.RENT_PER_SQM);
                        price.setValue(bigDecimal);
                    }
                }
            }
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            price.setMarketingType(MarketingType.RENT);
            if (bl && estateImpl.isHiddenPrices()) {
                price.setPriceIntervalType(PriceIntervalType.MONTH);
                price.setValue(BigDecimal.ZERO);
            } else {
                BigDecimal bigDecimal = RentFlatRate.getAsBigDecimal((EstateImpl)estateImpl);
                if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                    price.setValue(bigDecimal);
                    RentFlatRatePer.Option option = RentFlatRatePer.get((EstateImpl)estateImpl);
                    if (RentFlatRatePer.Option.DAY.equals((Object)option)) {
                        price.setPriceIntervalType(PriceIntervalType.DAY);
                    } else if (RentFlatRatePer.Option.MONTH.equals((Object)option)) {
                        price.setPriceIntervalType(PriceIntervalType.MONTH);
                    } else if (RentFlatRatePer.Option.WEEK.equals((Object)option)) {
                        price.setPriceIntervalType(PriceIntervalType.WEEK);
                    } else if (RentFlatRatePer.Option.YEAR.equals((Object)option)) {
                        price.setPriceIntervalType(PriceIntervalType.YEAR);
                    } else {
                        price.setPriceIntervalType(PriceIntervalType.MONTH);
                    }
                } else {
                    price.setPriceIntervalType(PriceIntervalType.MONTH);
                    bigDecimal = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
                    if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                        price.setMarketingType(MarketingType.RENT);
                        price.setValue(bigDecimal);
                    } else {
                        bigDecimal = RentExcludingServiceChargesPerArea.getAsBigDecimal((EstateImpl)estateImpl);
                        if (bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
                            price.setMarketingType(MarketingType.RENT_PER_SQM);
                            price.setValue(bigDecimal);
                        }
                    }
                }
            }
        } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
            if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                price.setPriceIntervalType(PriceIntervalType.YEAR);
            } else {
                price.setPriceIntervalType(PriceIntervalType.MONTH);
            }
            if (bl2) {
                price.setMarketingType(MarketingType.RENT);
                if (bl && estateImpl.isHiddenPrices()) {
                    price.setValue(BigDecimal.ZERO);
                } else {
                    price.setValue(Lease.getAsBigDecimal((EstateImpl)estateImpl));
                }
            } else {
                price.setMarketingType(MarketingType.LEASE);
                if (bl && estateImpl.isHiddenPrices()) {
                    price.setValue(BigDecimal.ZERO);
                } else {
                    price.setValue(Lease.getAsBigDecimal((EstateImpl)estateImpl));
                }
            }
        } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
            if (list.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
                price.setPriceIntervalType(PriceIntervalType.YEAR);
            } else {
                price.setPriceIntervalType(PriceIntervalType.MONTH);
            }
            price.setMarketingType(MarketingType.LEASEHOLD);
            if (bl && estateImpl.isHiddenPrices()) {
                price.setValue(BigDecimal.ZERO);
            } else {
                price.setValue(Lease.getAsBigDecimal((EstateImpl)estateImpl));
            }
        }
        return price;
    }

    protected PublishChannels getEstatePublishChannels(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        PublishChannels publishChannels = objectFactory.createPublishChannels();
        PublishChannel publishChannel = objectFactory.createPublishChannel();
        publishChannel.setId(Long.valueOf(10000L));
        publishChannel.setTitle("Immobilienscout24");
        publishChannels.getPublishChannel().add(publishChannel);
        PublishChannel publishChannel2 = objectFactory.createPublishChannel();
        publishChannel2.setId(Long.valueOf(10001L));
        publishChannel2.setTitle("Homepage");
        publishChannels.getPublishChannel().add(publishChannel2);
        return publishChannels;
    }

    protected Price getEstatePurchasePrice(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = PurchasePrice.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        price.setMarketingType(MarketingType.PURCHASE);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected Price getEstatePurchasePricePerSqm(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = PurchasePricePerArea.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.ONE_TIME_CHARGE);
        price.setMarketingType(MarketingType.PURCHASE_PER_SQM);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected Price getEstateRentalIncomeActual(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = RentalIncomeActualPerAnnum.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.YEAR);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected Price getEstateRentalIncomeDebit(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        BigDecimal bigDecimal = RentalIncomeDebitPerAnnum.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            return null;
        }
        Price price = objectFactory.createPrice();
        price.setPriceIntervalType(PriceIntervalType.YEAR);
        price.setValue(bigDecimal);
        try {
            price.setCurrency(Currency.fromValue((String)estateImpl.getCurrency().getCurrencyCode()));
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set currency!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        return price;
    }

    protected ShortTermAccommodationType getEstateShortTermAccommodationType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.APARTMENT.equals((Object)openEstateType)) {
                return ShortTermAccommodationType.APARTMENT;
            }
            if (OpenEstateType.HOUSE.equals((Object)openEstateType)) {
                return ShortTermAccommodationType.HOUSE;
            }
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return ShortTermAccommodationType.FLAT;
            }
            if (!OpenEstateType.ROOM.equals((Object)openEstateType)) continue;
            return ShortTermAccommodationType.ROOM;
        }
        return ShortTermAccommodationType.FLAT;
    }

    protected SiteRecommendedUseForTradeTypes getEstateSiteRecommendedUseForTradeTypes(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        List list = BuildableWith.getAsList((EstateImpl)estateImpl);
        SiteRecommendedUseForTradeTypes siteRecommendedUseForTradeTypes = objectFactory.createSiteRecommendedUseForTradeTypes();
        if (list.contains(BuildableWith.Option.FARMLAND)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.FARMLAND);
        }
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.FUTURE_DEVELOPMENT_LAND);
        }
        if (list.contains(BuildableWith.Option.JETTY)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.MOORAGE);
        }
        if (list.contains(BuildableWith.Option.OFFICE)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.OFFICE);
        }
        if (list.contains(BuildableWith.Option.CAMPING)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.CAMPING);
        }
        if (list.contains(BuildableWith.Option.RETAIL_LARGE)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.BIG_STORE);
        }
        if (list.contains(BuildableWith.Option.RETAIL_SMALL)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.LITTLE_STORE);
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.GARAGE);
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.GARDEN);
        }
        if (list.contains(BuildableWith.Option.GASTRONOMY)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.GASTRONOMY);
        }
        if (list.contains(BuildableWith.Option.BUSINESS_BIG)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.BUSINESS);
        }
        if (list.contains(BuildableWith.Option.HOTEL)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.HOTEL);
        }
        if (list.contains(BuildableWith.Option.INDUSTRY)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.INDUSTRY);
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.NO_DEVELOPMENT);
        }
        if (list.contains(BuildableWith.Option.BUSINESS_SMALL)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.SMALL_BUSINESS);
        }
        if (list.contains(BuildableWith.Option.WAREHOUSE)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.STOCK);
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.ORCHARD);
        }
        if (list.contains(BuildableWith.Option.PARKING_STRUCTURE)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.CAR_PARK);
        }
        if (list.contains(BuildableWith.Option.PRODUCTION)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.PRODUCTION);
        }
        if (list.contains(BuildableWith.Option.CAR_PARKING_SPACES)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.GARAGE);
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.FORREST);
        }
        if (siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().isEmpty()) {
            siteRecommendedUseForTradeTypes.getSiteRecommendedUseForTradeType().add(SiteRecommendedUseForTradeType.NO_INFORMATION);
        }
        return siteRecommendedUseForTradeTypes;
    }

    protected SiteRecommendedUseTypes getEstateSiteRecommendedUseTypes(EstateImpl estateImpl) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        List list = BuildableWith.getAsList((EstateImpl)estateImpl);
        SiteRecommendedUseTypes siteRecommendedUseTypes = objectFactory.createSiteRecommendedUseTypes();
        if (list.contains(BuildableWith.Option.DEVELOPMENT_AREA)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.FUTURE_DEVELOPMENT_LAND);
        }
        if (list.contains(BuildableWith.Option.DUPLEX_HOUSE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.TWINHOUSE);
        }
        if (list.contains(BuildableWith.Option.SINGLE_FAMILY_HOUSE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.SINGLE_FAMILY_HOUSE);
        }
        if (list.contains(BuildableWith.Option.GARAGE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.GARAGE);
        }
        if (list.contains(BuildableWith.Option.GARDEN)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.GARDEN);
        }
        if (list.contains(BuildableWith.Option.NO_DEVELOPMENT)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.NO_DEVELOPMENT);
        }
        if (list.contains(BuildableWith.Option.MULTI_FAMILY_HOUSE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.APARTMENT_BUILDING);
        }
        if (list.contains(BuildableWith.Option.FRUIT_PLANTING)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.ORCHARD);
        }
        if (list.contains(BuildableWith.Option.PARKING_STRUCTURE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.PARKING_SPACE);
        }
        if (list.contains(BuildableWith.Option.TERRACED_HOUSE)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.TERRACE_HOUSE);
        }
        if (list.contains(BuildableWith.Option.CAR_PARKING_SPACES)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.PARKING_SPACE);
        }
        if (list.contains(BuildableWith.Option.VILLA)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.VILLA);
        }
        if (list.contains(BuildableWith.Option.FOREST)) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.FORREST);
        }
        if (siteRecommendedUseTypes.getSiteRecommendedUseType().isEmpty()) {
            siteRecommendedUseTypes.getSiteRecommendedUseType().add(SiteRecommendedUseType.NO_INFORMATION);
        }
        return siteRecommendedUseTypes;
    }

    protected SmokingAllowedType getEstateSmokingAllowedType(EstateImpl estateImpl) {
        NonSmoker.Option option = NonSmoker.get((EstateImpl)estateImpl);
        if (NonSmoker.Option.YES.equals((Object)option)) {
            return SmokingAllowedType.UNWANTED;
        }
        if (NonSmoker.Option.NO.equals((Object)option)) {
            return SmokingAllowedType.ALLOWED;
        }
        return SmokingAllowedType.NO_INFORMATION;
    }

    protected SiteConstructibleType getEstateSiteConstructibleType(EstateImpl estateImpl) {
        BuildableAccordingTo.Option option = BuildableAccordingTo.get((EstateImpl)estateImpl);
        if (BuildableAccordingTo.Option.BINDING_SITE_PLAN.equals((Object)option)) {
            return SiteConstructibleType.CONSTRUCTIONPLAN;
        }
        if (BuildableAccordingTo.Option.NEIGHBORING_DEVELOPMENT.equals((Object)option)) {
            return SiteConstructibleType.NEIGHBOURCONSTRUCTION;
        }
        if (BuildableAccordingTo.Option.PERIPHERY_DEVELOPMENT.equals((Object)option)) {
            return SiteConstructibleType.EXTERNALAREA;
        }
        return SiteConstructibleType.NO_INFORMATION;
    }

    protected SiteDevelopmentType getEstateSiteDevelopmentType(EstateImpl estateImpl) {
        Development.Option option = Development.get((EstateImpl)estateImpl);
        if (Development.Option.PARTIALLY.equals((Object)option)) {
            return SiteDevelopmentType.DEVELOPED_PARTIALLY;
        }
        if (Development.Option.UNDEVELOPED.equals((Object)option)) {
            return SiteDevelopmentType.NOT_DEVELOPED;
        }
        if (Development.Option.COMPLETELY.equals((Object)option)) {
            return SiteDevelopmentType.DEVELOPED;
        }
        return SiteDevelopmentType.NO_INFORMATION;
    }

    protected SpecialPurposeType getEstateSpecialPurposeType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.FARM.equals((Object)openEstateType)) {
                return SpecialPurposeType.FARM;
            }
            if (OpenEstateType.LEISURE_SPORTS_FACILITY.equals((Object)openEstateType)) {
                return SpecialPurposeType.LEISURE_FACILITY;
            }
            if (OpenEstateType.GENERAL_COMMERCIAL.equals((Object)openEstateType)) {
                return SpecialPurposeType.INDUSTRIAL_AREA;
            }
            if (OpenEstateType.RIDING_ESTATE.equals((Object)openEstateType)) {
                return SpecialPurposeType.HORSE_FARM;
            }
            if (OpenEstateType.VINICULTURE.equals((Object)openEstateType)) {
                return SpecialPurposeType.VINEYARD;
            }
            if (!OpenEstateType.WORKSHOP.equals((Object)openEstateType)) continue;
            return SpecialPurposeType.REPAIR_SHOP;
        }
        return SpecialPurposeType.INDUSTRIAL_AREA;
    }

    protected StoreType getEstateStoreType(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.EXHIBITION_AREA.equals((Object)openEstateType)) {
                return StoreType.SHOWROOM_SPACE;
            }
            if (OpenEstateType.SHOPPING_CENTER.equals((Object)openEstateType)) {
                return StoreType.SHOPPING_CENTRE;
            }
            if (OpenEstateType.DEPARTMENT_STORE.equals((Object)openEstateType)) {
                return StoreType.DEPARTMENT_STORE;
            }
            if (OpenEstateType.KIOSK.equals((Object)openEstateType)) {
                return StoreType.KIOSK;
            }
            if (OpenEstateType.SHOP.equals((Object)openEstateType) || OpenEstateType.STORE.equals((Object)openEstateType) || OpenEstateType.PREMISE.equals((Object)openEstateType) || OpenEstateType.OFFICE_COMMERCIAL_PREMISE.equals((Object)openEstateType)) {
                return StoreType.STORE;
            }
            if (OpenEstateType.SELF_SERVICE_MARKET.equals((Object)openEstateType)) {
                return StoreType.SELF_SERVICE_MARKET;
            }
            if (OpenEstateType.SALES_AREA.equals((Object)openEstateType)) {
                return StoreType.SALES_AREA;
            }
            if (!OpenEstateType.SHOWROOM.equals((Object)openEstateType)) continue;
            return StoreType.SALES_HALL;
        }
        return StoreType.SALES_AREA;
    }

    protected SupplyType getEstateSupplyType(EstateImpl estateImpl) {
        List list = SupplyAccess.getAsList((EstateImpl)estateImpl);
        if (list.contains(SupplyAccess.Option.DIRECT_ACCESS)) {
            return SupplyType.DIRECT_APPROACH;
        }
        if (list.contains(SupplyAccess.Option.ALL_DAY)) {
            return SupplyType.FULL_TIME;
        }
        if (list.contains(SupplyAccess.Option.NO_DIRECT_ACCESS)) {
            return SupplyType.NO_DIRECT_APPROACH;
        }
        if (list.contains(SupplyAccess.Option.CAR_ACCESS)) {
            return SupplyType.CAR_APPROACH;
        }
        if (list.contains(SupplyAccess.Option.FROM_BACK_SIDE)) {
            return SupplyType.APPROACH_TO_THE_BACK;
        }
        if (list.contains(SupplyAccess.Option.FROM_FRONT_SIDE)) {
            return SupplyType.APPROACH_TO_THE_FRONT;
        }
        if (list.contains(SupplyAccess.Option.MORNING)) {
            return SupplyType.FORENOON;
        }
        return SupplyType.NO_INFORMATION;
    }

    protected TvConnectionType getEstateTvConnectionType(EstateImpl estateImpl) {
        List list = Technics.getAsList((EstateImpl)estateImpl);
        if (list.contains(Technics.Option.CABLE_SAT_TV)) {
            return TvConnectionType.CABLE_AND_SATELLITE;
        }
        if (list.contains(Technics.Option.CABLE_TV)) {
            return TvConnectionType.CABLE;
        }
        if (list.contains(Technics.Option.SAT_TV)) {
            return TvConnectionType.SATELLITE;
        }
        return TvConnectionType.NO_INFORMATION;
    }

    protected UtilizationTradeSite getEstateUtilizationTradeSite(EstateImpl estateImpl, List<OpenEstateType> list) {
        for (int i = list.size() - 1; i > -1; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.LEISURE_GROUND.equals((Object)openEstateType)) {
                return UtilizationTradeSite.LEISURE;
            }
            if (OpenEstateType.COMMERCIAL_GROUND.equals((Object)openEstateType)) {
                return UtilizationTradeSite.TRADE;
            }
            if (!OpenEstateType.AGRICULTURAL_FORESTRY_GROUND.equals((Object)openEstateType)) continue;
            return UtilizationTradeSite.AGRICULTURE_FORESTRY;
        }
        return UtilizationTradeSite.TRADE;
    }

    protected Phonenumber.PhoneNumber getPhoneNumber(String string, String string2) {
        try {
            string = StringUtils.trimToNull((String)string);
            string2 = StringUtils.trimToNull((String)string2);
            return !StringUtils.isBlank((CharSequence)string) ? PhoneNumberUtil.getInstance().parse((CharSequence)string, string2) : null;
        }
        catch (NumberParseException numberParseException) {
            LOGGER.warn("Can't parse phone number '" + string + "'!");
            LOGGER.warn("> " + numberParseException.getLocalizedMessage(), (Throwable)numberParseException);
            return null;
        }
    }

    protected String[] getPhoneNumberSegments(String string, String string2) {
        Phonenumber.PhoneNumber phoneNumber = this.getPhoneNumber(string, string2);
        if (phoneNumber == null) {
            return null;
        }
        String string3 = PhoneNumberUtil.getInstance().format(phoneNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
        return StringUtils.split((String)StringUtils.trimToNull((String)string3), (String)" ", (int)3);
    }

    protected SalutationType getSalutationType(Gender gender) {
        if (Gender.FEMALE.equals((Object)gender)) {
            return SalutationType.FEMALE;
        }
        if (Gender.MALE.equals((Object)gender)) {
            return SalutationType.MALE;
        }
        return SalutationType.NO_SALUTATION;
    }

    protected String getText(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        string = string.replaceAll("<br[^>]*>", "\n");
        string = string.replaceAll("<[^>]*>", "");
        return string;
    }

    protected YesNoNotApplicableType getYesNoNotApplicable(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return YesNoNotApplicableType.YES;
        }
        if (Boolean.FALSE.equals(bl)) {
            return YesNoNotApplicableType.NO;
        }
        return YesNoNotApplicableType.NOT_APPLICABLE;
    }

    protected YesNotApplicableType getYesNotApplicable(Boolean bl) {
        if (Boolean.TRUE.equals(bl)) {
            return YesNotApplicableType.YES;
        }
        return YesNotApplicableType.NOT_APPLICABLE;
    }

    public Attachment writeAttachment(EstateAttachmentImpl estateAttachmentImpl, List<String> list) {
        return this.writeAttachment(estateAttachmentImpl, false, list);
    }

    public Attachment writeAttachment(EstateAttachmentImpl estateAttachmentImpl, boolean bl, List<String> list) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        String string = StringUtils.trimToEmpty((String)estateAttachmentImpl.getMimeType());
        PDFDocument pDFDocument = null;
        if (string.equalsIgnoreCase("application/pdf")) {
            PDFDocument pDFDocument2 = objectFactory.createPDFDocument();
            pDFDocument2.setFloorplan(EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType()));
            pDFDocument2.setTitle(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
            pDFDocument = pDFDocument2;
        } else if (string.toLowerCase().startsWith("image/")) {
            Picture picture = objectFactory.createPicture();
            picture.setFloorplan(EstateAttachmentType.IMAGE_GROUNDPLAN.equals((Object)estateAttachmentImpl.getType()));
            picture.setTitle(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
            picture.setTitlePicture(bl);
            pDFDocument = picture;
        } else if (string.toLowerCase().startsWith("video/")) {
            StreamingVideo streamingVideo = objectFactory.createStreamingVideo();
            streamingVideo.setTitle(estateAttachmentImpl.getTitle(this.getOpenEstateLanguage()));
            pDFDocument = streamingVideo;
        }
        return pDFDocument;
    }

    public Attachment writeAttachment(EstateLinkImpl estateLinkImpl, List<String> list) {
        String string;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        Link link = null;
        if (estateLinkImpl.isWebLink()) {
            Link link2 = objectFactory.createLink();
            link2.setTitle(estateLinkImpl.getTitle(this.getOpenEstateLanguage()));
            link2.setUrl(estateLinkImpl.getWebLink());
            link = link2;
        } else if (estateLinkImpl.isProviderLink() && (string = StringUtils.trimToNull((String)estateLinkImpl.getProviderLink().getLinkId())) != null) {
            Link link3 = objectFactory.createLink();
            link3.setTitle(estateLinkImpl.getTitle(this.getOpenEstateLanguage()));
            link3.setUrl(estateLinkImpl.getProviderLink().getProvider().getUrlFromLinkId(string));
            link = link3;
        }
        return link;
    }

    public final RealtorContactDetails writeContact(AgentContactImpl agentContactImpl, List<String> list) {
        return this.writeContact(agentContactImpl, null, list);
    }

    public RealtorContactDetails writeContact(AgentContactImpl agentContactImpl, String string, List<String> list) {
        String string2;
        String string3;
        String[] stringArray;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        RealtorContactDetails realtorContactDetails = objectFactory.createRealtorContactDetails();
        realtorContactDetails.setAdditionName(StringUtils.trimToNull((String)agentContactImpl.getPersonMiddleName()));
        realtorContactDetails.setCompany(StringUtils.trimToNull((String)string));
        realtorContactDetails.setEmail(StringUtils.trimToNull((String)agentContactImpl.getPersonMail()));
        realtorContactDetails.setExternalId(StringUtils.trimToNull((String)agentContactImpl.getId()));
        realtorContactDetails.setFirstname(StringUtils.trimToNull((String)agentContactImpl.getPersonFirstName()));
        realtorContactDetails.setHomepageUrl(agentContactImpl.getContactWebsite());
        realtorContactDetails.setLastname(StringUtils.trimToNull((String)agentContactImpl.getPersonLastName()));
        realtorContactDetails.setOfficeHours(StringUtils.trimToNull((String)agentContactImpl.getContactOfficeHours()));
        realtorContactDetails.setTitle(StringUtils.trimToNull((String)agentContactImpl.getPersonTitle()));
        realtorContactDetails.setSalutation(this.getSalutationType(agentContactImpl.getPersonGender()));
        if (realtorContactDetails.getFirstname() == null && realtorContactDetails.getLastname() == null && realtorContactDetails.getCompany() != null) {
            realtorContactDetails.setSalutation(SalutationType.COMPANY);
        }
        if (!StringUtils.isBlank((CharSequence)agentContactImpl.getPersonPhone())) {
            stringArray = this.getPhoneNumberSegments(agentContactImpl.getPersonPhone(), agentContactImpl.getCountry());
            if (stringArray == null || stringArray.length != 3) {
                LOGGER.warn("Can't convert phone nr '" + agentContactImpl.getPersonPhone() + "' into the required format!");
            } else {
                realtorContactDetails.setPhoneNumber(StringUtils.join((Object[])stringArray, (String)" "));
                realtorContactDetails.setPhoneNumberCountryCode((String)stringArray[0]);
                realtorContactDetails.setPhoneNumberAreaCode((String)stringArray[1]);
                realtorContactDetails.setPhoneNumberSubscriber((String)stringArray[2]);
            }
        }
        if (!StringUtils.isBlank((CharSequence)agentContactImpl.getPersonMobilePhone())) {
            stringArray = this.getPhoneNumberSegments(agentContactImpl.getPersonMobilePhone(), agentContactImpl.getCountry());
            if (stringArray == null || stringArray.length != 3) {
                LOGGER.warn("Can't convert cellphone nr '" + agentContactImpl.getPersonMobilePhone() + "' into the required format!");
            } else {
                realtorContactDetails.setCellPhoneNumber(StringUtils.join((Object[])stringArray, (String)" "));
                realtorContactDetails.setCellPhoneNumberCountryCode((String)stringArray[0]);
                realtorContactDetails.setCellPhoneNumberAreaCode((String)stringArray[1]);
                realtorContactDetails.setCellPhoneNumberSubscriber((String)stringArray[2]);
            }
        }
        if (!StringUtils.isBlank((CharSequence)agentContactImpl.getPersonFax())) {
            stringArray = this.getPhoneNumberSegments(agentContactImpl.getPersonFax(), agentContactImpl.getCountry());
            if (stringArray == null || stringArray.length != 3) {
                LOGGER.warn("Can't convert cellphone nr '" + agentContactImpl.getPersonFax() + "' into the required format!");
            } else {
                realtorContactDetails.setFaxNumber(StringUtils.join((Object[])stringArray, (String)" "));
                realtorContactDetails.setFaxNumberCountryCode((String)stringArray[0]);
                realtorContactDetails.setFaxNumberAreaCode((String)stringArray[1]);
                realtorContactDetails.setFaxNumberSubscriber((String)stringArray[2]);
            }
        }
        stringArray = null;
        try {
            string3 = StringUtils.trimToNull((String)agentContactImpl.getCountry());
            String string4 = string2 = string3 != null ? OpenEstateUtils.convertToIso3Country((String)string3) : null;
            if (string2 != null) {
                stringArray = CountryCode.valueOf((String)string2.toUpperCase());
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read country code '" + agentContactImpl.getCountry() + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (stringArray == null) {
            stringArray = CountryCode.DEU;
        }
        realtorContactDetails.setCountryCode((CountryCode)stringArray);
        string3 = objectFactory.createAddress();
        string3.setCity(StringUtils.trimToNull((String)agentContactImpl.getCity()));
        string3.setHouseNumber(StringUtils.trimToNull((String)agentContactImpl.getStreetNr()));
        string3.setPostcode(StringUtils.trimToNull((String)agentContactImpl.getPostalCode()));
        string3.setStreet(StringUtils.trimToNull((String)agentContactImpl.getStreet()));
        if (!CountryCode.DEU.equals((Object)stringArray)) {
            string2 = objectFactory.createCountryRegion();
            string2.setCountry((CountryCode)stringArray);
            string3.setInternationalCountryRegion((CountryRegion)string2);
        }
        realtorContactDetails.setAddress((Address)string3);
        return realtorContactDetails;
    }

    public RealEstate writeEstate(EstateImpl estateImpl, List<String> list) {
        String string;
        PublishChannels publishChannels;
        Object object;
        Wgs84Coordinate wgs84Coordinate;
        RealEstate.Contact contact;
        String string2;
        Object object2;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        ObjectFactory objectFactory2 = new ObjectFactory();
        OpenEstateAction openEstateAction = estateImpl.getAction();
        if (openEstateAction == null) {
            throw new IllegalArgumentException("unbekannte Vermarktungsart!");
        }
        OpenEstateType openEstateType = estateImpl.getType();
        if (openEstateType == null) {
            throw new IllegalArgumentException("unbekannte Immobilienart!");
        }
        List<OpenEstateType> list2 = Arrays.asList(openEstateType.getParentPath());
        List list3 = Usage.getAsList((EstateImpl)estateImpl);
        Object object3 = null;
        if (list3.contains(Usage.Option.INVESTMENT) && OpenEstateAction.PURCHASE.equals((Object)openEstateAction) && (list2.contains(OpenEstateType.GENERAL_COMMERCIAL) || list2.contains(OpenEstateType.GENERAL_RESIDENCE))) {
            object3 = objectFactory2.createInvestment();
        } else if (OpenEstateAction.SHORT_TERM_RENT.equals((Object)openEstateAction)) {
            if (list2.contains(OpenEstateType.GENERAL_RESIDENCE)) {
                object3 = objectFactory2.createShortTermAccommodation();
            }
        } else if (OpenEstateAction.AUCTION.equals((Object)openEstateAction)) {
            object3 = objectFactory2.createCompulsoryAuction();
        } else if (OpenEstateAction.RENT.equals((Object)openEstateAction) && list2.contains(OpenEstateType.APARTMENT_SHARE)) {
            object3 = objectFactory2.createFlatShareRoom();
        } else if (list2.contains(OpenEstateType.RESIDENCE) || list2.contains(OpenEstateType.ROOM)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createApartmentBuy();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createApartmentRent();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createApartmentRent();
            }
        } else if (list2.contains(OpenEstateType.HOUSE)) {
            if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createHouseRent();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createHouseRent();
            } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object2 = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
                object3 = object2 != null && ((BigDecimal)object2).compareTo(BigDecimal.ZERO) > 0 ? objectFactory2.createHouseBuy() : objectFactory2.createHouseType();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_PIECE_OF_LAND)) {
            if (list3.contains(Usage.Option.COMMERCIAL)) {
                object3 = objectFactory2.createTradeSite();
            } else if (list2.contains(OpenEstateType.COMMERCIAL_GROUND)) {
                object3 = objectFactory2.createTradeSite();
            } else if (list2.contains(OpenEstateType.INDUSTRIAL_GROUND)) {
                object3 = objectFactory2.createTradeSite();
            } else if (list2.contains(OpenEstateType.AGRICULTURAL_FORESTRY_GROUND)) {
                object3 = objectFactory2.createTradeSite();
            } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createLivingBuySite();
            } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createLivingBuySite();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createLivingRentSite();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createLivingRentSite();
            }
        } else if (list2.contains(OpenEstateType.OFFICE_SURGERY) || list2.contains(OpenEstateType.OFFICE_COMMERCIAL_BUILDING)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createOffice();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createOffice();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createOffice();
            }
        } else if (list2.contains(OpenEstateType.RETAIL)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createStore();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createStore();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createStore();
            }
        } else if (list2.contains(OpenEstateType.GASTRONOMY) || list2.contains(OpenEstateType.HOSPITALITY_INDUSTRY)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGastronomy();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGastronomy();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGastronomy();
            }
        } else if (list2.contains(OpenEstateType.PRODUCTION) || list2.contains(OpenEstateType.HALL_WAREHOUSE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createIndustry();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createIndustry();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createIndustry();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_COMMERCIAL) || list2.contains(OpenEstateType.GENERAL_AGRICULTURE)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createSpecialPurpose();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createSpecialPurpose();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createSpecialPurpose();
            }
        } else if (list2.contains(OpenEstateType.GENERAL_PARKING)) {
            if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGarageBuy();
            } else if (OpenEstateAction.RENT.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGarageRent();
            } else if (OpenEstateAction.LEASE.equals((Object)openEstateAction)) {
                object3 = objectFactory2.createGarageRent();
            }
        } else if (OpenEstateAction.PURCHASE.equals((Object)openEstateAction)) {
            object3 = objectFactory2.createInvestment();
        }
        if (object3 == null) {
            LOGGER.warn("kein xml-schema gefunden f\u00fcr immobilie #" + estateImpl.getId() + " / " + openEstateType + " / " + openEstateAction);
            list.add("Von IS24-REST-XML nicht unterst\u00fctzt: " + openEstateType + " / " + openEstateAction);
            return null;
        }
        object3.setExternalId(estateImpl.getId());
        if (StringUtils.isBlank((CharSequence)object3.getExternalId())) {
            list.add("IS24-Pflichtfeld 'ExternalId' nicht angegeben!");
        }
        if ((object2 = StringUtils.trimToNull((String)estateImpl.getGroupId())) != null) {
            try {
                string2 = Long.valueOf((String)object2).toString();
            }
            catch (NumberFormatException numberFormatException) {
                int n = ((String)object2).hashCode();
                if (n == Integer.MIN_VALUE) {
                    ++n;
                }
                string2 = String.valueOf(Math.abs(n));
            }
            if (string2.length() > 10) {
                string2 = string2.substring(0, 10);
            }
            object3.setGroupNumber(Integer.valueOf(string2));
        }
        if ((string2 = StringUtils.trimToNull((String)estateImpl.getContactId())) != null) {
            contact = objectFactory2.createRealEstateContact();
            contact.setExternalId(string2);
            object3.setContact(contact);
        }
        contact = objectFactory.createWgs84Address();
        contact.setCity(StringUtils.trimToNull((String)estateImpl.getAddress().getCity()));
        contact.setPostcode(StringUtils.trimToNull((String)estateImpl.getAddress().getPostalCode()));
        contact.setQuarter(StringUtils.trimToNull((String)estateImpl.getAddress().getDistrict()));
        contact.setStreet(StringUtils.trimToNull((String)estateImpl.getAddress().getStreet()));
        String string3 = StringUtils.trimToNull((String)estateImpl.getAddress().getStreetNr());
        contact.setHouseNumber(string3 != null ? string3 : "0");
        contact.setPreciseHouseNumber(Boolean.valueOf(estateImpl.getAddress().isPublished() && string3 != null));
        if (estateImpl.getAddress().getLatitude() != null && estateImpl.getAddress().getLongitude() != null) {
            wgs84Coordinate = objectFactory.createWgs84Coordinate();
            wgs84Coordinate.setLatitude(estateImpl.getAddress().getLatitude());
            wgs84Coordinate.setLongitude(estateImpl.getAddress().getLongitude());
            contact.setWgs84Coordinate(wgs84Coordinate);
        }
        wgs84Coordinate = null;
        try {
            object = StringUtils.trimToNull((String)estateImpl.getAddress().getCountry());
            PublishChannels publishChannels2 = publishChannels = object != null ? OpenEstateUtils.convertToIso3Country((String)object) : null;
            if (publishChannels != null) {
                wgs84Coordinate = CountryCode.valueOf((String)publishChannels.toUpperCase());
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't read country code '" + estateImpl.getAddress().getCountry() + "'!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
        }
        if (wgs84Coordinate == null) {
            wgs84Coordinate = CountryCode.DEU;
        }
        if (!CountryCode.DEU.equals((Object)wgs84Coordinate)) {
            object = objectFactory.createCountryRegion();
            object.setCountry((CountryCode)wgs84Coordinate);
            contact.setInternationalCountryRegion((CountryRegion)object);
        }
        if (StringUtils.isBlank((CharSequence)contact.getPostcode())) {
            list.add("IS24-Pflichtfeld 'Postcode' nicht angegeben!");
        }
        if (StringUtils.isBlank((CharSequence)contact.getCity())) {
            list.add("IS24-Pflichtfeld 'City' nicht angegeben!");
        }
        object3.setAddress((Wgs84Address)contact);
        object3.setShowAddress(estateImpl.getAddress().isPublished());
        object3.setDescriptionNote(StringUtils.trimToNull((String)this.getText(DetailledDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))));
        object3.setFurnishingNote(StringUtils.trimToNull((String)this.getText(FeatureDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))));
        object3.setLocationNote(StringUtils.trimToNull((String)this.getText(LocationDescription.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))));
        object = new ArrayList();
        for (OpenEstateAttrib openEstateAttrib : OpenEstateAttribGroup.DESCRIPTIONS.getAttributes()) {
            String string4;
            AbstractAttribImpl abstractAttribImpl;
            if (OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_SHORT_DESCRIPTION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_FEATURE_DESCRIPTION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_LOCATION_DESCRIPTION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_AGENT_FEE_INFORMATION.equals((Object)openEstateAttrib) || OpenEstateAttrib.DESCRIPTIONS_KEYWORDS.equals((Object)openEstateAttrib) || (abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib)) == null || (string4 = StringUtils.trimToNull((String)abstractAttribImpl.getFormattedValue(this.getOpenEstateLanguage()))) == null) continue;
            object.add(string4);
        }
        if (!object.isEmpty()) {
            object3.setOtherNote(this.getText(StringUtils.join((Iterable)object, (String)StringUtils.repeat((String)System.lineSeparator(), (int)3))));
        }
        object3.setRealEstateState(RealEstateState.ACTIVE);
        publishChannels = this.getEstatePublishChannels(estateImpl);
        if (publishChannels != null) {
            object3.setPublishChannels(publishChannels);
        }
        object3.setTitle((string = StringUtils.trimToNull((String)estateImpl.getTitle(this.getOpenEstateLanguage()))) != null ? string : estateImpl.getFallbackTitle(this.getOpenEstateLanguage()));
        if (StringUtils.isBlank((CharSequence)object3.getTitle())) {
            list.add("IS24-Pflichtfeld 'Title' nicht angegeben!");
        }
        if (object3 instanceof ApartmentBuy) {
            this.writeEstate(estateImpl, (ApartmentBuy)object3, list2, list);
        } else if (object3 instanceof ApartmentRent) {
            this.writeEstate(estateImpl, (ApartmentRent)object3, list2, list);
        } else if (object3 instanceof AssistedLiving) {
            this.writeEstate(estateImpl, (AssistedLiving)object3, list2, list);
        } else if (object3 instanceof CompulsoryAuction) {
            this.writeEstate(estateImpl, (CompulsoryAuction)object3, list2, list);
        } else if (object3 instanceof FlatShareRoom) {
            this.writeEstate(estateImpl, (FlatShareRoom)object3, list2, list);
        } else if (object3 instanceof GarageBuy) {
            this.writeEstate(estateImpl, (GarageBuy)object3, list2, list);
        } else if (object3 instanceof GarageRent) {
            this.writeEstate(estateImpl, (GarageRent)object3, list2, list);
        } else if (object3 instanceof Gastronomy) {
            this.writeEstate(estateImpl, (Gastronomy)object3, list2, list);
        } else if (object3 instanceof HouseBuy) {
            this.writeEstate(estateImpl, (HouseBuy)object3, list2, list);
        } else if (object3 instanceof HouseRent) {
            this.writeEstate(estateImpl, (HouseRent)object3, list2, list);
        } else if (object3 instanceof HouseType) {
            this.writeEstate(estateImpl, (HouseType)object3, list2, list);
        } else if (object3 instanceof Industry) {
            this.writeEstate(estateImpl, (Industry)object3, list2, list);
        } else if (object3 instanceof Investment) {
            this.writeEstate(estateImpl, (Investment)object3, list2, list);
        } else if (object3 instanceof LivingBuySite) {
            this.writeEstate(estateImpl, (LivingBuySite)object3, list2, list);
        } else if (object3 instanceof LivingRentSite) {
            this.writeEstate(estateImpl, (LivingRentSite)object3, list2, list);
        } else if (object3 instanceof Office) {
            this.writeEstate(estateImpl, (Office)object3, list2, list);
        } else if (object3 instanceof SeniorCare) {
            this.writeEstate(estateImpl, (SeniorCare)object3, list2, list);
        } else if (object3 instanceof ShortTermAccommodation) {
            this.writeEstate(estateImpl, (ShortTermAccommodation)object3, list2, list);
        } else if (object3 instanceof SpecialPurpose) {
            this.writeEstate(estateImpl, (SpecialPurpose)object3, list2, list);
        } else if (object3 instanceof Store) {
            this.writeEstate(estateImpl, (Store)object3, list2, list);
        } else if (object3 instanceof TradeSite) {
            this.writeEstate(estateImpl, (TradeSite)object3, list2, list);
        }
        return list.isEmpty() ? object3 : null;
    }

    protected void writeEstate(EstateImpl estateImpl, ApartmentBuy apartmentBuy, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        Number number;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        apartmentBuy.setApartmentType(this.getEstateApartmentType(estateImpl, list));
        apartmentBuy.setBalcony(BalconyTerrace.get((EstateImpl)estateImpl));
        apartmentBuy.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        apartmentBuy.setCertificateOfEligibilityNeeded(WbsRequired.get((EstateImpl)estateImpl));
        apartmentBuy.setCondition(this.getEstateCondition(estateImpl));
        apartmentBuy.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setConstructionYearUnknown(apartmentBuy.getConstructionYear() == null ? Boolean.TRUE : null);
        apartmentBuy.setCourtage(this.getEstateCourtageInfo(estateImpl));
        apartmentBuy.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        apartmentBuy.setGarden(GardenUse.get((EstateImpl)estateImpl));
        apartmentBuy.setHandicappedAccessible(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        apartmentBuy.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        apartmentBuy.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        apartmentBuy.setLastRefurbishment(RefurbishmentYear.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setLift(Lift.get((EstateImpl)estateImpl));
        apartmentBuy.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        apartmentBuy.setNumberOfBathRooms(CountBathrooms.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setNumberOfBedRooms(CountBedrooms.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setNumberOfFloors(CountFloors.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setNumberOfParkingSpaces(CountParkingSpaces.getAsInteger((EstateImpl)estateImpl));
        apartmentBuy.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        apartmentBuy.setParkingSpaceType(this.getEstateParkingSpaceType(estateImpl));
        apartmentBuy.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        apartmentBuy.setRentalIncome(RentalIncomePerMonth.getAsBigDecimal((EstateImpl)estateImpl));
        apartmentBuy.setRented(this.getYesNotApplicable(Rented.get((EstateImpl)estateImpl)));
        apartmentBuy.setSummerResidencePractical(this.getYesNotApplicable(HolidayProperty.get((EstateImpl)estateImpl)));
        apartmentBuy.setUsableFloorSpace(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        if (ResidentialServices.hasOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING)) {
            apartmentBuy.setAssistedLiving(Boolean.valueOf(true));
        }
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            apartmentBuy.setBuiltInKitchen(Boolean.valueOf(true));
        }
        if ((number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) != null) {
            apartmentBuy.setFloor(Integer.valueOf(number.intValue()));
        }
        apartmentBuy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)apartmentBuy.getFreeFrom())) {
            apartmentBuy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            apartmentBuy.setGuestToilet(YesNotApplicableType.YES);
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        apartmentBuy.setLivingSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal2 = CountRooms.getAsBigDecimal((EstateImpl)estateImpl);
        apartmentBuy.setNumberOfRooms(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        BigDecimal bigDecimal3 = CommonCharge.getAsBigDecimal((EstateImpl)estateImpl);
        if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal3 = ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
        }
        apartmentBuy.setServiceCharge(bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal3 : null);
        if (apartmentBuy.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            apartmentBuy.setEnergyPerformanceCertificate(bl);
            apartmentBuy.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                apartmentBuy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                apartmentBuy.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                apartmentBuy.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal4 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal4 != null) {
                            bl2 = true;
                            apartmentBuy.setThermalCharacteristic(bigDecimal4);
                            apartmentBuy.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentBuy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal4 != null) {
                            bl3 = true;
                            apartmentBuy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            apartmentBuy.setThermalCharacteristic(bigDecimal4);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentBuy)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            apartmentBuy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentBuy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            apartmentBuy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            apartmentBuy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentBuy)!");
                        }
                    }
                }
            }
        }
        if (apartmentBuy.getLivingSpace() == null || apartmentBuy.getLivingSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LivingSpace' nicht angegeben (f\u00fcr ApartmentBuy)!");
        }
        if (apartmentBuy.getNumberOfRooms() == null || apartmentBuy.getNumberOfRooms().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NumberOfRooms' nicht angegeben (f\u00fcr ApartmentBuy)!");
        }
        if (apartmentBuy.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr ApartmentBuy)!");
        } else if (apartmentBuy.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr ApartmentBuy)!");
        }
        if (apartmentBuy.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr ApartmentBuy)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, ApartmentRent apartmentRent, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        String string;
        BigDecimal bigDecimal2;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        apartmentRent.setApartmentType(this.getEstateApartmentType(estateImpl, list));
        apartmentRent.setBalcony(BalconyTerrace.get((EstateImpl)estateImpl));
        apartmentRent.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        apartmentRent.setCertificateOfEligibilityNeeded(WbsRequired.get((EstateImpl)estateImpl));
        apartmentRent.setCondition(this.getEstateCondition(estateImpl));
        apartmentRent.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setConstructionYearUnknown(apartmentRent.getConstructionYear() == null ? Boolean.TRUE : null);
        apartmentRent.setCourtage(this.getEstateCourtageInfo(estateImpl));
        apartmentRent.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        apartmentRent.setGarden(GardenUse.get((EstateImpl)estateImpl));
        apartmentRent.setHandicappedAccessible(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        apartmentRent.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        apartmentRent.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        apartmentRent.setLastRefurbishment(RefurbishmentYear.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setLift(Lift.get((EstateImpl)estateImpl));
        apartmentRent.setNumberOfBathRooms(CountBathrooms.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setNumberOfBedRooms(CountBedrooms.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setNumberOfFloors(CountFloors.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setNumberOfParkingSpaces(CountParkingSpaces.getAsInteger((EstateImpl)estateImpl));
        apartmentRent.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        apartmentRent.setParkingSpaceType(this.getEstateParkingSpaceType(estateImpl));
        apartmentRent.setPetsAllowed(this.getEstatePetsAllowedType(estateImpl));
        apartmentRent.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        apartmentRent.setServiceCharge(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        apartmentRent.setTotalRent(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        apartmentRent.setUsableFloorSpace(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        apartmentRent.setUseAsFlatshareRoom(null);
        if (ResidentialServices.hasOption((EstateImpl)estateImpl, (ResidentialServices.Option)ResidentialServices.Option.ASSISTED_LIVING)) {
            apartmentRent.setAssistedLiving(Boolean.valueOf(true));
        }
        apartmentRent.setBaseRent((bigDecimal2 = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            apartmentRent.setBuiltInKitchen(Boolean.valueOf(true));
        }
        if ((string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        apartmentRent.setDeposit(string);
        Number number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number != null) {
            apartmentRent.setFloor(Integer.valueOf(number.intValue()));
        }
        apartmentRent.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)apartmentRent.getFreeFrom())) {
            apartmentRent.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            apartmentRent.setGuestToilet(YesNotApplicableType.YES);
        }
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        apartmentRent.setHeatingCostsInServiceCharge(this.getYesNoNotApplicable(bl));
        if (bl != null && (bigDecimal = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            apartmentRent.setHeatingCosts(bigDecimal);
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        apartmentRent.setLivingSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal3 = CountRooms.getAsBigDecimal((EstateImpl)estateImpl);
        apartmentRent.setNumberOfRooms(bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal3 : BigDecimal.ZERO);
        if (apartmentRent.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl2 = this.getEstateEnergyCertificateAvailable(estateImpl);
            apartmentRent.setEnergyPerformanceCertificate(bl2);
            apartmentRent.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl2)) {
                apartmentRent.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                apartmentRent.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                apartmentRent.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                apartmentRent.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal4 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal4 != null) {
                            bl3 = true;
                            apartmentRent.setThermalCharacteristic(bigDecimal4);
                            apartmentRent.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentRent)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal4 != null) {
                            bl4 = true;
                            apartmentRent.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            apartmentRent.setThermalCharacteristic(bigDecimal4);
                        }
                        if (!bl4) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentRent)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            apartmentRent.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentRent)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl6 = false;
                        if (bigDecimal5 != null) {
                            bl6 = true;
                            apartmentRent.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            apartmentRent.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl6) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ApartmentRent)!");
                        }
                    }
                }
            }
        }
        if (apartmentRent.getLivingSpace() == null || apartmentRent.getLivingSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LivingSpace' nicht angegeben (f\u00fcr ApartmentRent)!");
        }
        if (apartmentRent.getNumberOfRooms() == null || apartmentRent.getNumberOfRooms().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NumberOfRooms' nicht angegeben (f\u00fcr ApartmentRent)!");
        }
        if (apartmentRent.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr ApartmentRent)!");
        } else if (apartmentRent.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr ApartmentRent)!");
        }
        if (apartmentRent.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr ApartmentRent)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, AssistedLiving assistedLiving, List<OpenEstateType> list, List<String> list2) {
        list2.add("Betreutes Wohnen wird derzeit nicht unterst\u00fctzt!");
    }

    protected void writeEstate(EstateImpl estateImpl, CompulsoryAuction compulsoryAuction, List<OpenEstateType> list, List<String> list2) {
        Object object;
        Object object2;
        OpenEstateAttrib[] openEstateAttribArray;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        compulsoryAuction.setAuctionObjectType(this.getEstateCompulsoryAuctionType(estateImpl, list));
        compulsoryAuction.setCancellationDate(AuctionCancellationDate.getAsCalendar((EstateImpl)estateImpl));
        compulsoryAuction.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        compulsoryAuction.setConstructionYearUnknown(compulsoryAuction.getConstructionYear() == null ? Boolean.TRUE : null);
        compulsoryAuction.setCountyCourt(objectFactory.createCountyCourt());
        compulsoryAuction.getCountyCourt().setCourtNumber(CountryCourtNr.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        compulsoryAuction.getCountyCourt().setName(CountryCourtName.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        compulsoryAuction.setDateOfAuction(AuctionDate.getAsCalendar((EstateImpl)estateImpl));
        compulsoryAuction.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        compulsoryAuction.setFileReferenceAtCountyCourt(CountryCourtFileReference.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        compulsoryAuction.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        compulsoryAuction.setLastChangeDate(AuctionModificationDate.getAsCalendar((EstateImpl)estateImpl));
        compulsoryAuction.setLowestBid(this.getEstateLowestBid(estateImpl));
        compulsoryAuction.setMarketValue(this.getEstateMarketValue(estateImpl));
        compulsoryAuction.setNumberOfFolio(LandRegisterNr.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        compulsoryAuction.setOwner(Owner.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        compulsoryAuction.setRecordationDate(AuctionRecordationDate.getAsCalendar((EstateImpl)estateImpl));
        compulsoryAuction.setRecurrenceAppointment(AuctionRepeated.get((EstateImpl)estateImpl));
        compulsoryAuction.setSplittingAuction(AuctionSplitted.get((EstateImpl)estateImpl));
        for (Object object3 : openEstateAttribArray = new OpenEstateAttrib[]{OpenEstateAttrib.MEASURES_TOTAL_AREA, OpenEstateAttrib.MEASURES_COMMERCIAL_AREA, OpenEstateAttrib.MEASURES_STORAGE_AREA, OpenEstateAttrib.MEASURES_OFFICE_AREA, OpenEstateAttrib.MEASURES_RESIDENTIAL_AREA, OpenEstateAttrib.MEASURES_PLOT_AREA}) {
            object2 = (ComplexAreaAttrib)estateImpl.getAttribute(object3);
            if (object2 == null || (object = object2.getValue()) == null || object.getValue().compareTo(BigDecimal.ZERO) < 1) continue;
            compulsoryAuction.setArea(AreaValue.convert((AreaValue)object, (AreaValue.Unit)AreaValue.Unit.SQM));
            break;
        }
        if (compulsoryAuction.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            compulsoryAuction.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                Object object3;
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                compulsoryAuction.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                compulsoryAuction.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    object3 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    object2 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    object = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        compulsoryAuction.getEnergyCertificate().setElectricityConsumption((BigDecimal)object2);
                        compulsoryAuction.getEnergyCertificate().setHeatingConsumption((BigDecimal)object);
                        compulsoryAuction.setThermalCharacteristic((BigDecimal)object3);
                        compulsoryAuction.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        compulsoryAuction.getEnergyCertificate().setEnergyConsumptionElectricity((BigDecimal)object2);
                        compulsoryAuction.getEnergyCertificate().setEnergyConsumptionHeating((BigDecimal)object);
                        compulsoryAuction.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                        compulsoryAuction.setThermalCharacteristic((BigDecimal)object3);
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    object3 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    object2 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    object = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        compulsoryAuction.setThermalCharacteristic((BigDecimal)object3);
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        compulsoryAuction.getEnergyCertificate().setEnergyConsumptionElectricity((BigDecimal)object2);
                        compulsoryAuction.getEnergyCertificate().setEnergyConsumptionHeating((BigDecimal)object);
                        compulsoryAuction.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                        compulsoryAuction.setThermalCharacteristic((BigDecimal)object3);
                    }
                }
            }
        }
        if (compulsoryAuction.getArea() == null || compulsoryAuction.getArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'Area' nicht angegeben (f\u00fcr CompulsoryAuction)!");
        }
        if (compulsoryAuction.getDateOfAuction() == null) {
            list2.add("IS24-Pflichtfeld 'DateOfAuction' nicht angegeben (f\u00fcr CompulsoryAuction)!");
        }
        if (compulsoryAuction.getMarketValue() == null || compulsoryAuction.getMarketValue().getValue() == null || compulsoryAuction.getMarketValue().getValue().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'MarketValue' nicht angegeben (f\u00fcr CompulsoryAuction)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, FlatShareRoom flatShareRoom, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        flatShareRoom.setAgeOfFlatMatesFrom(AgeOfFlatmatesMinimal.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setAgeOfFlatMatesTo(AgeOfFlatmatesMaximal.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setAgeOfRequestedFrom(AgeOfRequestedFlatmatesMinimal.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setAgeOfRequestedTo(AgeOfRequestedFlatmatesMaximal.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setApartmentType(this.getEstateApartmentType(estateImpl, list));
        flatShareRoom.setBalcony(this.getYesNotApplicable(BalconyTerrace.get((EstateImpl)estateImpl)));
        flatShareRoom.setBarrierFree(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        flatShareRoom.setBathHasShower(this.getYesNotApplicable(Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.SHOWER)));
        flatShareRoom.setBathHasTub(this.getYesNotApplicable(Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.BATHTUB)));
        flatShareRoom.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        flatShareRoom.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        flatShareRoom.setConstructionYearUnknown(flatShareRoom.getConstructionYear() == null ? Boolean.TRUE : null);
        flatShareRoom.setCourtage(this.getEstateCourtageInfo(estateImpl));
        flatShareRoom.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        flatShareRoom.setFlooringType(this.getEstateFlooringType(estateImpl));
        flatShareRoom.setFreeFrom(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        flatShareRoom.setFreeUntil(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        flatShareRoom.setFurnishing(this.getEstateFurnishing(estateImpl));
        flatShareRoom.setGarden(this.getYesNotApplicable(GardenUse.get((EstateImpl)estateImpl)));
        flatShareRoom.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        flatShareRoom.setInternetConnection(InternetConnectionType.NO_INFORMATION);
        flatShareRoom.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        flatShareRoom.setNumberOfBathRooms(CountBathrooms.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setNumberOfFemaleFlatMates(CountFlatmatesFemale.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setNumberOfFloors(CountFloors.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setNumberOfMaleFlatMates(CountFlatmatesMale.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setNumberOfRequestedFlatMates(CountRequestedFlatmates.getAsLong((EstateImpl)estateImpl));
        flatShareRoom.setNumberOfRooms(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        flatShareRoom.setParkingSituation(ParkingSituationType.NO_INFORMATION);
        flatShareRoom.setPetsAllowed(this.getEstatePetsAllowedType(estateImpl));
        flatShareRoom.setRequestedGender(this.getEstateFlatMateGenderType(estateImpl));
        flatShareRoom.setServiceCharge(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        flatShareRoom.setSmokingAllowed(this.getEstateSmokingAllowedType(estateImpl));
        flatShareRoom.setTelephoneConnection(TelephoneConnectionType.NO_INFORMATION);
        flatShareRoom.setTotalRent(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        flatShareRoom.setTotalSpace(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        flatShareRoom.setTvConnection(this.getEstateTvConnectionType(estateImpl));
        flatShareRoom.setWashingMachine(this.getYesNotApplicable(Bathroom.hasOption((EstateImpl)estateImpl, (Bathroom.Option)Bathroom.Option.WASHING_MACHINE_CONNECTION)));
        BigDecimal bigDecimal2 = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
        flatShareRoom.setBaseRent(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        flatShareRoom.setDeposit(string);
        Integer n = CountFlatmatesTotal.getAsInteger((EstateImpl)estateImpl);
        if (n != null && n > 10) {
            n = 11;
        }
        flatShareRoom.setFlatShareSize(Integer.valueOf(n != null && n > 0 ? n : 0));
        Number number = OpenEstateUtils.parseNumber((String)Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number != null) {
            flatShareRoom.setFloor(Integer.valueOf(number.intValue()));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            flatShareRoom.setGuestToilet(YesNotApplicableType.YES);
        }
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        flatShareRoom.setHeatingCostsInServiceCharge(this.getYesNoNotApplicable(bl));
        if (bl != null && (bigDecimal = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            flatShareRoom.setHeatingCosts(bigDecimal);
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        flatShareRoom.setRoomSize(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        if (flatShareRoom.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl2 = this.getEstateEnergyCertificateAvailable(estateImpl);
            flatShareRoom.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl2)) {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                flatShareRoom.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                flatShareRoom.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                flatShareRoom.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal3 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal3 != null) {
                            bl3 = true;
                            flatShareRoom.setThermalCharacteristic(bigDecimal3);
                            flatShareRoom.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr FlatShareRoom)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal3 != null) {
                            bl4 = true;
                            flatShareRoom.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            flatShareRoom.setThermalCharacteristic(bigDecimal3);
                        }
                        if (!bl4) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr FlatShareRoom)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal4 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal4 != null) {
                            bl5 = true;
                            flatShareRoom.setThermalCharacteristic(bigDecimal4);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr FlatShareRoom)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl6 = false;
                        if (bigDecimal4 != null) {
                            bl6 = true;
                            flatShareRoom.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            flatShareRoom.setThermalCharacteristic(bigDecimal4);
                        }
                        if (!bl6) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr FlatShareRoom)!");
                        }
                    }
                }
            }
        }
        if (flatShareRoom.getRoomSize() == null || flatShareRoom.getRoomSize().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'RoomSize' nicht angegeben (f\u00fcr FlatShareRoom)!");
        }
        if (flatShareRoom.getFreeFrom() == null) {
            list2.add("IS24-Pflichtfeld 'FreeFrom' nicht angegeben (f\u00fcr FlatShareRoom)!");
        }
        if (flatShareRoom.getFlatShareSize() == null) {
            list2.add("IS24-Pflichtfeld 'FlatShareSize' nicht angegeben (f\u00fcr FlatShareRoom)!");
        } else {
            int n2 = flatShareRoom.getFlatShareSize();
            if (n2 < 2 || n2 > 11) {
                list2.add("IS24-Pflichtfeld 'FlatShareSize' ist ung\u00fcltig (f\u00fcr FlatShareRoom)!");
            }
        }
        if (flatShareRoom.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr FlatShareRoom)!");
        } else if (flatShareRoom.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr FlatShareRoom)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, GarageBuy garageBuy, List<OpenEstateType> list, List<String> list2) {
        garageBuy.setCondition(this.getEstateCondition(estateImpl));
        garageBuy.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        garageBuy.setCourtage(this.getEstateCourtageInfo(estateImpl));
        garageBuy.setGarageType(this.getEstateGarageType(estateImpl, list));
        garageBuy.setHeightGarage(Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        garageBuy.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        garageBuy.setLengthGarage(Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        garageBuy.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        garageBuy.setWidthGarage(Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        BigDecimal bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        garageBuy.setUsableFloorSpace(bigDecimal);
        if (garageBuy.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr GarageBuy)!");
        } else if (garageBuy.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr GarageBuy)!");
        }
        if (garageBuy.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr GarageBuy)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, GarageRent garageRent, List<OpenEstateType> list, List<String> list2) {
        garageRent.setCondition(this.getEstateCondition(estateImpl));
        garageRent.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        garageRent.setCourtage(this.getEstateCourtageInfo(estateImpl));
        garageRent.setFreeFrom(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        garageRent.setFreeUntil(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        garageRent.setGarageType(this.getEstateGarageType(estateImpl, list));
        garageRent.setHeightGarage(Height.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        garageRent.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        garageRent.setLengthGarage(Length.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        garageRent.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        garageRent.setWidthGarage(Width.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        BigDecimal bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        garageRent.setUsableFloorSpace(bigDecimal);
        if (garageRent.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr GarageRent)!");
        } else if (garageRent.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr GarageRent)!");
        }
        if (garageRent.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr GarageRent)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, Gastronomy gastronomy, List<OpenEstateType> list, List<String> list2) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        gastronomy.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gastronomy.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        gastronomy.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        gastronomy.setCommercializationType(this.getEstateCommercializationType(estateImpl, false));
        gastronomy.setCondition(this.getEstateCondition(estateImpl));
        gastronomy.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        gastronomy.setConstructionYearUnknown(gastronomy.getConstructionYear() == null ? Boolean.TRUE : null);
        gastronomy.setCourtage(this.getEstateCourtageInfo(estateImpl));
        gastronomy.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        gastronomy.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        gastronomy.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        gastronomy.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        gastronomy.setGastronomyType(this.getEstateGastronomyType(estateImpl, list));
        gastronomy.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        gastronomy.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        gastronomy.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        gastronomy.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        gastronomy.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        gastronomy.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gastronomy.setNetFloorSpace(SeatingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        gastronomy.setNumberBeds(CountBeds.getAsLong((EstateImpl)estateImpl));
        gastronomy.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        gastronomy.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        gastronomy.setNumberSeats(CountGuestroomSeats.getAsLong((EstateImpl)estateImpl));
        gastronomy.setPrice(this.getEstatePrice(estateImpl, list, true, true));
        gastronomy.setTerrace(this.getYesNotApplicable(BalconyTerrace.get((EstateImpl)estateImpl)));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        gastronomy.setDeposit(string);
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        gastronomy.setDistanceToPT(l != null && l > 0L ? l : null);
        gastronomy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)gastronomy.getFreeFrom())) {
            gastronomy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (CommercializationType.BUY.equals((Object)gastronomy.getCommercializationType())) {
            gastronomy.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            gastronomy.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        BigDecimal bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        gastronomy.setTotalFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : null);
        if (gastronomy.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            gastronomy.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                gastronomy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                gastronomy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                gastronomy.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                gastronomy.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal2 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal3 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl2 = true;
                            gastronomy.getEnergyCertificate().setElectricityConsumption(bigDecimal3);
                            gastronomy.getEnergyCertificate().setHeatingConsumption(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl2 = true;
                            gastronomy.setThermalCharacteristic(bigDecimal2);
                            gastronomy.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Gastronomy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl3 = true;
                            gastronomy.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal3);
                            gastronomy.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl3 = true;
                            gastronomy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            gastronomy.setThermalCharacteristic(bigDecimal2);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Gastronomy)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal6 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            gastronomy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Gastronomy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal6 != null && bigDecimal7 != null) {
                            bl5 = true;
                            gastronomy.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal6);
                            gastronomy.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal7);
                        }
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            gastronomy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            gastronomy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Gastronomy)!");
                        }
                    }
                }
            }
        }
        if (gastronomy.getTotalFloorSpace() == null || gastronomy.getTotalFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'TotalFloorSpace' nicht angegeben (f\u00fcr Gastronomy)!");
        }
        if (gastronomy.getGastronomyType() == null) {
            list2.add("IS24-Pflichtfeld 'GastronomyType' nicht angegeben (f\u00fcr Gastronomy)!");
        }
        if (gastronomy.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr Gastronomy)!");
        }
        if (gastronomy.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr Gastronomy)!");
        } else if (gastronomy.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr Gastronomy)!");
        }
        if (gastronomy.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr Gastronomy)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, HouseBuy houseBuy, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        houseBuy.setBuildingType(this.getEstateBuildingType(estateImpl, list));
        houseBuy.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        houseBuy.setCondition(this.getEstateCondition(estateImpl));
        houseBuy.setConstructionPhase(this.getEstateConstructionPhaseType(estateImpl));
        houseBuy.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setConstructionYearUnknown(houseBuy.getConstructionYear() == null ? Boolean.TRUE : null);
        houseBuy.setCourtage(this.getEstateCourtageInfo(estateImpl));
        houseBuy.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        houseBuy.setHandicappedAccessible(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        houseBuy.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        houseBuy.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        houseBuy.setLastRefurbishment(RefurbishmentYear.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        houseBuy.setLodgerFlat(this.getYesNotApplicable(GrannyFlat.get((EstateImpl)estateImpl)));
        houseBuy.setNumberOfBathRooms(CountBathrooms.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setNumberOfBedRooms(CountBedrooms.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setNumberOfFloors(CountFloors.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setNumberOfParkingSpaces(CountParkingSpaces.getAsInteger((EstateImpl)estateImpl));
        houseBuy.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        houseBuy.setParkingSpaceType(this.getEstateParkingSpaceType(estateImpl));
        houseBuy.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        houseBuy.setRentalIncome(RentalIncomePerMonth.getAsBigDecimal((EstateImpl)estateImpl));
        houseBuy.setRented(this.getYesNotApplicable(Rented.get((EstateImpl)estateImpl)));
        houseBuy.setSummerResidencePractical(this.getYesNotApplicable(HolidayProperty.get((EstateImpl)estateImpl)));
        houseBuy.setUsableFloorSpace(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        houseBuy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)houseBuy.getFreeFrom())) {
            houseBuy.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            houseBuy.setGuestToilet(YesNotApplicableType.YES);
        }
        houseBuy.setNumberOfRooms((bigDecimal = CountRooms.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal2 = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        houseBuy.setPlotArea(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        BigDecimal bigDecimal3 = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal3 == null || bigDecimal3.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal3 = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        houseBuy.setLivingSpace(bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal3 : BigDecimal.ZERO);
        if (houseBuy.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            houseBuy.setEnergyPerformanceCertificate(bl);
            houseBuy.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                houseBuy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                houseBuy.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                houseBuy.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                houseBuy.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal4 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal4 != null) {
                            bl2 = true;
                            houseBuy.setThermalCharacteristic(bigDecimal4);
                            houseBuy.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseBuy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal4 != null) {
                            bl3 = true;
                            houseBuy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            houseBuy.setThermalCharacteristic(bigDecimal4);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseBuy)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            houseBuy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseBuy)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            houseBuy.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            houseBuy.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseBuy)!");
                        }
                    }
                }
            }
        }
        if (houseBuy.getLivingSpace() == null || houseBuy.getLivingSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LivingSpace' nicht angegeben (f\u00fcr HouseBuy)!");
        }
        if (houseBuy.getPlotArea() == null || houseBuy.getPlotArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'PlotArea' nicht angegeben (f\u00fcr HouseBuy)!");
        }
        if (houseBuy.getNumberOfRooms() == null || houseBuy.getNumberOfRooms().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NumberOfRooms' nicht angegeben (f\u00fcr HouseBuy)!");
        }
        if (houseBuy.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr HouseBuy)!");
        } else if (houseBuy.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr HouseBuy)!");
        }
        if (houseBuy.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr HouseBuy)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, HouseRent houseRent, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        String string;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        houseRent.setBuildingType(this.getEstateBuildingType(estateImpl, list));
        houseRent.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        houseRent.setCondition(this.getEstateCondition(estateImpl));
        houseRent.setConstructionYear(BuildYear.getAsInteger((EstateImpl)estateImpl));
        houseRent.setConstructionYearUnknown(houseRent.getConstructionYear() == null ? Boolean.TRUE : null);
        houseRent.setCourtage(this.getEstateCourtageInfo(estateImpl));
        houseRent.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        houseRent.setHandicappedAccessible(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        houseRent.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        houseRent.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        houseRent.setLastRefurbishment(RefurbishmentYear.getAsInteger((EstateImpl)estateImpl));
        houseRent.setNumberOfBathRooms(CountBathrooms.getAsInteger((EstateImpl)estateImpl));
        houseRent.setNumberOfBedRooms(CountBedrooms.getAsInteger((EstateImpl)estateImpl));
        houseRent.setNumberOfFloors(CountFloors.getAsInteger((EstateImpl)estateImpl));
        houseRent.setNumberOfParkingSpaces(CountParkingSpaces.getAsInteger((EstateImpl)estateImpl));
        houseRent.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        houseRent.setParkingSpaceType(this.getEstateParkingSpaceType(estateImpl));
        houseRent.setPetsAllowed(this.getEstatePetsAllowedType(estateImpl));
        houseRent.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        houseRent.setServiceCharge(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        houseRent.setTotalRent(RentIncludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        houseRent.setUsableFloorSpace(UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        BigDecimal bigDecimal2 = RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl);
        houseRent.setBaseRent(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        if (Kitchen.hasOption((EstateImpl)estateImpl, (Kitchen.Option)Kitchen.Option.FITTED_KITCHEN)) {
            houseRent.setBuiltInKitchen(Boolean.valueOf(true));
        }
        if ((string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        houseRent.setDeposit(string);
        houseRent.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)houseRent.getFreeFrom())) {
            houseRent.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            houseRent.setGuestToilet(YesNotApplicableType.YES);
        }
        Boolean bl = ServiceChargesIncludingHeatingCosts.get((EstateImpl)estateImpl);
        houseRent.setHeatingCostsInServiceCharge(this.getYesNoNotApplicable(bl));
        if (bl != null && (bigDecimal = HeatingCosts.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0) {
            houseRent.setHeatingCosts(bigDecimal);
        }
        houseRent.setNumberOfRooms((bigDecimal = CountRooms.getAsBigDecimal((EstateImpl)estateImpl)) != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal3 = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        houseRent.setPlotArea(bigDecimal3 != null && bigDecimal3.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal3 : BigDecimal.ZERO);
        BigDecimal bigDecimal4 = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal4 == null || bigDecimal4.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal4 = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        houseRent.setLivingSpace(bigDecimal4 != null && bigDecimal4.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal4 : BigDecimal.ZERO);
        if (houseRent.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl2 = this.getEstateEnergyCertificateAvailable(estateImpl);
            houseRent.setEnergyPerformanceCertificate(bl2);
            houseRent.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl2)) {
                houseRent.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                houseRent.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                houseRent.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                houseRent.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal5 != null) {
                            bl3 = true;
                            houseRent.setThermalCharacteristic(bigDecimal5);
                            houseRent.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseRent)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            houseRent.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            houseRent.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseRent)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal6 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal6 != null) {
                            bl5 = true;
                            houseRent.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseRent)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl6 = false;
                        if (bigDecimal6 != null) {
                            bl6 = true;
                            houseRent.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            houseRent.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl6) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr HouseRent)!");
                        }
                    }
                }
            }
        }
        if (houseRent.getLivingSpace() == null || houseRent.getLivingSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LivingSpace' nicht angegeben (f\u00fcr HouseRent)!");
        }
        if (houseRent.getPlotArea() == null || houseRent.getPlotArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'PlotArea' nicht angegeben (f\u00fcr HouseRent)!");
        }
        if (houseRent.getNumberOfRooms() == null || houseRent.getNumberOfRooms().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NumberOfRooms' nicht angegeben (f\u00fcr HouseRent)!");
        }
        if (houseRent.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr HouseRent)!");
        } else if (houseRent.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr HouseRent)!");
        }
        if (houseRent.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr HouseRent)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, HouseType houseType, List<OpenEstateType> list, List<String> list2) {
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        houseType.setBuildingType(this.getEstateHouseTypeBuildingType(estateImpl, list));
        houseType.setCourtage(this.getEstateCourtageInfo(estateImpl));
        houseType.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        houseType.setTotalArea(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        BigDecimal bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        houseType.setLivingSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal2 = CountRooms.getAsBigDecimal((EstateImpl)estateImpl);
        houseType.setNumberOfRooms(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : BigDecimal.ZERO);
        if (houseType.getLivingSpace() == null || houseType.getLivingSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'LivingSpace' nicht angegeben (f\u00fcr HouseType)!");
        }
        if (houseType.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr HouseType)!");
        } else if (houseType.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr HouseType)!");
        }
        if (houseType.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr HouseType)!");
        }
        GeoHierarchy geoHierarchy = objectFactory.createGeoHierarchy();
        geoHierarchy.setCountry(objectFactory.createCountry());
        if ("DE".equalsIgnoreCase(estateImpl.getAddress().getCountry())) {
            geoHierarchy.getCountry().setName("Germany");
            geoHierarchy.getCountry().setGeoCodeId(276L);
        }
        geoHierarchy.setContinent(objectFactory.createContinent());
        geoHierarchy.getContinent().setName("Europe");
        geoHierarchy.getContinent().setGeoCodeId(1L);
        geoHierarchy.setRegion(objectFactory.createRegion());
        geoHierarchy.getRegion().setName(StringUtils.trimToNull((String)estateImpl.getAddress().getRegion()));
        if (StringUtils.isBlank((CharSequence)geoHierarchy.getRegion().getName())) {
            geoHierarchy.getRegion().setName(StringUtils.trimToNull((String)estateImpl.getAddress().getCity()));
        }
        geoHierarchy.setCity(objectFactory.createCity());
        geoHierarchy.getCity().setName(StringUtils.trimToNull((String)estateImpl.getAddress().getCity()));
        geoHierarchy.setQuarter(objectFactory.createQuarter());
        geoHierarchy.getQuarter().setName(StringUtils.trimToNull((String)estateImpl.getAddress().getDistrict()));
        houseType.setAddress(objectFactory.createWgs84Address());
        houseType.getAddress().setGeoHierarchy(geoHierarchy);
    }

    protected void writeEstate(EstateImpl estateImpl, Industry industry, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        industry.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        industry.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        industry.setAutoLift(this.getYesNotApplicable(LiftingPlatform.get((EstateImpl)estateImpl)));
        industry.setCommercializationType(this.getEstateCommercializationType(estateImpl, true));
        industry.setCondition(this.getEstateCondition(estateImpl));
        industry.setConnectedLoad(ElectricalConnectionValue.getAsLong((EstateImpl)estateImpl));
        industry.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        industry.setConstructionYearUnknown(industry.getConstructionYear() == null ? Boolean.TRUE : null);
        industry.setCourtage(this.getEstateCourtageInfo(estateImpl));
        industry.setCraneRunway(this.getYesNotApplicable(Crane.get((EstateImpl)estateImpl)));
        industry.setCraneRunwayLoad(CraneLiftingCapacity.getAsBigDecimal((EstateImpl)estateImpl));
        industry.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        industry.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        industry.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        industry.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        industry.setFloorLoad(FloorLoading.getAsBigDecimal((EstateImpl)estateImpl));
        industry.setFlooringType(this.getEstateFlooringType(estateImpl));
        industry.setGoodsLift(this.getYesNotApplicable(FreightElevator.get((EstateImpl)estateImpl)));
        industry.setGoodsLiftLoad(FreightElevatorCapacity.getAsBigDecimal((EstateImpl)estateImpl));
        industry.setHallHeight(WarehouseHeight.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        industry.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        industry.setIndustryType(this.getEstateIndustryType(estateImpl, list));
        industry.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        industry.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        industry.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        industry.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        industry.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        industry.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        industry.setPlotArea(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        industry.setPrice(this.getEstatePrice(estateImpl, list, true, true));
        industry.setRamp(this.getYesNotApplicable(Ramp.get((EstateImpl)estateImpl)));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        industry.setDeposit(string);
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        industry.setDistanceToPT(l != null && l > 0L ? l : null);
        industry.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)industry.getFreeFrom())) {
            industry.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = StorageArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        industry.setNetFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : null);
        BigDecimal bigDecimal2 = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal2 = industry.getNetFloorSpace();
        }
        industry.setTotalFloorSpace(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : null);
        if (CommercializationType.BUY.equals((Object)industry.getCommercializationType())) {
            industry.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            industry.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (industry.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            industry.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                industry.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                industry.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                industry.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                industry.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal3 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal5 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal4 != null && bigDecimal5 != null) {
                            bl2 = true;
                            industry.getEnergyCertificate().setElectricityConsumption(bigDecimal4);
                            industry.getEnergyCertificate().setHeatingConsumption(bigDecimal5);
                        }
                        if (bigDecimal3 != null) {
                            bl2 = true;
                            industry.setThermalCharacteristic(bigDecimal3);
                            industry.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Industry)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal4 != null && bigDecimal5 != null) {
                            bl3 = true;
                            industry.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal4);
                            industry.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal5);
                        }
                        if (bigDecimal3 != null) {
                            bl3 = true;
                            industry.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            industry.setThermalCharacteristic(bigDecimal3);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Industry)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal6 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal8 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal6 != null) {
                            bl4 = true;
                            industry.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Industry)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal7 != null && bigDecimal8 != null) {
                            bl5 = true;
                            industry.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal7);
                            industry.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal8);
                        }
                        if (bigDecimal6 != null) {
                            bl5 = true;
                            industry.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            industry.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Industry)!");
                        }
                    }
                }
            }
        }
        if (industry.getNetFloorSpace() == null || industry.getNetFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NetFloorSpace' nicht angegeben (f\u00fcr Industry)!");
        }
        if (industry.getTotalFloorSpace() == null || industry.getTotalFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'TotalFloorSpace' nicht angegeben (f\u00fcr Industry)!");
        }
        if (industry.getIndustryType() == null) {
            list2.add("IS24-Pflichtfeld 'IndustryType' nicht angegeben (f\u00fcr Industry)!");
        }
        if (industry.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr Industry)!");
        }
        if (industry.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr Industry)!");
        } else if (industry.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr Industry)!");
        }
        if (industry.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr Industry)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, Investment investment, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        investment.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        investment.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        investment.setCondition(this.getEstateCondition(estateImpl));
        investment.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        investment.setConstructionYearUnknown(investment.getConstructionYear() == null ? Boolean.TRUE : null);
        investment.setCourtage(this.getEstateCourtageInfo(estateImpl));
        investment.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        investment.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        investment.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        investment.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        investment.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        investment.setIndustrialArea(CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        investment.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        investment.setInvestmentType(this.getEstateInvestmentType(estateImpl, list));
        investment.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        investment.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        investment.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        investment.setLivingSpace(ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        investment.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        investment.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        investment.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        investment.setPlotArea(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        investment.setPrice(this.getEstatePurchasePrice(estateImpl));
        investment.setPriceMultiplier(PurchasePriceOnAnnualRentalIncome.getAsBigDecimal((EstateImpl)estateImpl));
        investment.setPricePerSQM(this.getEstatePurchasePricePerSqm(estateImpl));
        investment.setRentalIncomeActual(this.getEstateRentalIncomeActual(estateImpl));
        investment.setRentalIncomeTarget(this.getEstateRentalIncomeDebit(estateImpl));
        investment.setTotalFloorSpace(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        investment.setDistanceToPT(l != null && l > 0L ? l : null);
        investment.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)investment.getFreeFrom())) {
            investment.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = RentableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        investment.setNetFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        if (investment.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            investment.setEnergyPerformanceCertificate(bl);
            investment.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                investment.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                investment.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                investment.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                investment.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal2 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal3 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        investment.getEnergyCertificate().setElectricityConsumption(bigDecimal3);
                        investment.getEnergyCertificate().setHeatingConsumption(bigDecimal4);
                        investment.setThermalCharacteristic(bigDecimal2);
                        investment.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        investment.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal3);
                        investment.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal4);
                        investment.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                        investment.setThermalCharacteristic(bigDecimal2);
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal6 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        investment.setThermalCharacteristic(bigDecimal5);
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        investment.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal6);
                        investment.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal7);
                        investment.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                        investment.setThermalCharacteristic(bigDecimal5);
                    }
                }
            }
        }
        if (investment.getInvestmentType() == null) {
            list2.add("IS24-Pflichtfeld 'InvestmentType' nicht angegeben (f\u00fcr Investment)!");
        }
        if (investment.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr Investment)!");
        } else if (investment.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr Investment)!");
        }
        if (investment.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr Investment)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, LivingBuySite livingBuySite, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        livingBuySite.setBuildingPermission(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        livingBuySite.setCommercializationType(this.getEstateCommercializationType(estateImpl, false));
        livingBuySite.setCourtage(this.getEstateCourtageInfo(estateImpl));
        livingBuySite.setDemolition(DemolitionRequired.get((EstateImpl)estateImpl));
        livingBuySite.setGfz(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        livingBuySite.setGrz(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        livingBuySite.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        livingBuySite.setPrice(this.getEstatePrice(estateImpl, list, true, false));
        livingBuySite.setRecommendedUseTypes(this.getEstateSiteRecommendedUseTypes(estateImpl));
        livingBuySite.setShortTermConstructible(BuildableInShortTerm.get((EstateImpl)estateImpl));
        livingBuySite.setSiteConstructibleType(this.getEstateSiteConstructibleType(estateImpl));
        livingBuySite.setSiteDevelopmentType(this.getEstateSiteDevelopmentType(estateImpl));
        livingBuySite.setTenancy(EmphyteusisDuration.getAsLong((EstateImpl)estateImpl));
        livingBuySite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)livingBuySite.getFreeFrom())) {
            livingBuySite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        livingBuySite.setPlotArea(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        if (livingBuySite.getPlotArea() == null || livingBuySite.getPlotArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'PlotArea' nicht angegeben (f\u00fcr LivingBuySite)!");
        }
        if (livingBuySite.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr LivingBuySite)!");
        }
        if (livingBuySite.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr LivingBuySite)!");
        } else if (livingBuySite.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr LivingBuySite)!");
        }
        if (livingBuySite.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr LivingBuySite)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, LivingRentSite livingRentSite, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        livingRentSite.setBuildingPermission(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        livingRentSite.setCommercializationType(this.getEstateCommercializationType(estateImpl, false));
        livingRentSite.setCourtage(this.getEstateCourtageInfo(estateImpl));
        livingRentSite.setDemolition(DemolitionRequired.get((EstateImpl)estateImpl));
        livingRentSite.setGfz(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        livingRentSite.setGrz(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        livingRentSite.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        livingRentSite.setPrice(this.getEstatePrice(estateImpl, list, true, false));
        livingRentSite.setRecommendedUseTypes(this.getEstateSiteRecommendedUseTypes(estateImpl));
        livingRentSite.setShortTermConstructible(BuildableInShortTerm.get((EstateImpl)estateImpl));
        livingRentSite.setSiteConstructibleType(this.getEstateSiteConstructibleType(estateImpl));
        livingRentSite.setSiteDevelopmentType(this.getEstateSiteDevelopmentType(estateImpl));
        livingRentSite.setTenancy(EmphyteusisDuration.getAsLong((EstateImpl)estateImpl));
        livingRentSite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)livingRentSite.getFreeFrom())) {
            livingRentSite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        livingRentSite.setPlotArea(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        if (livingRentSite.getPlotArea() == null || livingRentSite.getPlotArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'PlotArea' nicht angegeben (f\u00fcr LivingRentSite)!");
        }
        if (livingRentSite.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr LivingRentSite)!");
        }
        if (livingRentSite.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr LivingRentSite)!");
        } else if (livingRentSite.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr LivingRentSite)!");
        }
        if (livingRentSite.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr LivingRentSite)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, Office office, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        office.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        office.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        office.setAirConditioning(this.getEstateAirConditioningType(estateImpl));
        office.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        office.setCommercializationType(this.getEstateCommercializationType(estateImpl, true));
        office.setCondition(this.getEstateCondition(estateImpl));
        office.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        office.setConstructionYearUnknown(office.getConstructionYear() == null ? Boolean.TRUE : null);
        office.setCourtage(this.getEstateCourtageInfo(estateImpl));
        office.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        office.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        office.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        office.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        office.setFlooringType(this.getEstateFlooringType(estateImpl));
        office.setHandicappedAccessible(this.getYesNotApplicable(BarrierFree.get((EstateImpl)estateImpl)));
        office.setHasCanteen(this.getYesNotApplicable(CanteenCafeteria.get((EstateImpl)estateImpl)));
        office.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        office.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        office.setKitchenComplete(this.getYesNotApplicable(!Kitchen.getAsList((EstateImpl)estateImpl).isEmpty()));
        office.setLanCables(this.getEstateItInfrastructureType(estateImpl));
        office.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        office.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        office.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        office.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        office.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        office.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        office.setOfficeType(this.getEstateOfficeType(estateImpl, list));
        office.setPrice(this.getEstatePrice(estateImpl, list, true, true));
        office.setTotalFloorSpace(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        office.setDeposit(string);
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        office.setDistanceToPT(l != null && l > 0L ? l : null);
        office.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)office.getFreeFrom())) {
            office.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = OfficeArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        office.setNetFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : null);
        if (CommercializationType.BUY.equals((Object)office.getCommercializationType())) {
            office.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            office.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (office.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            office.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                office.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                office.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                office.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                office.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal2 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal3 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl2 = true;
                            office.getEnergyCertificate().setElectricityConsumption(bigDecimal3);
                            office.getEnergyCertificate().setHeatingConsumption(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl2 = true;
                            office.setThermalCharacteristic(bigDecimal2);
                            office.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Office)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl3 = true;
                            office.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal3);
                            office.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl3 = true;
                            office.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            office.setThermalCharacteristic(bigDecimal2);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Office)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal6 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            office.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Office)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal6 != null && bigDecimal7 != null) {
                            bl5 = true;
                            office.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal6);
                            office.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal7);
                        }
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            office.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            office.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Office)!");
                        }
                    }
                }
            }
        }
        if (office.getNetFloorSpace() == null || office.getNetFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NetFloorSpace' nicht angegeben (f\u00fcr Office)!");
        }
        if (office.getOfficeType() == null) {
            list2.add("IS24-Pflichtfeld 'OfficeType' nicht angegeben (f\u00fcr Office)!");
        }
        if (office.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr Office)!");
        }
        if (office.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr Office)!");
        } else if (office.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr Office)!");
        }
        if (office.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr Office)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, SeniorCare seniorCare, List<OpenEstateType> list, List<String> list2) {
        list2.add("Altenpflege wird derzeit nicht unterst\u00fctzt!");
    }

    protected void writeEstate(EstateImpl estateImpl, ShortTermAccommodation shortTermAccommodation, List<OpenEstateType> list, List<String> list2) {
        Number number;
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        shortTermAccommodation.setBalcony(BalconyTerrace.get((EstateImpl)estateImpl));
        shortTermAccommodation.setBaseRent(RentExcludingServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        shortTermAccommodation.setCellar(Basement.get((EstateImpl)estateImpl));
        shortTermAccommodation.setCondition(this.getEstateCondition(estateImpl));
        shortTermAccommodation.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        shortTermAccommodation.setConstructionYearUnknown(shortTermAccommodation.getConstructionYear() == null ? Boolean.TRUE : null);
        shortTermAccommodation.setCourtage(this.getEstateCourtageInfo(estateImpl));
        shortTermAccommodation.setEndRentalDate(AvailabilityEndDate.getAsCalendar((EstateImpl)estateImpl));
        shortTermAccommodation.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        shortTermAccommodation.setFloor(Floor.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        shortTermAccommodation.setGarden(GardenUse.get((EstateImpl)estateImpl));
        shortTermAccommodation.setGender(this.getEstateFlatMateGenderType(estateImpl));
        shortTermAccommodation.setHandicappedAccessible(BarrierFree.get((EstateImpl)estateImpl));
        shortTermAccommodation.setHasFurniture(this.getEstateFurnishing(estateImpl));
        shortTermAccommodation.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        shortTermAccommodation.setLift(Lift.get((EstateImpl)estateImpl));
        shortTermAccommodation.setMaxNumberOfPersons(PeopleMaximumCount.getAsLong((EstateImpl)estateImpl));
        shortTermAccommodation.setNonSmoker(this.getEstateNonSmoker(estateImpl));
        shortTermAccommodation.setNumberOfFloors(CountFloors.getAsLong((EstateImpl)estateImpl));
        shortTermAccommodation.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        shortTermAccommodation.setNumberOfRooms(CountRooms.getAsBigDecimal((EstateImpl)estateImpl));
        shortTermAccommodation.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        shortTermAccommodation.setParkingSpaceType(this.getEstateParkingSpaceType(estateImpl));
        shortTermAccommodation.setPetsAllowed(this.getEstatePetsAllowedType(estateImpl));
        shortTermAccommodation.setPrice(this.getEstatePrice(estateImpl, list, false, false));
        shortTermAccommodation.setServiceCharge(ServiceCharges.getAsBigDecimal((EstateImpl)estateImpl));
        shortTermAccommodation.setShortTermAccomodationType(this.getEstateShortTermAccommodationType(estateImpl, list));
        shortTermAccommodation.setStartRentalDate(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        shortTermAccommodation.setDeposit(string);
        if (ResidentialRooms.hasOption((EstateImpl)estateImpl, (ResidentialRooms.Option)ResidentialRooms.Option.GUEST_TOILET)) {
            shortTermAccommodation.setGuestToilet(Boolean.valueOf(true));
        }
        if ((bigDecimal = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        shortTermAccommodation.setLivingSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        Number number2 = OpenEstateUtils.parseNumber((String)OccupationPeriodMaximum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (number2 instanceof BigDecimal) {
            shortTermAccommodation.setMaxRentalTime((BigDecimal)number2);
        } else if (number2 instanceof BigInteger) {
            shortTermAccommodation.setMaxRentalTime(new BigDecimal((BigInteger)number2));
        } else if (number2 != null) {
            shortTermAccommodation.setMaxRentalTime(BigDecimal.valueOf(number2.doubleValue()));
        }
        if (shortTermAccommodation.getMaxRentalTime() != null && shortTermAccommodation.getMaxRentalTime().compareTo(BigDecimal.ZERO) < 1) {
            shortTermAccommodation.setMaxRentalTime(null);
        }
        if ((number = OpenEstateUtils.parseNumber((String)OccupationPeriodMinimum.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()))) instanceof BigDecimal) {
            shortTermAccommodation.setMinRentalTime((BigDecimal)number);
        } else if (number instanceof BigInteger) {
            shortTermAccommodation.setMinRentalTime(new BigDecimal((BigInteger)number));
        } else if (number != null) {
            shortTermAccommodation.setMinRentalTime(BigDecimal.valueOf(number.doubleValue()));
        }
        if (shortTermAccommodation.getMinRentalTime() != null && shortTermAccommodation.getMinRentalTime().compareTo(BigDecimal.ZERO) < 1) {
            shortTermAccommodation.setMinRentalTime(null);
        }
        if (shortTermAccommodation.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            shortTermAccommodation.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                shortTermAccommodation.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                shortTermAccommodation.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal2 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal3 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl2 = true;
                            shortTermAccommodation.getEnergyCertificate().setElectricityConsumption(bigDecimal3);
                            shortTermAccommodation.getEnergyCertificate().setHeatingConsumption(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl2 = true;
                            shortTermAccommodation.setThermalCharacteristic(bigDecimal2);
                            shortTermAccommodation.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ShortTermAccommodation)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl3 = true;
                            shortTermAccommodation.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal3);
                            shortTermAccommodation.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl3 = true;
                            shortTermAccommodation.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            shortTermAccommodation.setThermalCharacteristic(bigDecimal2);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ShortTermAccommodation)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal6 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            shortTermAccommodation.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr ShortTermAccommodation)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal6 != null && bigDecimal7 != null) {
                            bl5 = true;
                            shortTermAccommodation.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal6);
                            shortTermAccommodation.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal7);
                        }
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            shortTermAccommodation.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            shortTermAccommodation.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr ShortTermAccommodation)!");
                        }
                    }
                }
            }
        }
        if (shortTermAccommodation.getShortTermAccomodationType() == null) {
            list2.add("IS24-Pflichtfeld 'ShortTermAccomodationType' nicht angegeben (f\u00fcr ShortTermAccommodation)!");
        }
        if (shortTermAccommodation.getStartRentalDate() == null) {
            list2.add("IS24-Pflichtfeld 'StartRentalDate' nicht angegeben (f\u00fcr ShortTermAccommodation)!");
        }
        if (shortTermAccommodation.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr ShortTermAccommodation)!");
        } else if (shortTermAccommodation.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr ShortTermAccommodation)!");
        }
        if (shortTermAccommodation.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr ShortTermAccommodation)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, SpecialPurpose specialPurpose, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        specialPurpose.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        specialPurpose.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        specialPurpose.setBasement(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        specialPurpose.setCommercializationType(this.getEstateCommercializationType(estateImpl, true));
        specialPurpose.setCondition(this.getEstateCondition(estateImpl));
        specialPurpose.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        specialPurpose.setConstructionYearUnknown(specialPurpose.getConstructionYear() == null ? Boolean.TRUE : null);
        specialPurpose.setCourtage(this.getEstateCourtageInfo(estateImpl));
        specialPurpose.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        specialPurpose.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        specialPurpose.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        specialPurpose.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        specialPurpose.setFlooringType(this.getEstateFlooringType(estateImpl));
        specialPurpose.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        specialPurpose.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        specialPurpose.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        specialPurpose.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        specialPurpose.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        specialPurpose.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        specialPurpose.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        specialPurpose.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        specialPurpose.setPlotArea(PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        specialPurpose.setPrice(this.getEstatePrice(estateImpl, list, true, true));
        specialPurpose.setSpecialPurposePropertyType(this.getEstateSpecialPurposeType(estateImpl, list));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        specialPurpose.setDeposit(string);
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        specialPurpose.setDistanceToPT(l != null && l > 0L ? l : null);
        specialPurpose.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)specialPurpose.getFreeFrom())) {
            specialPurpose.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        specialPurpose.setNetFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        BigDecimal bigDecimal2 = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (bigDecimal2 == null || bigDecimal2.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal2 = specialPurpose.getNetFloorSpace();
        }
        specialPurpose.setTotalFloorSpace(bigDecimal2 != null && bigDecimal2.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal2 : null);
        if (CommercializationType.BUY.equals((Object)specialPurpose.getCommercializationType())) {
            specialPurpose.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            specialPurpose.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (specialPurpose.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            specialPurpose.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                specialPurpose.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                specialPurpose.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                specialPurpose.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                specialPurpose.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal3 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal5 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal4 != null && bigDecimal5 != null) {
                            bl2 = true;
                            specialPurpose.getEnergyCertificate().setElectricityConsumption(bigDecimal4);
                            specialPurpose.getEnergyCertificate().setHeatingConsumption(bigDecimal5);
                        }
                        if (bigDecimal3 != null) {
                            bl2 = true;
                            specialPurpose.setThermalCharacteristic(bigDecimal3);
                            specialPurpose.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr SpecialPurpose)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal4 != null && bigDecimal5 != null) {
                            bl3 = true;
                            specialPurpose.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal4);
                            specialPurpose.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal5);
                        }
                        if (bigDecimal3 != null) {
                            bl3 = true;
                            specialPurpose.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            specialPurpose.setThermalCharacteristic(bigDecimal3);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr SpecialPurpose)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal6 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal8 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal6 != null) {
                            bl4 = true;
                            specialPurpose.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr SpecialPurpose)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal7 != null && bigDecimal8 != null) {
                            bl5 = true;
                            specialPurpose.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal7);
                            specialPurpose.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal8);
                        }
                        if (bigDecimal6 != null) {
                            bl5 = true;
                            specialPurpose.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            specialPurpose.setThermalCharacteristic(bigDecimal6);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr SpecialPurpose)!");
                        }
                    }
                }
            }
        }
        if (specialPurpose.getNetFloorSpace() == null || specialPurpose.getNetFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NetFloorSpace' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
        if (specialPurpose.getTotalFloorSpace() == null || specialPurpose.getTotalFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'TotalFloorSpace' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
        if (specialPurpose.getSpecialPurposePropertyType() == null) {
            list2.add("IS24-Pflichtfeld 'SpecialPurposePropertyType' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
        if (specialPurpose.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
        if (specialPurpose.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr SpecialPurpose)!");
        } else if (specialPurpose.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
        if (specialPurpose.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr SpecialPurpose)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, Store store, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        org.openestate.is24.restapi.xml.common.ObjectFactory objectFactory = new org.openestate.is24.restapi.xml.common.ObjectFactory();
        store.setAdditionalArea(RemainingAreas.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        store.setAdditionalCosts(this.getEstateAdditionalCosts(estateImpl));
        store.setCellar(this.getYesNotApplicable(Basement.get((EstateImpl)estateImpl)));
        store.setCommercializationType(this.getEstateCommercializationType(estateImpl, true));
        store.setCondition(this.getEstateCondition(estateImpl));
        store.setConstructionYear(BuildYear.getAsLong((EstateImpl)estateImpl));
        store.setConstructionYearUnknown(store.getConstructionYear() == null ? Boolean.TRUE : null);
        store.setCourtage(this.getEstateCourtageInfo(estateImpl));
        store.setDistanceToAirport(Is24Utils.getFahrtwegZeit(DistanceToAirport.get((EstateImpl)estateImpl)));
        store.setDistanceToFM(Is24Utils.getFahrtwegZeit(DistanceToMotorway.get((EstateImpl)estateImpl)));
        store.setDistanceToMRS(Is24Utils.getFahrtwegZeit(DistanceToMainLineStation.get((EstateImpl)estateImpl)));
        store.setEnergySourcesEnev2014(this.getEstateFiringTypes(estateImpl));
        store.setFloorLoad(CeilingLoad.getAsBigDecimal((EstateImpl)estateImpl));
        store.setFlooringType(this.getEstateFlooringType(estateImpl));
        store.setGoodsLift(this.getYesNotApplicable(FreightElevator.get((EstateImpl)estateImpl)));
        store.setGoodsLiftLoad(FreightElevatorCapacity.getAsBigDecimal((EstateImpl)estateImpl));
        store.setHeatingTypeEnev2014(this.getEstateHeatingType(estateImpl));
        store.setInteriorQuality(this.getEstateInteriorQuality(estateImpl));
        store.setLastRefurbishment(RefurbishmentYear.getAsLong((EstateImpl)estateImpl));
        store.setLift(this.getYesNotApplicable(Lift.get((EstateImpl)estateImpl)));
        store.setListed(this.getYesNotApplicable(MonumentalProtection.get((EstateImpl)estateImpl)));
        store.setLocationClassificationType(this.getEstateLocationClassificationType(estateImpl));
        store.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        store.setNumberOfFloors(CountFloors.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        store.setNumberOfParkingSpaces(CountParkingSpaces.getAsLong((EstateImpl)estateImpl));
        store.setPrice(this.getEstatePrice(estateImpl, list, true, true));
        store.setRamp(this.getYesNotApplicable(Ramp.get((EstateImpl)estateImpl)));
        store.setShopWindowLength(FrontWindowLength.getAsBigDecimal((EstateImpl)estateImpl, (LengthValue.Unit)LengthValue.Unit.M));
        store.setStoreType(this.getEstateStoreType(estateImpl, list));
        store.setSupplyType(this.getEstateSupplyType(estateImpl));
        store.setTotalFloorSpace(TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        String string = StringUtils.trimToNull((String)Deposit.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        if (string == null) {
            string = StringUtils.trimToNull((String)DepositAmount.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        }
        store.setDeposit(string);
        Long l = Is24Utils.getFusswegZeit(DistanceToBusStation.get((EstateImpl)estateImpl));
        if (l == null || l < 1L) {
            l = Is24Utils.getFusswegZeit(DistanceToNextTrainStation.get((EstateImpl)estateImpl));
        }
        store.setDistanceToPT(l != null && l > 0L ? l : null);
        store.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)store.getFreeFrom())) {
            store.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = SalesArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = AdministrationArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        store.setNetFloorSpace(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : null);
        if (CommercializationType.BUY.equals((Object)store.getCommercializationType())) {
            store.setParkingSpacePrice(CarParkingSpacePrice.getAsBigDecimal((EstateImpl)estateImpl));
        } else {
            store.setParkingSpacePrice(CarParkingSpaceRent.getAsBigDecimal((EstateImpl)estateImpl));
        }
        if (store.getAddress().getInternationalCountryRegion() == null) {
            Boolean bl = this.getEstateEnergyCertificateAvailable(estateImpl);
            store.setEnergyCertificate(objectFactory.createEnergyPerformanceCertificate());
            if (!Boolean.TRUE.equals(bl)) {
                store.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.NOT_AVAILABLE_YET);
            } else {
                store.getEnergyCertificate().setEnergyCertificateAvailability(EnergyCertificateAvailability.AVAILABLE);
                BuildingEnergyRatingType buildingEnergyRatingType = this.getEstateEnergyCertificateType(estateImpl);
                store.setBuildingEnergyRatingType(buildingEnergyRatingType);
                EnergyCertificateCreationDate energyCertificateCreationDate = this.getEstateEnergyCertificateDate(estateImpl);
                store.getEnergyCertificate().setEnergyCertificateCreationDate(energyCertificateCreationDate);
                if (BuildingEnergyRatingType.ENERGY_CONSUMPTION.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal2 = ConsumptionTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal3 = ConsumptionElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal4 = ConsumptionHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl2 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl2 = true;
                            store.getEnergyCertificate().setElectricityConsumption(bigDecimal3);
                            store.getEnergyCertificate().setHeatingConsumption(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl2 = true;
                            store.setThermalCharacteristic(bigDecimal2);
                            store.setEnergyConsumptionContainsWarmWater(this.getYesNotApplicable(ConsumptionIncludingHotWater.get((EstateImpl)estateImpl)));
                        }
                        if (!bl2) {
                            list2.add("Energie-Verbrauchsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Store)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl3 = false;
                        if (bigDecimal3 != null && bigDecimal4 != null) {
                            bl3 = true;
                            store.getEnergyCertificate().setEnergyConsumptionElectricity(bigDecimal3);
                            store.getEnergyCertificate().setEnergyConsumptionHeating(bigDecimal4);
                        }
                        if (bigDecimal2 != null) {
                            bl3 = true;
                            store.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            store.setThermalCharacteristic(bigDecimal2);
                        }
                        if (!bl3) {
                            list2.add("Energie-Verbrauchsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Store)!");
                        }
                    }
                } else if (BuildingEnergyRatingType.ENERGY_REQUIRED.equals((Object)buildingEnergyRatingType)) {
                    BigDecimal bigDecimal5 = DemandTotal.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal6 = DemandElectricity.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    BigDecimal bigDecimal7 = DemandHeating.getAsBigDecimal((EstateImpl)estateImpl, (EnergyConsumptionValue.Unit)EnergyConsumptionValue.Unit.KWH_PER_SQM_AND_YEAR);
                    if (EnergyCertificateCreationDate.BEFORE_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl4 = false;
                        if (bigDecimal5 != null) {
                            bl4 = true;
                            store.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl4) {
                            list2.add("Energie-Bedarfsausweis (vor 01.05.2014) ist ung\u00fcltig (f\u00fcr Store)!");
                        }
                    } else if (EnergyCertificateCreationDate.FROM_01_MAY_2014.equals((Object)energyCertificateCreationDate)) {
                        boolean bl5 = false;
                        if (bigDecimal6 != null && bigDecimal7 != null) {
                            bl5 = true;
                            store.getEnergyCertificate().setThermalCharacteristicElectricity(bigDecimal6);
                            store.getEnergyCertificate().setThermalCharacteristicHeating(bigDecimal7);
                        }
                        if (bigDecimal5 != null) {
                            bl5 = true;
                            store.getEnergyCertificate().setEnergyEfficiencyClass(this.getEstateEnergyCertificateClass(estateImpl));
                            store.setThermalCharacteristic(bigDecimal5);
                        }
                        if (!bl5) {
                            list2.add("Energie-Bedarfsausweis (ab 01.05.2014) ist ung\u00fcltig (f\u00fcr Store)!");
                        }
                    }
                }
            }
        }
        if (store.getNetFloorSpace() == null || store.getNetFloorSpace().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'NetFloorSpace' nicht angegeben (f\u00fcr Office)!");
        }
        if (store.getStoreType() == null) {
            list2.add("IS24-Pflichtfeld 'StoreType' nicht angegeben (f\u00fcr Store)!");
        }
        if (store.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr Store)!");
        }
        if (store.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr Store)!");
        } else if (store.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr Store)!");
        }
        if (store.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr Store)!");
        }
    }

    protected void writeEstate(EstateImpl estateImpl, TradeSite tradeSite, List<OpenEstateType> list, List<String> list2) {
        BigDecimal bigDecimal;
        tradeSite.setBuildingPermission(BuildingPermissionAvailable.get((EstateImpl)estateImpl));
        tradeSite.setCommercializationType(this.getEstateCommercializationType(estateImpl, false));
        tradeSite.setCourtage(this.getEstateCourtageInfo(estateImpl));
        tradeSite.setDemolition(DemolitionRequired.get((EstateImpl)estateImpl));
        tradeSite.setGfz(FloorAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        tradeSite.setGrz(BaseAreaIndex.getAsBigDecimal((EstateImpl)estateImpl));
        tradeSite.setMinDivisible(DivisibleFromArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM));
        tradeSite.setPrice(this.getEstatePrice(estateImpl, list, true, false));
        tradeSite.setRecommendedUseTypes(this.getEstateSiteRecommendedUseForTradeTypes(estateImpl));
        tradeSite.setShortTermConstructible(BuildableInShortTerm.get((EstateImpl)estateImpl));
        tradeSite.setSiteConstructibleType(this.getEstateSiteConstructibleType(estateImpl));
        tradeSite.setSiteDevelopmentType(this.getEstateSiteDevelopmentType(estateImpl));
        tradeSite.setTenancy(EmphyteusisDuration.getAsLong((EstateImpl)estateImpl));
        tradeSite.setUtilizationTradeSite(this.getEstateUtilizationTradeSite(estateImpl, list));
        tradeSite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBegin.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        if (StringUtils.isBlank((CharSequence)tradeSite.getFreeFrom())) {
            tradeSite.setFreeFrom(StringUtils.trimToNull((String)AvailabilityBeginDate.getAsString((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage())));
        }
        if ((bigDecimal = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM)) == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = UsableArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (bigDecimal == null || bigDecimal.compareTo(BigDecimal.ZERO) < 1) {
            bigDecimal = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        tradeSite.setPlotArea(bigDecimal != null && bigDecimal.compareTo(BigDecimal.ZERO) > 0 ? bigDecimal : BigDecimal.ZERO);
        if (tradeSite.getPlotArea() == null || tradeSite.getPlotArea().compareTo(BigDecimal.ZERO) < 1) {
            list2.add("IS24-Pflichtfeld 'PlotArea' nicht angegeben (f\u00fcr TradeSite)!");
        }
        if (tradeSite.getUtilizationTradeSite() == null) {
            list2.add("IS24-Pflichtfeld 'UtilizationTradeSite' nicht angegeben (f\u00fcr TradeSite)!");
        }
        if (tradeSite.getCommercializationType() == null) {
            list2.add("IS24-Pflichtfeld 'CommercializationType' nicht angegeben (f\u00fcr TradeSite)!");
        }
        if (tradeSite.getCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'Courtage' nicht angegeben (f\u00fcr TradeSite)!");
        } else if (tradeSite.getCourtage().getHasCourtage() == null) {
            list2.add("IS24-Pflichtfeld 'HasCourtage' nicht angegeben (f\u00fcr TradeSite)!");
        }
        if (tradeSite.getPrice() == null) {
            list2.add("IS24-Pflichtfeld 'Price' nicht angegeben (f\u00fcr TradeSite)!");
        }
    }
}

