/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.impl.daft_ie;

import com.openindex.openestate.impl.AgencyImpl;
import com.openindex.openestate.impl.AgentContactImpl;
import com.openindex.openestate.impl.AgentImpl;
import com.openindex.openestate.impl.EstateAttachmentImpl;
import com.openindex.openestate.impl.EstateImpl;
import com.openindex.openestate.impl.OpenEstateAction;
import com.openindex.openestate.impl.OpenEstateAttrib;
import com.openindex.openestate.impl.OpenEstateType;
import com.openindex.openestate.impl.OpenEstateUtils;
import com.openindex.openestate.impl.TransferAgencyImpl;
import com.openindex.openestate.impl.TransferImpl;
import com.openindex.openestate.impl.attribs.AbstractAttribImpl;
import com.openindex.openestate.impl.attribs.ComplexEnumAttrib;
import com.openindex.openestate.impl.attribs.ComplexStringAttrib;
import com.openindex.openestate.impl.attribs.SimpleBooleanAttrib;
import com.openindex.openestate.impl.attribs.SimpleEnumAttrib;
import com.openindex.openestate.impl.attribs.administration.AvailabilityBeginDate;
import com.openindex.openestate.impl.attribs.condition.Age;
import com.openindex.openestate.impl.attribs.features.ClimateBuildingStandard;
import com.openindex.openestate.impl.attribs.features.Furnished;
import com.openindex.openestate.impl.attribs.features.Technics;
import com.openindex.openestate.impl.attribs.measures.CarParkingArea;
import com.openindex.openestate.impl.attribs.measures.CommercialArea;
import com.openindex.openestate.impl.attribs.measures.CountBathrooms;
import com.openindex.openestate.impl.attribs.measures.CountBedrooms;
import com.openindex.openestate.impl.attribs.measures.CountBeds;
import com.openindex.openestate.impl.attribs.measures.PlotArea;
import com.openindex.openestate.impl.attribs.measures.ResidentialArea;
import com.openindex.openestate.impl.attribs.measures.SalesArea;
import com.openindex.openestate.impl.attribs.measures.TotalArea;
import com.openindex.openestate.impl.attribs.prices.BasicRent;
import com.openindex.openestate.impl.attribs.prices.Lease;
import com.openindex.openestate.impl.attribs.prices.PurchasePrice;
import com.openindex.openestate.impl.attribs.prices.RentExcludingServiceCharges;
import com.openindex.openestate.impl.attribs.prices.RentFlatRate;
import com.openindex.openestate.impl.attribs.prices.RentFlatRatePer;
import com.openindex.openestate.impl.attribs.prices.RentIncludingServiceCharges;
import com.openindex.openestate.impl.utils.AbstractXmlWriter;
import com.openindex.openestate.impl.values.AreaValue;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.daft_ie.DaftIeDocument;
import org.openestate.io.daft_ie.DaftIeUtils;
import org.openestate.io.daft_ie.xml.CommercialType;
import org.openestate.io.daft_ie.xml.Daft;
import org.openestate.io.daft_ie.xml.FeaturesType;
import org.openestate.io.daft_ie.xml.HouseType;
import org.openestate.io.daft_ie.xml.ObjectFactory;
import org.openestate.io.daft_ie.xml.OverseasRentalAdType;
import org.openestate.io.daft_ie.xml.OverseasSaleAdType;
import org.openestate.io.daft_ie.xml.PdfsType;
import org.openestate.io.daft_ie.xml.PhotosType;
import org.openestate.io.daft_ie.xml.PropertyType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DaftIeWriter
extends AbstractXmlWriter<DaftIeDocument, Daft> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DaftIeWriter.class);
    private static final ObjectFactory FACTORY = DaftIeUtils.getFactory();
    private boolean energyCertificateAppendedToDescription = false;
    private String baseUrl = null;

    public DaftIeWriter() {
        this(DaftIeUtils.DEFAULT_LOCALE);
    }

    public DaftIeWriter(Locale locale) {
        this.setOpenEstateLanguage(locale != null ? locale : DaftIeUtils.DEFAULT_LOCALE);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OverseasRentalAdType convertEstateForRent(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        Object object;
        OverseasRentalAdType overseasRentalAdType;
        block31: {
            block33: {
                block32: {
                    AgentContactImpl agentContactImpl2;
                    overseasRentalAdType = FACTORY.createOverseasRentalAdType();
                    overseasRentalAdType.setAgentId(agentImpl.getId());
                    overseasRentalAdType.setExternalId(estateImpl.getId());
                    try {
                        agentContactImpl2 = Arrays.asList(estateImpl.getType().getParentPath());
                        object = this.getPropertyType((List<OpenEstateType>)agentContactImpl2);
                        if (object == null) {
                            throw new Exception("Unsupported estate type: " + estateImpl.getType() + "!");
                        }
                        overseasRentalAdType.setPropertyType((PropertyType)object);
                        if (PropertyType.HOUSE.equals(object)) {
                            overseasRentalAdType.setHouseType(this.getHouseType((List<OpenEstateType>)agentContactImpl2));
                        } else {
                            overseasRentalAdType.setHouseType(null);
                        }
                        if (PropertyType.COMMERCIAL.equals(object)) {
                            overseasRentalAdType.setCommercialType(this.getCommercialType((List<OpenEstateType>)agentContactImpl2));
                        } else {
                            overseasRentalAdType.setCommercialType(null);
                        }
                    }
                    catch (Exception exception) {
                        LOGGER.warn("Can't set estate-type!");
                        LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
                        list.add("Can't set estate-type: " + exception.getLocalizedMessage());
                        return null;
                    }
                    overseasRentalAdType.setCountry(estateImpl.getAddress().getCountry());
                    overseasRentalAdType.setRegion(estateImpl.getAddress().getRegion());
                    if (StringUtils.isBlank((CharSequence)overseasRentalAdType.getRegion())) {
                        overseasRentalAdType.setRegion(estateImpl.getAddress().getCity());
                    }
                    overseasRentalAdType.setArea(estateImpl.getAddress().getCity());
                    if (estateImpl.getAddress().isPublished()) {
                        overseasRentalAdType.setAddress(estateImpl.getAddress().writeStreet() + ", " + estateImpl.getAddress().getPostalCode());
                    } else {
                        overseasRentalAdType.setAddress(estateImpl.getAddress().getPostalCode());
                    }
                    agentContactImpl2 = agentContactImpl != null ? agentContactImpl : agentImpl.getCompany();
                    overseasRentalAdType.setContactName(agentContactImpl2.writePersonFullName());
                    if (StringUtils.isBlank((CharSequence)overseasRentalAdType.getContactName())) {
                        overseasRentalAdType.setContactName(agentImpl.getCompany().getCompanyName());
                    }
                    overseasRentalAdType.setMainEmail(agentContactImpl2.getPersonMail());
                    if (StringUtils.isBlank((CharSequence)overseasRentalAdType.getMainEmail())) {
                        overseasRentalAdType.setMainEmail(agentImpl.getCompany().getCompanyMail());
                    }
                    overseasRentalAdType.setPhone1(agentContactImpl2.getPersonPhone());
                    if (StringUtils.isBlank((CharSequence)overseasRentalAdType.getPhone1())) {
                        overseasRentalAdType.setPhone1(agentImpl.getCompany().getCompanyPhone());
                    }
                    overseasRentalAdType.setPhone2(agentContactImpl2.getPersonMobilePhone());
                    if (StringUtils.isBlank((CharSequence)overseasRentalAdType.getPhone2())) {
                        overseasRentalAdType.setPhone2(agentImpl.getCompany().getCompanyMobilePhone());
                    }
                    if (!OpenEstateAction.RENT.equals((Object)estateImpl.getAction())) break block32;
                    overseasRentalAdType.setRent(BasicRent.getAsBigInteger((EstateImpl)estateImpl));
                    if (overseasRentalAdType.getRent() == null || overseasRentalAdType.getRent().compareTo(BigInteger.ZERO) < 1) {
                        overseasRentalAdType.setRent(RentExcludingServiceCharges.getAsBigInteger((EstateImpl)estateImpl));
                    }
                    if (overseasRentalAdType.getRent() == null || overseasRentalAdType.getRent().compareTo(BigInteger.ZERO) < 1) {
                        overseasRentalAdType.setRent(RentIncludingServiceCharges.getAsBigInteger((EstateImpl)estateImpl));
                    }
                    overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
                    break block31;
                }
                if (!OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction())) break block33;
                overseasRentalAdType.setRent(RentFlatRate.getAsBigInteger((EstateImpl)estateImpl));
                object = RentFlatRatePer.get((EstateImpl)estateImpl);
                if (RentFlatRatePer.Option.MONTH.equals(object)) {
                    overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
                    break block31;
                } else if (RentFlatRatePer.Option.WEEK.equals(object)) {
                    overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.WEEKLY);
                    break block31;
                } else {
                    if (object != null) {
                        list.add("Unssupported rent period: " + object + "!");
                        return null;
                    }
                    overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
                }
                break block31;
            }
            if (OpenEstateAction.LEASE.equals((Object)estateImpl.getAction())) {
                overseasRentalAdType.setRent(Lease.getAsBigInteger((EstateImpl)estateImpl));
                overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
            } else if (OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
                overseasRentalAdType.setRent(Lease.getAsBigInteger((EstateImpl)estateImpl));
                overseasRentalAdType.setRentCollectionPeriod(OverseasRentalAdType.RentPeriod.MONTHLY);
            }
        }
        overseasRentalAdType.setBathroomNumber(CountBathrooms.getAsBigInteger((EstateImpl)estateImpl));
        overseasRentalAdType.setBedroomNumber(CountBedrooms.getAsBigInteger((EstateImpl)estateImpl));
        overseasRentalAdType.setDescription(this.getDescription(estateImpl));
        overseasRentalAdType.setDishwasher(Boolean.valueOf(false));
        overseasRentalAdType.setDryer(Boolean.valueOf(false));
        overseasRentalAdType.setMicrowave(Boolean.valueOf(false));
        overseasRentalAdType.setWashingMachine(Boolean.valueOf(false));
        object = Technics.getAsList((EstateImpl)estateImpl);
        overseasRentalAdType.setCableTelevision(Boolean.valueOf(object.contains(Technics.Option.CABLE_SAT_TV) || object.contains(Technics.Option.CABLE_TV)));
        Furnished.Option option = Furnished.get((EstateImpl)estateImpl);
        if (Furnished.Option.YES.equals((Object)option)) {
            overseasRentalAdType.setFurnished(OverseasRentalAdType.Furnished.FURNISHED);
        } else if (Furnished.Option.NO.equals((Object)option)) {
            overseasRentalAdType.setFurnished(OverseasRentalAdType.Furnished.UNFURNISHED);
        } else if (Furnished.Option.PARTIAL.equals((Object)option)) {
            overseasRentalAdType.setFurnished(OverseasRentalAdType.Furnished.FURNISHED);
        } else {
            overseasRentalAdType.setFurnished(OverseasRentalAdType.Furnished.EITHER);
        }
        overseasRentalAdType.setAvailableFrom(AvailabilityBeginDate.getAsCalendar((EstateImpl)estateImpl));
        overseasRentalAdType.setNumberPeople(CountBeds.getAsBigInteger((EstateImpl)estateImpl));
        overseasRentalAdType.setFeatures(this.getFeatures(estateImpl));
        overseasRentalAdType.setPhotos(this.getPhotos(estateImpl));
        return overseasRentalAdType;
    }

    public OverseasSaleAdType convertEstateForSale(EstateImpl estateImpl, AgentImpl agentImpl, AgentContactImpl agentContactImpl, List<String> list) {
        Age.Option option;
        Object object;
        AgentContactImpl agentContactImpl2;
        OverseasSaleAdType overseasSaleAdType = FACTORY.createOverseasSaleAdType();
        overseasSaleAdType.setAgentId(agentImpl.getId());
        overseasSaleAdType.setExternalId(estateImpl.getId());
        overseasSaleAdType.setPropertyStatus(OverseasSaleAdType.PropertyStatus.FOR_SALE);
        try {
            agentContactImpl2 = Arrays.asList(estateImpl.getType().getParentPath());
            object = this.getPropertyType((List<OpenEstateType>)agentContactImpl2);
            if (object == null) {
                throw new Exception("Unsupported estate type: " + estateImpl.getType() + "!");
            }
            overseasSaleAdType.setPropertyType((PropertyType)object);
            if (PropertyType.HOUSE.equals(object)) {
                overseasSaleAdType.setHouseType(this.getHouseType((List<OpenEstateType>)agentContactImpl2));
            } else {
                overseasSaleAdType.setHouseType(null);
            }
            if (PropertyType.COMMERCIAL.equals(object)) {
                overseasSaleAdType.setCommercialType(this.getCommercialType((List<OpenEstateType>)agentContactImpl2));
            } else {
                overseasSaleAdType.setCommercialType(null);
            }
        }
        catch (Exception exception) {
            LOGGER.warn("Can't set estate-type!");
            LOGGER.warn("> " + exception.getLocalizedMessage(), (Throwable)exception);
            list.add("Can't set estate-type: " + exception.getLocalizedMessage());
            return null;
        }
        overseasSaleAdType.setCountry(estateImpl.getAddress().getCountry());
        overseasSaleAdType.setRegion(estateImpl.getAddress().getRegion());
        if (StringUtils.isBlank((CharSequence)overseasSaleAdType.getRegion())) {
            overseasSaleAdType.setRegion(estateImpl.getAddress().getCity());
        }
        overseasSaleAdType.setArea(estateImpl.getAddress().getCity());
        if (estateImpl.getAddress().isPublished()) {
            overseasSaleAdType.setAddress(estateImpl.getAddress().writeStreet() + ", " + estateImpl.getAddress().getPostalCode());
        } else {
            overseasSaleAdType.setAddress(estateImpl.getAddress().getPostalCode());
        }
        agentContactImpl2 = agentContactImpl != null ? agentContactImpl : agentImpl.getCompany();
        overseasSaleAdType.setContactName(agentContactImpl2.writePersonFullName());
        if (StringUtils.isBlank((CharSequence)overseasSaleAdType.getContactName())) {
            overseasSaleAdType.setContactName(agentImpl.getCompany().getCompanyName());
        }
        overseasSaleAdType.setMainEmail(agentContactImpl2.getPersonMail());
        if (StringUtils.isBlank((CharSequence)overseasSaleAdType.getMainEmail())) {
            overseasSaleAdType.setMainEmail(agentImpl.getCompany().getCompanyMail());
        }
        overseasSaleAdType.setPhone1(agentContactImpl2.getPersonPhone());
        if (StringUtils.isBlank((CharSequence)overseasSaleAdType.getPhone1())) {
            overseasSaleAdType.setPhone1(agentImpl.getCompany().getCompanyPhone());
        }
        overseasSaleAdType.setPhone2(agentContactImpl2.getPersonMobilePhone());
        if (StringUtils.isBlank((CharSequence)overseasSaleAdType.getPhone2())) {
            overseasSaleAdType.setPhone2(agentImpl.getCompany().getCompanyMobilePhone());
        }
        if (estateImpl.isHiddenPrices()) {
            overseasSaleAdType.setPrice(BigInteger.ZERO);
            overseasSaleAdType.setPriceType(OverseasSaleAdType.PriceType.ON_APPLICATION);
        } else {
            overseasSaleAdType.setPrice(PurchasePrice.getAsBigInteger((EstateImpl)estateImpl));
            overseasSaleAdType.setPriceType(OverseasSaleAdType.PriceType.REGION);
        }
        overseasSaleAdType.setBathroomNumber(CountBathrooms.getAsBigInteger((EstateImpl)estateImpl));
        overseasSaleAdType.setBedroomNumber(CountBedrooms.getAsBigInteger((EstateImpl)estateImpl));
        overseasSaleAdType.setDescription(this.getDescription(estateImpl));
        overseasSaleAdType.setEnergyRating(ClimateBuildingStandard.get((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage()));
        object = TotalArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        if (object == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1) {
            object = PlotArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1) {
            object = ResidentialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1) {
            object = CommercialArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1) {
            object = SalesArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object == null || ((BigDecimal)object).compareTo(BigDecimal.ZERO) < 1) {
            object = CarParkingArea.getAsBigDecimal((EstateImpl)estateImpl, (AreaValue.Unit)AreaValue.Unit.SQM);
        }
        if (object != null && ((BigDecimal)object).compareTo(BigDecimal.ZERO) > 0) {
            overseasSaleAdType.setSquareMetres((BigDecimal)object);
            overseasSaleAdType.setAcres(AreaValue.convert((BigDecimal)object, (AreaValue.Unit)AreaValue.Unit.SQM, (AreaValue.Unit)AreaValue.Unit.AC));
        }
        if (Age.Option.NEW_BUILDING.equals((Object)(option = Age.get((EstateImpl)estateImpl)))) {
            overseasSaleAdType.setIsNewDevelopment(Boolean.valueOf(true));
        } else if (Age.Option.OLD_BUILDING.equals((Object)option)) {
            overseasSaleAdType.setIsNewDevelopment(Boolean.valueOf(false));
        }
        overseasSaleAdType.setFeatures(this.getFeatures(estateImpl));
        overseasSaleAdType.setPhotos(this.getPhotos(estateImpl));
        overseasSaleAdType.setPdfs(this.getPdfs(estateImpl));
        return overseasSaleAdType;
    }

    protected Daft convertToXmlObject(AgencyImpl agencyImpl) {
        Daft daft = this.createRoot();
        if (agencyImpl == null) {
            LOGGER.warn("No agency was provided!");
            return daft;
        }
        for (EstateImpl estateImpl : agencyImpl.getEstates().values()) {
            try {
                OverseasSaleAdType overseasSaleAdType;
                AgentContactImpl agentContactImpl;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = estateImpl.getContactId();
                AgentContactImpl agentContactImpl2 = agentContactImpl = agencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)agencyImpl.getContacts().get(string) : null;
                if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
                    overseasSaleAdType = this.convertEstateForSale(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    if (daft.getOverseasSales() == null) {
                        daft.setOverseasSales(FACTORY.createDaftOverseasSales());
                    }
                    daft.getOverseasSales().getOverseasSaleAd().add(overseasSaleAdType);
                    continue;
                }
                if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
                    overseasSaleAdType = this.convertEstateForRent(estateImpl, agencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    if (daft.getOverseasRental() == null) {
                        daft.setOverseasRental(FACTORY.createDaftOverseasRental());
                    }
                    daft.getOverseasRental().getOverseasRentalAd().add(overseasSaleAdType);
                    continue;
                }
                LOGGER.warn("Unsupported action '" + estateImpl.getAction() + "' for property '" + estateImpl.getId() + "'!");
                this.putError(estateImpl.getId(), "Unsupported property action '" + estateImpl.getAction() + "'!");
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return daft;
    }

    protected Daft convertToXmlObject(TransferImpl transferImpl) {
        Daft daft = this.createRoot();
        if (transferImpl == null) {
            LOGGER.warn("No transfer was provided!");
            return daft;
        }
        TransferAgencyImpl transferAgencyImpl = (TransferAgencyImpl)transferImpl.getAgencies().iterator().next();
        if (transferAgencyImpl == null) {
            LOGGER.warn("No agency was provided!");
            return daft;
        }
        for (EstateImpl estateImpl : transferAgencyImpl.getEstatesToSave()) {
            try {
                OverseasSaleAdType overseasSaleAdType;
                AgentContactImpl agentContactImpl;
                ArrayList<String> arrayList = new ArrayList<String>();
                String string = estateImpl.getContactId();
                AgentContactImpl agentContactImpl2 = agentContactImpl = transferAgencyImpl.getContacts().containsKey(string) ? (AgentContactImpl)transferAgencyImpl.getContacts().get(string) : null;
                if (OpenEstateAction.PURCHASE.equals((Object)estateImpl.getAction())) {
                    overseasSaleAdType = this.convertEstateForSale(estateImpl, transferAgencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    if (daft.getOverseasSales() == null) {
                        daft.setOverseasSales(FACTORY.createDaftOverseasSales());
                    }
                    daft.getOverseasSales().getOverseasSaleAd().add(overseasSaleAdType);
                    continue;
                }
                if (OpenEstateAction.RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.SHORT_TERM_RENT.equals((Object)estateImpl.getAction()) || OpenEstateAction.LEASE.equals((Object)estateImpl.getAction()) || OpenEstateAction.EMPHYTEUSIS.equals((Object)estateImpl.getAction())) {
                    overseasSaleAdType = this.convertEstateForRent(estateImpl, transferAgencyImpl.getAgent(), agentContactImpl, arrayList);
                    if (!arrayList.isEmpty()) {
                        this.putErrors(estateImpl.getId(), arrayList);
                        continue;
                    }
                    if (daft.getOverseasRental() == null) {
                        daft.setOverseasRental(FACTORY.createDaftOverseasRental());
                    }
                    daft.getOverseasRental().getOverseasRentalAd().add(overseasSaleAdType);
                    continue;
                }
                LOGGER.warn("Unsupported action '" + estateImpl.getAction() + "' for property '" + estateImpl.getId() + "'!");
                this.putError(estateImpl.getId(), "Unsupported property action '" + estateImpl.getAction() + "'!");
            }
            catch (Exception exception) {
                LOGGER.error("Fehler beim Parsen der Immobilie!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
        return daft;
    }

    protected DaftIeDocument createXmlDocument(Daft daft) throws ParserConfigurationException, JAXBException {
        return DaftIeDocument.newDocument((Daft)daft);
    }

    protected Daft createRoot() {
        Daft daft = FACTORY.createDaft();
        daft.setVersion(DaftIeUtils.VERSION.toReadableVersion());
        return daft;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    protected CommercialType getCommercialType(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.HOSPITALITY_INDUSTRY.equals((Object)openEstateType)) {
                return CommercialType.HOTEL;
            }
            if (OpenEstateType.COMMERCIAL_GROUND.equals((Object)openEstateType)) {
                return CommercialType.LAND;
            }
            if (!OpenEstateType.GENERAL_AGRICULTURE.equals((Object)openEstateType)) continue;
            return CommercialType.LAND;
        }
        return CommercialType.SHOP;
    }

    protected String getDescription(EstateImpl estateImpl) {
        OpenEstateAttrib[] openEstateAttribArray = new OpenEstateAttrib[]{OpenEstateAttrib.DESCRIPTIONS_DETAILLED_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_FEATURE_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_LOCATION_DESCRIPTION, OpenEstateAttrib.DESCRIPTIONS_ADDITIONAL_INFORMATION};
        StringBuilder stringBuilder = new StringBuilder();
        String string = estateImpl.getTitle(this.getOpenEstateLanguage());
        if (!StringUtils.isBlank((CharSequence)string)) {
            stringBuilder.append(string);
        }
        Object object = openEstateAttribArray;
        int n = ((OpenEstateAttrib[])object).length;
        for (int i = 0; i < n; ++i) {
            String string2;
            OpenEstateAttrib openEstateAttrib = object[i];
            ComplexStringAttrib complexStringAttrib = (ComplexStringAttrib)estateImpl.getAttribute(openEstateAttrib);
            if (complexStringAttrib == null || StringUtils.isBlank((CharSequence)(string2 = complexStringAttrib.getFormattedValue(this.getOpenEstateLanguage())))) continue;
            if (stringBuilder.length() > 0) {
                stringBuilder.append(System.lineSeparator()).append(System.lineSeparator()).append("------------------------------------").append(System.lineSeparator()).append(System.lineSeparator());
            }
            stringBuilder.append(string2.trim());
        }
        if (this.isEnergyCertificateAppendedToDescription() && (object = OpenEstateUtils.writeEnergyCertificate((EstateImpl)estateImpl, (Locale)this.getOpenEstateLanguage(), (String)this.getXmlLineSeparator())) != null) {
            stringBuilder.append(System.lineSeparator()).append(System.lineSeparator()).append("------------------------------------").append(System.lineSeparator()).append(System.lineSeparator());
            stringBuilder.append((String)object);
        }
        return OpenEstateUtils.serializeString((String)stringBuilder.toString(), (String)this.getXmlLineSeparator());
    }

    /*
     * WARNING - void declaration
     */
    protected FeaturesType getFeatures(EstateImpl estateImpl) {
        void string;
        FeaturesType featuresType = new FeaturesType[]{OpenEstateAttrib.FEATURES_AIR_CONDITIONED, OpenEstateAttrib.FEATURES_BARRIER_FREE, OpenEstateAttrib.FEATURES_APPLICABILITY, OpenEstateAttrib.FEATURES_BASEMENT, OpenEstateAttrib.FEATURES_TECHNICS, OpenEstateAttrib.FEATURES_TYPE_OF_HEATING, OpenEstateAttrib.FEATURES_FIREPLACE, OpenEstateAttrib.FEATURES_KITCHEN, OpenEstateAttrib.FEATURES_BATHROOM, OpenEstateAttrib.FEATURES_RESIDENTIAL_ROOMS, OpenEstateAttrib.FEATURES_GARDEN_USE, OpenEstateAttrib.FEATURES_CONSERVATORY, OpenEstateAttrib.FEATURES_SWIMMING_POOL, OpenEstateAttrib.FEATURES_BALCONY_TERRACE, OpenEstateAttrib.FEATURES_LIFT, OpenEstateAttrib.FEATURES_RESIDENTIAL_SERVICES, OpenEstateAttrib.FEATURES_SHUTTERS_INTERIOR, OpenEstateAttrib.FEATURES_GLAZING, OpenEstateAttrib.FEATURES_CHIMNEY_PORT, OpenEstateAttrib.FEATURES_COMMERCIAL_ROOMS, OpenEstateAttrib.FEATURES_FREIGHT_ELEVATOR, OpenEstateAttrib.FEATURES_LIFTING_PLATFORM, OpenEstateAttrib.FEATURES_RAMP, OpenEstateAttrib.FEATURES_CRANE, OpenEstateAttrib.FEATURES_PIT, OpenEstateAttrib.FEATURES_OIL_SEPARATOR, OpenEstateAttrib.FEATURES_CANTEEN_CAFETERIA, OpenEstateAttrib.FEATURES_COMMERCIAL_SERVICES, OpenEstateAttrib.FEATURES_ATTACHED_GASTRONOMY, OpenEstateAttrib.FEATURES_WELLNESS_AREA, OpenEstateAttrib.FEATURES_BREWERY_OBLIGATION, OpenEstateAttrib.FEATURES_SPORTS_FACILITIES, OpenEstateAttrib.FEATURES_BOWLING, OpenEstateAttrib.FEATURES_NINEPINS_ALLEY, OpenEstateAttrib.FEATURES_SAUNA, OpenEstateAttrib.FEATURES_SOLARIUM, OpenEstateAttrib.FEATURES_SECURITY_TECHNOLOGY, OpenEstateAttrib.FEATURES_BUILDING_STYLE};
        ArrayList<Object> arrayList = new ArrayList<Object>();
        FeaturesType featuresType2 = featuresType;
        int n = ((OpenEstateAttrib[])featuresType2).length;
        boolean bl = false;
        while (string < n) {
            OpenEstateAttrib openEstateAttrib = featuresType2[string];
            AbstractAttribImpl abstractAttribImpl = estateImpl.getAttribute(openEstateAttrib);
            if (abstractAttribImpl != null) {
                Object[] objectArray;
                Object[] objectArray2;
                SimpleBooleanAttrib simpleBooleanAttrib;
                if (abstractAttribImpl instanceof SimpleBooleanAttrib) {
                    simpleBooleanAttrib = (SimpleBooleanAttrib)abstractAttribImpl;
                    if (Boolean.TRUE.equals(simpleBooleanAttrib.getValue()) && !StringUtils.isBlank((CharSequence)(objectArray2 = openEstateAttrib.getTranslation(this.getOpenEstateLanguage())))) {
                        arrayList.add(objectArray2);
                    }
                } else if (abstractAttribImpl instanceof SimpleEnumAttrib) {
                    simpleBooleanAttrib = (SimpleEnumAttrib)abstractAttribImpl;
                    objectArray2 = simpleBooleanAttrib.getValue();
                    if (objectArray2 != null && !StringUtils.isBlank((CharSequence)(objectArray = simpleBooleanAttrib.getOptionTranslation((Enum)objectArray2, this.getOpenEstateLanguage())))) {
                        arrayList.add(objectArray);
                    }
                } else if (abstractAttribImpl instanceof ComplexEnumAttrib) {
                    simpleBooleanAttrib = (ComplexEnumAttrib)abstractAttribImpl;
                    objectArray2 = simpleBooleanAttrib.getValue();
                    if (!ArrayUtils.isEmpty((Object[])objectArray2)) {
                        objectArray = objectArray2;
                        int n2 = objectArray.length;
                        for (int i = 0; i < n2; ++i) {
                            Object object = objectArray[i];
                            String string2 = simpleBooleanAttrib.getOptionTranslation((Enum)object, this.getOpenEstateLanguage());
                            if (StringUtils.isBlank((CharSequence)string2)) continue;
                            arrayList.add(string2);
                        }
                    }
                } else {
                    LOGGER.warn("Can't read feature from attribute!");
                    LOGGER.warn("> attrib : " + openEstateAttrib.getGroup() + " / " + openEstateAttrib);
                    LOGGER.warn("> type   : " + openEstateAttrib.getClass().getName());
                }
            }
            ++string;
        }
        featuresType2 = null;
        if (!arrayList.isEmpty()) {
            for (String string3 : arrayList) {
                if (StringUtils.isBlank((CharSequence)string3)) continue;
                if (featuresType2 == null) {
                    featuresType2 = FACTORY.createFeaturesType();
                }
                featuresType2.getFeature().add(string3.trim());
                if (featuresType2.getFeature().size() < 10) continue;
                break;
            }
        }
        return featuresType2;
    }

    protected HouseType getHouseType(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.TERRACED_HOUSE_TAIL.equals((Object)openEstateType)) {
                return HouseType.END_OF_TERRACE;
            }
            if (OpenEstateType.SEMIDETACHED_HOUSE.equals((Object)openEstateType)) {
                return HouseType.SEMI_DETACHED;
            }
            if (OpenEstateType.TERRACED_HOUSE.equals((Object)openEstateType)) {
                return HouseType.TERRACED;
            }
            if (!OpenEstateType.TOWN_HOUSE.equals((Object)openEstateType)) continue;
            return HouseType.TOWNHOUSE;
        }
        return HouseType.DETACHED;
    }

    protected PdfsType getPdfs(EstateImpl estateImpl) {
        String string = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string == null) {
            return null;
        }
        PdfsType pdfsType = null;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            URI uRI;
            if (estateAttachmentImpl == null || !estateAttachmentImpl.isMimeType("application/pdf") || (uRI = estateAttachmentImpl.getAbsoluteUrl(string)) == null) continue;
            if (pdfsType == null) {
                pdfsType = FACTORY.createPdfsType();
            }
            pdfsType.getPdf().add(uRI);
            if (pdfsType.getPdf().size() < 3) continue;
            break;
        }
        return pdfsType;
    }

    protected PhotosType getPhotos(EstateImpl estateImpl) {
        String string = StringUtils.trimToNull((String)this.getBaseUrl());
        if (string == null) {
            return null;
        }
        PhotosType photosType = null;
        for (EstateAttachmentImpl estateAttachmentImpl : estateImpl.getAttachments()) {
            URI uRI;
            if (estateAttachmentImpl == null || !estateAttachmentImpl.isImageType() || (uRI = estateAttachmentImpl.getAbsoluteUrl(string)) == null) continue;
            if (photosType == null) {
                photosType = FACTORY.createPhotosType();
            }
            photosType.getPhoto().add(uRI);
        }
        return photosType;
    }

    protected PropertyType getPropertyType(List<OpenEstateType> list) {
        for (int i = list.size() - 1; i >= 0; --i) {
            OpenEstateType openEstateType = list.get(i);
            if (OpenEstateType.RESIDENCE.equals((Object)openEstateType)) {
                return PropertyType.APARTMENT;
            }
            if (OpenEstateType.BUNGALOW.equals((Object)openEstateType)) {
                return PropertyType.BUNGALOW;
            }
            if (OpenEstateType.COMMERCIAL_GROUND.equals((Object)openEstateType)) {
                return PropertyType.COMMERCIAL;
            }
            if (OpenEstateType.GENERAL_AGRICULTURE.equals((Object)openEstateType)) {
                return PropertyType.COMMERCIAL;
            }
            if (OpenEstateType.GENERAL_COMMERCIAL.equals((Object)openEstateType)) {
                return PropertyType.COMMERCIAL;
            }
            if (OpenEstateType.DUPLEX_HOUSE.equals((Object)openEstateType)) {
                return PropertyType.DUPLEX;
            }
            if (OpenEstateType.TWO_FAMILY_HOUSE.equals((Object)openEstateType)) {
                return PropertyType.DUPLEX;
            }
            if (OpenEstateType.HOUSE.equals((Object)openEstateType)) {
                return PropertyType.HOUSE;
            }
            if (OpenEstateType.GENERAL_RESIDENCE.equals((Object)openEstateType)) {
                return PropertyType.HOUSE;
            }
            if (!OpenEstateType.GENERAL_PIECE_OF_LAND.equals((Object)openEstateType)) continue;
            return PropertyType.SITE;
        }
        return null;
    }

    public boolean isEnergyCertificateAppendedToDescription() {
        return this.energyCertificateAppendedToDescription;
    }

    public void setBaseUrl(String string) {
        this.baseUrl = string;
    }

    public void setEnergyCertificateAppendedToDescription(boolean bl) {
        this.energyCertificateAppendedToDescription = bl;
    }
}

