/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.kyero;

import java.util.ArrayList;
import java.util.Locale;
import org.apache.commons.lang3.LocaleUtils;
import org.apache.commons.lang3.StringUtils;
import org.openestate.io.kyero.xml.LangType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum KyeroLanguage {
    CA,
    DA,
    DE,
    EN,
    ES,
    FI,
    FR,
    IT,
    NL,
    NO,
    PT,
    RU,
    SV;

    private static final Logger LOGGER;

    public static void clear(LangType langType) {
        for (KyeroLanguage kyeroLanguage : KyeroLanguage.values()) {
            kyeroLanguage.setText(langType, null);
        }
    }

    public static KyeroLanguage fromLanguageCode(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (KyeroLanguage kyeroLanguage : KyeroLanguage.values()) {
            if (!kyeroLanguage.name().equalsIgnoreCase(string)) continue;
            return kyeroLanguage;
        }
        return null;
    }

    public static KyeroLanguage fromLocale(Locale locale) {
        return locale != null ? KyeroLanguage.fromLanguageCode(locale.getLanguage()) : null;
    }

    public static KyeroLanguage[] getLanguages(LangType langType) {
        ArrayList<KyeroLanguage> arrayList = new ArrayList<KyeroLanguage>();
        if (StringUtils.isNotBlank((CharSequence)langType.getCa())) {
            arrayList.add(CA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getDa())) {
            arrayList.add(DA);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getDe())) {
            arrayList.add(DE);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEn())) {
            arrayList.add(EN);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getEs())) {
            arrayList.add(ES);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getFi())) {
            arrayList.add(FI);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getFr())) {
            arrayList.add(FR);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getIt())) {
            arrayList.add(IT);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getNl())) {
            arrayList.add(NL);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getNo())) {
            arrayList.add(NO);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getPt())) {
            arrayList.add(PT);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getRu())) {
            arrayList.add(RU);
        }
        if (StringUtils.isNotBlank((CharSequence)langType.getSv())) {
            arrayList.add(SV);
        }
        return arrayList.toArray(new KyeroLanguage[0]);
    }

    public String getText(LangType langType) {
        if (langType == null) {
            return null;
        }
        switch (this) {
            case CA: {
                return StringUtils.trimToNull((String)langType.getCa());
            }
            case DA: {
                return StringUtils.trimToNull((String)langType.getDa());
            }
            case DE: {
                return StringUtils.trimToNull((String)langType.getDe());
            }
            case EN: {
                return StringUtils.trimToNull((String)langType.getEn());
            }
            case ES: {
                return StringUtils.trimToNull((String)langType.getEs());
            }
            case FI: {
                return StringUtils.trimToNull((String)langType.getFi());
            }
            case FR: {
                return StringUtils.trimToNull((String)langType.getFr());
            }
            case IT: {
                return StringUtils.trimToNull((String)langType.getIt());
            }
            case NL: {
                return StringUtils.trimToNull((String)langType.getNl());
            }
            case NO: {
                return StringUtils.trimToNull((String)langType.getNo());
            }
            case PT: {
                return StringUtils.trimToNull((String)langType.getPt());
            }
            case RU: {
                return StringUtils.trimToNull((String)langType.getRu());
            }
            case SV: {
                return StringUtils.trimToNull((String)langType.getSv());
            }
        }
        LOGGER.warn("unsupported language: " + (Object)((Object)this));
        return null;
    }

    public static String getText(LangType langType, KyeroLanguage kyeroLanguage) {
        return kyeroLanguage != null ? kyeroLanguage.getText(langType) : null;
    }

    public void setText(LangType langType, String string) {
        if (langType == null) {
            return;
        }
        switch (this) {
            case CA: {
                langType.setCa(StringUtils.trimToNull((String)string));
                break;
            }
            case DA: {
                langType.setDa(StringUtils.trimToNull((String)string));
                break;
            }
            case DE: {
                langType.setDe(StringUtils.trimToNull((String)string));
                break;
            }
            case EN: {
                langType.setEn(StringUtils.trimToNull((String)string));
                break;
            }
            case ES: {
                langType.setEs(StringUtils.trimToNull((String)string));
                break;
            }
            case FI: {
                langType.setFi(StringUtils.trimToNull((String)string));
                break;
            }
            case FR: {
                langType.setFr(StringUtils.trimToNull((String)string));
                break;
            }
            case IT: {
                langType.setIt(StringUtils.trimToNull((String)string));
                break;
            }
            case NL: {
                langType.setNl(StringUtils.trimToNull((String)string));
                break;
            }
            case NO: {
                langType.setNo(StringUtils.trimToNull((String)string));
                break;
            }
            case PT: {
                langType.setPt(StringUtils.trimToNull((String)string));
                break;
            }
            case RU: {
                langType.setRu(StringUtils.trimToNull((String)string));
                break;
            }
            case SV: {
                langType.setSv(StringUtils.trimToNull((String)string));
                break;
            }
            default: {
                LOGGER.warn("unsupported language: " + (Object)((Object)this));
            }
        }
    }

    public static void setText(LangType langType, String string, KyeroLanguage kyeroLanguage) {
        if (kyeroLanguage != null) {
            kyeroLanguage.setText(langType, string);
        }
    }

    public String toLanguageCode() {
        return this.name().toLowerCase();
    }

    public Locale toLocale() {
        return LocaleUtils.toLocale((String)this.toLanguageCode());
    }

    static {
        LOGGER = LoggerFactory.getLogger(KyeroLanguage.class);
    }
}

