/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo;

import javax.xml.bind.JAXBException;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoUtils;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.openestate.io.openimmo.xml.Openimmo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class OpenImmoTransferDocument
extends OpenImmoDocument<Openimmo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmoTransferDocument.class);

    public OpenImmoTransferDocument(Document document) {
        super(document);
        if (!OpenImmoTransferDocument.isReadable(document)) {
            throw new IllegalArgumentException("The provided document is invalid!");
        }
    }

    @Override
    public OpenImmoVersion getDocumentVersion() {
        String string;
        Object object;
        try {
            object = this.getDocument();
            string = StringUtils.trimToNull((String)XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung/@version", (Document)object).stringValueOf(object));
            if (string == null) {
                LOGGER.warn("Can't find version information in the XML document!");
                return null;
            }
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
            return null;
        }
        object = OpenImmoVersion.detectFromString(string);
        if (object != null) {
            return object;
        }
        LOGGER.warn("The provided version (" + string + ") is not supported!");
        return null;
    }

    public static boolean isReadable(Document document) {
        Element element = XmlUtils.getRootElement((Document)document);
        return "openimmo".equals(element.getLocalName());
    }

    public static OpenImmoTransferDocument newDocument() throws ParserConfigurationException, JAXBException {
        return OpenImmoTransferDocument.newDocument(OpenImmoUtils.getFactory().createOpenimmo());
    }

    public static OpenImmoTransferDocument newDocument(Openimmo openimmo) throws ParserConfigurationException, JAXBException {
        if (openimmo.getUebertragung() == null) {
            openimmo.setUebertragung(OpenImmoUtils.getFactory().createUebertragung());
        }
        if (StringUtils.isBlank((CharSequence)openimmo.getUebertragung().getVersion())) {
            openimmo.getUebertragung().setVersion(OpenImmoUtils.VERSION.toReadableVersion());
        }
        Document document = XmlUtils.newDocument();
        OpenImmoUtils.createMarshaller("UTF-8", true).marshal((Object)openimmo, (Node)document);
        return new OpenImmoTransferDocument(document);
    }

    public void setDocumentVersion(OpenImmoVersion openImmoVersion) {
        try {
            Object object;
            Document document = this.getDocument();
            String string = StringUtils.trimToEmpty((String)XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung/@version", (Document)document).stringValueOf((Object)document));
            String[] stringArray = StringUtils.split((String)string, (String)"/", (int)2);
            Element element = (Element)XmlUtils.newXPath((String)"/io:openimmo/io:uebertragung", (Document)document).selectSingleNode((Object)document);
            if (element == null) {
                object = (Element)XmlUtils.newXPath((String)"/io:openimmo", (Document)document).selectSingleNode((Object)document);
                if (object == null) {
                    LOGGER.warn("Can't find an <openimmo> element in the document!");
                    return;
                }
                element = document.createElement("uebertragung");
                object.insertBefore(element, object.getFirstChild());
            }
            object = openImmoVersion.toReadableVersion();
            if (stringArray.length > 1) {
                object = (String)object + "/" + stringArray[1];
            }
            element.setAttribute("version", (String)object);
        }
        catch (JaxenException jaxenException) {
            LOGGER.error("Can't evaluate XPath expression!");
            LOGGER.error("> " + jaxenException.getLocalizedMessage(), (Throwable)jaxenException);
        }
    }

    public Openimmo toObject() throws JAXBException {
        this.upgradeToLatestVersion();
        return (Openimmo)OpenImmoUtils.createUnmarshaller().unmarshal((Node)this.getDocument());
    }
}

