/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.openimmo.converters;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.jaxen.JaxenException;
import org.openestate.io.core.XmlConverter;
import org.openestate.io.core.XmlUtils;
import org.openestate.io.openimmo.OpenImmoDocument;
import org.openestate.io.openimmo.OpenImmoTransferDocument;
import org.openestate.io.openimmo.OpenImmoVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class OpenImmo_1_2_6
extends XmlConverter<OpenImmoDocument, OpenImmoVersion> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OpenImmo_1_2_6.class);

    public OpenImmoVersion getVersion() {
        return OpenImmoVersion.V1_2_6;
    }

    public void downgradeToPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_5);
        if (openImmoDocument instanceof OpenImmoTransferDocument) {
            try {
                this.removePreiseChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <preise> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeKaufpreisElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <kaufpreis> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeZwangsversteigerungElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <zwangsversteigerung> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeFlaechenChildElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported children of <flaechen> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.removeBauzoneElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't remove unsupported <bauzone> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBodenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <boden> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeEnergietypElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <energietyp> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeAusblickElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <ausblick> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
            try {
                this.downgradeBueroPraxenElements(openImmoDocument.getDocument());
            }
            catch (Exception exception) {
                LOGGER.error("Can't downgrade <buero_praxen> elements!");
                LOGGER.error("> " + exception.getLocalizedMessage(), (Throwable)exception);
            }
        }
    }

    public void upgradeFromPreviousVersion(OpenImmoDocument openImmoDocument) {
        openImmoDocument.setDocumentVersion(OpenImmoVersion.V1_2_6);
    }

    protected void downgradeAusblickElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:infrastruktur/io:ausblick[@blick]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("blick"));
            if (!"MEER".equalsIgnoreCase(string)) continue;
            element.setAttribute("blick", "SEE");
        }
    }

    protected void downgradeBodenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:boden[@GRANIT]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("GRANIT");
        }
    }

    protected void downgradeBueroPraxenElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:objektkategorie/io:objektart/io:buero_praxen[@buero_typ]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            String string = StringUtils.trimToNull((String)element.getAttribute("buero_typ"));
            if ("COWORKING".equalsIgnoreCase(string)) {
                element.setAttribute("buero_typ", "BUEROFLAECHE");
                continue;
            }
            if (!"SHARED_OFFICE".equalsIgnoreCase(string)) continue;
            element.setAttribute("buero_typ", "BUEROFLAECHE");
        }
    }

    protected void downgradeKaufpreisElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:kaufpreis[@auf_anfrage]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("auf_anfrage");
        }
    }

    protected void removeBauzoneElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:zustand_angaben/io:bauzone", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void downgradeEnergietypElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:ausstattung/io:energietyp[@MINERGIEBAUWEISE or @MINERGIE_ZERTIFIZIERT]", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            element.removeAttribute("MINERGIEBAUWEISE");
            element.removeAttribute("MINERGIE_ZERTIFIZIERT");
        }
    }

    protected void removeFlaechenChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:kubatur | /io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:ausnuetzungsziffer | /io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:flaechevon | /io:openimmo/io:anbieter/io:immobilie/io:flaechen/io:flaechebis", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removePreiseChildElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:preise/io:kaufpreisnetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:kaufpreisbrutto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:hauptmietzinsnetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:pauschalmiete | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:betriebskostennetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:evbnetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:gesamtmietenetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:gesamtmietebrutto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:gesamtbelastungnetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:gesamtbelastungbrutto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:gesamtkostenprom2von | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:heizkostennetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:monatlichekostennetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:monatlichekostenbrutto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:nebenkostenprom2von | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:ruecklagenetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:sonstigekostennetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:sonstigemietenetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:summemietenetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:nettomieteprom2von | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:provisionnetto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:provisionbrutto | /io:openimmo/io:anbieter/io:immobilie/io:preise/io:richtpreisprom2", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }

    protected void removeZwangsversteigerungElements(Document document) throws JaxenException {
        List list = XmlUtils.newXPath((String)"/io:openimmo/io:anbieter/io:immobilie/io:versteigerung/io:zwangsversteigerung", (Document)document).selectNodes((Object)document);
        for (Object e : list) {
            Element element = (Element)e;
            Element element2 = (Element)element.getParentNode();
            element2.removeChild(element);
        }
    }
}

