/*
 * Decompiled with CFR 0.152.
 */
package org.openestate.io.trovit.xml.types;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum OrientationValue {
    NORTH(new String[]{"North", "Nord", "Norden"}),
    SOUTH(new String[]{"South", "S\u00fcd", "S\u00fcden"}),
    EAST(new String[]{"East", "Ost", "Osten"}),
    WEST(new String[]{"West", "Westen"});

    private static final Logger LOGGER;
    private final String[] aliases;

    private OrientationValue(String[] stringArray) {
        this.aliases = stringArray;
    }

    public static OrientationValue fromXmlValue(String string) {
        if ((string = StringUtils.trimToNull((String)string)) == null) {
            return null;
        }
        for (OrientationValue orientationValue : OrientationValue.values()) {
            if (orientationValue.name().equalsIgnoreCase(string)) {
                return orientationValue;
            }
            for (String string2 : orientationValue.aliases) {
                if (!string2.equalsIgnoreCase(string)) continue;
                return orientationValue;
            }
        }
        return null;
    }

    public String write() {
        return this.aliases[0];
    }

    static {
        LOGGER = LoggerFactory.getLogger(OrientationValue.class);
    }
}

