/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolTaskContainer;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyBrokeringViewTask;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyContactsUtils;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandler;
import com.openindex.openestate.tool.agency.extensions.EstateTableAdapter;
import com.openindex.openestate.tool.agency.extensions.EstateTableExtension;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.util.ArrayList;
import javax.swing.Action;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={EstateTableExtension.class}, plugins={"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"})
public class AgencyEstateTableContactsExtension
extends EstateTableAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateTableContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateTableContactsExtension.class);

    public Action[] getActions(Long[] longArray) {
        ArrayList<ShowEstateOwnerAction> arrayList = new ArrayList<ShowEstateOwnerAction>();
        if (AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
            arrayList.add(new ShowEstateOwnerAction(longArray));
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new Action[0]);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"};
    }

    private static class ShowEstateOwnerTask
    extends ImmoToolTaskContainer {
        private final long[] agencyObjectIds;

        public ShowEstateOwnerTask(Long[] longArray) {
            this(ArrayUtils.toPrimitive((Long[])longArray));
        }

        public ShowEstateOwnerTask(long[] lArray) {
            this.agencyObjectIds = lArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Boolean doInBackground() throws Exception {
            ImmoToolProject immoToolProject = ImmoToolProject.getAppInstance();
            DbAgencyBrokeringsHandler dbAgencyBrokeringsHandler = AgencyContactsUtils.getBrokeringsHandler();
            Connection connection = null;
            long[] lArray = null;
            try {
                connection = immoToolProject.getDbConnection();
                lArray = dbAgencyBrokeringsHandler.getBrokeringIds(connection, null, null, this.agencyObjectIds);
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
            int n = 0;
            if (lArray != null) {
                for (long l : lArray) {
                    this.add(new AgencyBrokeringViewTask(immoToolProject.getDbDriver(), l, lArray.length < 2));
                    if (++n >= 5) break;
                }
            }
            return super.doInBackground();
        }

        protected void failed(Throwable throwable) {
            super.failed(throwable);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't load owner for the selected properties!", (Throwable)throwable, (Window)this.getParentWindow());
        }
    }

    private static class ShowEstateOwnerAction
    extends AbstractI18nAction {
        private final long[] agencyObjectIds;

        public ShowEstateOwnerAction(Long[] longArray) {
            this(ArrayUtils.toPrimitive((Long[])longArray));
        }

        public ShowEstateOwnerAction(long[] lArray) {
            this.agencyObjectIds = lArray;
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"assistant.png", (int)16));
            this.setEnabled(AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ImmoToolUtils.executeTask((ImmoToolTask)new ShowEstateOwnerTask(this.agencyObjectIds));
        }

        protected void updateLocalization() {
            super.updateLocalization();
            this.setName(StringUtils.capitalize((String)I18N.tr("view brokering")));
            this.setShortDescription(I18N.tr("Show brokering mandate for the selected properties."));
        }
    }
}

