/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts.db.hsql;

import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.impl.db.NamedCallableStatement;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokering;
import com.openindex.openestate.tool.agency.addons.contacts.db.DbAgencyBrokeringsHandlerImpl;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class HSqlDbAgencyBrokeringsHandler
extends DbAgencyBrokeringsHandlerImpl {
    private static final Logger LOGGER = LoggerFactory.getLogger(HSqlDbAgencyBrokeringsHandler.class);
    private static final I18n I18N = I18nFactory.getI18n(HSqlDbAgencyBrokeringsHandler.class);
    public static final String VIEW_BROKERINGS = "view_immotool_agency_brokerings";
    public static final String PROC_REMOVE_BROKERINGS = "remove_immotool_agency_brokerings";
    public static final String PROC_SAVE_BROKERINGS = "save_immotool_agency_brokerings";
    private static final String FIELD_BROKERING_ID = "brokering_id";
    private static final String FIELD_BROKERING_EXCLUSIVE = "brokering_exclusive";
    private static final String FIELD_BROKERING_BEGIN = "brokering_begin";
    private static final String FIELD_BROKERING_END = "brokering_end";
    private static final String FIELD_BROKERING_NOTES = "brokering_notes";
    private static final String FIELD_AGENCY_OBJECT_ID = "agency_object_id";
    private static final String FIELD_CONTACTS_ENTRY_ID = "contacts_entry_id";
    private static final String FIELD_CREATED_AT = "created_at";
    private static final String FIELD_MODIFIED_AT = "modified_at";

    private DbAgencyBrokering createBrokering(ResultSet resultSet) throws SQLException {
        DbAgencyBrokering dbAgencyBrokering = this.buildBrokering();
        dbAgencyBrokering.id = resultSet.getLong(FIELD_BROKERING_ID);
        dbAgencyBrokering.agencyObjectId = resultSet.getLong(FIELD_AGENCY_OBJECT_ID);
        dbAgencyBrokering.contactsEntryId = resultSet.getLong(FIELD_CONTACTS_ENTRY_ID);
        dbAgencyBrokering.exclusive = resultSet.getBoolean(FIELD_BROKERING_EXCLUSIVE);
        dbAgencyBrokering.notes = resultSet.getString(FIELD_BROKERING_NOTES);
        dbAgencyBrokering.begin = resultSet.getTimestamp(FIELD_BROKERING_BEGIN);
        dbAgencyBrokering.end = resultSet.getTimestamp(FIELD_BROKERING_END);
        dbAgencyBrokering.createdAt = resultSet.getTimestamp(FIELD_CREATED_AT);
        dbAgencyBrokering.modifiedAt = resultSet.getTimestamp(FIELD_MODIFIED_AT);
        return dbAgencyBrokering;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyBrokering[] getBrokerings(Connection connection, long[] lArray) throws SQLException {
        DbAgencyBrokering[] dbAgencyBrokeringArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyBrokering[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings ORDER BY brokering_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings WHERE brokering_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY brokering_id ASC LIMIT " + lArray.length + ";");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyBrokering> arrayList = new ArrayList<DbAgencyBrokering>();
            while (resultSet.next()) {
                arrayList.add(this.createBrokering(resultSet));
            }
            dbAgencyBrokeringArray = arrayList.toArray(new DbAgencyBrokering[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyBrokeringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyBrokering[] getBrokeringsForContact(Connection connection, long[] lArray) throws SQLException {
        DbAgencyBrokering[] dbAgencyBrokeringArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyBrokering[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings ORDER BY brokering_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings WHERE contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY brokering_id ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyBrokering> arrayList = new ArrayList<DbAgencyBrokering>();
            while (resultSet.next()) {
                arrayList.add(this.createBrokering(resultSet));
            }
            dbAgencyBrokeringArray = arrayList.toArray(new DbAgencyBrokering[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyBrokeringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DbAgencyBrokering[] getBrokeringsForObject(Connection connection, long[] lArray) throws SQLException {
        DbAgencyBrokering[] dbAgencyBrokeringArray;
        if (lArray != null && lArray.length < 1) {
            return new DbAgencyBrokering[0];
        }
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            if (lArray == null) {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings ORDER BY brokering_id ASC;");
            } else {
                preparedStatement = connection.prepareStatement("SELECT * FROM view_immotool_agency_brokerings WHERE agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ") ORDER BY brokering_id ASC;");
                for (int i = 0; i < lArray.length; ++i) {
                    preparedStatement.setLong(i + 1, lArray[i]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<DbAgencyBrokering> arrayList = new ArrayList<DbAgencyBrokering>();
            while (resultSet.next()) {
                arrayList.add(this.createBrokering(resultSet));
            }
            dbAgencyBrokeringArray = arrayList.toArray(new DbAgencyBrokering[0]);
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return dbAgencyBrokeringArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getBrokeringIds(Connection connection, DbAgencyObject.Status status, long[] lArray, long[] lArray2) throws SQLException {
        long[] lArray3;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            int n;
            ArrayList<Object> arrayList = new ArrayList<Object>();
            if (status != null) {
                arrayList.add("agency_object_id IN (SELECT object_id FROM view_openestate_objects WHERE object_status = ?)");
            }
            if (lArray != null) {
                arrayList.add("contacts_entry_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray.length) + ")");
            }
            if (lArray2 != null) {
                arrayList.add("agency_object_id IN (" + JdbcUtils.writeQuestionMarkList((int)lArray2.length) + ")");
            }
            String string = !arrayList.isEmpty() ? "WHERE (" + StringUtils.join(arrayList, (String)" ) AND (") + ")" : "";
            preparedStatement = connection.prepareStatement("SELECT brokering_id FROM view_immotool_agency_brokerings " + string + " ORDER BY brokering_id ASC;");
            int n2 = 0;
            if (status != null) {
                preparedStatement.setString(++n2, status.name());
            }
            if (lArray != null) {
                for (n = 0; n < lArray.length; ++n) {
                    preparedStatement.setLong(++n2, lArray[n]);
                }
            }
            if (lArray2 != null) {
                for (n = 0; n < lArray2.length; ++n) {
                    preparedStatement.setLong(++n2, lArray2[n]);
                }
            }
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList2 = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList2.add(resultSet.getLong(FIELD_BROKERING_ID));
            }
            lArray3 = ArrayUtils.toPrimitive((Long[])arrayList2.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly(preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long[] getUnBrokeredObjectIds(Connection connection) throws SQLException {
        long[] lArray;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement("SELECT object_id FROM view_openestate_objects WHERE object_id NOT IN (SELECT agency_object_id FROM view_immotool_agency_brokerings) ORDER BY object_id ASC;");
            resultSet = preparedStatement.executeQuery();
            ArrayList<Long> arrayList = new ArrayList<Long>();
            while (resultSet.next()) {
                arrayList.add(resultSet.getLong("object_id"));
            }
            lArray = ArrayUtils.toPrimitive((Long[])arrayList.toArray(new Long[0]));
        }
        catch (Throwable throwable) {
            JdbcUtils.closeQuietly(resultSet);
            JdbcUtils.closeQuietly((Statement)preparedStatement);
            throw throwable;
        }
        JdbcUtils.closeQuietly((ResultSet)resultSet);
        JdbcUtils.closeQuietly((Statement)preparedStatement);
        return lArray;
    }

    @Override
    public void removeBrokerings(Connection connection, long[] lArray) throws SQLException {
        if (lArray.length < 1) {
            return;
        }
        boolean bl = connection.getAutoCommit();
        CallableStatement callableStatement = null;
        try {
            connection.setAutoCommit(false);
            callableStatement = connection.prepareCall("CALL remove_immotool_agency_brokerings(?);");
            for (long l : lArray) {
                callableStatement.clearParameters();
                callableStatement.setLong(1, l);
                callableStatement.execute();
            }
            connection.commit();
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(callableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((Statement)callableStatement);
        connection.setAutoCommit(bl);
    }

    @Override
    public void saveBrokering(Connection connection, DbAgencyBrokering dbAgencyBrokering) throws SQLException {
        boolean bl = connection.getAutoCommit();
        NamedCallableStatement namedCallableStatement = null;
        try {
            long l;
            connection.setAutoCommit(false);
            namedCallableStatement = new NamedCallableStatement(connection, "CALL save_immotool_agency_brokerings(:brokering_id, :contacts_entry_id, :agency_object_id, :brokering_exclusive, :brokering_begin, :brokering_end, :brokering_notes);");
            namedCallableStatement.setLong(FIELD_BROKERING_ID, dbAgencyBrokering.id);
            namedCallableStatement.setLong(FIELD_CONTACTS_ENTRY_ID, dbAgencyBrokering.contactsEntryId);
            namedCallableStatement.setLong(FIELD_AGENCY_OBJECT_ID, dbAgencyBrokering.agencyObjectId);
            namedCallableStatement.setString(FIELD_BROKERING_NOTES, dbAgencyBrokering.notes);
            namedCallableStatement.setBoolean(FIELD_BROKERING_EXCLUSIVE, dbAgencyBrokering.exclusive);
            namedCallableStatement.setTimestamp(FIELD_BROKERING_BEGIN, dbAgencyBrokering.begin != null ? new Timestamp(dbAgencyBrokering.begin.getTime()) : null);
            namedCallableStatement.setTimestamp(FIELD_BROKERING_END, dbAgencyBrokering.end != null ? new Timestamp(dbAgencyBrokering.end.getTime()) : null);
            namedCallableStatement.execute();
            long l2 = l = dbAgencyBrokering.id < 1L ? namedCallableStatement.getLong(FIELD_BROKERING_ID) : dbAgencyBrokering.id;
            if (l < 1L) {
                throw new SQLException("Can't determine ID of the saved object!");
            }
            connection.commit();
            if (dbAgencyBrokering.id < 1L) {
                dbAgencyBrokering.id = l;
            }
        }
        catch (SQLException sQLException) {
            try {
                connection.rollback();
                throw sQLException;
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(namedCallableStatement);
                connection.setAutoCommit(bl);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly((NamedCallableStatement)namedCallableStatement);
        connection.setAutoCommit(bl);
    }
}

