/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.calendar;

import com.openindex.openestate.impl.db.DbLanguagesHandler;
import com.openindex.openestate.impl.db.DbObject;
import com.openindex.openestate.impl.db.JdbcUtils;
import com.openindex.openestate.tool.ImmoToolEnvironment;
import com.openindex.openestate.tool.ImmoToolProject;
import com.openindex.openestate.tool.ImmoToolTask;
import com.openindex.openestate.tool.ImmoToolUtils;
import com.openindex.openestate.tool.agency.AgencyEstateRelationPanel;
import com.openindex.openestate.tool.agency.AgencyEstateTable;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.calendar.AgencyCalendarUtils;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyCalendarHandler;
import com.openindex.openestate.tool.agency.addons.calendar.db.DbAgencyEstateCalendarEntry;
import com.openindex.openestate.tool.agency.db.DbAgencyObject;
import com.openindex.openestate.tool.agency.db.DbAgencyObjectsHandler;
import com.openindex.openestate.tool.calendar.CalendarEntryViewPanel;
import com.openindex.openestate.tool.calendar.db.DbCalendarEntry;
import com.openindex.openestate.tool.gui.AbstractI18nAction;
import com.openindex.openestate.tool.gui.AbstractTable;
import com.openindex.openestate.tool.gui.DefaultTableCellRenderer;
import com.openindex.openestate.tool.gui.FirstLineRenderer;
import com.openindex.openestate.tool.gui.Renderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.swingx.JXTitledSeparator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

public class CalendarEntryEstateTablePanel
extends CalendarEntryViewPanel.AbstractTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(CalendarEntryEstateTablePanel.class);
    private static final I18n I18N = I18nFactory.getI18n(CalendarEntryEstateTablePanel.class);
    private static final String RELATION_TABLE_ID = "CalendarEntryEstateTablePanel.RelationTable";
    private DbCalendarEntry currentCalendarEntry = null;
    private JXTitledSeparator objectsTitle;
    private RelationTable objectsTable;
    private RelationForm relationForm;
    private AbstractI18nAction relationAddAction;
    private AbstractI18nAction refreshAction;
    private AbstractI18nAction showActionsAction;

    public CalendarEntryEstateTablePanel() {
        this.build();
    }

    private void build() {
        this.objectsTable = new RelationTable();
        this.objectsTitle = ImmoToolUtils.createHead2Separator((String)"");
        this.showActionsAction = new ShowActionsAction();
        this.relationAddAction = new RelationAddAction();
        this.refreshAction = new RefreshAction();
        JPanel jPanel = ImmoToolUtils.buildTitleBar((JXTitledSeparator)this.objectsTitle, (Action[])new Action[]{this.refreshAction, this.relationAddAction, this.showActionsAction});
        this.relationForm = new RelationForm();
        this.setLayout(new BorderLayout(5, 5));
        this.add(jPanel, "North");
        this.add(this.objectsTable.createScrollPane(), "Center");
        this.add((Component)((Object)this.relationForm), "South");
        this.updateLocalization();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doLoadInBackground(Connection connection) throws Exception {
        this.objectsTable.setEnabled(false);
        this.objectsTable.clearSelection();
        this.objectsTable.clearRows();
        this.updateTitle();
        ArrayList<DbObject> arrayList = new ArrayList<DbObject>();
        HashMap<Long, DbAgencyEstateCalendarEntry> hashMap = new HashMap<Long, DbAgencyEstateCalendarEntry>();
        try {
            DbAgencyCalendarHandler dbAgencyCalendarHandler = AgencyCalendarUtils.getCalendarHandler();
            DbAgencyObjectsHandler dbAgencyObjectsHandler = AgencyPlugin.getDbAgencyExtension().getObjectsHandler();
            DbLanguagesHandler dbLanguagesHandler = AgencyPlugin.getDbAgencyExtension().getLanguagesHandler();
            Map map = dbLanguagesHandler.getLanguageMap(connection, Boolean.valueOf(true));
            DbAgencyEstateCalendarEntry[] dbAgencyEstateCalendarEntryArray = dbAgencyCalendarHandler.getEstateCalendarEntries(connection, 0L, this.currentCalendarEntry.id);
            long[] lArray = new long[dbAgencyEstateCalendarEntryArray.length];
            for (int i = 0; i < dbAgencyEstateCalendarEntryArray.length; ++i) {
                lArray[i] = dbAgencyEstateCalendarEntryArray[i].agencyEstateId;
                hashMap.put(dbAgencyEstateCalendarEntryArray[i].agencyEstateId, dbAgencyEstateCalendarEntryArray[i]);
            }
            DbObject[] dbObjectArray = dbAgencyObjectsHandler.getObjects(connection, lArray);
            dbAgencyObjectsHandler.loadObjectAttribs(connection, dbObjectArray, map);
            dbAgencyObjectsHandler.loadObjectTranslations(connection, dbObjectArray, map);
            arrayList.addAll(Arrays.asList(dbObjectArray));
        }
        catch (Throwable throwable) {
            SwingUtilities.invokeLater(new Runnable(arrayList, hashMap){
                final /* synthetic */ List val$objectsList;
                final /* synthetic */ Map val$relationsMap;
                {
                    this.val$objectsList = list;
                    this.val$relationsMap = map;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        for (DbObject dbObject : this.val$objectsList) {
                            String string = this.val$relationsMap.containsKey(dbObject.id) ? ((DbAgencyEstateCalendarEntry)this.val$relationsMap.get((Object)Long.valueOf((long)dbObject.id))).relationNotes : null;
                            CalendarEntryEstateTablePanel.this.objectsTable.addRow((AbstractTable.Row)new RelationTableRow((DbAgencyObject)dbObject, string));
                        }
                    }
                    finally {
                        CalendarEntryEstateTablePanel.this.objectsTable.setEnabled(true);
                        CalendarEntryEstateTablePanel.this.showActionsAction.setEnabled(false);
                        CalendarEntryEstateTablePanel.this.updateTitle();
                    }
                }
            });
            throw throwable;
        }
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void doObjectView() {
        int n = this.objectsTable.getSelectedRow();
        if (n < 0) {
            return;
        }
        long l = this.objectsTable.getEstateIdAt(this.objectsTable.convertRowIndexToModel(n));
        new AgencyPlugin.EstateFormAction(l).actionPerformed(null);
    }

    private void doRefresh() {
        try {
            this.load(this.currentCalendarEntry);
            if (this.isLoadedInBackground()) {
                ImmoToolUtils.executeTask((ImmoToolTask)new RefreshTask());
            }
        }
        catch (Exception exception) {
            LOGGER.error("Can't reload activity properties!");
            LOGGER.error(">" + exception.getLocalizedMessage(), (Throwable)exception);
            ImmoToolUtils.showMessageErrorDialog((String)"Can't reload activity properties!", (Throwable)exception, (Window)ImmoToolEnvironment.getFrame());
        }
    }

    private void doRelationAdd() {
        this.relationForm.selectEmptyRelation();
    }

    private void doRelationRemove() {
        if (this.objectsTable.removeSelectedRows()) {
            this.relationForm.unselectRelation();
            this.updateTitle();
        }
    }

    private void doShowActions(Component component, int n, int n2) {
        if (this.objectsTable.getSelectedRowCount() < 1) {
            return;
        }
        JPopupMenu jPopupMenu = new JPopupMenu();
        jPopupMenu.add(new JMenuItem((Action)((Object)new RelationRemoveAction())));
        jPopupMenu.addSeparator();
        jPopupMenu.add(new JMenuItem((Action)((Object)new ObjectViewAction())));
        jPopupMenu.show(component, n, n2);
    }

    public String getTabTitle() {
        return StringUtils.capitalize((String)I18N.tr("properties"));
    }

    public boolean isLoadedInBackground() {
        return this.currentCalendarEntry != null && this.currentCalendarEntry.id > 0L;
    }

    public void load(DbCalendarEntry dbCalendarEntry) {
        this.currentCalendarEntry = dbCalendarEntry;
        this.relationForm.unselectRelation();
        this.objectsTable.setEnabled(false);
        this.objectsTable.clearSelection();
        this.objectsTable.clearRows();
        this.showActionsAction.setEnabled(false);
        this.updateTitle();
    }

    public void save(DbCalendarEntry dbCalendarEntry) {
    }

    public void saveFinished(Connection connection, ImmoToolProject immoToolProject, DbCalendarEntry dbCalendarEntry) throws SQLException {
        DbAgencyCalendarHandler dbAgencyCalendarHandler = AgencyCalendarUtils.getCalendarHandler();
        HashMap<Long, Object> hashMap = new HashMap<Long, Object>();
        Object[] objectArray = dbAgencyCalendarHandler.getEstateCalendarEntries(connection, 0L, dbCalendarEntry.id);
        if (!ArrayUtils.isEmpty((Object[])objectArray)) {
            for (Object object : objectArray) {
                hashMap.put(((DbAgencyEstateCalendarEntry)object).agencyEstateId, object);
            }
        }
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.objectsTable.getRowCount(); ++i) {
            Object object;
            Long l = this.objectsTable.getEstateIdAt(i);
            object = this.objectsTable.getNotesAt(i);
            DbAgencyEstateCalendarEntry serializable = hashMap.containsKey(l) ? (DbAgencyEstateCalendarEntry)hashMap.get(l) : new DbAgencyEstateCalendarEntry();
            serializable.agencyEstateId = l;
            serializable.calendarEntryId = dbCalendarEntry.id;
            serializable.relationNotes = object;
            dbAgencyCalendarHandler.saveEstateCalendarEntry(connection, serializable);
            arrayList.add(l);
            hashMap.put(l, serializable);
        }
        for (Long l : hashMap.keySet().toArray(new Long[0])) {
            if (arrayList.contains(l)) continue;
            dbAgencyCalendarHandler.removeEstateCalendarEntry(connection, (DbAgencyEstateCalendarEntry)hashMap.get(l));
            hashMap.remove(l);
        }
    }

    protected void updateLocalization() {
        super.updateLocalization();
        this.updateTitle();
    }

    private void updateTitle() {
        int n;
        Object object = StringUtils.capitalize((String)I18N.tr("properties for the calendar entry"));
        int n2 = n = this.objectsTable != null ? this.objectsTable.getRowCount() : 0;
        if (n > 0) {
            object = (String)object + " / ";
            object = (String)object + I18N.trn("{0} entry", "{0} entries", (long)n, (Object)n);
        }
        this.objectsTitle.setTitle((String)object);
    }

    private class ShowActionsAction
    extends AbstractI18nAction {
        private ShowActionsAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.setEnabled(false);
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JButton jButton = (JButton)actionEvent.getSource();
            CalendarEntryEstateTablePanel.this.doShowActions(jButton, 0, jButton.getSize().height);
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("actions")));
            this.setShortDescription(I18N.tr("Show actions for the selected assignments."));
        }
    }

    private class RelationRemoveAction
    extends AbstractI18nAction {
        private RelationRemoveAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_remove.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryEstateTablePanel.this.doRelationRemove();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("remove assignment")));
            this.setShortDescription(I18N.tr("Remove the selected assignments."));
        }
    }

    private class RelationAddAction
    extends AbstractI18nAction {
        private RelationAddAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"edit_add.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryEstateTablePanel.this.doRelationAdd();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("new assignment")));
            this.setShortDescription(I18N.tr("Add an assignment."));
        }
    }

    private class RefreshTask
    extends ImmoToolTask<Boolean, Void> {
        private RefreshTask() {
        }

        protected Boolean doInBackground() throws Exception {
            Connection connection = null;
            try {
                connection = ImmoToolProject.getAppInstance().getDbConnection();
                CalendarEntryEstateTablePanel.this.doLoadInBackground(connection);
                Boolean bl = true;
                return bl;
            }
            finally {
                JdbcUtils.closeQuietly((Connection)connection);
            }
        }
    }

    private class RefreshAction
    extends AbstractI18nAction {
        private RefreshAction() {
            this.setSmallIcon(ImmoToolEnvironment.getResourceIcon((String)"reload.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryEstateTablePanel.this.doRefresh();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("refresh")));
            this.setShortDescription(I18N.tr("Reload assignments from database."));
        }
    }

    private class ObjectViewAction
    extends AbstractI18nAction {
        private ObjectViewAction() {
            this.setSmallIcon(AgencyPlugin.getResourceIcon((String)"agent_estates.png", (int)16));
            this.updateLocalization();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CalendarEntryEstateTablePanel.this.doObjectView();
        }

        protected void updateLocalization() {
            this.setName(StringUtils.capitalize((String)I18N.tr("show property")));
            this.setShortDescription(I18N.tr("Show details about the property."));
        }
    }

    private class RelationTableRow
    extends AgencyEstateTable.Row {
        private final String notes;

        private RelationTableRow(DbAgencyObject dbAgencyObject, String string) {
            super(dbAgencyObject);
            this.notes = string;
        }

        public Object getValue(AbstractTable.Column column) {
            if (column instanceof RelationTableColumn) {
                return this.getValueForRelation((RelationTableColumn)column);
            }
            return super.getValue(column);
        }

        public Object getValueForRelation(RelationTableColumn relationTableColumn) {
            switch (relationTableColumn) {
                case NOTES: {
                    return StringUtils.trimToNull((String)this.notes);
                }
            }
            return null;
        }
    }

    private static enum RelationTableColumn implements AbstractTable.Column
    {
        NOTES;


        public TableCellEditor getCellEditor() {
            switch (this) {
                default: 
            }
            return null;
        }

        public TableCellRenderer getCellRenderer() {
            switch (this) {
                case NOTES: {
                    return new DefaultTableCellRenderer((Renderer)new FirstLineRenderer());
                }
            }
            return null;
        }

        public Class<?> getColumnClass() {
            switch (this) {
                case NOTES: {
                    return String.class;
                }
            }
            return Object.class;
        }

        public String getColumnName() {
            switch (this) {
                case NOTES: {
                    return StringUtils.capitalize((String)I18N.tr("notes"));
                }
            }
            return null;
        }

        public String getColumnId() {
            return this.name();
        }

        public Comparator getComparator() {
            switch (this) {
                default: 
            }
            return null;
        }

        public boolean isEditable() {
            switch (this) {
                default: 
            }
            return false;
        }

        public boolean isHideable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isSortable() {
            switch (this) {
                default: 
            }
            return true;
        }

        public boolean isVisibleByDefault() {
            switch (this) {
                default: 
            }
            return true;
        }
    }

    private class RelationTable
    extends AgencyEstateTable<RelationTableRow> {
        private RelationTable() {
            super(CalendarEntryEstateTablePanel.RELATION_TABLE_ID);
        }

        protected void doRemove() {
            CalendarEntryEstateTablePanel.this.doRelationRemove();
        }

        protected void doSelect() {
            CalendarEntryEstateTablePanel.this.showActionsAction.setEnabled(this.getSelectedRowCount() > 0);
            if (this.getSelectedRowCount() < 1) {
                CalendarEntryEstateTablePanel.this.relationForm.unselectRelation();
            } else {
                int n = this.convertRowIndexToModel(this.getSelectedRow());
                CalendarEntryEstateTablePanel.this.relationForm.selectRelation(this.getEstateAt(n), this.getNotesAt(n));
            }
        }

        protected void doShowActions(int n, int n2) {
            CalendarEntryEstateTablePanel.this.doShowActions((Component)((Object)this), n, n2);
        }

        protected void doView() {
            CalendarEntryEstateTablePanel.this.doObjectView();
        }

        public String getNotesAt(int n) {
            RelationTableRow relationTableRow = (RelationTableRow)this.getRow(n);
            return relationTableRow != null ? relationTableRow.notes : null;
        }

        protected List<AbstractTable.Column> listColumns() {
            List list = super.listColumns();
            list.addAll(Arrays.asList(RelationTableColumn.values()));
            return list;
        }
    }

    private class RelationForm
    extends AgencyEstateRelationPanel {
        private RelationForm() {
            super(true);
        }

        protected void close() {
            if (CalendarEntryEstateTablePanel.this.objectsTable.getSelectedRowCount() > 0) {
                CalendarEntryEstateTablePanel.this.objectsTable.clearSelection();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean submit(DbAgencyObject dbAgencyObject, String string) {
            if (dbAgencyObject == null) {
                return false;
            }
            CalendarEntryEstateTablePanel.this.objectsTable.setEnabled(false);
            try {
                if (this.getCurrentAgencyObjectId() < 1L) {
                    CalendarEntryEstateTablePanel.this.objectsTable.addRow((AbstractTable.Row)new RelationTableRow(dbAgencyObject, string));
                }
                int n = CalendarEntryEstateTablePanel.this.objectsTable.getSelectedRow();
                if (n >= 0) {
                    int n2 = CalendarEntryEstateTablePanel.this.objectsTable.convertRowIndexToModel(n);
                    CalendarEntryEstateTablePanel.this.objectsTable.setRowAt(n2, (AbstractTable.Row)new RelationTableRow(dbAgencyObject, string));
                }
            }
            finally {
                CalendarEntryEstateTablePanel.this.objectsTable.clearSelection();
                CalendarEntryEstateTablePanel.this.objectsTable.setEnabled(true);
                CalendarEntryEstateTablePanel.this.updateTitle();
                return true;
            }
        }
    }
}

