/*
 * Decompiled with CFR 0.152.
 */
package com.openindex.openestate.tool.agency.addons.contacts;

import com.openindex.openestate.tool.agency.AgencyEstateViewPanel;
import com.openindex.openestate.tool.agency.AgencyPermission;
import com.openindex.openestate.tool.agency.AgencyPlugin;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyEstateViewBrokeringPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyEstateViewContactAddPanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyEstateViewContactTablePanel;
import com.openindex.openestate.tool.agency.addons.contacts.AgencyEstateViewInterestsPanel;
import com.openindex.openestate.tool.agency.extensions.EstateViewAdapter;
import com.openindex.openestate.tool.agency.extensions.EstateViewExtension;
import com.openindex.openestate.tool.contacts.ContactsPermission;
import com.openindex.openestate.tool.contacts.ContactsPlugin;
import java.util.ArrayList;
import org.pf4j.Extension;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xnap.commons.i18n.I18n;
import org.xnap.commons.i18n.I18nFactory;

@Extension(points={EstateViewExtension.class}, plugins={"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"})
public class AgencyEstateViewContactsExtension
extends EstateViewAdapter {
    private static final Logger LOGGER = LoggerFactory.getLogger(AgencyEstateViewContactsExtension.class);
    private static final I18n I18N = I18nFactory.getI18n(AgencyEstateViewContactsExtension.class);

    public AgencyEstateViewPanel.AbstractTab[] createContactTabs() {
        ArrayList<AgencyEstateViewPanel.AbstractTab> arrayList = new ArrayList<AgencyEstateViewPanel.AbstractTab>();
        if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.BROKERINGS)) {
            arrayList.add(new AgencyEstateViewBrokeringPanel());
        }
        if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN) && AgencyPlugin.isUserAllowedTo((AgencyPermission)AgencyPermission.INTERESTS)) {
            arrayList.add(new AgencyEstateViewInterestsPanel());
        }
        if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.USE_PLUGIN)) {
            AgencyEstateViewContactTablePanel agencyEstateViewContactTablePanel = new AgencyEstateViewContactTablePanel();
            arrayList.add(agencyEstateViewContactTablePanel);
            if (ContactsPlugin.isUserAllowedTo((ContactsPermission)ContactsPermission.ENTRIES_EDIT)) {
                AgencyEstateViewContactAddPanel agencyEstateViewContactAddPanel = new AgencyEstateViewContactAddPanel(agencyEstateViewContactTablePanel);
                arrayList.add(agencyEstateViewContactAddPanel);
            }
        }
        return arrayList.isEmpty() ? null : arrayList.toArray(new AgencyEstateViewPanel.AbstractTab[0]);
    }

    public final String[] getRequiredPluginIds() {
        return new String[]{"OpenEstate-Tool-Agency", "OpenEstate-Tool-Contacts"};
    }
}

